
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSHMA.C							*/
/*									*/
/*	High Memory Area Management Functions				*/
/*	(hmarequest, hmarelease)					*/
/*									*/
/* ---------------------------------------------------------------------*/

#include "xms.h"

#pragma inline

/* hmarequest - request HMA
 */

int hmarequest(unsigned int reqsize)
{
  asm	mov	dx, reqsize
  asm	xor	bl, bl
  asm	mov	ah, 0x01
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* hmarelease - release HMA
 */

int hmarelease(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x02
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}