1 KEY OFF
2 CLS
3 REM      Lines 4-4998 are reserved for initialization.
4 DIM POINT.X(12),POINT.Y(12),POINT.Z(12)
5 DATA -0.4118871,0.9079996,-0.07671904
6 DATA 0.1384243,-0.3550399,0.9245461
7 DATA -0.6921797,0.2209025,0.6870876
8 DATA 0.2536102,0.6783116,0.6896197
9 DATA -0.2693563,-0.6470865,-0.7132505
10 DATA -0.5892926,-0.7569793,0.2823415
11 DATA -0.9513623,0.03821032,-0.3056953
12 DATA 0.6965288,-0.2344079,-0.6781597
13 DATA 0.6159785,0.7314981,-0.2923718
14 DATA -0.1431547,0.3652876,-0.9198216
15 DATA 0.4155043,-0.9075403,0.06104855
16 DATA 0.9394635,-0.03937519,0.3403796
17 FOR VERTEX.NUM%=1 TO 12
18   READ POINT.X(VERTEX.NUM%),POINT.Y(VERTEX.NUM%),POINT.Z(VERTEX.NUM%)
19 NEXT VERTEX.NUM%
4999 GOTO 9769
5000 REM      Lines 5000-9767 are reserved for defining
5001 REM INTENSITY=f(LATITUDE,LONGITUDE).
5002 REM
5003 REM      Here, INTENSITY is set to the intensity of light observed from 12
5004 REM evenly spaced points on a transparent sphere when the observer is 1.4
5005 REM radii from the center of the sphere.
5006 SPHERE.Z=1.4*SIN(LATITUDE)
5007 SPHERE.X=1.4*COS(LATITUDE)*SIN(LONGITUDE)
5008 SPHERE.Y=1.4*COS(LATITUDE)*COS(LONGITUDE)
5009 INTENSITY=0!
5010 FOR VERTEX.NUM%=1 TO 12
5011   TEM.X=SPHERE.X-POINT.X(VERTEX.NUM%)
5012   TEM.Y=SPHERE.Y-POINT.Y(VERTEX.NUM%)
5013   TEM.Z=SPHERE.Z-POINT.Z(VERTEX.NUM%)
5014   INTENSITY=INTENSITY+1!/(TEM.X*TEM.X+TEM.Y*TEM.Y+TEM.Z*TEM.Z)
5015 NEXT VERTEX.NUM%
9768 RETURN
9769 MAX.Y.OUT%=639
9770 MAX.Z.OUT%=199
9771 PRINT "                             Three Dimensional Plot"
9772 PRINT
9773 PRINT
9774 PRINT
9775 LATITUDE.MIN=-2!*ATN(1!)
9776 LATITUDE.MAX=-LATITUDE.MIN
9777 LONGITUDE.MIN=0!
9778 LONGITUDE.MAX=4!*LATITUDE.MAX
9779 PRINT "Number of divisions for latitude";
9780 INPUT NUM.LATITUDE.DIVISIONS%
9781 IF NUM.LATITUDE.DIVISIONS% > 1 THEN 9784
9782 PRINT "? there must be at least 2 divisions"
9783 GOTO 9779
9784 LATITUDE.COUNT%=NUM.LATITUDE.DIVISIONS%+1
9785 PRINT "Number of divisions for longitude";
9786 INPUT NUM.LONGITUDE.DIVISIONS%
9787 IF NUM.LONGITUDE.DIVISIONS% > 1 THEN 9790
9788 PRINT "? there must be at least 2 divisions"
9789 GOTO 9785
9790 LONGITUDE.COUNT%=NUM.LONGITUDE.DIVISIONS%+1
9791 DIM X.PRIME(LATITUDE.COUNT%*LONGITUDE.COUNT%)
9792 DIM Y.PRIME(LATITUDE.COUNT%,LONGITUDE.COUNT%)
9793 DIM Z.PRIME(LATITUDE.COUNT%,LONGITUDE.COUNT%)
9794 DIM X.DIVISION.INDEX%(LATITUDE.COUNT%*LONGITUDE.COUNT%)
9795 DIM Y.DIVISION.INDEX%(LATITUDE.COUNT%*LONGITUDE.COUNT%)
9796 DIM BOX.X%(4),BOX.Y%(4)
9797   PRINT "Rotation (degrees)";
9798   INPUT ROTATION
9799   PRINT "Tilt (degrees)";
9800   INPUT TILT
9801   PRINT "After the plot is displayed, press a key to continue."
9802   PRINT "Evaluating function..."
9803   RADIANS.PER.DEGREE=ATN(1!)/45!
9804   RADIANS=TILT*RADIANS.PER.DEGREE
9805   COS.TILT=COS(RADIANS)
9806   SIN.TILT=SIN(RADIANS)
9807   RADIANS=ROTATION*RADIANS.PER.DEGREE
9808   COS.ROTATION=COS(RADIANS)
9809   SIN.ROTATION=SIN(RADIANS)
9810   LATITUDE=LATITUDE.MIN
9811   LONGITUDE=LONGITUDE.MIN
9812   GOSUB 5000
9813   X=INTENSITY*COS(LATITUDE)*SIN(LONGITUDE)
9814   Y=INTENSITY*COS(LATITUDE)*COS(LONGITUDE)
9815   Z=INTENSITY*SIN(LATITUDE)
9816   X.ROTATED=X*COS.ROTATION+Y*SIN.ROTATION
9817   Y.PRIME.MIN=-X*SIN.ROTATION+Y*COS.ROTATION
9818   Z.PRIME.MIN=-X.ROTATED*SIN.TILT+Z*COS.TILT
9819   Y.PRIME.MAX=Y.PRIME.MIN
9820   Z.PRIME.MAX=Z.PRIME.MIN
9821   X.PRIME.MAX=X.ROTATED*COS.TILT+Z*SIN.TILT
9822   DELTA.LATITUDE=NUM.LATITUDE.DIVISIONS%
9823   DELTA.LATITUDE=(LATITUDE.MAX-LATITUDE.MIN)/DELTA.LATITUDE
9824   DELTA.LONGITUDE=NUM.LONGITUDE.DIVISIONS%
9825   DELTA.LONGITUDE=(LONGITUDE.MAX-LONGITUDE.MIN)/DELTA.LONGITUDE
9826   LATITUDE=LATITUDE.MIN
9827   NUM.X.PRIMES%=0
9828   FOR X.DIVISION.NUM%=1 TO LATITUDE.COUNT%
9829     LONGITUDE=LONGITUDE.MIN
9830     FOR Y.DIVISION.NUM%=1 TO LONGITUDE.COUNT%
9831       GOSUB 5000
9832       X=INTENSITY*COS(LATITUDE)*SIN(LONGITUDE)
9833       Y=INTENSITY*COS(LATITUDE)*COS(LONGITUDE)
9834       Z=INTENSITY*SIN(LATITUDE)
9835       NUM.X.PRIMES%=NUM.X.PRIMES%+1
9836       X.DIVISION.INDEX%(NUM.X.PRIMES%)=X.DIVISION.NUM%
9837       Y.DIVISION.INDEX%(NUM.X.PRIMES%)=Y.DIVISION.NUM%
9838       X.ROTATED=X*COS.ROTATION+Y*SIN.ROTATION
9839       Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)=-X*SIN.ROTATION+Y*COS.ROTATION
9840       X.PRIME(NUM.X.PRIMES%)=X.ROTATED*COS.TILT+Z*SIN.TILT
9841       Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)=-X.ROTATED*SIN.TILT+Z*COS.TILT
9842       IF X.PRIME(NUM.X.PRIMES%) <= X.PRIME.MAX THEN 9844
9843         X.PRIME.MAX=X.PRIME(NUM.X.PRIMES%)
9844       IF Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%) >= Y.PRIME.MIN THEN 9846
9845         Y.PRIME.MIN=Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9846       IF Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%) <= Y.PRIME.MAX THEN 9848
9847         Y.PRIME.MAX=Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9848       IF Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%) >= Z.PRIME.MIN THEN 9850
9849         Z.PRIME.MIN=Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9850       IF Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%) <= Z.PRIME.MAX THEN 9852
9851         Z.PRIME.MAX=Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9852       LONGITUDE=LONGITUDE+DELTA.LONGITUDE
9853     NEXT Y.DIVISION.NUM%
9854     LATITUDE=LATITUDE+DELTA.LATITUDE
9855   NEXT X.DIVISION.NUM%
9856   PRINT "Adjusting perspective..."
9857   IF Y.PRIME.MAX-Y.PRIME.MIN > Z.PRIME.MAX-Z.PRIME.MIN THEN 9861
9858   IF Z.PRIME.MAX = Z.PRIME.MIN THEN 9880
9859   X.EYE=2!*(Z.PRIME.MAX-Z.PRIME.MIN)+X.PRIME.MAX
9860   GOTO 9862
9861   X.EYE=2!*(Y.PRIME.MAX-Y.PRIME.MIN)+X.PRIME.MAX
9862   Y.CENTER=(Y.PRIME.MAX+Y.PRIME.MIN)/2!
9863   Z.CENTER=(Z.PRIME.MAX+Z.PRIME.MIN)/2!
9864   NUM.X.PRIMES%=0
9865   FOR X.DIVISION.NUM%=1 TO LATITUDE.COUNT%
9866     Y=Y.MIN
9867     FOR Y.DIVISION.NUM%=1 TO LONGITUDE.COUNT%
9868       NUM.X.PRIMES%=NUM.X.PRIMES%+1
9869       X=X.PRIME(NUM.X.PRIMES%)
9870       Y=Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9871       Z=Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)
9872       DELTA.X=X-X.EYE
9873       DELTA.Y=Y-Y.CENTER
9874       DELTA.Z=Z-Z.CENTER
9875       X.PRIME(NUM.X.PRIMES%)=SQR(DELTA.X*DELTA.X+DELTA.Y*DELTA.Y+DELTA.Z*DELTA.Z)
9876       Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)=Y.CENTER+(Y-Y.CENTER)*(X.EYE-X.PRIME.MAX)/(X.EYE-X)
9877       Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)=Z.CENTER+(Z-Z.CENTER)*(X.EYE-X.PRIME.MAX)/(X.EYE-X)
9878     NEXT Y.DIVISION.NUM%
9879   NEXT X.DIVISION.NUM%
9880   PRINT "Sorting points..."
9881   SORT.LEFT%=NUM.X.PRIMES%\2
9882   SORT.LEFT%=SORT.LEFT%+1
9883   SORT.RIGHT%=NUM.X.PRIMES%
9884   SORT.T1=X.PRIME(1)
9885   SORT.T2%=X.DIVISION.INDEX%(1)
9886   SORT.T3%=Y.DIVISION.INDEX%(1)
9887   IF SORT.RIGHT% <= 1 THEN 9918
9888     IF SORT.LEFT% <= 1 THEN 9894
9889       SORT.LEFT%=SORT.LEFT%-1
9890       SORT.T1=X.PRIME(SORT.LEFT%)
9891       SORT.T2%=X.DIVISION.INDEX%(SORT.LEFT%)
9892       SORT.T3%=Y.DIVISION.INDEX%(SORT.LEFT%)
9893     GOTO 9901
9894       SORT.T1=X.PRIME(SORT.RIGHT%)
9895       SORT.T2%=X.DIVISION.INDEX%(SORT.RIGHT%)
9896       SORT.T3%=Y.DIVISION.INDEX%(SORT.RIGHT%)
9897       X.PRIME(SORT.RIGHT%)=X.PRIME(1)
9898       X.DIVISION.INDEX%(SORT.RIGHT%)=X.DIVISION.INDEX%(1)
9899       Y.DIVISION.INDEX%(SORT.RIGHT%)=Y.DIVISION.INDEX%(1)
9900       SORT.RIGHT%=SORT.RIGHT%-1
9901     IF SORT.RIGHT% <= 1 THEN 9918
9902     KEY.INDEX.2%=SORT.LEFT%
9903     KEY.INDEX.1%=KEY.INDEX.2%
9904       KEY.INDEX.2%=2*KEY.INDEX.2%
9905       IF KEY.INDEX.2% > SORT.RIGHT% THEN 9914
9906         IF KEY.INDEX.2% = SORT.RIGHT% THEN 9909
9907           IF X.PRIME(KEY.INDEX.2%) <= X.PRIME(KEY.INDEX.2%+1) THEN 9909
9908             KEY.INDEX.2%=KEY.INDEX.2%+1
9909         IF SORT.T1 <= X.PRIME(KEY.INDEX.2%) THEN 9914
9910           X.PRIME(KEY.INDEX.1%)=X.PRIME(KEY.INDEX.2%)
9911           X.DIVISION.INDEX%(KEY.INDEX.1%)=X.DIVISION.INDEX%(KEY.INDEX.2%)
9912           Y.DIVISION.INDEX%(KEY.INDEX.1%)=Y.DIVISION.INDEX%(KEY.INDEX.2%)
9913     GOTO 9903
9914     X.PRIME(KEY.INDEX.1%)=SORT.T1
9915     X.DIVISION.INDEX%(KEY.INDEX.1%)=SORT.T2%
9916     Y.DIVISION.INDEX%(KEY.INDEX.1%)=SORT.T3%
9917   GOTO 9887
9918   X.PRIME(1)=SORT.T1
9919   X.DIVISION.INDEX%(1)=SORT.T2%
9920   Y.DIVISION.INDEX%(1)=SORT.T3%
9921   SCREEN 2
9922   ASPECT.RATIO=1!/(4!*(200!/640!)/3!)
9923   Y.OUT.MAX=MAX.Y.OUT%
9924   Z.OUT.MAX=MAX.Z.OUT%
9925   IF ASPECT.RATIO*Z.OUT.MAX*(Y.PRIME.MAX-Y.PRIME.MIN) <= Y.OUT.MAX*(Z.PRIME.MAX-Z.PRIME.MIN) THEN 9930
9926     PIXELS.PER.UNIT=Y.OUT.MAX/(ASPECT.RATIO*(Y.PRIME.MAX-Y.PRIME.MIN))
9927     Y.OFFSET=0!
9928     Z.OFFSET=-(Z.OUT.MAX-PIXELS.PER.UNIT*(Z.PRIME.MAX-Z.PRIME.MIN))/2!
9929   GOTO 9938
9930     IF ASPECT.RATIO*Z.OUT.MAX*(Y.PRIME.MAX-Y.PRIME.MIN) >= Y.OUT.MAX*(Z.PRIME.MAX-Z.PRIME.MIN) THEN 9935
9931       PIXELS.PER.UNIT=Z.OUT.MAX/(Z.PRIME.MAX-Z.PRIME.MIN)
9932       Y.OFFSET=(Y.OUT.MAX-ASPECT.RATIO*PIXELS.PER.UNIT*(Y.PRIME.MAX-Y.PRIME.MIN))/2!
9933       Z.OFFSET=0!
9934     GOTO 9938
9935       PIXELS.PER.UNIT=1!
9936       Y.OFFSET=Y.OUT.MAX/2!
9937       Z.OFFSET=-Z.OUT.MAX/2!
9938   FOR X.PRIME.NUM%=1 TO NUM.X.PRIMES%
9939     X.DIVISION.NUM%=X.DIVISION.INDEX%(X.PRIME.NUM%)
9940     IF X.DIVISION.NUM% = LATITUDE.COUNT% THEN 9985
9941       Y.DIVISION.NUM%=Y.DIVISION.INDEX%(X.PRIME.NUM%)
9942       IF Y.DIVISION.NUM% = LONGITUDE.COUNT% THEN 9985
9943         BOX.X%(1)=FIX(Y.OFFSET+PIXELS.PER.UNIT*ASPECT.RATIO*(Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)-Y.PRIME.MIN))
9944         BOX.Y%(1)=FIX(Z.OFFSET+Z.OUT.MAX-PIXELS.PER.UNIT*(Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%)-Z.PRIME.MIN))
9945         BOX.X%(2)=FIX(Y.OFFSET+PIXELS.PER.UNIT*ASPECT.RATIO*(Y.PRIME(X.DIVISION.NUM%+1,Y.DIVISION.NUM%)-Y.PRIME.MIN))
9946         BOX.Y%(2)=FIX(Z.OFFSET+Z.OUT.MAX-PIXELS.PER.UNIT*(Z.PRIME(X.DIVISION.NUM%+1,Y.DIVISION.NUM%)-Z.PRIME.MIN))
9947         BOX.X%(3)=FIX(Y.OFFSET+PIXELS.PER.UNIT*ASPECT.RATIO*(Y.PRIME(X.DIVISION.NUM%+1,Y.DIVISION.NUM%+1)-Y.PRIME.MIN))
9948         BOX.Y%(3)=FIX(Z.OFFSET+Z.OUT.MAX-PIXELS.PER.UNIT*(Z.PRIME(X.DIVISION.NUM%+1,Y.DIVISION.NUM%+1)-Z.PRIME.MIN))
9949         BOX.X%(4)=FIX(Y.OFFSET+PIXELS.PER.UNIT*ASPECT.RATIO*(Y.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%+1)-Y.PRIME.MIN))
9950         BOX.Y%(4)=FIX(Z.OFFSET+Z.OUT.MAX-PIXELS.PER.UNIT*(Z.PRIME(X.DIVISION.NUM%,Y.DIVISION.NUM%+1)-Z.PRIME.MIN))
9951         BOX.Y.MIN%=BOX.Y%(1)
9952         BOX.Y.MAX%=BOX.Y.MIN%
9953         FOR BOX.NUM.1%=2 TO 4
9954           IF BOX.Y%(BOX.NUM.1%) < BOX.Y.MIN% THEN BOX.Y.MIN%=BOX.Y%(BOX.NUM.1%)
9955           IF BOX.Y%(BOX.NUM.1%) > BOX.Y.MAX% THEN BOX.Y.MAX%=BOX.Y%(BOX.NUM.1%)
9956         NEXT BOX.NUM.1%
9957         FOR BOX.Y1%=BOX.Y.MIN% TO BOX.Y.MAX%
9958           INTERCEPT.COUNT.MOD.2%=0
9959           BOX.NUM.2%=2
9960           FOR BOX.NUM.1%=1 TO 4
9961             IF BOX.Y%(BOX.NUM.1%) >= BOX.Y1% THEN 9974
9962               IF BOX.Y1% > BOX.Y%(BOX.NUM.2%) THEN 9975
9963                 BOX.DELTA.Y=BOX.Y%(BOX.NUM.2%)-BOX.Y%(BOX.NUM.1%)
9964                 BOX.DELTA.X=BOX.X%(BOX.NUM.2%)-BOX.X%(BOX.NUM.1%)
9965                 BOX.Y.OFFSET=BOX.Y1%-BOX.Y%(BOX.NUM.1%)
9966                 BOX.X.INTERCEPT=BOX.X%(BOX.NUM.1%)
9967                 BOX.X1%=FIX(BOX.DELTA.X*BOX.Y.OFFSET/BOX.DELTA.Y+BOX.X.INTERCEPT)
9968                 IF INTERCEPT.COUNT.MOD.2% = 0 THEN 9971
9969                   LINE (BOX.X1%,BOX.Y1%)-(BOX.X2%,BOX.Y1%),0
9970                 GOTO 9972
9971                   BOX.X2%=BOX.X1%
9972                 INTERCEPT.COUNT.MOD.2%=1-INTERCEPT.COUNT.MOD.2%
9973               GOTO 9975
9974             IF BOX.Y1% > BOX.Y%(BOX.NUM.2%) THEN 9963
9975             BOX.NUM.2%=BOX.NUM.2%+1
9976             IF BOX.NUM.2% > 4 THEN BOX.NUM.2%=1
9977           NEXT BOX.NUM.1%
9978         NEXT BOX.Y1%
9979         BOX.NUM.2%=2
9980         FOR BOX.NUM.1%=1 TO 4
9981           LINE (BOX.X%(BOX.NUM.1%),BOX.Y%(BOX.NUM.1%))-(BOX.X%(BOX.NUM.2%),BOX.Y%(BOX.NUM.2%))
9982           BOX.NUM.2%=BOX.NUM.2%+1
9983           IF BOX.NUM.2% > 4 THEN BOX.NUM.2%=1
9984         NEXT BOX.NUM.1%
9985   NEXT X.PRIME.NUM%
9986   RESPONSE$=INKEY$
9987   IF LEN(RESPONSE$) = 0 THEN 9986
9988   SCREEN 0
9989   WIDTH 80
9990   PRINT "                             Three Dimensional Plot"
9991   PRINT
9992   PRINT
9993   PRINT
9994   PRINT "Again (y or n)? ";
9995   RESPONSE$=INKEY$
9996   IF LEN(RESPONSE$) = 0 THEN 9995
9997   PRINT
9998   IF ((RESPONSE$ = "Y") OR (RESPONSE$ = "y")) THEN 9797
9999 END

