*** dospecia.c	1995/10/02 07:30:19	2.1
--- dospecia.c	1995/10/02 07:49:20
***************
*** 4,9 ****
--- 4,17 ----
   */
  #include "dvips.h" /* The copyright notice in that file is included too! */
  
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      25-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_pictpath ;
+ extern struct emtex_dir ed_figpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  #include <ctype.h>
  extern int atoi();
  extern void fil2ps();
***************
*** 452,458 ****
--- 460,471 ----
  int maccess(s)
  char *s ;
  {
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    FILE *f = search(&ed_figpath, s, "r") ;
+ #else
     FILE *f = search(figpath, s, "r") ;
+ #endif
     if (f)
        fclose(f) ;
     return (f != 0) ;
***************
*** 720,725 ****
--- 733,739 ----
        }
  
     cmdout("@setspecial");
+    cmdout("") ;/*    saw 28.6.95 */
  
     if(psfile[0]) {
        if (task == 0) {
***************
*** 742,748 ****
--- 756,767 ----
  {
     char cmd[400] ;
     FILE *f ;
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    if (0 != (f=emtex_dir_search(&ed_pictpath, iname, "r"))) {
+ #else
     if (0 != (f=search(pictpath, iname, "r"))) {
+ #endif
        fclose(f) ;
     } else {
        fprintf(stderr, " couldn't open %s\n", iname) ;
*** drawPS.c	1995/10/02 07:30:19	2.1
--- drawPS.c	1995/10/02 07:49:24
***************
*** 5,13 ****
   *
   * (minor mods by don on 5 Jan 90 to accommodate highres PostScript)
   *
!  * $Revision: 2.1 $
   *
   * $Log: drawPS.c $
   * Revision 2.1  1995/10/02 07:30:19  sawade
   * *** empty log message ***
   *
--- 5,16 ----
   *
   * (minor mods by don on 5 Jan 90 to accommodate highres PostScript)
   *
!  * $Revision: 2.2 $
   *
   * $Log: drawPS.c $
+  * Revision 2.2  1995/10/02 07:42:15  sawade
+  * *** empty log message ***
+  *
   * Revision 2.1  1995/10/02 07:30:19  sawade
   * *** empty log message ***
   *
***************
*** 39,45 ****
   */
  #ifndef lint
  char RCSid[] =
!   "@(#)$Header: F:/sawdvips/dvihps/RCS\\drawPS.c 2.1 1995/10/02 07:30:19 sawade dvihps $ (UCLA)";
  #endif
  
  /*
--- 42,48 ----
   */
  #ifndef lint
  char RCSid[] =
!   "@(#)$Header: F:/sawdvips/dvihps/RCS\\drawPS.c 2.2 1995/10/02 07:42:15 sawade saw244 $ (UCLA)";
  #endif
  
  /*
*** dvips.c	1995/10/02 07:30:19	2.1
--- dvips.c	1995/10/02 07:49:26
***************
*** 9,14 ****
--- 9,27 ----
  #ifndef SYSV
  extern char *strtok() ; /* some systems don't have this in strings.h */
  #endif
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_vfpath,      
+                         ed_pictpath,    
+                         ed_tfmpath,     
+                         ed_figpath,     
+                         ed_flipath,
+                         ed_headerpath,  
+                         ed_configpath;
+ #endif
+ 
  #ifdef VMS
  #define GLOBAL globaldef
  #ifdef __GNUC__
***************
*** 470,475 ****
--- 483,509 ----
  #endif
     register sectiontype *sects ;
  
+ #ifdef SAWVER
+ /*
+  *      When DVIPS_STDERR is set, this is the file, where
+  *      all messages go. (this is for the DOS community. they
+  *      cannot redirect stderr).
+  *      and a version information about the port follows.
+  *      sawade@physik.tu-berlin.de      29.sept.95
+  */
+    char *dvips_messages;
+    extern char *getenv() ;
+    if( dvips_messages = getenv("DVIPS_STDERR") )
+       if( NULL == freopen(dvips_messages, "w", stderr) ) {
+          printf("** Cannot redirect stderr to '%s'\n STOP!. **\n", dvips_messages);
+          exit( 99 );
+       }
+ 
+ /********************************/
+    fprintf(stderr, "%s\n", SAWVER);   /* sawade 10/94 */
+ /********************************/
+ #endif
+ 
  #ifdef __THINK__
     argc = dcommand(&argv) ; /* do I/O stream redirection */
  #endif
***************
*** 632,642 ****
  case 'p' :
  #if defined(MSDOS) || defined(OS2) || defined(ATARIST)
                 /* check for emTeX job file (-pj=filename) */
!                if (*p == 'j') {
                   p++;
                   if (*p == '=' || *p == ':')
                     p++;
                   mfjobname = newstring(p);
                   break;
                 }
                 /* must be page number instead */
--- 666,680 ----
  case 'p' :
  #if defined(MSDOS) || defined(OS2) || defined(ATARIST)
                 /* check for emTeX job file (-pj=filename) */
!                /* hacked for new emTeX dvidrv 1.5.. (-pv:filename) sawade 8/94 */
!                if (*p == 'j' || *p == 'v') {
                   p++;
                   if (*p == '=' || *p == ':')
                     p++;
+                  if( *p ) /* This is due to OS/2's interpretation of '='... sawade 3/95 */
                   mfjobname = newstring(p);
+                  else
+                     mfjobname = newstring(p=argv[++i]);
                   break;
                 }
                 /* must be page number instead */
***************
*** 967,978 ****
             (void)fprintf(stderr,"input file %s output file %s swmem %d\n",
  #endif /* ~SHORTINT */
             iname, oname, swmem) ;
     (void)fprintf(stderr,"tfm path %s\npk path %s\n", tfmpath, pkpath) ;
     (void)fprintf(stderr,"fig path %s\nvf path %s\n", figpath, vfpath) ;
     (void)fprintf(stderr,"config path %s\nheader path %s\n",
                    configpath, headerpath) ;
  #ifdef FONTLIB
!    (void)fprintf(stderr,"fli path %s\nfli names %s\n", flipath, fliname) ;
  #endif
     } /* dd(D_PATHS) */
  #endif /* DEBUG */
--- 1005,1040 ----
             (void)fprintf(stderr,"input file %s output file %s swmem %d\n",
  #endif /* ~SHORTINT */
             iname, oname, swmem) ;
+ #ifdef EMTEXDIR
+    (void)fprintf(stderr,"\npk path %s\n", pkpath) ;
+    (void)fprintf(stderr,"\ntfm path %s\n- directories:\n", tfmpath) ;
+      for (i = 0; i < ed_tfmpath.used; ++i)
+          fprintf (stderr,"   %s\n", ed_tfmpath.list[i]);
+    (void)fprintf(stderr,"\nfig path %s\n- directories:\n", figpath) ;
+      for (i = 0; i < ed_figpath.used; ++i)
+          fprintf (stderr,"   %s\n", ed_figpath.list[i]);
+    (void)fprintf(stderr,"\nvf path %s\n- directories:\n", vfpath) ;
+      for (i = 0; i < ed_vfpath.used; ++i)
+          fprintf (stderr,"   %s\n", ed_vfpath.list[i]);
+    (void)fprintf(stderr,"\nconfig path %s\n- directories:\n", configpath) ;
+      for (i = 0; i < ed_configpath.used; ++i)
+          fprintf (stderr,"   %s\n", ed_configpath.list[i]);
+    (void)fprintf(stderr,"\nheader path %s\n- directories:\n", headerpath) ;
+      for (i = 0; i < ed_headerpath.used; ++i)
+          fprintf (stderr,"   %s\n", ed_headerpath.list[i]);
+ #else
     (void)fprintf(stderr,"tfm path %s\npk path %s\n", tfmpath, pkpath) ;
     (void)fprintf(stderr,"fig path %s\nvf path %s\n", figpath, vfpath) ;
     (void)fprintf(stderr,"config path %s\nheader path %s\n",
                    configpath, headerpath) ;
+ #endif
  #ifdef FONTLIB
!    (void)fprintf(stderr,"\nfli path %s\nfli names %s\n", flipath, fliname) ;
! #ifdef EMTEXDIR
!    (void)fprintf(stderr,"- directories:\n") ;
!      for (i = 0; i < ed_flipath.used; ++i)
!          fprintf (stderr,"   %s\n", ed_flipath.list[i]);
! #endif
  #endif
     } /* dd(D_PATHS) */
  #endif /* DEBUG */
*** dvips.tex	1995/10/02 07:30:19	2.1
--- dvips.tex	1995/10/02 07:49:26
***************
*** 4,9 ****
--- 4,10 ----
  %
  \newif\ifgeneric\genericfalse
  \ifx\ntmanloaded Y\else\input dvipsmac \fi % uh oh, no macros, give our own.
+ \genericfalse
  %
  %   Finally, the document itself.
  %
*** emspecia.c	1995/10/02 07:30:19	2.1
--- emspecia.c	1995/10/02 07:49:28
***************
*** 8,13 ****
--- 8,21 ----
  extern int atoi();
  extern FILE *search();
  extern char *getenv();
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_figpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  /*
   *   These are the external routines called:
   */
***************
*** 1418,1438 ****
--- 1426,1460 ----
  	strcpy(fname, filename);
  
  	/* find the file */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+ 	f = emtex_dir_search(&ed_figpath, fname, READBIN);
+ #else
  	f = search(figpath, fname, READBIN);
+ #endif
+ #ifndef EMTEXDIR
  	if (f == (FILE *)NULL) {
     	    if ( (env = getenv("DVIDRVGRAPH")) != NULL )
  		f = search(env,filename,READBIN);
  	}
+ #endif
  	/* if still haven't found it try adding extensions */
  	if (f == (FILE *)NULL) {
  	    i = 0;
  	    while (extarr[i] != NULL) {
  		strcpy(fname, filename);
  		strcat(fname, extarr[i]);
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+ 		f = emtex_dir_search(&ed_figpath, fname, READBIN);
+ #else
  		f = search(figpath, fname, READBIN);
+ #endif
  		if (f == (FILE *)NULL) {
+ #ifndef EMTEXDIR
  	    	    if ( (env = getenv("DVIDRVGRAPH")) != NULL )
  			f = search(env,filename,READBIN);
+ #endif
  		}
  		if (f != (FILE *)NULL)
  		    break;
*** finclude.c	1995/10/02 07:30:19	2.1
--- finclude.c	1995/10/02 07:49:30
***************
*** 11,16 ****
--- 11,23 ----
  #define getname vms_getname
  #endif
  
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_figpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  double atof();
  /*
   *   These are the external routines we call.
***************
*** 247,253 ****
--- 254,265 ----
     Boolean trueknown = 0 ;
     fontdesctype *oldcf = curfnt;
  
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+    f = emtex_dir_search(&ed_figpath, filename, READ) ;
+ #else
     f = search(figpath, filename, READ) ;
+ #endif
     if (f) {
        while (fgets(p,500,f) && p[0]=='%' &&
              (p[1]=='!' || p[1]=='%' || p[1]=='*'))
*** flib.c	1995/10/02 07:30:19	2.1
--- flib.c	1995/10/02 07:49:32
***************
*** 6,11 ****
--- 6,19 ----
  #ifdef FONTLIB
  #include "dvips.h"
  #include "paths.h"
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_flipath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  extern FILE *search() ;
  extern char *newstring() ;
  extern shalfword pkbyte() ;
***************
*** 103,109 ****
--- 111,122 ----
           if (needext)
              strcat(name,".fli");
  
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+          if ( (pkfile=emtex_dir_search(&ed_flipath,name,READBIN)) != (FILE *)NULL ) {
+ #else
           if ( (pkfile=search(flipath,name,READBIN)) != (FILE *)NULL ) {
+ #endif
              /* for each font library */
              for (i=0; i<4; i++) {
                fontname[i] = pkbyte();  /* read header */
***************
*** 250,256 ****
--- 263,274 ----
                          for (i=FLICSIZE-1; i>0; i--)
                               fli_cache[i] = fli_cache[i-1];
                          /* put this font library at front */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+                         if ( (pkfile=emtex_dir_search(&ed_flipath,lib->name,READBIN)) == (FILE *)NULL ) {
+ #else
                          if ( (pkfile=search(flipath,lib->name,READBIN)) == (FILE *)NULL ) {
+ #endif
                             sprintf(errbuf,"Can't reopen font library %s", lib->name);
                             error(errbuf);
                             return((FILE *)NULL);
*** header.c	1995/10/02 07:30:19	2.1
--- header.c	1995/10/02 07:49:32
***************
*** 16,21 ****
--- 16,29 ----
  /*
   *   The external routines we use.
   */
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_headerpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  extern char *newstring() ;
  extern void error() ;
  extern void copyfile() ;
***************
*** 68,74 ****
--- 76,88 ----
  void checkhmem(s)
  char *s ;
  {
+ 
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+    FILE *f = emtex_dir_search(&ed_headerpath, s, READ) ;
+ #else
     FILE *f = search(headerpath, s, READ) ;
+ #endif
  
     if (f==0) {
        (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
*** loadfont.c	1995/10/02 07:30:19	2.1
--- loadfont.c	1995/10/02 07:49:34
***************
*** 256,264 ****
  #else
     (void)sprintf(name, "%s.%dpk", n, fd->dpi) ;
  #endif
     (void)sprintf(errbuf,
!       "Font %s%s not found, characters will be left blank.",
!       fd->area, name) ;
     error(errbuf) ;
     return(0) ;
  }
--- 256,270 ----
  #else
     (void)sprintf(name, "%s.%dpk", n, fd->dpi) ;
  #endif
+ 
+ /*      Output modification by SAW 27/6/95 */
     (void)sprintf(errbuf,
! #if defined OS2 || defined MSDOS
!       "Font %s at %d dpi not found, characters will be left blank.", n, fd->dpi) ;
! #else
!       "Font %s%s not found, characters will be left blank.", fd->area, name) ;
! #endif
! 
     error(errbuf) ;
     return(0) ;
  }
*** makefont.c	1995/10/02 07:30:19	2.1
--- makefont.c	1995/10/02 07:49:34
***************
*** 278,284 ****
        (void)fprintf(stderr, "- %s\n", buf) ;
     if (dontmakefont == 0) {
        if (mfjobname != (char *)NULL)
!          mfjobout(name,t);
        else
           (void)system(buf) ;
     }
--- 278,284 ----
        (void)fprintf(stderr, "- %s\n", buf) ;
     if (dontmakefont == 0) {
        if (mfjobname != (char *)NULL)
!          mfjobout(name,(double)dpi/bdpi);
        else
           (void)system(buf) ;
     }
*** output.c	1995/10/02 07:30:19	2.1
--- output.c	1995/10/02 07:49:36
***************
*** 16,21 ****
--- 16,30 ----
  #define pclose(pstream) _pclose(pstream)
  #endif
  #endif
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      26-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_figpath ;
+ extern struct emtex_dir ed_headerpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  /*
   *   The external routines called here:
   */
***************
*** 141,149 ****
--- 150,168 ----
   *   Look in headerpath too, just in case.  This allows common header
   *   or figure files to be installed in the .../ps directory.
   */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+       f = emtex_dir_search(&ed_figpath, s, READ) ;
+ #else
        f = search(figpath, s, READ) ;
+ #endif
        if (f == 0)
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+          f = emtex_dir_search(&ed_headerpath, s, READ) ;
+ #else
           f = search(headerpath, s, READ) ;
+ #endif
  #ifdef VMCMS
        lastdirsep = strrchr(s, '/') ;
        if ( NULL != lastdirsep ) trunc_s = lastdirsep + 1 ;
***************
*** 161,167 ****
--- 180,191 ----
  #endif
        break ;
     default:
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+       f = emtex_dir_search(&ed_headerpath, s, READ) ;
+ #else
        f = search(headerpath, s, READ) ;
+ #endif
        (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
        break ;
  #ifndef VMCMS
***************
*** 232,238 ****
--- 256,267 ----
        if (c == 0x80) {
  #if defined MSDOS || defined OS2 || defined(ATARIST)
           (void)fclose(f) ;  /* close MSDOS font file */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+          f = emtex_dir_search(&ed_headerpath, s, READBIN) ;  /* reopen in BINARY mode */
+ #else
           f = search(headerpath, s, READBIN) ;  /* reopen in BINARY mode */
+ #endif
           (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
           if (f==NULL)
             error(errbuf) ;
***************
*** 305,311 ****
--- 334,345 ----
  	                            && (getc(f)=='F'+0x80)) {
  #if defined MSDOS || defined OS2
                 (void)fclose(f) ;  /* close DOS EPS file */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+                f = emtex_dir_search(&ed_headerpath, s, READBIN) ;
+ #else
                 f = search(headerpath, s, READBIN) ;
+ #endif
                                                     /* reopen in BINARY mode */
                 (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
                 if (f==NULL)
***************
*** 324,330 ****
--- 358,369 ----
                 dosepsend += dosepsbegin;
  #if defined MSDOS || defined OS2
                 (void)fclose(f) ;  /* close DOS EPS file */
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 26-sep-95 */
+                f = emtex_dir_search(&ed_headerpath, s, READ) ;  /* reopen in TEXT mode */
+ #else
                 f = search(headerpath, s, READ) ;  /* reopen in TEXT mode */
+ #endif
                 (void)sprintf(errbuf, "! Couldn't find header file %s", s) ;
                 if (f==NULL)
                   error(errbuf) ;
*** resident.c	1995/10/02 07:30:19	2.1
--- resident.c	1995/10/02 07:49:40
***************
*** 10,15 ****
--- 10,37 ----
   */
  #include "dvips.h" /* The copyright notice in that file is included too! */
  #include "paths.h"
+ 
+ 
+ /*      Include definitions from emtexdir.h if EMTEXDIR is set.
+  *      setting up the emtex-dir structures for all pathes.
+  *      sawade@physik.tu-berlin.de      25-sep-95
+  */
+ #ifdef EMTEXDIR
+ #include "emtexdir.h"
+ 
+ extern FILE * emtex_dir_search() ;
+ 
+ struct emtex_dir        ed_vfpath,      
+                         ed_pictpath,    
+                         ed_tfmpath,     
+                         ed_figpath,     
+                         ed_flipath,
+                         ed_headerpath,  
+                         ed_configpath   
+ ;
+ #endif
+ 
+ 
  /*
   *   This is the structure definition for resident fonts.  We use
   *   a small and simple hash table to handle these.  We don't need
***************
*** 274,284 ****
--- 296,329 ----
  static char *getpath(who, what)
  char *who, *what ;
  {
+    char varname[80], *v;
     if (who) {
        register char *pp, *qq ;
        int lastsep = 1 ;
  
        for (pp=nextstring, qq=who; *qq;) {
+ /*********          Additions for variable $(var) expanding into <var>  */
+ /*********          sawade@physik.tu-berlin.de          3/95            */
+          if ( *qq == '$') {
+             if (*++qq == '(') {
+                v = varname;
+                while( *++qq ) {
+                   if( (*v++ = *qq) == ')' ) {
+                      *(v-1) = '\0';
+                      qq++; 
+                      if ( getenv(varname) ) {
+                         strcpy(pp, getenv(varname)); 
+                         pp = pp + strlen(pp); 
+                         lastsep = 0;
+                      }
+                      break;
+                   }
+                }
+             } else {
+                qq--; /* no '(' follows '$', ignore  */
+             } 
+          }
+ /*********          end of additions for variable expansion             */
           if (*qq == PATHSEP) {
              if (lastsep) {
                 strcpy(pp, what) ;
***************
*** 329,334 ****
--- 374,400 ----
        bad_config() ;
     return newstring(tstr) ;
  }
+ 
+ #ifdef EMTEXDIR
+ /*   Now the setting up routine to fetch the list of directories.
+  *   This is only an adaption of the original emtex_dir_setup
+  *   function from emtexdir.c by E. Mattes.
+  *   sawade@physik.tu-berlin.de         25-sep-95
+  */
+ int ed_path_setup (struct emtex_dir *ed, const char *path,
+                    const char *dir, unsigned flags)
+ {
+   extern int setup_list() ;
+   char dummy[260] ;
+ 
+   ed->alloc = 0;
+   ed->used = 0;
+   ed->list = NULL;
+   return( setup_list (ed, dummy, path, flags) );
+ }
+ #endif
+ 
+ 
  /*
   *   Now we have the getdefaults routine.
   */
***************
*** 365,371 ****
--- 431,442 ----
        strcat(PSname, printer) ;
  #endif
     }
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    if ((deffile=emtex_dir_search(&ed_configpath,PSname,READ))!=NULL) {
+ #else
     if ((deffile=search(d,PSname,READ))!=NULL) {
+ #endif
        while (fgets(was_inline, INLINE_SIZE, deffile)!=NULL) {
  /*
   *   We need to get rid of the newline.
***************
*** 460,465 ****
--- 531,546 ----
              if (sscanf(was_inline+1, "%s", PSname) != 1) bad_config() ;
              else {
                 flipath = getpath(fliparse(PSname,tempname), flipath);
+ /*
+  *      Yes, we use emtex_dir routines also for flipath :)
+  *      sawade@physik.tu-berlin.de      25-sep-95
+  */
+ #ifdef EMTEXDIR
+                if( !ed_path_setup (&ed_flipath, flipath, NULL, EDS_BANG ) ) {
+                   printf("\n** ed_path_setup for FLIPATH failed. Abort.\n");
+                   exit(1);
+                }
+ #endif
                 fliname = newstring(tempname) ;
              }
  	 }
***************
*** 652,658 ****
--- 733,744 ----
  
     if (name == 0)
        name = psmapfile ;
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    if ((deffile=emtex_dir_search(&ed_configpath,name,READ))!=NULL) {
+ #else
     if ((deffile=search(configpath, name, READ))!=NULL) {
+ #endif
        while (fgets(was_inline, INLINE_SIZE, deffile)!=NULL) {
           p = was_inline ;
           if (*p > ' ' && *p != '*' && *p != '#' && *p != ';' && *p != '%') {
***************
*** 715,738 ****
--- 801,902 ----
  {
     return getpath(getenv(who), what) ;
  }
+ 
+ 
+ /*
+  * Here is a lot of code added for setting up the lists of directories.
+  * sawade@physik.tu-berlin.de           25-sep-95
+  */
  #ifdef SEARCH_SUBDIRECTORIES
  static char *concat3();
  #endif
  void checkenv(which)
  int which ;
  {
+    int i;
+ 
     if (which) {
        tfmpath = getenvup(FONTPATH, tfmpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("FONTPATH") )
+            (void) fprintf(stderr, "\n!! tfmpath replaced by FONTPATH.\n");
+ #endif
+ #ifdef EMTEXDIR
+      if( !ed_path_setup (&ed_tfmpath, tfmpath, NULL, EDS_BANG ) ) {
+         printf("\n** ed_path_setup for tfmpath failed. Abort.\n");
+         exit(1);
+      }
+ #endif
+ 
        vfpath = getenvup("VFFONTS", vfpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("VFFONTS") )
+            (void) fprintf(stderr, "\n!! vfpath replaced by VFFONTS.\n");
+ #endif
+ #ifdef EMTEXDIR
+      if( !ed_path_setup (&ed_vfpath, vfpath, NULL, EDS_BANG ) ) {
+         printf("\n** ed_path_setup for vfpath failed. Abort.\n");
+         exit(1);
+      }
+ #endif
+ 
        pictpath = getenvup("TEXPICTS", pictpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("TEXPICTS") )
+            (void) fprintf(stderr, "\n!! pictpath replaced by TEXPICTS.\n");
+ #endif
+ #ifdef EMTEXDIR
+      if( !ed_path_setup (&ed_pictpath, pictpath, NULL, EDS_BANG ) ) {
+         printf("\n** ed_path_setup for pictpath failed. Abort.\n");
+         exit(1);
+      }
+ #endif
+ 
        figpath = getenvup("TEXINPUTS", figpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("TEXINPUTS") )
+            (void) fprintf(stderr, "\n!! figpath replaced by TEXINPUTS.\n");
+ #endif
+ #ifdef EMTEXDIR
+      if( !ed_path_setup (&ed_figpath, figpath, NULL, EDS_BANG ) ) {
+         printf("\n** ed_path_setup for figpath failed. Abort.\n");
+         exit(1);
+      }
+ #endif
+ 
        headerpath = getenvup("DVIPSHEADERS", headerpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("DVIPSHEADERS") )
+            (void) fprintf(stderr, "\n!! headerpath replaced by DVIPSHEADERS.\n");
+ #endif
+ #ifdef EMTEXDIR
+      if( !ed_path_setup (&ed_headerpath, headerpath, NULL, EDS_BANG ) ) {
+         printf("\n** ed_path_setup for headerpath failed. Abort.\n");
+         exit(1);
+      }
+ #endif
+ 
        if (getenv("TEXPKS"))
           pkpath = getenvup("TEXPKS", pkpath) ;
        else if (getenv("TEXPACKED"))
           pkpath = getenvup("TEXPACKED", pkpath) ;
        else if (getenv("PKFONTS"))
           pkpath = getenvup("PKFONTS", pkpath) ;
+ #ifdef DEBUG
+      if( dd(D_PATHS) )
+         if( getenv("TEXPKS") ) 
+            (void) fprintf(stderr, "\n!! pkpath replaced by TEXPKS.\n");
+         else if( getenv("TEXPACKED") )
+            (void) fprintf(stderr, "\n!! pkpath replaced by TEXPACKED.\n");
+         else if( getenv("PKFONTS") )
+            (void) fprintf(stderr, "\n!pkpath replaced by PKFONTS.\n");
+ #endif
+ 
  #ifdef SEARCH_SUBDIRECTORIES
        else if (getenv(FONTPATH))
           pkpath = getenvup(FONTPATH, pkpath) ;
***************
*** 751,758 ****
        }
  #endif
     } else
!       configpath = getenvup("TEXCONFIG", configpath) ;
  }
  
  #ifdef SEARCH_SUBDIRECTORIES
  
--- 915,952 ----
        }
  #endif
     } else
! /*
!  *      The following makes emTeX/dvips setup more comfortable,
!  *      because TEXCONFIG defaults to $(EMTEXDIR)\data\dvips.
!  *      sawade@physik.tu-berlin.de      25-sep-95
!  */
! #ifdef EMTEX
!    {
! #ifdef DEBUG
!      if( dd(D_PATHS) )
!         if( getenv("TEXCONFIG") )
!            (void) fprintf(stderr, "\n!! configpath replaced by TEXCONFIG.\n");
! #endif
!      if( getenv("TEXCONFIG") == NULL ) {
!         if( getenv("EMTEXDIR") == NULL )
!            configpath = getpath("\\emtex\\data\\dvips", configpath) ;
!         else
!            configpath = getpath("$(EMTEXDIR)\\data\\dvips", configpath) ;
!      } else
!        configpath = getenvup("TEXCONFIG", configpath) ;
! 
! #ifdef EMTEXDIR
!      if( !ed_path_setup (&ed_configpath, configpath, NULL, EDS_BANG ) ) {
!         printf("\n** ed_path_setup for configpath failed. Abort.\n");
!         exit(1);
!      }
! #endif
!    }
! #else
!      configpath = getenvup("TEXCONFIG", configpath) ;
! #endif
  }
+ 
  
  #ifdef SEARCH_SUBDIRECTORIES
  
*** search.c	1995/10/02 07:30:19	2.1
--- search.c	1995/10/02 07:49:44
***************
*** 1,3 ****
--- 1,4 ----
+ 
  /*
   *   The search routine takes a directory list, separated by PATHSEP, and
   *   tries to open a file.  Null directory components indicate current
***************
*** 11,21 ****
--- 12,34 ----
  FILE *fat_fopen();
  #endif
  
+ #if defined OS2 || defined MSDOS
+ #include <string.h>
+ #endif
+ 
  #if defined(SYSV) || defined(VMS) || defined(__THINK__) || defined(MSDOS) || defined(OS2) || defined(ATARIST)
  #define MAXPATHLEN (256)
  #else
  #include <sys/param.h>          /* for MAXPATHLEN */
  #endif
+ 
+ /*
+  * sawade@physik.tu-berlin.de   25-sep-95
+  */
+ #ifdef EMTEXDIR
+ #include "emtexdir.h"
+ #endif
+ 
  #if !defined(MSDOS) && !defined(OS2)
  #ifndef VMS
  #ifndef MVSXA
***************
*** 74,87 ****
  #endif   /* IBM: VM/CMS */
  
  #if defined MSDOS || defined OS2 || defined(ATARIST)
!    if ( isalpha(file[0]) && file[1]==':' ) {   /* if full path name */
!       if ((fd=fopen(file,mode)) != NULL) {
!          strcpy(realnameoffile, file) ;
!          return(fd) ;
!       } else
!          return(NULL) ;
!    }
!    if (*file == '/') {/* if full path name with unix DIRSEP less drive code */
        if ((fd=fopen(file,mode)) != NULL) {
           strcpy(realnameoffile, file) ;
           return(fd) ;
--- 87,94 ----
  #endif   /* IBM: VM/CMS */
  
  #if defined MSDOS || defined OS2 || defined(ATARIST)
!     if ( (isalpha(file[0]) && file[1]==':')   /* if full path name */
!            || *file == '/' || *file == '\\' ) {   /* or path from root, sawade 10/94 */
        if ((fd=fopen(file,mode)) != NULL) {
           strcpy(realnameoffile, file) ;
           return(fd) ;
***************
*** 105,110 ****
--- 112,123 ----
                 if (0 != (home = getenv("HOME")))
                    home = newstring(home) ;
                 else
+ #if defined MSDOS || defined OS2
+ /*      Under dos / os2 better use TEXCONFIG, when HOME is empty, saw 31-7-95    */
+                   if (0 != (home = getenv("TEXCONFIG")))
+                      home = newstring(home) ;
+                   else
+ #endif
                    home = "." ;
              }
              strcpy(fname, home) ;
***************
*** 206,211 ****
--- 219,254 ----
  
  }               /* end search */
  
+ 
+ /*
+  * And this is used instead, if EMTEXDIR is defined.
+  * emtex style directory search.
+  * sawade@physik.tu-berlin.de   25-sep-95
+  */
+ #ifdef EMTEXDIR
+ FILE * emtex_dir_search(list, file, mode)
+         struct emtex_dir *list ;
+         char *file, *mode ;
+ {
+    FILE *ret;
+    char name[MAXPATHLEN];
+ 
+ #ifdef DEBUG
+    if (dd(D_PATHS))
+       (void)fprintf(stderr,"\nemtex_dir_search: Trying to locate %s\n", file) ;
+ #endif
+    if( emtex_dir_find(realnameoffile, sizeof(realnameoffile), list, file, EDF_CWD) ) {
+ #ifdef DEBUG
+       if (dd(D_PATHS))
+          (void)fprintf(stderr,"        -> found: %s\n", realnameoffile);
+ #endif
+       return( fopen(realnameoffile, mode) );
+    }
+    return(NULL);
+ }
+ #endif
+ 
+ 
  FILE *
  pksearch(path, file, mode, n, dpi, vdpi)
          char *path, *file, *mode ;
***************
*** 249,254 ****
--- 292,303 ----
                 if (0 != (home = getenv("HOME")))
                    home = newstring(home) ;
                 else
+ #if defined MSDOS || defined OS2
+ /*      Under dos / os2 better use TEXCONFIG, when HOME is empty, saw 31-7-95    */
+                   if (0 != (home = getenv("TEXCONFIG")))
+                      home = newstring(home) ;
+                   else
+ #endif
                    home = "." ;
              }
              strcpy(fname, home) ;
***************
*** 381,386 ****
--- 430,436 ----
     if (tf == (FILE *)NULL)
       tf = fat_fopen(n, t); /* try again with filename truncated to 8.3 */
  #endif
+ 
     return tf ;
  }
  #endif
***************
*** 417,422 ****
--- 467,476 ----
     /* copy it to nbuf, truncating to 8.3 */
     ns = np;
     nd = nbuf;
+    if (*(ns+1) == ':') {        /* If the filename starts with a        */
+       *nd++ = *ns++;            /* Drive-Letter specification,          */
+       *nd++ = *ns++;            /* pass these two charcters whithout    */
+    }                            /* truncation.           saw 24-3-95    */
     ni = 0;
     while ((*ns!='.') && (*ns) && (ni<8)) {
        *nd++ = *ns++;
***************
*** 442,450 ****
     if ((ni>8) || (ne>3)) {
        strcpy(np,nbuf);
        /* now code copied from my_real_fopen() */
        if (dd(D_FILES)) {
           fprintf(stderr, "<%s(%s)> ", n, t) ;
-          tf = fopen(n, t) ;
           if (tf == 0)
              fprintf(stderr, "failed\n") ;
           else
--- 496,505 ----
     if ((ni>8) || (ne>3)) {
        strcpy(np,nbuf);
        /* now code copied from my_real_fopen() */
+       tf = fopen(n, t) ;
+ #ifdef DEBUG    /* Added for proper compilation without DEBUG defined, saw 23-5-95 */
        if (dd(D_FILES)) {
           fprintf(stderr, "<%s(%s)> ", n, t) ;
           if (tf == 0)
              fprintf(stderr, "failed\n") ;
           else
***************
*** 452,459 ****
--- 507,517 ----
        }
        else
           tf = fopen(n, t) ;
+ #endif        /* dito, saw 23-5-95 */
        return tf;
     }
     return (FILE *)NULL;
  }
  #endif
+ 
+ 
*** special.lpr	1995/10/02 07:30:19	2.1
--- special.lpr	1995/10/02 07:49:46
***************
*** 175,181 ****
  %
  %
  % psfigTeX PostScript Prolog
! % $Header: F:/sawdvips/dvihps/RCS\\special.lpr 2.1 1995/10/02 07:30:19 sawade dvihps $
  %
  /psfts { S 65781.76 div N } N
  
--- 175,181 ----
  %
  %
  % psfigTeX PostScript Prolog
! % $Header: F:/sawdvips/dvihps/RCS\\special.lpr 2.2 1995/10/02 07:42:15 sawade saw244 $
  %
  /psfts { S 65781.76 div N } N
  
*** tfmload.c	1995/10/02 07:30:19	2.1
--- tfmload.c	1995/10/02 07:49:50
***************
*** 23,28 ****
--- 23,35 ----
  FILE *tfmfile ; 
  static char name[50] ;
  
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      25-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_tfmpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  /*
   *   Tries to open a tfm file.  Uses cmr10.tfm if unsuccessful,
   *   and complains loudly about it.
***************
*** 42,48 ****
--- 49,60 ----
  #else
     (void)sprintf(name, "%s.tfm", n) ;
  #endif
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    if ((tfmfile=emtex_dir_search(&ed_tfmpath,name,READBIN))==NULL) {
+ #else
     if ((tfmfile=search(d, name, READBIN))==NULL) {
+ #endif
        (void)sprintf(errbuf, "Can't open font metric file %s%s",
               fd->area, name) ;
        error(errbuf) ;
***************
*** 50,56 ****
--- 62,73 ----
  #ifdef MVSXA   /* IBM: MVS/XA */
        if ((tfmfile=search(d, "tfm(cmr10)", READBIN))==NULL)
  #else
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+       if ((tfmfile=emtex_dir_search(&ed_tfmpath,"cmr10.tfm",READBIN))==NULL)
+ #else
        if ((tfmfile=search(d, "cmr10.tfm", READBIN))==NULL)
+ #endif
  #endif
           error(
            "! I can't find cmr10.tfm; please reinstall me with proper paths") ;
*** virtualf.c	1995/10/02 07:30:19	2.1
--- virtualf.c	1995/10/02 07:49:50
***************
*** 3,8 ****
--- 3,16 ----
   *   Any resemblance between this file and loadfont.c is purely uncoincidental.
   */
  #include "dvips.h" /* The copyright notice in that file is included too! */
+ 
+ #ifdef EMTEXDIR
+ /*      sawade@physik.tu-berlin.de      25-sep-95       */
+ #include "emtexdir.h"
+ extern struct emtex_dir ed_vfpath ;
+ extern FILE * emtex_dir_search() ;
+ #endif
+ 
  /*
   *   These are the external routines we use.
   */
***************
*** 95,101 ****
--- 103,114 ----
  #else
     (void)sprintf(name, "%s.vf", n) ;
  #endif
+ #ifdef EMTEXDIR
+ /*  using emtex_dir_search instead of search.       sawade 25-sep-95 */
+    if (0 != (vffile=emtex_dir_search(&ed_vfpath, name, READBIN)))
+ #else
     if (0 != (vffile=search(d, name, READBIN)))
+ #endif
        return(1) ;
     return(0) ;
  }
