/* Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gzacpath.h */
/* Private representation of clipping path accumulator */
/* Requires gxdevice.h, gzcpath.h */

/* Device for accumulating a rectangle list. */
typedef struct gx_device_cpath_accum_s {
	gx_device_common;
	gs_memory_t *list_memory;		/* set by client */
	gs_int_rect bbox;
	gx_clip_list list;
} gx_device_cpath_accum;

/* Start accumulating a clipping path. */
void gx_cpath_accum_begin(P2(gx_device_cpath_accum *padev, gs_memory_t *mem));

/* Finish accumulating a clipping path. */
int gx_cpath_accum_end(P2(const gx_device_cpath_accum *padev,
			  gx_clip_path *pcpath));

/* Discard an accumulator in case of error. */
void gx_cpath_accum_discard(P1(gx_device_cpath_accum *padev));
