// datetime.hxx
//
// defines the OS/2 date and time classes
//
// (c) Copyright 1988 Aspen Scientific
// All Rights Reserved.

// the date-and-time class definition

class DateAndTime {

friend struct DateAndTimePlus;			// allow use of private members

	// the following is for private class use

	DATETIME	*dtBuf;			// OS/2 date and time buffer
	char		*showBuf;		// format buffer
	char		*showDateOnly;		// format buffer for date
	char		*showTimeOnly;		// format buffer for time
	static char	*errorMsg;		// an "error" message
	static char	**monthName;		// month names
	static char	**dayName;		// names of days of week
	int		showSize;		// the size of the show buffer
	int		dateSize;		// the size of the date only
	int		timeSize;		// the size of the time only

	// the following is for public use
public:

	DateAndTime(int dt =0, int tm =0);	// constructor
	~DateAndTime();				// destructor

	// make date and time current
	void		Update()	{ DosGetDateTime((PDATETIME) dtBuf); }

	char		*Show();		// return string for full info
	char		*ShowDate();		// return only a date string
	char		*ShowTime();		// return only a time string

	// return the size of the date and time buffers
	int		Size()		{ return (showSize); }
	int		DateSize()	{ return (dateSize); }
	int		TimeSize()	{ return (timeSize); }

};

// now, derive a class from DateAndTime to handle
// looking at each member of the dtBuf structure.

struct DateAndTimePlus : public DateAndTime {

	// we have no data to hide, only public functions to declare.
	// therefore, we will use a struct, rather than a class.

	// the constructor: it takes the same arguments as
	// its base, and calls the base constructor with the
	// arguments.  the constructor for this class actually
	// does nothing more than help to construct its base.

	DateAndTimePlus(int dt =0, int tm =0) : (dt, tm) { }

	// the destructor: see the constructor

	~DateAndTimePlus() { }

	int	GetHours()	{ return ( dtBuf->hours ); }
	int	GetMinutes()	{ return ( dtBuf->minutes ); }
	int	GetSeconds()	{ return ( dtBuf->seconds ); }
	int	GetHundredths()	{ return ( dtBuf->hundredths ); }
	int	GetDay()	{ return ( dtBuf->day ); }
	int	GetMonth()	{ return ( dtBuf->month ); }
	int	GetYear()	{ return ( dtBuf->year ); }
	int	GetTimeZone()	{ return ( dtBuf->timezone ); }
	int	GetWeekDay()	{ return ( dtBuf->weekday ); }

};
