/* resource.h	support for string Resource interface.
 *
 *	author: vaughn vernon
 *
 *	(c) 1990 Aspen Scientific
 *	All Rights Reserved
 */

static const unsigned	_ResourceMagic=12345;

typedef	struct	_str_resource
{
	unsigned char	*idName;	/* pointer to name string */
	unsigned char	*string;	/* pointer to resource string */
	unsigned	value;		/* integer value of value string */
	unsigned	magic;		/* make use resource is cool */
struct	_str_resource	*next;		/* next resource */
} StringResource;

extern	StringResource *LoadResources(char *fileName);
extern	void		FreeResources(StringResource *res);
extern	StringResource *LookUpResource(StringResource *res, unsigned id);

#define GetResourceString(res)	\
	((res)->magic==_ResourceMagic ? ((res)->string):(unsigned char *)0)
#define GetResourceName(res)	\
	((res)->magic==_ResourceMagic ? ((res)->idName):(unsigned char *)0)
#define GetResourceID(res)	\
	((res)->magic==_ResourceMagic ? ((res)->value):0)
#define	NextResource(res)	\
	((res)->magic==_ResourceMagic ? ((res)->next):(StringResource *)0)
