' Program to list all lines in a Quickbasic file containing the specified string
' By Chris Rodliffe     cr@clear.net.nz
' GOTO's forever!
DECLARE SUB lreadafile (filename$)
DECLARE SUB getnamelist (filename$)
DECLARE SUB readafile (filename$)
DEFINT A-Z
DIM SHARED filename$(19)
PRINT
PRINT
PRINT "ListIf"
PRINT "(enter /o for options)"
GOSUB readconfig
inputfname:
PRINT
IF showdefaultname THEN
   PRINT "Filename    ";
   vpos0 = CSRLIN: hpos0 = POS(0)
   PRINT ifilename$;
   z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
   IF ASC(z$) = 13 THEN
      filename$ = ifilename$
      PRINT
     ELSE
      IF ASC(z$) > 32 AND ASC(z$) < 127 THEN az$ = z$ ELSE az$ = ""
      LOCATE vpos0, hpos0: PRINT "              ";
      LOCATE vpos0, hpos0: PRINT az$; : LINE INPUT afilename$
      filename$ = az$ + afilename$
      PRINT
   END IF
  ELSE
   INPUT "Filename [.BAS]"; filename$
END IF
IF filename$ = "" OR filename$ = "?" THEN GOSUB helpfname: GOTO inputfname
IF filename$ = "/o" OR filename$ = "/O" THEN GOSUB options: GOTO inputfname
IF INSTR(filename$, ".") = 0 THEN filename$ = filename$ + ".BAS"
ifilename$ = filename$
GOSUB saveoptions1     'Save filename and current options to LISTIF.CFG
inputsearch:
INPUT "Item to search for    "; isearch$
IF isearch$ = "" OR isearch$ = "?" THEN GOSUB helptext: GOTO inputsearch
IF isearch$ = "/o" OR isearch$ = "/O" THEN GOSUB options: GOTO inputsearch
IF LEFT$(isearch$, 1) = "|" THEN checklhs = 1: isearch$ = RIGHT$(isearch$, LEN(isearch$) - 1)
IF RIGHT$(isearch$, 1) = "|" THEN checkrhs = 1: isearch$ = LEFT$(isearch$, LEN(isearch$) - 1)
IF LCASE$(isearch$) = isearch$ THEN anycase = 1
'search$ was entered all in lower case
IF anycase THEN search$ = UCASE$(isearch$)
getoutputname:
IF sendtofile = 2 THEN
   IF LEN(search$) > 8 THEN s$ = LEFT$(search$, 8) ELSE s$ = search$
   outfile$ = s$ + ".LST"
   PRINT "Filename for output    ";
   vpos0 = CSRLIN: hpos0 = POS(0)
   PRINT outfile$;
   z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
   IF ASC(z$) = 13 THEN
      PRINT
     ELSE
      LOCATE vpos0, hpos0: PRINT "              ";
      LOCATE vpos0, hpos0: PRINT z$; : LINE INPUT outfile$
      outfile$ = z$ + outfile$
      PRINT
   END IF
END IF
IF sendtofile = 1 THEN outfile$ = "LISTIF.LST"
IF sendtofile THEN
   OPEN outfile$ FOR OUTPUT AS #3
   IF sendtofile THEN PRINT #3, UCASE$(filename$): PRINT #3,
   IF sendtofile THEN PRINT #3, "Searching for:  "; isearch$: PRINT #3,
END IF

IF INSTR(filename$, ".mak") THEN
   'get list if files in *.mak and work through them
   CALL getnamelist(filename$)
  ELSE
   nrfiles = 1: filename$(1) = filename$
END IF
i = 1
DO
   IF showlinenos = 1 THEN CALL lreadafile(filename$(i)) ELSE CALL readafile(filename$(i))
   i = i + 1
LOOP UNTIL i > nrfiles

CLOSE
END

helpfname:
PRINT
PRINT "Works best on Quickbasic / Qbasic files"
PRINT "May also work on other source code files"
PRINT "Files must be in ASCII (text) format"
PRINT
PRINT "If a .MAK filename is entered, program will search all files "
PRINT "named in that .MAK file"
PRINT
RETURN

helptext:
PRINT
PRINT "If input all lowercase, ignores case (matches any case)"
PRINT "If any uppercase letters, matches case exactly"
PRINT "If whole-word required, enter text as  |string|  "
RETURN


options:
'Subroutine to ask for options settings & save them to LISTIF.CFG file
filename$ = "": ifilename$ = ""
PRINT "Show last filename as default?   ";
IF showdefaultname = 1 THEN PRINT "Y/n  " ELSE PRINT "y/N  ";
z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
IF z$ = "Y" OR z$ = "y" THEN showdefaultname = 1
IF z$ = "N" OR z$ = "n" THEN showdefaultname = 0
PRINT
PRINT "Show line numbers in listing?    ";
IF showlinenos = 1 THEN PRINT "Y/n  " ELSE PRINT "y/N  ";
z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
IF z$ = "Y" OR z$ = "y" THEN showlinenos = 1
IF z$ = "N" OR z$ = "n" THEN showlinenos = 0
PRINT
PRINT "Output to Disk(file)?    ";
IF sendtofile THEN PRINT "Y/n  " ELSE PRINT "y/N  ";
z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
IF z$ = "N" OR z$ = "n" THEN sendtofile = 0: GOTO saveoptions
IF z$ = "Y" OR z$ = "y" THEN
asksendtofile:
   PRINT
   PRINT "1   Save to LISTIF.LST"
   PRINT "2   Save to <search>.LST"
   z$ = "": WHILE z$ = "": z$ = INKEY$: WEND
   IF z$ = "1" OR z$ = "2" THEN sendtofile = VAL(z$) ELSE GOTO asksendtofile
END IF

saveoptions:
PRINT
PRINT "Saving options to LISTIF.CFG file"
saveoptions1:
OPEN "LISTIF.CFG" FOR OUTPUT AS #1
PRINT #1, "|LISTIF.CFG - config file for LISTIF                "
PRINT #1, "showdefaultname = "; showdefaultname; "                                    |"
PRINT #1, "showlinenos = "; showlinenos; "                                        |"
PRINT #1, "sendtofile = "; sendtofile; "                                        |"
PRINT #1, "inputname = "; ifilename$; "                                   |"
CLOSE #1
RETURN




readconfig:
'subroutine to read in settings from LISTIF.CFG file
ON ERROR GOTO cfgerror
OPEN "LISTIF.CFG" FOR INPUT AS #1
ON ERROR GOTO 0
DO
   LINE INPUT #1, a$
   IF INSTR(a$, "showdefaultname") > 0 THEN showdefaultname = VAL(LTRIM$(RTRIM$(MID$(a$, INSTR(a$, "=") + 1, (INSTR(a$, "|") - INSTR(a$, "=") - 1)))))
   IF INSTR(a$, "showlinenos") > 0 THEN showlinenos = VAL(LTRIM$(RTRIM$(MID$(a$, INSTR(a$, "=") + 1, (INSTR(a$, "|") - INSTR(a$, "=") - 1)))))
   IF INSTR(a$, "sendtofile") > 0 THEN sendtofile = VAL(LTRIM$(RTRIM$(MID$(a$, INSTR(a$, "=") + 1, (INSTR(a$, "|") - INSTR(a$, "=") - 1)))))
   IF INSTR(a$, "inputname") > 0 THEN ifilename$ = LTRIM$(RTRIM$(MID$(a$, INSTR(a$, "=") + 1, (INSTR(a$, "|") - INSTR(a$, "=") - 1))))
LOOP UNTIL EOF(1)
CLOSE #1
RETURN


cfgerror:
IF ERR = 53 THEN
   'LISTIF.CFG file not found in current directory - create one with defaults
   showdefaultname = 1
   showlinenos = 1
   sendtofile = 0
   ifilename$ = "<myfile>.BAS"
   GOSUB saveoptions1
END IF
RESUME

SUB getnamelist (filename$)
   SHARED nrfiles, sendtofile
   OPEN filename$ FOR INPUT AS #2
   i = 0
   DO
      i = i + 1
      LINE INPUT #2, filename$(i)
      PRINT filename$(i)
      IF sendtofile THEN PRINT #3, filename$(i)
   LOOP UNTIL EOF(2)
   CLOSE #2
   nrfiles = i
END SUB

SUB lreadafile (filename$)
   'This version adds line numbers to the display
   'Not included with the non-line-number version so as not to slow it down
   SHARED checklhs, checkrhs, anycase, search$, nrfiles, sendtofile
   OPEN filename$ FOR INPUT AS #1
   lineno = 0
   
   PRINT
   PRINT "File  "; filename$
   PRINT
   IF sendtofile THEN PRINT #3, : PRINT #3, "File  "; filename$: PRINT #3,
   
   
lreadaline:
   lineno = lineno + 1
   IF endit THEN CLOSE #1: EXIT SUB
   LINE INPUT #1, a$
   IF EOF(1) THEN endit = 1
   
   d$ = a$         'use d$ to test for current SUB logic
   
   
   IF INSTR(d$, "'$INCLUDE:") THEN
      'check for $INCLUDEd files and add name to list to check
      d1$ = RIGHT$(d$, LEN(d$) - INSTR(d$, ":"))
      IF INSTR(d1$, "'") = 0 THEN GOTO lskipit
      d1$ = RIGHT$(d1$, LEN(d1$) - INSTR(d1$, "'"))
      d1$ = LEFT$(d1$, INSTR(d1$, "'") - 1)
      inclname$ = d1$
      i = 1
lcheckfilelist:
      IF inclname$ = filename$(i) THEN GOTO lskipit      'Filename already listed
      i = i + 1
      IF i <= nrfiles THEN GOTO lcheckfilelist
      nrfiles = nrfiles + 1
      filename$(nrfiles) = inclname$
lskipit:
   END IF
   
   
   
   IF INSTR(d$, "'") THEN d$ = LEFT$(d$, INSTR(d$, "'"))
   IF INSTR(d$, "REM") THEN d$ = LEFT$(d$, INSTR(d$, "REM"))
   
   IF INSTR(d$, "DECLARE SUB") THEN GOTO lskippedsubs:
   
   IF INSTR(d$, "EXIT SUB") THEN GOTO lskippedsubs:
   
   IF INSTR(d$, "END SUB") OR INSTR(d$, "ENDSUB") THEN
      currentsub$ = "": subprinted = 0
      GOTO lreadaline
   END IF
   
   IF INSTR(d$, "SUB") > 0 AND INSTR(d$, "GOSUB") = 0 THEN
      'extract current sub name from line
      dd$ = RIGHT$(d$, LEN(d$) - INSTR(d$, "SUB") - 2)
      IF INSTR(dd$, "(") THEN
         currentsub$ = LEFT$(dd$, INSTR(dd$, "(")) + ")"
        ELSE
         dd$ = LTRIM$(dd$)
         currentsub$ = dd$
      END IF
   END IF
   
   
lskippedsubs:
   
   c$ = a$        ' Use c$ for searching in line
   GOSUB lsearchforstring
   
   GOTO lreadaline
   
   
lsearchforstring:
   IF anycase THEN c$ = UCASE$(a$) ELSE c$ = a$
lcontsearch:
   
   IF INSTR(c$, search$) > 0 THEN GOSUB lcheckit
   IF checkfailed THEN
      IF c + LEN(search$) < LEN(c$) THEN
         c$ = RIGHT$(c$, LEN(c$) - c - LEN(search$))    'try remainder of line for string sought
         GOTO lcontsearch
      END IF
   END IF
   RETURN
   
lcheckit:
   'check whether whole-word if so required
   checkfailed = 0
   IF checklhs OR checkrhs THEN GOTO lchecking
   GOSUB lfoundit: RETURN
   
lchecking:
   IF checklhs THEN
      c = INSTR(c$, search$)
      IF c > 1 THEN d$ = MID$(c$, c - 1, 1)    ' get character 1 to left of search$
      checkfailed = 1
      GOSUB lcheckd
      IF d$ = "(" THEN checkfailed = 0
      IF checkfailed = 1 THEN RETURN
   END IF
   IF checkrhs THEN
      c = INSTR(c$, search$)
      IF c + LEN(search$) > LEN(c$) THEN GOSUB lfoundit: RETURN      'search$ is at end of line
      d$ = MID$(c$, c + LEN(search$), 1)    'get character 1 to right of search$
      checkfailed = 1
      GOSUB lcheckd
      IF d$ = ")" THEN checkfailed = 0
      IF checkfailed = 1 THEN RETURN
   END IF
   GOSUB lfoundit
   RETURN
   
   
lcheckd:
   'check whether character d$ is a space, comma etc or part of a word
   'checkfailed indicates string found is part of a bigger word
   'resets checkfailed to 0 if character d$ is NOT part of a word
   IF d$ = " " THEN checkfailed = 0: RETURN
   IF d$ = "." THEN checkfailed = 0: RETURN
   IF d$ = "," THEN checkfailed = 0: RETURN
   IF d$ = "'" THEN checkfailed = 0: RETURN
   IF d$ = "REM" THEN checkfailed = 0: RETURN
   IF d$ = ":" THEN checkfailed = 0: RETURN
   IF d$ = ";" THEN checkfailed = 0: RETURN
   IF d$ = "+" THEN checkfailed = 0: RETURN
   IF d$ = "-" THEN checkfailed = 0: RETURN
   IF d$ = "*" THEN checkfailed = 0: RETURN
   IF d$ = "/" THEN checkfailed = 0: RETURN
   IF d$ = "=" THEN checkfailed = 0: RETURN
   IF d$ = ">" THEN checkfailed = 0: RETURN
   IF d$ = "<" THEN checkfailed = 0: RETURN
   IF d$ = "^" THEN checkfailed = 0: RETURN
   RETURN
   
   
lfoundit:
   IF currentsub$ > "" AND subprinted = 0 THEN
      PRINT "SUB " + currentsub$: subprinted = 1
      IF sendtofile THEN
         PRINT #3, "SUB " + currentsub$
      END IF
   END IF
   PRINT RIGHT$("      " + STR$(lineno), 5); "   ";
   PRINT a$
   IF sendtofile THEN
      PRINT #3, RIGHT$("      " + STR$(lineno), 5); "   ";
      PRINT #3, a$
   END IF
   RETURN
   
END SUB

SUB readafile (filename$)
   SHARED checklhs, checkrhs, anycase, search$, nrfiles, sendtofile
   OPEN filename$ FOR INPUT AS #1
   
   PRINT
   PRINT "File  "; filename$
   PRINT
   IF sendtofile THEN PRINT #3, : PRINT #3, "File  "; filename$; : PRINT #3,
   
   
readaline:
   IF endit THEN CLOSE #1: EXIT SUB
   LINE INPUT #1, a$
   IF EOF(1) THEN endit = 1
   
   d$ = a$         'use d$ to test for current SUB logic
   
   
   IF INSTR(d$, "'$INCLUDE:") THEN
      'check for $INCLUDEd files and add name to list to check
      d1$ = RIGHT$(d$, LEN(d$) - INSTR(d$, ":"))
      IF INSTR(d1$, "'") = 0 THEN GOTO skipit
      d1$ = RIGHT$(d1$, LEN(d1$) - INSTR(d1$, "'"))
      d1$ = LEFT$(d1$, INSTR(d1$, "'") - 1)
      inclname$ = d1$
      i = 1
checkfilelist:
      IF inclname$ = filename$(i) THEN GOTO skipit      'Filename already listed
      i = i + 1
      IF i <= nrfiles THEN GOTO checkfilelist
      nrfiles = nrfiles + 1
      filename$(nrfiles) = inclname$
skipit:
   END IF
   
   
   
   IF INSTR(d$, "'") THEN d$ = LEFT$(d$, INSTR(d$, "'"))
   IF INSTR(d$, "REM") THEN d$ = LEFT$(d$, INSTR(d$, "REM"))
   
   IF INSTR(d$, "DECLARE SUB") THEN GOTO skippedsubs:
   
   IF INSTR(d$, "EXIT SUB") THEN GOTO skippedsubs:
   
   IF INSTR(d$, "END SUB") OR INSTR(d$, "ENDSUB") THEN
      currentsub$ = "": subprinted = 0
      GOTO readaline
   END IF
   
   IF INSTR(d$, "SUB") > 0 AND INSTR(d$, "GOSUB") = 0 THEN
      'extract current sub name from line
      dd$ = RIGHT$(d$, LEN(d$) - INSTR(d$, "SUB") - 2)
      IF INSTR(dd$, "(") THEN
         currentsub$ = LEFT$(dd$, INSTR(dd$, "(")) + ")"
        ELSE
         dd$ = LTRIM$(dd$)
         currentsub$ = dd$
      END IF
   END IF
   
   
skippedsubs:
   
   c$ = a$        ' Use c$ for searching in line
   GOSUB searchforstring
   
   GOTO readaline
   
   
searchforstring:
   IF anycase THEN c$ = UCASE$(a$) ELSE c$ = a$
contsearch:
   
   IF INSTR(c$, search$) > 0 THEN GOSUB checkit
   IF checkfailed THEN
      IF c + LEN(search$) < LEN(c$) THEN
         c$ = RIGHT$(c$, LEN(c$) - c - LEN(search$))    'try remainder of line for string sought
         GOTO contsearch
      END IF
   END IF
   RETURN
   
checkit:
   'check whether whole-word if so required
   checkfailed = 0
   IF checklhs OR checkrhs THEN GOTO checking
   GOSUB foundit: RETURN
   
checking:
   IF checklhs THEN
      c = INSTR(c$, search$)
      IF c > 1 THEN d$ = MID$(c$, c - 1, 1)    ' get character 1 to left of search$
      GOSUB checkd
      IF checkfailed = 1 THEN RETURN
   END IF
   IF checkrhs THEN
      c = INSTR(c$, search$)
      IF c + LEN(search$) > LEN(c$) THEN GOSUB foundit: RETURN      'search$ is at end of line
      d$ = MID$(c$, c + LEN(search$), 1)    'get character 1 to right of search$
      GOSUB checkd
      IF checkfailed = 1 THEN RETURN
   END IF
   GOSUB foundit
   RETURN
   
   
checkd:
   'check whether character d$ is a space, comma etc or part of a word
   'checkfailed indicates string found is part of a bigger word
   'resets checkfailed to 0 if character d$ is NOT part of a word
   checkfailed = 1
   IF d$ = " " THEN checkfailed = 0: RETURN
   IF d$ = "." THEN checkfailed = 0: RETURN
   IF d$ = "," THEN checkfailed = 0: RETURN
   IF d$ = "'" THEN checkfailed = 0: RETURN
   IF d$ = "REM" THEN checkfailed = 0: RETURN
   IF d$ = ":" THEN checkfailed = 0: RETURN
   IF d$ = ";" THEN checkfailed = 0: RETURN
   IF d$ = "+" THEN checkfailed = 0: RETURN
   IF d$ = "-" THEN checkfailed = 0: RETURN
   IF d$ = "*" THEN checkfailed = 0: RETURN
   IF d$ = "/" THEN checkfailed = 0: RETURN
   IF d$ = "=" THEN checkfailed = 0: RETURN
   IF d$ = ">" THEN checkfailed = 0: RETURN
   IF d$ = "<" THEN checkfailed = 0: RETURN
   IF d$ = "^" THEN checkfailed = 0: RETURN
   IF d$ = "(" THEN checkfailed = 0: RETURN
   IF d$ = ")" THEN checkfailed = 0: RETURN
   RETURN
   
   
foundit:
   IF currentsub$ > "" AND subprinted = 0 THEN
      PRINT "SUB " + currentsub$: subprinted = 1
      IF sendtofile THEN
         PRINT #3, "SUB " + currentsub$
      END IF
   END IF
   PRINT a$
   IF sendtofile THEN
      PRINT #3, a$
   END IF
   RETURN
   
END SUB

