TITLE  'Draw Ellipse EGA - VIDEO SYSTEMS p.234'
NAME   DRAWELL
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Draw an ellipse in EGA/VGA (W for window bounded)      |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWELL(0,7,320,175,50,50)                        |
;                call DRAWELLW(0,7,320,175,50,50)                       |
;    stack:     +06 = minor axes                                        |
;                08 = major axes                                        |
;                10 = yC                                                |
;                12 = xC                                                |
;                14 = value of pixel                                    |
;                16 = replacement type                                  |
;  returns:      none                                                   |
;     NOTE:      yC-min must be >= 0 else early out (W only)            |
;------------------------------------------------------------------------

PARMS           = 6
ARGaddtype      EQU [bp+16]
ARGvalue        EQU [bp+14]
ARGxC           EQU [bp+12]
ARGyC           EQU [bp+10]
ARGmaj          EQU [bp+08]
ARGmin          EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawEll_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawEll_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawEll,DrawEllW
DrawEll         PROC    FAR

                mov     InWindow,0
                jmp     short DrawEll2

DrawEllW        LABEL FAR
                mov     InWindow,1

DrawEll2:       push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGvalue
                mov     ax,[bx]
                mov     PixelValue,ax
                mov     bx,ARGxC
                mov     ax,[bx]
                mov     xC,ax
                mov     bx,ARGmaj
                mov     ax,[bx]
                mov     maj,ax

                mov     bx,ARGyC
                mov     ax,[bx]
                mov     yC,ax
                mov     bx,ARGmin
                mov     cx,[bx]
                mov     min,cx

                cmp     InWindow,0      ;no check if not window mode
                je      DE1

                sub     ax,cx           ;yC-min
                jns     DE1             ;make sure topmost Y >= 0
                jmp     Lexit1

                ;set up Graphics Controller

DE1:            mov     dx,03CEh        ;dx = Graphics Controller I/O port
                mov     ax,5
                out     dx,ax

                ;set data rotate/function select register

                mov     ah,byte ptr RMWbits
                mov     al,3            ;reg number
                out     dx,ax           ;update this register

                ;set set/reset and enable set/reset registers

                mov     ah,byte ptr PixelValue
                mov     al,0
                out     dx,ax

                mov     ax,0F01h
                out     dx,ax

                ;initial constants

                mov     ax,maj
                mul     ax
                mov     Asquared,ax
                mov     Asquared+2,dx
                shl     ax,1
                rcl     dx,1
                mov     TwoAsquared,ax
                mov     TwoAsquared+2,dx

                mov     ax,min
                mul     ax
                mov     Bsquared,ax
                mov     Bsquared+2,dx
                shl     ax,1
                rcl     dx,1
                mov     TwoBsquared,ax
                mov     TwoBsquared+2,dx

                ;plot pixels froms (0,b) until dy/dx = -1
                ;initial buffer address and bit mask

                mov     ax,bpl
                mul     min
                mov     si,ax
                mov     di,ax

                mov     ax,yC
                mov     bx,xC
                mov     cx,bpl
                call    PixelAddr

                mov     ah,1
                shl     ah,cl
                mov     byte ptr LMask,ah
                mov     byte ptr RMask,ah

                add     si,bx
                mov     ULAddr,si
                mov     URAddr,si
                sub     bx,di
                mov     LLAddr,bx
                mov     LRAddr,bx

                ;initial decision variables

                xor     ax,ax
                mov     vdx,ax
                mov     vdx+2,ax

                mov     ax,TwoAsquared
                mov     dx,TwoAsquared+2
                mov     cx,min
                call    LongMultiply
                mov     vdy,ax
                mov     vdy+2,dx

                mov     ax,Asquared
                mov     dx,Asquared+2
                sar     dx,1
                rcr     ax,1
                sar     dx,1
                rcr     ax,1

                add     ax,Bsquared
                adc     dx,Bsquared+2
                mov     vd,ax
                mov     vd+2,dx

                mov     ax,Asquared
                mov     dx,Asquared+2
                mov     cx,min
                call    LongMultiply
                sub     vd,ax
                sbb     vd+2,dx

                ;loop until dy/dx= -1

                mov     bx,min
                xor     cx,cx

L10:            mov     ax,vdx
                mov     dx,vdx+2
                sub     ax,vdy
                sbb     dx,vdy+2
                jns     L20

                call    Set4Pixels

                mov     cx,1
                cmp     vd+2,0
                js      L11

                mov     ch,1
                dec     bx

                mov     ax,vdy
                mov     dx,vdy+2
                sub     ax,TwoAsquared
                sbb     dx,TwoAsquared+2
                mov     vdy,ax
                mov     vdy+2,dx

                sub     vd,ax
                sbb     vd+2,dx

L11:            mov     ax,vdx
                mov     dx,vdx+2
                add     ax,TwoBsquared
                adc     dx,TwoBsquared+2
                mov     vdx,ax
                mov     vdx+2,dx

                add     ax,Bsquared
                adc     dx,Bsquared+2
                add     vd,ax
                adc     vd+2,dx

                jmp     L10

                ;plot pixels from current (x,y) until y<0
                ;initial buffer address and bit planes

L20:            push    bx
                push    cx

                mov     ax,Asquared
                mov     dx,Asquared+2
                sub     ax,Bsquared
                sbb     dx,Bsquared+2

                mov     bx,ax
                mov     cx,dx

                sar     dx,1
                rcr     ax,1
                add     ax,bx
                adc     dx,cx

                sub     ax,vdx
                sbb     dx,vdx+2
                sub     ax,vdy
                sbb     dx,vdy+2

                sar     dx,1
                rcr     ax,1

                add     vd,ax
                adc     vd+2,dx

                ;loop until y < 0

                pop     cx
                pop     bx

L21:            call    Set4Pixels

                mov     cx,0100h

                cmp     vd+2,0
                jns     L22

                mov     cl,1

                mov     ax,vdx
                mov     dx,vdx+2
                add     ax,TwoBsquared
                adc     dx,TwoBsquared+2
                mov     vdx,ax
                mov     vdx+2,dx

                add     vd,ax
                adc     vd+2,dx

L22:            mov     ax,vdy
                mov     dx,vdy+2
                sub     ax,TwoAsquared
                sbb     dx,TwoAsquared+2
                mov     vdy,ax
                mov     vdy+2,dx

                sub     ax,Asquared
                sbb     dx,Asquared+2
                sub     vd,ax
                sbb     vd+2,dx

                dec     bx
                jns     L21

                ;restore default graphics controller registers

Lexit:          mov     ax,0FF08h
                mov     dx,03CEh
                out     dx,ax

                mov     ax,3
                out     dx,ax

                mov     ax,1
                out     dx,ax

Lexit1:         pop     di
                pop     si
                pop     ds
                mov     sp,bp
                pop     bp
                RET     PARMS*2

DrawEll         ENDP
                
Set4Pixels      PROC NEAR

                push    ax
                push    bx
                push    dx
                mov     dx,03CEh
                cmp     InWindow,1      ;window bound?
                je      S4W             ;yes

                xor     bx,bx
                test    ch,ch
                jz      L30
                mov     bx,bpl
                neg     bx
L30:            mov     al,8

                ;pixels at (xC-x,yC+y) and (xC-x,yC-y)

                xor     si,si
                mov     ah,byte ptr LMask
                rol     ah,cl
                rcl     si,1
                neg     si
                mov     di,si
                add     si,ULAddr
                add     si,bx
                add     di,LLAddr
                sub     di,bx
                mov     byte ptr LMask,ah
                mov     ULAddr,si
                mov     LLAddr,di
                out     dx,ax
                mov     ch,es:[si]
                mov     es:[si],ch
                mov     ch,es:[di]
                mov     es:[di],ch

                ;pixels at (xC+x,yC+y) and (xC+x,yC-y)

                xor     si,si
                mov     ah,byte ptr RMask
                ror     ah,cl
                rcl     si,1
                mov     di,si
                add     si,URAddr
                add     si,bx
                add     di,LRAddr
                sub     di,bx
                mov     byte ptr RMask,ah
                mov     URAddr,si
                mov     LRAddr,di
                out     dx,ax
                mov     ch,es:[si]
                mov     es:[si],ch
                mov     ch,es:[di]
                mov     es:[di],ch
                pop     dx
                pop     bx
                pop     ax
                ret

S4W:            xor     bx,bx           ;check if points are in window
                test    ch,ch
                jz      L30W
                mov     bx,bpl
                neg     bx
L30W:           mov     al,8

                ;pixels at (xC-x,yC+y) and (xC-x,yC-y)

                xor     si,si
                mov     ah,byte ptr LMask
                rol     ah,cl
                rcl     si,1
                neg     si
                mov     di,si
                add     si,ULAddr       ;lower-left really
                add     si,bx
                add     di,LLAddr       ;upper-left
                sub     di,bx
                mov     byte ptr LMask,ah
                mov     ULAddr,si
                mov     LLAddr,di
                out     dx,ax           ;set bit mask
                push    dx
                push    bx
                sub     dx,dx           ;ready for 32x16 div
                mov     bx,bpl
                mov     ax,si           ;check lower Y of ellipse
                div     bx              ;ax=lower y-coor
                mov     LOy,ax          ;save it
                                        ;bx=640 for 80 byte line
                sub     dx,dx
                mov     ax,di           ;check upper Y of ellipse
                div     bx              ;ax=upper y-coor
                mov     HIy,ax          ;save it
                                        ;DX HAS REMAINDER!!!
                sub     ax,ax
                mov     bx,ax
                mov     al,byte ptr LMask
L32:            inc     bx              ;count to pixel mask in byte
                shl     al,1            ;for offset of pixel into byte
                jnc     L32
                dec     bx              ;zero base x
                mov     ax,dx           ;get remainder (same for HI & LO)
                shl     ax,1
                shl     ax,1
                shl     ax,1            ;8 horz pixels per byte
                add     ax,bx           ;add offset
                mov     LFx,ax          ;ax=left x-coor
                cmp     ax,X0clip2      ;is this point left of X0?
                jb      SK2             ;yes,no set either upper or lower
                cmp     ax,X1clip2      ;is this point right of X1?
                ja      SK2             ;yes,no set either upper or lower
                                        ;x-coor is okay...
                mov     ax,LOy          ;check LLy
                cmp     ax,Y0clip2      ;is this point before Y0?
                jb      SK1             ;yes,no set
                cmp     ax,Y1clip2      ;is this point after Y1?
                ja      SK1             ;yes,no set
                mov     ch,es:[si]      ;lower-left pixel okay...
                mov     es:[si],ch
SK1:            mov     ax,HIy          ;check ULy
                cmp     ax,Y0clip2      ;is this point before Y0?
                jb      SK2             ;yes,no set
                cmp     ax,Y1clip2      ;is this point after Y1?
                ja      SK2             ;yes,no set
                mov     ch,es:[di]      ;upper-left pixel okay...
                mov     es:[di],ch
SK2:            pop     bx
                pop     dx

                ;pixels at (xC+x,yC+y) and (xC+x,yC-y)

                mov     al,8            ;bit mask register
                xor     si,si
                mov     ah,byte ptr RMask
                ror     ah,cl
                rcl     si,1
                mov     di,si
                add     si,URAddr       ;lower-right really
                add     si,bx
                add     di,LRAddr       ;upper-right
                sub     di,bx
                mov     byte ptr RMask,ah
                mov     URAddr,si
                mov     LRAddr,di
                out     dx,ax           ;set bit mask
                push    dx
                push    bx
                sub     dx,dx           ;ready for 32x16 div
                mov     bx,bpl
                mov     ax,si           ;check lower Y of ellipse
                div     bx              ;ax=lower y-coor
                mov     LOy,ax          ;save it
                                        ;bx=640 for 80 byte line
                sub     dx,dx
                mov     ax,di           ;check upper Y of ellipse
                div     bx              ;ax=upper y-coor
                mov     HIy,ax          ;save it
                                        ;DX HAS REMAINDER!!!
                sub     ax,ax
                mov     bx,ax
                mov     al,byte ptr RMask
L33:            inc     bx              ;count to pixel mask in byte
                shl     al,1            ;for offset of pixel into byte
                jnc     L33
                dec     bx              ;zero base x
                mov     ax,dx           ;get remainder (same for HI & LO)
                shl     ax,1
                shl     ax,1
                shl     ax,1            ;8 horz pixels per byte
                add     ax,bx           ;add offset
                mov     RTx,ax          ;ax=left x-coor
                cmp     ax,X0clip2      ;is this point left of X0?
                jb      SK4             ;yes,no set either upper or lower
                cmp     ax,X1clip2      ;is this point right of X1?
                ja      SK4             ;yes,no set either upper or lower
                                        ;x-coor is okay...
                mov     ax,LOy          ;check LRy
                cmp     ax,Y0clip2      ;is this point before Y0?
                jb      SK3             ;yes,no set
                cmp     ax,Y1clip2      ;is this point after Y1?
                ja      SK3             ;yes,no set
                mov     ch,es:[si]      ;lower-right pixel okay...
                mov     es:[si],ch
SK3:            mov     ax,HIy          ;check URy
                cmp     ax,Y0clip2      ;is this point before Y0?
                jb      SK4             ;yes,no set
                cmp     ax,Y1clip2      ;is this point after Y1?
                ja      SK4             ;yes,no set
                mov     ch,es:[di]      ;upper-right pixel okay...
                mov     es:[di],ch
SK4:            pop     bx              ;clean stack
                pop     dx

                pop     dx
                pop     bx
                pop     ax
                ret

Set4Pixels      ENDP

LongMultiply    PROC NEAR

                push    ax
                mov     ax,dx
                mul     cx
                xchg    ax,cx
                pop     dx
                mul     dx
                add     dx,cx
                ret

LongMultiply    ENDP
DrawEll_TEXT    ENDS
                END

