TITLE  'Draw a line in step EGA - VIDEO SYSTEMS p.191'
NAME   DRAWLNS
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Draw a line in step EGA\VGA                            |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWLNS(0,7,320,199)                              |
;    stack:     +06 = y1                                                |
;                08 = x1                                                |
;                10 = value of pixel                                    |
;                12 = replacement type                                  |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 4
ARGaddtype      EQU [bp+12]
ARGvalue        EQU [bp+10]
ARGx1           EQU [bp+08]
ARGy1           EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawLnS_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME  cs:DrawLnS_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawLnS
DrawLnS         PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGvalue
                mov     ax,[bx]
                mov     PixelValue,ax

                mov     bx,ARGx1
                mov     ax,[bx]
                mov     x1,ax
                push    ax              ;save then since we might switch
                mov     bx,ARGy1        ;them around
                mov     ax,[bx]
                mov     y1,ax
                push    ax

                ;set up Graphics Controller

                mov     dx,03CEh        ;dx = Graphics Controller I/O port
                mov     ah,byte ptr PixelValue
                xor     al,al           ;reg number
                out     dx,ax           ;update this register

                mov     ax,0F01h        ;ah = 0F (bit plane mask for enable\..
                out     dx,ax           ;al = reg number

                mov     ah,byte ptr RMWbits     ;bits 3 & 4 of ah = function
                mov     al,3            ;al = reg number
                out     dx,ax

                ;check for vertical line

                mov     si,bpl          ;increment for video buffer
                mov     cx,x1
                sub     cx,x0
                jz      VertLine10

                ;force x0 < x1

                jns     L01             ;jump if x1 > x0
                neg     cx              ;cx = x1 - x2
                mov     bx,x1           ;exchange x0 and x1
                xchg    bx,x0
                mov     x1,bx
                mov     bx,y1           ;exchange y0 and y1
                xchg    bx,y0
                mov     y1,bx

                ;calculate dy = abs(y1-y0)

L01:            mov     bx,y1
                sub     bx,y0           ;bx = y1 - y0
                jz      HorizLine10     ;jump if horizontal line

                jns     L03             ;jump if slope is positive

                neg     bx              ;bx = y0 - y1
                neg     si              ;negative increment for buff interleave

                ;select appropriate routine for slope of line

L03:            mov     VertIncr,si  ;save vertical increment
                mov     Routine,offset LoSlopeLine10
                cmp     bx,cx
                jle     L04             ;jump if dy <= dx (slope <=1)
                mov     Routine,offset HiSlopeLine10
                xchg    bx,cx           ;exchange dy and dx

                ;calculate initial decision variable and increments

L04:            shl     bx,1            ;bx= 2*dy
                mov     Incr1,bx        ;incr1 = 2*dy
                sub     bx,cx
                mov     si,bx           ;si = d = 2*dy-dx
                sub     bx,cx
                mov     Incr2,bx        ;incr2 = 2*(dy-dx)

                ;calculate first pixel address

                push    cx              ;preserve this register
                mov     ax,y0           ;ax = y
                mov     bx,x0           ;bx = x
                mov     cx,bpl
                call    PixelAddr       ;ah = bitmask
                                        ;es:bx -> buffer
                                        ;cl = # bits to shift left
                mov     di,bx           ;es:di -> buffer
                shl     ah,cl           ;ah = bit mask in proper position
                mov     bl,ah           ;ah,bl = bit mask
                mov     al,8            ;al = bit mask reg number

                pop     cx
                inc     cx              ;cx = pixels to draw

                jmp     Routine         ;jump to appropriate slope routine

                ;routine for vertical lines

VertLine10:     mov     ax,y0           ;ax = y0
                mov     bx,y1           ;bx = y1
                mov     cx,bx
                sub     cx,ax           ;cx = dy
                jge     L31             ;jump if dy >= 0

                neg     cx              ;force dy >=0
                mov     ax,bx           ;ax = y1

L31:            inc     cx              ;cx = # pixels to draw
                push    cx              ;preserve this register
                mov     bx,x0           ;bx = x0
                mov     cx,bpl
                call PixelAddr

                ;set up Graphics controller

                shl     ah,cl           ;ah = bit mask in proper position
                mov     al,8            ;bit mask reg number
                out     dx,ax

                pop     cx

                ;draw the line

L32:            or      es:[bx],al      ;set pixel
                add     bx,si           ;increment to next line
                loop    L32

                jmp     Lexit

                ;routine for horizontal lines (slope = 0)

HorizLine10:    push    ds
                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr

                mov     di,bx           ;es:di -> buffer
                mov     dh,ah           ;dh = unshifted bit mask for left byte
                not     dh
                shl     dh,cl           ;dh = reverse bit mask for first byte
                not     dh              ;sh = bit mask for first byte

                mov     cx,x1
                and     cl,7
                xor     cl,7            ;cl = number of bits to shift left

                mov     dl,0FFh         ;dl = unshifted bit mask for right byte
                shl     dl,cl           ;dl = bit mask for last byte

                ;determine byte offset of first and last pixel in the line

                mov     ax,x1           ;ax = x1
                mov     bx,x0           ;bx = x0

                mov     cl,ByteOffsetShift      ;number of bits to shift left
                                                ;convert pixels to bytes
                shr     ax,cl           ;ax = byte offset of x1
                shr     bx,cl           ;bx = byte offset of x0
                mov     cx,ax
                sub     cx,bx           ;cx = # bytes per line - 1

                ;get Graphics controller port address into DX

                mov     bx,dx           ;bh = bit mask for first byte
                                        ;bl = bit mask for last byte
                mov     dx,03CEh        ;dx = graphics controller port
                mov     al,8            ;al = bit mask reg number

                ;make video buffer addressable through ds:di

                push    es
                pop     ds
                ASSUME ds:nothing
                mov     si,di           ;ds:si = video buffer

                ;set pixels in left byte of the line

                or      bh,bh
                js      L43             ;jump if byte-aligned

                or      cx,cx
                jnz     L42             ;jump if more than one byte in the line

                and     bl,bh           ;bl = bit mask for the line
                jmp     short L44

L42:            mov     ah,bh           ;bl = bit mask for the line
                out     dx,ax           ;update the graphics controller

                movsb
                dec     cx

                ;use a fast 8086 instruction to draw remainder of the line

L43:            mov     ah,11111111b    ;ah = bit mask
                out     dx,ax           ;update bit mask register
                rep     movsb

                ;set pixels in right byte of the line

L44:            mov     ah,bl           ;ah = bit mask for last byte
                out     dx,ax           ;update graphics controller
                movsb

                pop     ds
                ASSUME ds:dgroup
                jmp     short Lexit

                ;routine for dy >= dx (slope <= 1)
                        ;es:di -> video buffer
                        ;al = bit mask reg number
                        ;bl = bit mask for 1st pixel
                        ;cx = # pixels to draw
                        ;dx = graphics controller port addr
                        ;si = decision variable

LoSlopeLine10:

L10:            mov     ah,bl           ;ah = bit mask for next pixel
L11:            or      ah,bl           ;mask current pixel position
                ror     bl,1            ;rotate pixel value
                jc      L14             ;jump if bit mask rotate to leftmost
                                        ; pixel position

                ;bit mask not shifted out

                or      si,si           ;test sign of d
                jns     L12             ;jump if d >=0

                add     si,Incr1        ;d = d + incr1
                loop    L11

                out     dx,ax           ;update bit mask reg
                or      es:[di],al      ;set remaining pixel(s)
                jmp     short Lexit

L12:            add     si,Incr2        ;d = d +_ incr2
                out     dx,ax           ;update bit mask register
                or      es:[di],al      ;update bit planes

                add     di,VertIncr     ;increment y
                loop    L10
                jmp     short Lexit

                ;bit mask shifted out

L14:            out     dx,ax           ;update bit mask reg
                or      es:[di],al      ; bit planes
                inc     di              ; increment x

                or      si,si           ;test sign of d
                jns     L15             ;jimp if non-negative

                add     si,Incr1        ;d = d + incr1
                loop    L10
                jmp     short Lexit

L15:            add     si,Incr2        ;d = d + incr2
                add     di,VertIncr     ;vertical increment
                loop    L10
                jmp     short Lexit

                ;routine for dy > dx (slope > 1)
                        ;es:di -> video buffer
                        ;ah = bit mask for 1st pixel
                        ;al = bit mask reg number
                        ;cx = # pixels to draw
                        ;dx = graphics controller port addr
                        ;si = decision variable

HiSlopeLine10:  mov     bx,VertIncr     ;bx = y-increment
L21:            out     dx,ax           ;update bit mask reg
                or      es:[di],al      ;update bit mask planes
                add     di,bx           ;increment y

L22:            or      si,si           ;test sign of d
                jns     L23             ;jump if d >= 0

                add     si,Incr1        ;d = d + incr1
                loop    L21
                jmp     short Lexit

L23:            add     si,Incr2        ;d = d + incr2
                ror     ah,1            ;rotate bit mask
                adc     di,0            ;increment di if when mask rotated to
                                        ; leftmost pixel position
                loop    L21

                ;restore default graphics controller state and return to caller

Lexit:          xor     ax,ax
                out     dx,ax           ;restore set\reset register

                inc     ax
                out     dx,ax           ;restore enable set\reset reg

                mov     al,3
                out     dx,ax           ;data rotate\function select reg

                mov     ax,0FF08h
                out     dx,ax           ;restore bit mask reg

                pop     ax
                mov     ss:y0,ax        ;get the unswitched x1,y1
                pop     ax              ;and update for next step
                mov     ss:x0,ax

                pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                mov     sp,bp
                pop     bp
                RET     PARMS*2

DrawLnS         ENDP
DrawLnS_TEXT    ENDS
                END

