TITLE  'System Font xx - uses local data in code segment'
NAME   FNSYSXX
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Set active graphic font 2 standard system font(8,14,16)|
;   caller:      FAR call (QuickBASIC convention)                       |
;                FONTSYS08 or FONTSYS14 or FONTSYS16                    |
;    stack:      none                                                   |
;  returns:      long int seg:off of char data start or NOTHING         |
;------------------------------------------------------------------------

PARMS           = 0

FNSYSXX_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:FNSYSXX_TEXT

                PUBLIC  FONTSYS16,FONTSYS14,FONTSYS08
FNSYSXX         PROC FAR

FONTSYS16       LABEL FAR
                mov     ax,1A00h        ;VGA font available?
                int 10h
                cmp     al,1Ah
                mov     bh,6            ;8X16 font
                mov     byte ptr cs:ptsb,16
                je      SYSXXa          ;if not, fall through to 14pt EGA font
FONTSYS14       LABEL FAR
                mov     bh,2            ;8x14 font
                mov     byte ptr cs:ptsb,14
                jmp     short SYSXXa
FONTSYS08       LABEL FAR
                mov     bh,3            ;8x8 font
                mov     byte ptr cs:ptsb,8
SYSXXa:         push    bp              ;save for QB
                mov     ax,1130h
                int 10h                 ;get address of system font
                                        ;cx=pts, es:bp address of table
                mov     dx,bp           ;dx=offset
                pop     bp
                push    ds              ;save for QB
                sub     ax,ax
                mov     ds,ax           ;ds->0 seg
                mov     cx,cs:ptsw
                mov     ds:[0485h],cx   ;update BIOS points

                mov     di,043h * 4     ;INT 43->graphic char data
                mov     ds:[di],dx
                mov     ds:[di+2],es
                mov     ax,dx
                mov     dx,es           ;dx:ax->new vector
                pop     ds

                RET     PARMS*2

ptsw            label word
ptsb            db 0,0                  ;BIOS bug returns pts as the
                                        ;current pts, not what we wanted
FNSYSXX         ENDP
FNSYSXX_TEXT    ENDS
                END

