TITLE  'Read Dot EGA - VIDEO SYSTEMS p.127'
NAME   READDOT
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      return a pixel (x,y) value (function)                  |
;   caller:      FAR call (QuickBASIC convention)                       |
;                pixel = READDOT(320,175)                               |
;    stack:     +06 = y-coordinate                                      |
;                08 = x-coordinate                                      |
;  returns:      pixel value                                            |
;------------------------------------------------------------------------

PARMS           = 2
ARGx            EQU [bp+08]
ARGy            EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

ReadDot_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:ReadDot_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  ReadDot
ReadDot         PROC    FAR

                push    bp
                mov     bp,sp
                push    si

                cld
                mov     bx,ARGy
                mov     ax,[bx]         ;ax=y
                mov     y0,ax           ;update step point
                mov     bx,ARGx
                mov     bx,[bx]         ;bx=x
                mov     x0,bx
                mov     cx,bpl

                call    PixelAddr

                mov     ch,ah
                shl     ch,cl           ;ch=bit mask in proper position

                mov     si,bx           ;es:si -> regen buffer byte
                xor     bl,bl           ;bl is used to accumulate the pixel value
                mov     dx,03CEh        ;dx = graphics controller port
                mov     ax,0304h        ;ah = initial bit plane number
                                        ;al = read map select reg
L01:            out     dx,ax           ;select bit plane
                mov     bh,es:[si]      ;bh = byte from current bit plane
                and     bh,ch           ;mask one bit
                neg     bh              ;bit 7 of bh = 1 (if mask bit = 1)
                                        ;bit 7 of bh = 0 (if mask bit = 0)
                rol     bx,1            ;bit 0 of bl = next bit from pixel value
                dec     ah              ;ah = next bit plane number
                jge     L01

                xor     ax,ax
                mov     al,bl           ;al = pixel value

                pop     si
                mov     sp,bp
                pop     bp
                RET     PARMS*2

ReadDot         ENDP
ReadDot_TEXT    ENDS
                END

