TITLE  'Set/Get parameter save area (PSA)
NAME   SETPSA
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      11 Feb 91                                              |
; function:      set/get palette save area                              |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETPSA(onoff)                                     |
;                call GETPSA(vseg,voff)                                 |
;    stack:     +06 = mode or 17-byte data area offset                  |
;                08 = string segment                                    |
;  returns:      none                                                   |
;     NOTE:      SETPSA() must be turned off (if turned on) before exit |
;     NOTE:      GETPSA must be 17 byte data area (pal17)               |
;     NOTE:      if SETPSA 1 and already installed,won't be done again  |
;     NOTE:      if SETPSA 0 and not installed,won't be deinstalled     |
;     NOTE:      if GETPSA and psa is unitialized,pal17 not changed     |
;     NOTE:      B_OnExit is not available with QB 4.00b!!!             |
;-----------------------------------------------------------------------|

PARMS           = 2     ;or 1
ARGmode         EQU [bp+06]
ARGseg          EQU [bp+08]
ARGoff          EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

SetPSA_TEXT     SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:SetPSA_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SetPSA
SetPSA          PROC    FAR

                push    bp
                mov     bp,sp
                push    si
                push    di
                push    ds

                mov     bx,ARGmode
                cmp     [bx],word ptr 0
                je      PSAoff

                sub     ax,ax
                mov     ds,ax
                ASSUME ds:nothing
                mov     si,ds:[04A8h]           ;table pointer off
                mov     bx,ds:[04AAh]           ;table pointer seg
                mov     ax,cs
                cmp     bx,ax                   ;already pointing to us?
                je      SetPSAxit               ;then outa here
                mov     cs:SavePointerOld,si
                mov     cs:SavePointerOld+2,bx
                mov     ds,bx                   ;ds:si->org save pointer table
                mov     ax,cs
                mov     es,ax
                mov     di,offset SavePointer   ;es:di->new one here
                mov     cx,14                   ;copy what's already there
                rep     movsw                   ;to here
                mov     ax,offset PSAdata
                mov     cs:PSAaddr,ax           ;update our Save Pointer Table
                mov     cs:PSAaddr+2,cs         ;to reflect new PSA
                sub     ax,ax
                mov     ds,ax
                mov     ax,offset SavePointer
                cli
                mov     ds:[04A8h],ax           ;point BIOS to our table
                mov     ds:[04AAh],cs
                sti

SetPSAxit:      pop     ds
                ASSUME ds:dgroup
                pop     di
                pop     si
                pop     bp
                RET 2

PSAoff:         sub     ax,ax
                mov     ds,ax
                ASSUME ds:nothing
                mov     ax,cs
                cmp     ds:[04AAh],ax           ;is it our pointer?
                jne     PSAoffxit               ;no,leave it alone
                mov     ax,cs:SavePointerOld
                mov     bx,cs:SavePointerOld+2
                cli
                mov     ds:[04A8h],ax           ;point BIOS to org table
                mov     ds:[04AAh],bx
                sti
PSAoffxit:      pop     ds
                pop     di
                pop     si
                pop     bp
                RET 2

SetPSA          ENDP

                PUBLIC  GetPSA
GetPSA          PROC    FAR

                ASSUME ds:dgroup
                push    bp
                mov     bp,sp
                push    si
                push    di
                push    ds
                mov     bx,ARGoff
                mov     di,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:di->palette string lies here

                sub     ax,ax
                mov     ds,ax
                ASSUME ds:nothing
                mov     si,ds:[04A8h]
                mov     ds,ds:[04AAh]   ;ds:si->save pointer table
                mov     ax,ds:[si+4]    ;get offset of PSA
                mov     ds,ds:[si+6]    ;get segment of PSA
                mov     si,ax           ;ds:si->palette save area

                mov     ax,ds
                or      ax,si           ;pointer uninitialized?
                jz      GetPSAxit       ;yes
                mov     cx,8            ;17 bytes (8 words + 1 byte)
                rep     movsw           ;copy to our string
                movsb

GetPSAxit:      pop     ds
                ASSUME ds:dgroup
                pop     di
                pop     si
                pop     bp
                RET     PARMS*2
GetPSA          ENDP

EVEN
SavePointerOld  dw 0,0          ;original save pointer table address

SavePointer     LABEL word      ;new save pointer table
VPaddr          dw 0,0
PSAaddr         dw 0,0          ;palette save area pointer
ACSOaddr        dw 0,0
GCSOaddr        dw 0,0
SSPaddr         dw 0,0
                dw 0,0
                dw 0,0
PSAdata         db 256 dup(0)

SetPSA_TEXT     ENDS
                END

