TITLE  'Transform/Translate/Scale in 2D'
NAME   XFORM2D
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Transform/Translate/Scale in 2D                        |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call XFORM2D(vseg,voff)                                |
;    stack:     +06 = offset of data packet                             |
;                08 = segment of data packet                            |
;  returns:      none                                                   |
;-----------------------------------------------------------------------|

PARMS           = 2
ARGpackseg      EQU [bp+08]
ARGpackoff      EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

XFORM2D_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:XFORM2D_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  XFORM2D
XFORM2D         PROC    FAR

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGpackoff
                mov     si,[bx]
                mov     bx,ARGpackseg
                mov     es,[bx]
                mov     di,offset dgroup:xtype2
                mov     cx,13           ;packet is 13 words
                push    ds
                mov     ax,es
                mov     bx,ds           ;es:di->dgroup:xtype2
                mov     es,bx
                mov     ds,ax           ;ds:si->passed seg:off
                rep     movsw           ;copy xform2d pack to dgroup
                pop     ds
            
                mov     cx,points2
                or      cx,cx
                jnz     TL1
TL0:            mov     ax,-1
                jmp     Trans2Dxit

TL1:            mov     ax,deg2         ;rotation in degrees
                call    GetTrig
                jc      TL0             ;bad degree
                mov     si,offXY2       ;ds:si -> xy() original pts data
                mov     es,segXYp2
                mov     di,offXYp2      ;es:di -> xy() new pts data
                mov     bx,10000        ;trig divisor
                mov     bp,100          ;scale divisor

; nx = (orgX + (((x0-orgX)*cos(deg) - (y0-orgY)*sin(deg)) * scaleX)) + Dx
; ny = (orgY + (((x0-orgX)*sin(deg) + (y0-orgY)*cos(deg)) * scaleY)) + Dy

L01:            push    ds
                mov     ds,segXY2       ;ds->original pts segment
                lodsw                   ;get x data
                xchg    ax,dx           ;temp store ax in dx
                lodsw                   ;get y data
                pop     ds              ;ds->dgroup

                mov     y0,ax
                xchg    ax,dx
                mov     x0,ax           ;x0,y0 are original pt data

                sub     ax,orgX2
                mov     x1,ax           ;x1=(x0-orgX)

                mov     ax,y0
                sub     ax,orgY2
                mov     y1,ax           ;y1=(y0-orgY)

                mov     ax,x1
                imul    COSdeg
                idiv    bx              ;ax=(x0-orgX)*cos(deg)

                push    ax

                mov     ax,y1
                imul    SINdeg
                idiv    bx              ;ax=(y0-orgY)*sin(deg)

                pop     dx
                xchg    ax,dx
                sub     ax,dx   ;ax=(x0-orgX)*cos(deg)-(y0-orgY)*sin(deg)

                imul     scaleX2
                idiv     bp             ;scale

                add     ax,orgX2        ;restore
                add     ax,transX2      ;and translate
                stosw                   ;replace x data pt with new

                mov     ax,x1
                imul    SINdeg
                idiv    bx              ;ax=(x0-orgX)*sin(deg)
                push    ax

                mov     ax,y1
                imul    COSdeg
                idiv    bx              ;ax=(y0-orgY)*cos(deg)

                pop     dx
                xchg    ax,dx           ;<-NN
                add     ax,dx   ;ax=(x0-orgX)*sin(deg)+(y0-orgY)*cos(deg)

                imul     scaleY2
                idiv     bp             ;scale

                add     ax,orgY2        ;restore
                add     ax,transY2      ;and translate
                stosw                   ;replace y data pt with new

                loop    L01             ;do for as many points
                xor     ax,ax

Trans2Dxit:     pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                pop     bp
                mov     sp,bp
                pop     bp
                RET     PARMS*2
XFORM2D         ENDP

;lookup the COS() & SIN() of degree in ax
;return in COSdeg & SINdeg
;carry set if out-of-range

GetTrig         PROC NEAR

                push    si
                or      ax,ax
                jge     GT0             ;must be positive
                jmp     GTbad

GT0:            cmp     ax,90
                jae     GT1
                ;For cos(  0 -  89) TrigTable (forward order)
                ;For sin(  0 -  89) TrigTableEnd (reverse order)
                mov     si,offset dgroup:TrigTable
                shl     ax,1            ;use ax as ptr into word table
                add     si,ax           ;si->cos(deg) in TrigTable
                mov     si,[si]
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTableEnd
                sub     si,ax           ;si->sin(deg) in TrigTable
                mov     si,[si]
                mov     SINdeg,si
                jmp     short GTxit

GT1:            cmp     ax,180
                jae     GT2
                ;For cos( 90 - 179) TrigTableEnd (reverse order & negative)
                ;For sin( 90 - 179) TrigTable (forward order)
                mov     si,offset dgroup:TrigTableEnd
                sub     ax,90
                shl     ax,1
                sub     si,ax
                mov     si,[si]
                neg     si
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTable
                add     si,ax
                mov     si,[si]
                mov     SINdeg,si
                jmp     short GTxit

GT2:            cmp     ax,270
                jae     GT3
                ;For cos(180 - 269) TrigTable (forward order & negative)
                ;For sin(180 - 269) TrigTableEnd (reverse order & negative)
                mov     si,offset dgroup:TrigTable
                sub     ax,180
                shl     ax,1
                add     si,ax
                mov     si,[si]
                neg     si
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTableEnd
                sub     si,ax
                mov     si,[si]
                neg     si
                mov     SINdeg,si
                jmp     short GTxit

GT3:            cmp     ax,359
                ja      GTbad
                ;For cos(270 - 359) TrigTableEnd (reverse order)
                ;For sin(270 - 359) TrigTable (forward order & negative)
                mov     si,offset dgroup:TrigTableEnd
                sub     ax,270
                shl     ax,1
                sub     si,ax
                mov     si,[si]
                mov     COSdeg,si
                mov     si,offset dgroup:TrigTable
                add     si,ax
                mov     si,[si]
                neg     si
                mov     SINdeg,si
GTxit:          clc
                pop     si
                ret

GTbad:          stc     ;above 359
                pop     si
                ret
GetTrig         ENDP

XFORM2D_TEXT    ENDS
                END

