DEFINT A-Z
'+==================================================================+
'|                           KEYBOARD.BAS                           |
'|                                                                  |
'|  A set of input routines developed by Larry Stone and the SWOCC  |
'|  students of Larry Stone, CS133B, Fall Term '91, SWOCC.          |
'+------------------------------------------------------------------+
'
DECLARE FUNCTION InsertState% ()
DECLARE FUNCTION KeyPressed% ()
DECLARE FUNCTION Lower% (Value%)
DECLARE FUNCTION Upper% (Value%)

CONST True = -1
CONST False = 0

'+==================================================================+
'|                            SUBPROGRAMS                           |
'+------------------------------------------------------------------+

FUNCTION InsertState%

    '---- Insert is either On or Off and InsertState% is set to True or False
    DEF SEG = False                         'Go to ROM segment
    InsertState% = (PEEK(&H417) AND 128) = 128  '1000 0000
    DEF SEG                                 'Back to BASIC DGROUP

END FUNCTION

'+==============================================================+
'|                     KeyPressed% FUNCTION                     |
'|                                                              |
'|  Input:  Nothing                                             |
'|  Return: The function returns an integer representing the    |
'|          ASCII value of a keystroke.  If an extended key     |
'|          value is returned from the keyboard buffer then the |
'|          right byte (scan code) is returned as a negative    |
'|          value.  If no keystroke is pending in the keyboard  |
'|          buffer then zero is returned.                       |
'+--------------------------------------------------------------+
FUNCTION KeyPressed%

    Temp$ = INKEY$               'Get a keystroke from the keyboard buffer

    IF LEN(Temp$) THEN           'If we got a key from the buffer

        '---- Set value representing the right byte
        AsciiValue = ASC(RIGHT$(Temp$, 1))

        '---- If extended key value then flag it so by changing its sign
        IF LEN(Temp$) = 2 THEN AsciiValue = -AsciiValue
    ELSE                         'No key value found in keyboard buffer

        AsciiValue = False       'So, set value to zero
    END IF

    KeyPressed = AsciiValue      'Set the function to value derived

END FUNCTION

'+==============================================================+
'|                        Lower% FUNCTION                       |
'|                                                              |
'|  Input:  An INTEGER value.                                   |
'|  Return: The function returns the integer, unaltered, if     |
'|          the value of the INTEGER is outside of the lower    |
'|          case letter range.  If the INTEGER is between 65    |
'|          and 90 (ASCII for 'A' through 'Z') then 32 is ORed  |
'|          (added), resulting in a return value of 97 through  |
'|          122 (ASCII for 'a' through 'z').                    |
'+--------------------------------------------------------------+
FUNCTION Lower% (Value%)
    IF Value > 64 AND Value < 91 THEN Lower = Value OR 32 ELSE Lower = Value
END FUNCTION

'+==============================================================+
'|                      RingSound SUBPROGRAM                    |
'|                                                              |
'|  Input:    Nothing                                           |
'|  Return:   Nothing                                           |
'|  Purpose:  Produces a more pleasing sound than BEEP.         |
'|            Does not use floating point library.              |
'|                                                              |
'+--------------------------------------------------------------+
SUB RingSound

    OUT &H43, 182                   ' set up for sound
    OUT &H42, &H33                  ' low part of sound
    OUT &H42, 5                     ' high part of sound
    N = INP(&H61)                   ' get byte value from port
    N1 = N                          ' save value as N1
    N = N OR 3                      ' set bits 0 and 1 to on
    OUT &H61, N                     ' turn on speaker
    GOSUB ShortDelay                ' delay 2 ticks
    OUT &H42, &H33                  ' low part second tone
    OUT &H42, 6                     ' high part second tone
    GOSUB ShortDelay                ' delay 2 ticks
    OUT &H61, N1                    ' turn speaker off
    
    DO: LOOP WHILE KeyPressed%      ' clear keyboard buffer

    EXIT SUB

ShortDelay:
    DelayTicks% = 2
    Tick% = False
    TestTick% = False

    DEF SEG = False                 ' ROM BIOS
    DO WHILE TestTick% < DelayTicks%
        LastTick% = Tick%
        Tick% = PEEK(&H46C)         ' get a tick from the clock.

        '   ---- Prevents endless loop when rolling past midnight.
        IF LastTick% <> Tick% THEN TestTick% = TestTick% + 1
    LOOP
    DEF SEG                         ' back to BASIC DGROUP
RETURN

END SUB

'+==============================================================+
'|                     TurnCapsOn SUBPROGRAM                    |
'|                                                              |
'|  Input:    ToggleOn%     Boolean, False to toggle lock state |
'|                          off, NOT False to toggle it on.     |
'|  Return:   Nothing                                           |
'|                                                              |
'+--------------------------------------------------------------+
SUB TurnCapsOn (ToggleOn%)

    DEF SEG = False                        'ROM segment
    IF ToggleOn% THEN
        POKE &H417, PEEK(&H417) OR 64      '0100 0000
    ELSE
        POKE &H417, PEEK(&H417) AND 191    '1011 1111
    END IF
    DEF SEG                                'Back to BASIC's DGROUP

END SUB

'+==============================================================+
'|                    TurnInsertOn SUBPROGRAM                   |
'|                                                              |
'|  Input:    ToggleOn%     Boolean, False to toggle lock state |
'|                          off, NOT False to toggle it on.     |
'|  Return:   Nothing                                           |
'|                                                              |
'+--------------------------------------------------------------+
SUB TurnInsertOn (ToggleOn%)

    DEF SEG = False                        'ROM segment
    IF ToggleOn% THEN
        POKE &H417, PEEK(&H417) OR 128     '1000 0000
    ELSE
        POKE &H417, PEEK(&H417) AND 127    '0111 1111
    END IF
    DEF SEG                                'Back to BASIC's DGROUP

END SUB

'+==============================================================+
'|                      TurnNumOn SUBPROGRAM                    |
'|                                                              |
'|  Input:    ToggleOn%     Boolean, False to toggle lock state |
'|                          off, NOT False to toggle it on.     |
'|  Return:   Nothing                                           |
'|                                                              |
'+--------------------------------------------------------------+
SUB TurnNumOn (ToggleOn%)

    DEF SEG = False                        'ROM segment
    IF ToggleOn% THEN
        POKE &H417, PEEK(&H417) OR 32      '0010 0000
    ELSE
        POKE &H417, PEEK(&H417) AND 223    '1101 1111
    END IF
    DEF SEG                                'Back to BASIC's DGROUP

END SUB

'+==============================================================+
'|                    TurnScrollOn SUBPROGRAM                   |
'|                                                              |
'|  Input:    ToggleOn%     Boolean, False to toggle lock state |
'|                          off, NOT False to toggle it on.     |
'|  Return:   Nothing                                           |
'|                                                              |
'+--------------------------------------------------------------+
SUB TurnScrollOn (ToggleOn%)

    DEF SEG = False                        'ROM segment
    IF ToggleOn% THEN
        POKE &H417, PEEK(&H417) OR 16      '0001 0000
    ELSE
        POKE &H417, PEEK(&H417) AND 239    '1110 1111
    END IF
    DEF SEG                                'Back to BASIC's DGROUP

END SUB

'+==============================================================+
'|                        Upper% FUNCTION                       |
'|                                                              |
'|  Input:  An INTEGER value.                                   |
'|  Return: The function returns the integer, unaltered, if     |
'|          the value of the INTEGER is outside of the lower    |
'|          case letter range.  If the INTEGER is between 97    |
'|          and 122 (ASCII for 'a' through 'z') then 223 is     |
'|          ANDed (32 subtracted), resulting in a return value  |
'|          of 65 through 90 (ASCII for 'A' through 'Z').       |
'+--------------------------------------------------------------+
FUNCTION Upper% (Value%)
    IF Value > 96 AND Value < 123 THEN Upper = Value AND 223 ELSE Upper = Value
END FUNCTION

