/****************************************************************************/
/* FIXIT module for RBBSMNT, a maintenance utility for RBBS-PC              */
/* NOTICE ͸*/
/*  A limited license is granted to all users of this program to make     */
/*  copies if this program and distribute those copies to other users     */
/*  on the following three conditions:                                    */
/*                                                                        */
/*    1.   This notice is NOT altered, bypassed or removed,               */
/*    2.   The program is not to be distributed to others in modified     */
/*         form. You may make changes for your own non-commercial use     */
/*    3.   No fee is to be charged (or any other consideration received)  */
/*         for copying or distributing these programs without an express  */
/*         written agreement with J. Terpstra, Bamestra RBBS, PO Box 66,  */
/*         Beemster, The Netherlands.                                     */
/*                                                                        */
/*Copyright (C) 1991, 1992 - Jan Terpstra, Bamestra RBBS, The Netherlands.*/
/*;*/
/****************************************************************************/

#include "rbbsmnt.h"                    /* definitions for this program     */
#include "externs.h"                    /* external data references         */
int rcount;                             /* # msgs read                      */
int wcount;                             /* # msgs written                   */
int last_one;

  /**************************************************************************/
  /* repair messages file                                                   */
  /**************************************************************************/

char *virgin = "                               -1 0 0 0 0 0 0 0    0 0 0I   \
                                                                    ";
void repair(void)
{
   char buf[sizeof(RBBSMSG)+1];
   RBBSMSG *msg_hdr = (RBBSMSG_PTR)buf;
   RBBSHDR *hdr = (RBBSHDR_PTR)buf;
   int cur_rec = 0;
   int num_rec = 0;
   int nhm,j,msg,x1,x2;
   long msgpos;

   memset(buf, 0, sizeof(RBBSMSG)+1);
   sprintf(logbuf, "Repairing HEADER and NODE reords of %s", msgfile);
   writelog(logbuf, 1, 3);
 
   if ((msg = open(msgfile, O_RDWR|O_BINARY)) == ERROR)
   {
      sprintf(logbuf, "Error opening %s.", msgfile);
      writelog(logbuf, 1, 0);
      return ;
   } 
   last_rec = (int)(lseek(msg, 0L, SEEK_END)/128L);/* get real filesize     */
   lseek(msg, 0L, SEEK_SET);            /* seek to header                   */

   /*************************************************************************/
   /* find first message                                                    */
   /*************************************************************************/
 

   while (cur_rec < last_rec)           /* search for a msg header          */
   {
      read(msg, buf, (size_t)sizeof(RBBSMSG));
      cur_rec++;
 
      if (msg_hdr->enter_date[2] == '-' && msg_hdr->enter_date[5] == '-' && 
      msg_hdr->enter_time[2] == ':')    /* got a real message header?       */
      {
         first_rec = cur_rec;
         cur_rec += num_rec;
         next_rec = cur_rec;
         sscanf(msg_hdr->num_recs, "%4u", &num_rec);
         sscanf(msg_hdr->msg_number, "%4u", &high_msg);
         nhm = high_msg;
         break;
      } 
   } 

   /*************************************************************************/
   /* find other messages                                                   */
   /*************************************************************************/
 

   do
   {
      msgpos = (long)(cur_rec-1)*128L;
      lseek(msg, msgpos, SEEK_SET);     /* move to start of next message    */
      read(msg, buf, (size_t)sizeof(RBBSMSG));
      cur_rec++;
 
      if (msg_hdr->enter_date[2] == '-' && msg_hdr->enter_date[5] == '-' && 
      msg_hdr->enter_time[2] == ':')    /* got a real message header?       */
      {
         sscanf(msg_hdr->num_recs, "%4u", &num_rec);
         sscanf(msg_hdr->msg_number, "%4u", &nhm);
 
         if (nhm > high_msg)
         {
            high_msg = nhm;
         } 
         cur_rec += num_rec-1;
         next_rec = cur_rec;
      } 
 
      else
      {
 
         while (cur_rec < last_rec)     /* search for a msg header          */
         {
            read(msg, buf, (size_t)sizeof(RBBSMSG));
 
            if (msg_hdr->enter_date[2] == '-' && msg_hdr->enter_date[5] == 
            '-' && msg_hdr->enter_time[2] == ':')/* got a real message      
                                           header?                          */
            {
               break;
            } 
            cur_rec++;
         } 
      } 
   } 
 
   while (cur_rec < last_rec);

   /*************************************************************************/
   /* restore the message header                                            */
   /*************************************************************************/

   printf("  How many copies of RBBS share this msg file (1...36) : ");
   scanf("%u", &x1);
   first_rec = x1+2;
   printf("  Security level to join this conference (1...32000)   : ");
   scanf("%u", &x2);
 
   if (next_rec < first_rec)
   {
      next_rec = first_rec;
   } 
 
   if (last_rec < first_rec-1)
   {
      last_rec = first_rec-1;
   } 
   lseek(msg, 0L, SEEK_SET);            /* seek to header                   */
 
   for (j = 1; j < first_rec; j++)
   {
      write(msg, virgin, (int)sizeof(RBBSHDR));/* write control records     */
   } 

   /*************************************************************************/
   /* fill msg header                                                       */
   /*************************************************************************/

   memset(buf, ' ', sizeof(RBBSHDR));   /* make empty header                */
   itos(high_msg, hdr->last_msg, 8);
   itos(1, hdr->user_count, 5);
   itos(first_rec, hdr->first_msg_rec, 7);
   itos(next_rec, hdr->next_free_rec, 7);
   itos(last_rec, hdr->last_msg_rec, 7);
   itos(999, hdr->max_message, 7);
   itos(x1, hdr->num_nodes, 2);
   hdr->joinsec = x2;
   lseek(msg, 0L, SEEK_SET);            /* seek to header                   */
   write(msg, buf, (int)sizeof(RBBSHDR));/* write hdr                       */
   close(msg);
} 


/*--------------------------------------------------------------------------*/

