#ifndef SWEARS_H
#define SWEARS_H

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>

/* miscellaneous constants */

#ifndef FALSE
#define FALSE (1!=1)
#define TRUE (1==1)
#endif

#define ERR -1
#define OK 0
#define YES -1
#define NO 0

/* swears bool typedef */
typedef short bool;

/* window typedef structure */
typedef struct _window {
    int    begy, begx;
    int    cury, curx;
    int    maxy, maxx;
    int    flags;
    int    ch_off;
    bool   clear;
    bool   leave;
    bool   scroll;
	int  **array;
    int    boxset;
} WINDOW;

/* boxset structure */
struct _box {
    int    tl;
    int    tr;
    int    bl;
    int    br;
    int    t;
    int    b;
    int    l;
    int    r;
};

/* external Swears declarations and typedefs */
extern int LINES, COLS;
extern WINDOW *stdscr;

/* swears function constants */
#define clearok(win,bf)  (win->clear = bf)
#define leaveok(win,bf)  (win->leave = bf)
#define scrollok(win,bf) (win->scroll = bf)
#define flushok(win,bf)  (bf ? (win->flags |= 1):(win->flags &= 0))
#define getyx(win,y,x)   (y = win->cury, x = win->curx)

#define raw       _swears_dummy
#define noraw     _swears_dummy
#define cbreak    _swears_dummy
#define nocbreak  _swears_dummy
#define crmode    cbreak    /* backwards compatability */
#define nocrmode  nocbreak  /* backwards compatability */
#define echo      _swears_dummy
#define noecho    _swears_dummy
#define nl        _swears_dummy
#define nonl      _swears_dummy
#define savetty   _swears_dummy
#define resetty   _swears_dummy
#define erasechar _swears_dummy
#define killchar  _swears_dummy
#define baudrate  _swears_dummy

/* swears function declarations */
int              initscr(void);
void             endwin(void);

WINDOW          *newwin(int,int,int,int);
void             delwin(WINDOW *);
WINDOW          *subwin(WINDOW *,int,int,int,int);

#define          move(y, x)               (wmove(stdscr, y, x))
void            wmove(WINDOW *, int, int);

#define          refresh()                (wrefresh(stdscr))
void            wrefresh(WINDOW *);

#define          addch(ch)                (waddch(stdscr, ch))
#define        mvaddch(y,x,ch)            (mvwaddch(stdscr,y,x,ch) )
#define       mvwaddch(win,y,x,ch)        (wmove(win,y,x), waddch(win,ch))
void            waddch(WINDOW *,int);

#define          addstr(str)              (waddstr(stdscr, str))
#define        mvaddstr(y,x,str)          (mvwaddstr(stdscr,y,x,str) )
#define       mvwaddstr(win,y,x,str)      (wmove(win,y,x), waddstr(win,str))
void            waddstr(WINDOW *, char *);

#define          printw(str)              (wprintw(stdscr, str))
#define        mvprintw(y,x,str)          (mvwprintw(stdscr,y,x,str) )
#define       mvwprintw(win,y,x,str)      (wmove(win,y,x), wprintw(win,str))
#define         wprintw(win,fmt)          (wmove(win,win->cury,win->curx),printf(fmt))
/* void            wprintw(WINDOW *, char *, ...); */

#define          clear()                  (wclear(stdscr))
void            wclear(WINDOW *);

#define          clrtobot()               (wclrtobot(stdscr))
void            wclrtobot(WINDOW *);

#define          clrtoeol()               (wclrtoeol(stdscr))
void            wclrtoeol(WINDOW *);

#define          delch()                  (wdelch(stdscr))
#define        mvdelch(y,x)               (mvwdelch(stdscr,y,x))
#define       mvwdelch(win,y,x)           (wmove(win,y,x), wdelch(win) )
void            wdelch(WINDOW *);

#define          deleteln()               (wdeleteln(stdscr))
void            wdeleteln(WINDOW *);

#define          erase()                  (werase(stdscr))
void            werase(WINDOW *);

char            *getcap(char *);

/*
#define          getch()                  (wgetch(stdscr))
*/

#define        mvgetch(y,x)               (mvwgetch(stdscr,y,x))
#define       mvwgetch(win,y,x)           (wmove(win,y,x), wgetch(win) )
void            wgetch(WINDOW *);

#define          getstr(str)              (wgetstr(stdscr, str))
#define        mvgetstr(y,x,str)          (mvwgetstr(stdscr,y,x,str) )
#define       mvwgetstr(win,y,x,str)      (wmove(win,y,x), wgetstr(win,str))
void            wgetstr(WINDOW *, char *);

#define          inch()                   (winch(stdscr))
#define        mvinch(y,x)                (mvwinch(stdscr,y,x) )
#define       mvwinch(win,y,x)            (wmove(win,y,x), winch(win))
void            winch(WINDOW *);

#define          insch(c)                 (winsch(stdscr,c))
#define        mvinsch(y,x,c)             (mvwinsch(stdscr,y,x,c))
#define       mvwinsch(win,y,x,c)         (wmove(win,y,x), winsch(win,c) )
void            winsch(WINDOW *,int);

#define          insertln()               (winsertln(stdscr))
void            winsertln(WINDOW *);

char            *longname(void);

#define          standend()               (wstandend(stdscr))
void            wstandend(WINDOW *);

#define          standout()               (wstandout(stdscr))
void            wstandout(WINDOW *);

#define          beep()                   (putc(7,stdout))
void            _swears_dummy(void);

/**************************************************************************/

/* some unsigned far macros for memory access */
#define Wtofaru(seg,off) ((void far *)((((unsigned long) (unsigned int) \
                         (seg)) << 16L) | ((unsigned long) (unsigned int) \
                         (off))))
#define Wpeek(addr)         ( *((unsigned char far *) (addr)) )
#define Wpoke(addr,cval)    ( *((unsigned char far *) (addr)) = (cval))

#endif
