/* This program is designed to run length encode spaces in a video memory image
   file such as summary documentation files for WAS.COM.  Each series of
   consecutive spaces will be represented by a byte value that can range from
   128 to 255.  If the high bit is set in a code byte it represents a coded
   series of spaces.  Attributes for coded spaces are not written to the code
   file.  Spaces in a coded series will be given 7 as attribute when decoded.
   The lower 7 bits of a spaces encoded byte indicate the number of spaces in
   the series.  SPCPAK.C can be compiled with either Microsoft/Quick C or Turbo
   C.
*/

#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <sys\types.h>
#include <sys\stat.h>

#define OUTSIZ 1024

char outbuf[OUTSIZ];

void setcodebyte(int outhand, unsigned char outbyte, int setcode);

main(int argc, char **argv) {
	unsigned char infile[64], outfile[64], ch, inpline[160], priorspaces = 0;
	int inhand, outhand, i;

	if (argc < 2) {
		printf("\n  Input file:   ");
		gets(infile);
	} else strcpy(infile, argv[1]);

	if (argc < 3) {
		if (argc == 2) printf("\n");
		printf("  Output file:  ");
		gets(outfile);
	} else strcpy(outfile, argv[2]);

	inhand = open(infile, O_RDONLY | O_BINARY);
	if (inhand == -1) {
		printf("  Can't open file %s\n", infile);
		exit(1);
	}
	if (!access(outfile, 0)) {
		printf("\nOutput file %s exists.  Overwrite (Y/N)? ", outfile);
		while ((ch = 0xdf & getch()) && ch != 'N' && ch != 'Y');
		printf("%c", ch);
		if (ch == 'N') exit(0);
	}
	outhand = open(outfile, O_CREAT | O_TRUNC | O_RDWR | O_BINARY, S_IWRITE);
	if (outhand == -1) {
		printf("\n  Error creating file %s.\n", outfile);
		exit(2);
	}
	while (read(inhand, inpline, 160)) {
		for (i = 0; i < 80; i++) {
			if (inpline[i*2] == ' ') {
				priorspaces++;
				if (priorspaces == 127) {
					priorspaces = 0;
					setcodebyte(outhand, 255, 1);
				}
			}	else {
				if (priorspaces) {
					setcodebyte(outhand, 128+priorspaces, 1);
					priorspaces = 0;
				}
				setcodebyte(outhand, inpline[i*2], 1);
				setcodebyte(outhand, inpline[i*2+1], 1);
			}
		}
	}
	if (priorspaces) setcodebyte(outhand, 128+priorspaces, 1);
	setcodebyte(outhand, 0, 0);
}

/* setcodebyte() places a coded byte into the output file buffer if setcode is
	 1 or flushes the buffer and closes the output file if setcode = 0.
*/

void setcodebyte(int outhand, unsigned char outbyte, int setcode) {
	static int bufpos = 0;

	if (setcode) {
		outbuf[bufpos++] = outbyte;
		if (bufpos == OUTSIZ) {
			bufpos = 0;
			write(outhand, outbuf, OUTSIZ);
		}
	} else {
		if (bufpos) write(outhand, outbuf, bufpos);
		close(outhand);
	}
}
