
/*
Name:               cryptic.c
Processor:          Intel 80xxx
Platform:           IBM PC
Compiler:           BC v3.00
Compiler Directive: Autolink
Creation Date:      07 May 00
Author:             I Parker
Version:            3.15 
Bugs:               none known
ToDo:               It would be nice to find a way of detecting -ve numbers for compair
Description:        The whole encryption suite in one file 
Usage:              cryptic [switch]  
Status:             freeware use this code at your own risk I accept no liability
Revision History: 
      10 Sep 01     fixed but in unmerge
      07 May 00     fixed a bug in help files
      01 May 00     added modulus 2 encryption to the xor encryption
      30 Apr 00     put modify in 
      15 Feb 00     put backward compatability in
      14 Feb 00     put multipass noise in
      06 Feb 00     put vert and unvert in 
      07 Dec 99     improved noise function
      04 Dec 99     put copy in
      26 Nov 99     corrected bug in multple scan routine
      21 Nov 99     corrected bug in scan decode routine
      16 Nov 99     corrected bug in verbatum cipher rewind              
                    corrected fault in pgp header removal and insertion
                    prints characters as well as decimal byte info in preamble
                    corrected bug in size function
                    added cracking functions
                    added noise (z) generator
                    corrected bug in crack function
                    putin unnoise function
                    put random noise in
    13 Oct 99       passphrase replaced by hash function in file
    13 Nov 99       compair function put in
The following was in the 250 bit pseudorandom function I used as part of the key
generator. 
  Description: implements R250 random number generator, from S. 
  Kirkpatrick and E.  Stoll, Journal of Computational Physics, 40, p. 
  517 (1981).
  Written by:    W. L. Maier

	METHOD...
		16 parallel copies of a linear shift register with
		period 2^250 - 1.  FAR longer period than the usual
		linear congruent generator, and commonly faster as
		well.  (For details see the above paper, and the
		article in DDJ referenced below.)

	HISTORY...
		Sep 92: Number returned by dr250() is in range [0,1) instead 
			of [0,1], so for example a random angle in the
			interval [0, 2*PI) can be calculated
			conveniently.  (J. R. Van Zandt <jrv@mbunix.mitre.org>)
		Aug 92: Initialization is optional.  Default condition is 
			equivalent to initializing with the seed 12345,
			so that the sequence of random numbers begins:
			1173, 53403, 52352, 35341...  (9996 numbers
			skipped) ...57769, 14511, 46930, 11942, 7978,
			56163, 46506, 45768, 21162, 43113...  Using ^=
			operator rather than two separate statements. 
			Initializing with own linear congruent
			pseudorandom number generator for portability. 
			Function prototypes moved to a header file. 
			Implemented r250n() to generate numbers
			uniformly distributed in a specific range
			[0,n), because the common expedient rand()%n is
			incorrect.  (J. R. Van Zandt <jrv@mbunix.mitre.org>)
		May 91: Published by W. L. Maier, "A Fast Pseudo Random Number 
			Generator", Dr. Dobb's Journal #176.
Notes:              I can't work out the exact key size but with in particular
                    the noise function it would be very difficult to crack even
                    with this source code. The first five bytes are the alpha code
                    the next is an encrypted hash function of the passphrase. The
                    rest is all data. We are talking at least three times the size
                    of pgp's key, without additional functions.      
Wish List: 
Faults:                      
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "r250.h"
#include "r250a.h"

/**** Static variables ****/
static int r250_index = 0;
static unsigned int r250_buffer[250] = {
	15301,57764,10921,56345,19316,43154,54727,49252,32360,49582,
	26124,25833,34404,11030,26232,13965,16051,63635,55860,5184,
	15931,39782,16845,11371,38624,10328,9139,1684,48668,59388,
	13297,1364,56028,15687,63279,27771,5277,44628,31973,46977,
	16327,23408,36065,52272,33610,61549,58364,3472,21367,56357,
	56345,54035,7712,55884,39774,10241,50164,47995,1718,46887,
	47892,6010,29575,54972,30458,21966,54449,10387,4492,644,
	57031,41607,61820,54588,40849,54052,59875,43128,50370,44691,
	286,12071,3574,61384,15592,45677,9711,23022,35256,45493,
	48913,146,9053,5881,36635,43280,53464,8529,34344,64955,
	38266,12730,101,16208,12607,58921,22036,8221,31337,11984,
	20290,26734,19552,48,31940,43448,34762,53344,60664,12809,
	57318,17436,44730,19375,30,17425,14117,5416,23853,55783,
	57995,32074,26526,2192,11447,11,53446,35152,64610,64883,
	26899,25357,7667,3577,39414,51161,4,58427,57342,58557,
	53233,1066,29237,36808,19370,17493,37568,3,61468,38876,
	17586,64937,21716,56472,58160,44955,55221,63880,1,32200,
	62066,22911,24090,10438,40783,36364,14999,2489,43284,9898,
	39612,9245,593,34857,41054,30162,65497,53340,27209,45417,
	37497,4612,58397,52910,56313,62716,22377,40310,15190,34471,
	64005,18090,11326,50839,62901,59284,5580,15231,9467,13161,
	58500,7259,317,50968,2962,23006,32280,6994,18751,5148,
	52739,49370,51892,18552,52264,54031,2804,17360,1919,19639,
	2323,9448,43821,11022,45500,31509,49180,35598,38883,19754,
	987,11521,55494,38056,20664,2629,50986,31009,54043,59743
	};

static unsigned myrand();
static void mysrand(unsigned newseed);

/**** Function: r250_init  
	Description: initializes r250 random number generator. ****/
void r250_init(int seed)
{
/*---------------------------------------------------------------------------*/
    int        j, k;
    unsigned int mask;
    unsigned int msb;
/*---------------------------------------------------------------------------*/
    mysrand(seed);
    r250_index = 0;
    for (j = 0; j < 250; j++)     /* Fill the r250 buffer with 15-bit values */
        r250_buffer[j] = myrand();
    for (j = 0; j < 250; j++)     /* Set some of the MS bits to 1 */
        if (myrand() > 16384)
            r250_buffer[j] |= 0x8000;
    msb = 0x8000;       /* To turn on the diagonal bit   */
    mask = 0xffff;      /* To turn off the leftmost bits */
    for (j = 0; j < 16; j++)
        {
        k = 11 * j + 3;             /* Select a word to operate on        */
        r250_buffer[k] &= mask;     /* Turn off bits left of the diagonal */
        r250_buffer[k] |= msb;      /* Turn on the diagonal bit           */
        mask >>= 1;
        msb >>= 1;
        }
}

/**** Function: r250 Description: returns a random unsigned integer k
				uniformly distributed in the interval 0 <= k < 65536.  ****/
unsigned int r250()
{
/*---------------------------------------------------------------------------*/
    register int    j;
    register unsigned int new_rand;
/*---------------------------------------------------------------------------*/
    if (r250_index >= 147)
        j = r250_index - 147;      /* Wrap pointer around */
    else
        j = r250_index + 103;

    new_rand = r250_buffer[r250_index] ^= r250_buffer[j];

    if (r250_index >= 249)      /* Increment pointer for next time */
        r250_index = 0;
    else
        r250_index++;

    return new_rand;
}

/**** Function: r250n Description: returns a random unsigned integer k
					uniformly distributed in the interval 0 <= k < n ****/
unsigned int r250n(unsigned n)
{
/*---------------------------------------------------------------------------*/
    register int    j;
    register unsigned int new_rand, limit;
/*---------------------------------------------------------------------------*/
	limit = (65535U/n)*n;
	do 
        {new_rand = r250();
        if (r250_index >= 147)
            j = r250_index - 147;      /* Wrap pointer around */
        else
            j = r250_index + 103;

        new_rand = r250_buffer[r250_index] ^= r250_buffer[j];

        if (r250_index >= 249)      /* Increment pointer for next time */
            r250_index = 0;
        else
            r250_index++;
        } while(new_rand >= limit);
    return new_rand%n;
}

/**** Function: dr250 
		Description: returns a random double z in range 0 <= z < 1.  ****/
double dr250()
{
/*---------------------------------------------------------------------------*/
    register int    j;
    register unsigned int new_rand;
/*---------------------------------------------------------------------------*/
    if (r250_index >= 147)
        j = r250_index - 147;     /* Wrap pointer around */
    else
        j = r250_index + 103;

    new_rand = r250_buffer[r250_index] ^= r250_buffer[j];

    if (r250_index >= 249)      /* Increment pointer for next time */
        r250_index = 0;
    else
        r250_index++;
    return new_rand / 65536.;   /* Return a number in [0.0 to 1.0) */
}


/***  linear congruent pseudorandom number generator for initialization ***/

static unsigned long seed=1;

	/*	Return a pseudorandom number in the interval 0 <= n < 32768.
		This produces the following sequence of pseudorandom 
		numbers:
		346, 130, 10982, 1090...  (9996 numbers skipped) ...23369,
		2020, 5703, 12762, 10828, 16252, 28648, 27041, 23444, 6604... 
	*/ 
static unsigned myrand()
{
	seed = seed*0x015a4e35L + 1;
	return (seed>>16)&0x7fff;
}

	/*	Initialize above linear congruent pseudorandom number generator */
static void mysrand(unsigned newseed)
{	seed = newseed;
}

/* the following is the initial value for the passphrase, any passphrase will
overwrite this, when it is decoded it goes into a buffer and a pseudo random
routine gets bytes out of it to set the encryption/decryption routines. Add
the value of all the bytes together to get the prang seed */

char passphrase[] = "kg4iGturydjdliweurfJYUBuecmuioqwPO4udrnycqweu67"; /* 47 */
char passphraselength;
char verbkey[50];

void ippassphrase(void)        /* input and veryfy passphrase on encrypt */
{
extern char passphrase[];
extern char passphraselength;
char passphrasecheck[47];
char chr;
int cnt_1,cnt_2;

printf("\n\n Enter passphrase max 44 characters");
printf("\n the closer to 44 characters the more secure:-\n\n\n\n  ");
for(cnt_1=0; (chr = getch()) != '\r'; cnt_1++)
   {
   if(cnt_1 >= 44)
   {cnt_1 = 0;printf("\n Too many characters");exit(0);}
   passphrase[cnt_1] = chr;
   printf("*");
   }
passphraselength = cnt_1;
if(cnt_1 < 7)
{ printf("\n\n\n YOU CAN DO BETTER THAN THAT!!!!  do ctn 'C' and start again\n\n");}
printf("\n Confirm passphrase please re-enter \n  ");
for(cnt_1=0;(chr = getch()) != '\r';cnt_1++)
   {
   printf("*");
   passphrasecheck[cnt_1] = chr;
   }
cnt_1 = 0;
for(cnt_2=0; cnt_2 <= (int)passphraselength; cnt_2++)
   {
   if(((int)passphrase[cnt_2] - (int)passphrasecheck[cnt_2]) == 0)
   cnt_1++;
   if((cnt_1 - (int)passphraselength) == 0)
   {return;}
   }
printf("\n passphrases do NOT match \n");
exit(0);
}

void prompt(void)
{
printf("\n cryptic Tools by sheepish V3.15"
       "\n usage:- cryptic -encrypt     [mod2andxor encrypt E]"
       "\n                 -decrypt     [mod2andxor decrypt E]"
       "\n                 -verbatum    [encipher Vxxxxx]"
       "\n                 -unverbatum  [decipher Vxxxxx]"
       "\n                 -reverse     [invert whole file S]"
       "\n                 -invert      [invert all bits I]"
       "\n                 -lr1         [roll all bits right by 1 Lx]"
       "\n                 -rr1         [roll all bits left by 1 Rx]"
       "\n                 -rotate      [rotate all bytes by offset Txxxxx]"
       "\n                 -merge       [merge multifiles U]"
       "\n                 -unmerge     [unmerge multifiles U]"
       "\n                 -mask        [places double mask in file M]"
       "\n                 -compair     [compairs two files ]"
       "\n                 -copy        [copies changes name and creation date of file]"
       "\n                 -help        this screen       "
       "\n                 -help2       help screen 2"
       "\n                 -help3       help screen 3"
       "\n                 -keyhelp     key help          "
       "\n read the readme file for more information");
}

void help(void)
{
printf("\n These are encryption modifiers and NOT encryption "
       "\n                 -wibble      [insert syncronus white noise W]"
       "\n                 -unwibble    [remove syncronus white noise W]"
       "\n                 -noise       [insert random noise Z]"
       "\n                 -unnoise     [extract random noise Z]"
       "\n                 -random      [encrypts random noise see manual]"
       "\n                 -unrandom    [removes random noise see manual]"

       "\n                     only on formated/structured files "
       "\n                 -vert        [secondry noise insertion]"
       "\n                 -unvert      [secondry noise removal]"

       "\n                     only on unformated/unstructured files "
       "\n                 -multi       [insert multipass encrypted noise]"
       "\n                 -unmulti     [remove multipass encrypted noise]"

       "\n                 -modify      [crypto modifier]"
       "\n                 -unmodify    [remove crypto modifier]");
}

void help3(void)
{
printf("\n                 -duress      [duress code detector]"
       "\n                 -preamble    [prints first 11 bytes in deanary]"
       "\n                 -size        [reports file size to screen]"
       "\n                 -rempgp      [remove pgp pre-header P5]"
       "\n                 -inspgp      [reinsert pgp pre-header P5]"
       "\n                 -rempub      [strips pgp 1 ads file of public key]"
       "\n                 -inspub      [reinserts public key into pgp file]"
       "\n                 -white       [creates file containing white noise]"
       "\n                 -kill        destroys 1 or more alpha sequences"
       "\n                              from Steganographic MOdulator DEModulator stream"
       "\n                 -insert      [create alpha key marker]"
       "\n                 -zeros       [creates file containing all zeros]"
       "\n                              max size is 2,000,000,000 bytes!"
       "\n                 -back        [backward compatability C20]"
       "\n                 -unback      [backward compatability C20]"
       "\n                 -scan        [alpha code scanner]"
       "\n                 -xor         [xor function for 2 files]"
       "\n  Note the scan command requires a BRAVO code from an SMODEM to work");
}

void keyhelp(void)
{
printf("\n suggestions in key passing:- "
       "\n Axxxxx alpha key, the default should only be used for smodems "
       "\n Bxxxxx restriction modifier "
       "\n Cxxxxx multi segment smodem retriever "
       "\n Dxxxxx single segment smodem retriever "
       "\n      E encrypted with encrypt in this program "
       "\n      F extra alpha code inserted"
       "\n      I inverted "
       "\n     L1 rolled to left by one place 2.3.4.. etc. "
       "\n      M mask used "
       "\n      N merge used "
       "\n      O multi-alpha sequencing in simple mode only"
       "\n     P1 pgp encryption changed by -rempgp switch "
       "\n     P2 pgp encryption public pre-header encrypted "
       "\n     P3 pgp file converted back to conventional encryption "
       "\n     P4 pgp encryption ASCII mode header and tailer removed "
       "\n     P5 pgp encryption public pre-header removed "
       "\n     R1 rolled to right by one place "
       "\n      S  reverse used "
       "\n Txxxxx rotate used by offset "
       "\n      U unmerge used before merge to split file "
       "\n Vxxxxx verbatum cipher used with offset "
       "\n      W wibble used "
       "\n      X file has been encrypted with noise after Z"
       "\n      Z file has had noise added to desyncronis it"
       "\n to decode you read backwards ie. AxdftgER2V239W - WV239R2EAxdftg");
}

void encrypt(void)
{
FILE *in,*out,*verb;
int count;
extern char passphrase[];
extern char verbkey[];
char ch,ch_tmp,che_1,che_2,che_3,che_4;
int cnt_3;
unsigned long int cnt_1,cnt_2,last,key;
unsigned int k;
int seed = 0;
int hash = 0;
char filehash;
char alpha[] = "abcde";
char sync[] = "vzczc";
char buf_out[5];
char opname[13]; 
char vername[13]; 
char inname[13];
char ch_test;

printf("\n Enter name of data file including file extension to encrypt ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of key file including file extension ");
printf("\n must be at least 2kbyts long preferably binary "); 
scanf("%12s",&vername);            
if((verb = fopen(vername, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open key file. \n",&vername);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n Do you want to change the alpha code y/n");
ch = getch();
if((ch - 'y') == 0)
     {
     printf("\n enter FIVE alphanumberic characters ");
     scanf("%5s",&alpha);
     }

/* the sync marker is encrypted sent to the sync buffer then o/p to file it is
not decoded or used in this program again although it does make the file more
difficult to crack */

for(cnt_3 = 0; cnt_3 <= 4; cnt_3++)                      /* encrypt sync marker */
     {
     buf_out[cnt_3] = alpha[cnt_3] ^ sync[cnt_3];        /* send sync to buffer */
     fputc(buf_out[cnt_3],out);                       /* send alpha key to file */
     }

ippassphrase();

for (count=0; count <= 45; count++)        /* remove any \0 and place at end */
   {
   if((passphrase[count]) == '\0')
   {passphrase[count] = 0x26;}
   /* find a seed value based on the passphrase */
if(count <= 45) {seed = (unsigned long)passphrase[count] + seed;}
   }
passphrase[47] = '\0';
hash = seed / 58 +14;

fseek(verb,1L,SEEK_SET);  /* find a place to start reading the key file in */
ch = (unsigned char)fgetc(verb);       /* and place 50 bytes into a buffer */
fseek(verb,ch,SEEK_SET);
for(count=0; count<=50; count++)
    {
    ch = fgetc(verb);
    if((unsigned char)ch == 0x00)
    {ch = 0x186;}
    if((unsigned char)ch == 0xff)
    {ch = 0x187;}
    verbkey[count] = ch;
    }

fputc((char)hash ^ verbkey[5],out);
/* this routine reads file in encrypts everything with one standard encryption
then goes through a keymat modifier */

/* printf("\n seed value is %d ", seed); */
/* printf("\n passphrase is %s ",passphrase); */
/* printf("\n hash is %d ", hash); */
/* printf("\n verbkey = %s ",verbkey); */

printf("\n PROCESSING DATA PLEASE WAIT.....");
srand((char)seed);
fseek(in,0L,SEEK_END);
last = ftell(in);

fseek(in,0L,SEEK_SET);
r250_inita(seed);
for(cnt_1 = 0L; cnt_1 <= last - 1; cnt_1++)
   {
   ch = fgetc(in);
   che_1 = (char)rand() %255;         /* produce a srandom number no larger than a byte */
   che_2 = (unsigned char)rand() %45; /* produce a number no larger than the passphrase buffer */
   che_3 = (unsigned int)rand();                    /* produce a number 0 - 65535 */
   che_4 = (char)r250() %255;         /* produce a srandom (250 bit) number no larger than a byte */
/* from S.Kirkpatrick and E. Stoll Journal of computational Physics 40,P.517 */
/* take a pseudo-random number out of the passphrase buffer and dynamicaly bit
shift the bits in it and use it as a key */   

   ch_tmp = passphrase[che_2] ^ che_1;
   ch = ch ^ ch_tmp;           /* xor encrypt using passphrase */ 
   k = (unsigned int) r250a();
   key = k + che_3;            /* modulus 2 encrypt */
   ch = ch ^ (char)key;  
                              /* modify the encryption */
if((che_1 % 5) == 0)          /* if key1 modulo 5 the re-encrypt */ 
   {ch = ~ch ^ che_4;}
if((che_1 % 7) == 0)          /* if key1 modulo 7 re-encrypt with key file */
   {
 /*  printf("\n point seven "); */
   ch_tmp = verbkey[che_2] ^ che_1;
   ch = ch ^ ch_tmp;
   }
if((unsigned long)che_3 > 11000)
   {ch = ch ^ che_2;}

   fputc(ch,out);  
   }
fclose(in);
fclose(verb);
fclose(out);
}

void decrypt(void)
{
FILE *in, *verb, *out;

extern char passphrase[];
char ch,ch_tmp,che_1,che_2,che_3,che_4;
int count,cnt_1;
unsigned long int cnt_2,cnt_3,last,key;
unsigned int k;
int seed = 0;
int hash = 0;
int pwhash = 0;
char opname[13]; 
char vername[13];
char inname[13];
char filehash;
char defilehash;

printf("\n Enter name of encrypted file including file extension to decrypt ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open encrypted file. \n",&inname);
   exit(2);
   }       

printf("\n Enter name of key file including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open key file. \n",&vername);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }
                                          /* put passphrase in from keyboard */
printf("\n Enter passphrase ");
cnt_1 = 0;
for(cnt_1=0; (ch = getch()) != '\r'; cnt_1++)
   {
   passphrase[cnt_1] = ch;
   printf("*");
   }


for (count=0; count<=45; count++)
{
 if((passphrase[count]) == '\0')
   {passphrase[count] = 0x26;}
/* count the values of all the chars in phrase and use as a seed */
seed = (unsigned long)passphrase[count] + seed;
}
passphrase[47] = '\0';
hash = seed / 58 +14; /* use all the chars added together and produce */
                                 /* a number which will fit in a byte */

fseek(in,5L,SEEK_SET);
filehash = fgetc(in);             /* get the encrypted hash character */

fseek(verb,1L,SEEK_SET); /* find an offset to start reading the key file in */
ch = (unsigned char)fgetc(verb);
fseek(verb,ch,SEEK_SET);              /* from offset get a buffer of key */
for(count=0; count<=50; count++)
    {
    ch = fgetc(verb);
    if((unsigned char)ch == 0x00)
    {ch = 0x186;}
    if((unsigned char)ch == 0xff)
    {ch = 0x187;}
    verbkey[count] = ch;
    }

/* printf("\n seed value is %d ", seed); */
/* printf("\n passphrase is %s ",passphrase); */
/* printf("\n hash is %d ",hash); */
/* printf("\n filehash is %d, ", (int)filehash); */
defilehash = filehash ^ verbkey[5];
pwhash = (int)defilehash - hash; 
/* printf("\n hash - filehash = %d ",pwhash); */
if((pwhash) != 0)
{printf("\n INCORRECT PASSPHRASE \n\n");fclose(in);fclose(verb);fclose(out);exit(0);}

printf("\n DECRYPTING FILE PLEASE WAIT................");

srand((char)seed);
                                     /* write decoded message to output file */
fseek(in,0L,SEEK_END);                     /* find size of file for for loop */
last = ftell(in); 
                                               /* reset to beginning of file */
fseek(in,6L,SEEK_SET);
r250_init(seed);
for(cnt_3 = 0; cnt_3 <= last -7; cnt_3++)
   {
   che_1 = (char)rand() %255; /* produce a random number no larger than a byte */
   che_2 = (unsigned char)rand() %45; /* produce a number no larger than the passphrase buffer */
   che_3 = (unsigned int)rand();                    /* produce a number 0 - 65535 */
   che_4 = (char)r250() %255;         /* produce a srandom (250 bit) number no larger than a byte */
   ch = fgetc(in);
   
/* take a pseudo-random number out of the passphrase buffer and dynamicaly bit
shift the bits in it and use it as a key */   

   ch_tmp = passphrase[che_2] ^ che_1;
   ch = ch ^ ch_tmp;
   k = (unsigned int) r250a();
   key = k + che_3;
   ch = ch ^ (char)key;             
                           /* modify the encryption */ 
   if((che_1 % 5) == 0)
   {ch = ~ch ^ che_4;}
   
   if((che_1 % 7) == 0)
   {
   ch_tmp = verbkey[che_2] ^ che_1;
   ch = ch ^ ch_tmp;
   } 
   if((unsigned long)che_3 > 11000)
   {ch = ch ^ che_2;}

      fputc(ch,out);
   }
fclose(in);
fclose(verb);
fclose(out);
}


void verbatum(void)
{
FILE *in, *out, *verb;
unsigned long int SEED = 1356;
char ch,chr,encrypt;
unsigned long count,klast,last,offset;                       
char opname[13]; 
char vername[13];  
char inname[13];

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }     

printf("\n Enter name of key file including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open key file. \n",&vername);
   exit(2);
   }

printf("\n Enter name of output file two including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }


srand((char)SEED);                     /* set seed value into pseudo random generator */

printf("\nEnter key offset:-  ");      /* enter offset for key file */
scanf("%ld",&offset);

fseek(verb,0L,SEEK_END);           /* make sure offset is within range of key file */
klast = ftell(verb);
if (offset >= klast)
   {
   printf("\n the offset value must be less than the size of the key file");
   printf("\n your key file is %ld bytes long ", klast);
   printf("\n           !ENCRYPTION ABORTED!         \N\N\N");
   exit(0);
   } 

printf("\n This process may take some time PLEASE WAIT..........");

fseek(in,0L,SEEK_END);                               /* seek end of file */
	last = ftell(in);                            /* report size of file */
	for (count = 0L; count <= last - 1; count++)     /* loop to end of data file */
	{
		fseek(in, +count, SEEK_SET);         /* go forwards */
                fseek(verb, count + offset, SEEK_SET);         /* keep track in key file */
		ch = fgetc(in);                       /* get char from data file */ 
                chr = fgetc(verb);                     /* get char from key file */
                   if(chr == EOF)
                      {
                      rewind(verb);                  /* if the key file comes to an end */
                      chr = 0x56;
                      }                              /* before data, reset key */
                   if(chr == 0x00)                   /* if char is zero in key file*/
                      {                              /* use conventional encryption */
                      chr = (char)rand() %255;       /* locked to size of a byte */
                      }
                encrypt = ch ^ chr;                  /* encrypt key file with data file */ 
                fputc(encrypt,out);
	}
fclose(in);
fclose(verb);
fclose(out);
}

void wibble(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
char seed;
time_t t;
char inname[13];

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file to wibble. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n wibbling file please wait.....");

srand((unsigned) time(&t));
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in); 
   fputc(ch,out);
   fputc(rand() % 255,out);
   }
fclose(in);
fclose(out);
}

void unwibble(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
char seed;
time_t t;
char inname[13];

printf("\n Enter name of file to unwibble including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open wibbled file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n unwibble file please wait.....");

srand((unsigned) time(&t));
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in);
   
       if((cnt_2 % 2) == 0)
         {
         fputc(ch,out);
         }
  
    continue;
   }
fclose(in);
fclose(out);
}

void reverse(void)
{
FILE *in, *out;
unsigned long cnt_1,cnt_2,last;
char ch,opname[13];
char inname[13];

printf("\n Enter name of file to reverse including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

fseek(in,0L,SEEK_END);
last = ftell(in);
cnt_1 = last -2;
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   fseek(in,cnt_1,SEEK_SET);
   ch = fgetc(in);
   fputc(ch,out);
   cnt_1--;
   }
fclose(in);
fclose(out);
}

void invert(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
char inname[13];

printf("\n Enter name of file to invert including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n inverting file please wait.....");

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = ~fgetc(in);
   fputc(ch,out);
   }
fclose(in);
fclose(out);
}


void left(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
int status;
char inname[13];

printf("\n Enter name of file to shift including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n left shifting file please wait.....");

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
status = 0;
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in);
   if((ch & 0x80)!=0) {status = 1;}
   ch = ch << 1;
   if(status == 1)
   {ch = ch | 0x01; status = 0;}
   fputc(ch,out);
   }
fclose(in);
fclose(out);
}

void right(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
int status;
char inname[13];

printf("\n Enter name of file to shift including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n right shifting file please wait.....");

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
status = 0;
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in);
   if((ch & 0x01)!=0) {status = 1;}
   ch = ch >> 1;
   if(status == 1)
   {ch = ch | 0x80; status = 0;}
   fputc(ch,out);
   }
fclose(in);
fclose(out);
}

void rotate(void)
{
FILE *in, *out;
unsigned long cnt_2,last;
char ch,opname[13];
unsigned long offset;
char inname[13];

printf("\n Enter name of file to rotate including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}


fseek(in,0L,SEEK_END);
last = ftell(in);
printf("\n file size is:- %d ",last);
printf("\n Enter offset ");
scanf("%d",&offset);
printf("\n extraction key is %d :-", last - offset);

printf("\n processing file please wait.....");

cnt_2 = 0;
fseek(in,0L,SEEK_SET);
while ((ch = fgetc(in)) != EOF)
   {
   cnt_2 = cnt_2 +1;
   if(cnt_2 > offset)
   fputc(ch,out);
   }
cnt_2 = 0;
rewind(in);
while ((ch = fgetc(in)) != EOF)
   {
   cnt_2 = cnt_2 +1;
   if(cnt_2 < offset + 1)
   fputc(ch,out);
   }
fclose(in);
fclose(out);
}

void merge(void)
{
FILE *in, *out,*verb;
char opname[13]; 
char vername[13];          
unsigned long count,last_in,last_verb;
long answer = 0;
char ch,chr;
char inname[13];

printf("\n Enter name of first merge file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open first file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of second merge file including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open second file. \n",&vername);
   exit(2);
   }

                                 
printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

fseek(in,0L,SEEK_END);                                   /* seek end of file */
	last_in = ftell(in);                             /* report size of file */
fseek(verb,0L,SEEK_END);                                   /* seek end of file */
	last_verb = ftell(verb);                         /* report size of file */
printf("\n size verb (smaller)= %ld", last_verb);
printf("\n size in (larger)= %ld", last_in);
answer = last_verb - last_in;
if(answer > 0)
    {
    printf("\n smaller file is in ");
    printf("\n the difference is %d ",answer);
rewind(in);
rewind(verb);
    for (count = 0L; count <= last_in - 1; count++)
        {
        ch = fgetc(verb);
        if(ch == EOF)
          rewind(verb);
           chr = fgetc(in);
           fputc(ch,out);
           fputc(chr,out);
        }
    }
       else {
            printf("\n smaller file is verb"); 
            printf("\n the difference is %d ",answer);
            rewind(in);
            rewind(verb);
            for (count = 0L; count <= last_verb - 1; count++)
                {
                ch = fgetc(in);
                  if(ch == EOF)
                    rewind(in);
                    chr = fgetc(verb);
                    fputc(ch,out);
                    fputc(chr,out);
        }
            }
fclose(in);
fclose(verb);
fclose(out);
}

void unmerge(void)
{
FILE *in, *verb, *out;  
unsigned long count,last;
int status=1;
char ch;
char opname[13]; 
char vername[13]; 
char inname[13];

printf("\n Enter name of file to unmerge or split including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file one including file extension ");
scanf("%12s",&vername);            
if((verb = fopen(vername, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file one. \n",&vername);
   exit(2);
   }

printf("\n Enter name of output file two including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                    /* write only */
   {
   fprintf(stderr,"Can't create output file two. \n",&opname);
   exit(2);
   }

fseek(in,0L,SEEK_END);                                   /* seek end of file */
	last = ftell(in);                             /* report size of file */
fseek(in,0L,SEEK_SET);                           
	for (count = 0L; count <= last - 1; count++)     /* loop to end of data file */
	{
	
		ch = fgetc(in);                       /* get char from data file */ 
           
                if((status % 2) == 0)
                {fputc(ch,out);if(status <= 3) status = 2;}
                if((status % 2) != 0)
                {fputc(ch,verb);if(status <= 2) status = 1;}  
status = status++;                                        
	}
fclose(in);
fclose(verb);
fclose(out);
}

void mask(void)
{
FILE *in, *out;

unsigned long cnt_2,last;
char ch,opname[13];
char inname[13];

printf("\n Enter name of file to mask/unmask including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n masking file please wait.....");

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in);
   ch = ch ^ 0x25;
   ch = ch ^ 0xf0;
   fputc(ch,out);
   }

fclose(in);
fclose(out);
}

void duress(void)
{
FILE *in;
char ch,dch,inname[13];
char alpha[] = "sosos";
unsigned long cnt_1 = 0;
unsigned long last;
int set = 0;

printf("\n Enter file name ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file. \n",&inname);
   exit(2);
   }
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);

for(cnt_1 = 0L; cnt_1 <= last -1; cnt_1++)
{
ch = fgetc(in);
dch = ch ^ alpha[cnt_1];
 switch (dch)
   {
   case 'v':
     if(set == 0)
     set = 1;
   break;
   case 'z':
     if (set == 1)
     set = 2;
     if (set == 3)
     set = 4;
   break;
   case 'c':
     if (set == 2)
     set = 3;
     if (set == 4)
     printf("\n\n *** DURESS CODE DETECTED *** ");
   break;
     default:
     set = 0;
   }
}
fclose(in);
}


void preamble(void)
{
FILE *in;
char inname[13];
char ch;
int count;

printf("\n Enter file name ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }
for (count=0; count <= 10; count++)
{
ch = (unsigned char)fgetc(in);
printf(" %d %c ",(unsigned char)ch,ch);
}
fclose(in);
}

void size(void)
{
FILE *in;
char inname[13];
unsigned long int last;

printf("\n Enter file name ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }
fseek(in,0L,SEEK_END);
last = ftell(in);
printf("\n\n file size is %ld bytes ", last);
fclose(in);
}

void inspgp(void)
{
FILE *in, *out;
char ch,opname[13];
char inname[13];
unsigned long last, cnt_a;

printf("\n Enter file name to regenerate header, including extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}
fputc(0xa8,out);
fputc(0x03,out);
fputc(0x50,out);
fputc(0x47,out);
fputc(0x50,out);
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_a = 0;cnt_a <= last - 1;cnt_a++)
    {
    ch = fgetc(in);
    fputc(ch,out);
    }

fclose(in);
fclose(out);
}

void rempgp(void)
{
FILE *in, *out;
char ch,opname[13];
char inname[13];
unsigned long cnt_a,last;

printf("\n Enter file name extract header from, including extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_a = 0;cnt_a <= last - 1;cnt_a++)
    {
    ch = fgetc(in);
    if(cnt_a > 4)
    fputc(ch,out);
    }

fclose(in);
fclose(out);
}

void randn(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch;
char preseed[] = "00000";
unsigned long rnd,rndd,last,count;
unsigned int seed;
unsigned int r;
int x;
time_t t;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n ADDING NOISE\n");
rnd = time(&t) % 255;                /* produce a random number bassed on clock */
srand((unsigned int)seed);                            /* set pseudo-random seed */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* fine file size */
        rewind(in);                        /* set file pointer to start of file */
	for (count = 0L; count <= last - 1; count++) /* loop to end of data file */
	{
                r = (unsigned int)rand();
		ch = fgetc(in);                       /* get char from data file */ 
                rndd = rnd ^ ch;                        /* generate white noise */
                if((r % 7) == 0)         /* test for place noise to be inserted */
                {
                fputc((char)rndd,out);                /* put white noise in file */
                if(rnd >= 1800000){rnd = 10023;}                /* modify noise */
                rnd = rnd + 42 / 3;  
                }                                   
                fputc(ch,out);                     /* copy character to o/p file */
                
        }

fclose(in);
fclose(out);
}

void unnoise(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch;
char preseed[] = "00000";
unsigned long last,count;
unsigned int seed;
unsigned int r;
int set = 0;
int skip = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n EXTRACTING NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */

fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
for(count = 0L; count <= last - 1; count++)
   {
   if(set == 0)
      {
      r = (unsigned int) rand();
      }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
      {
      set = 1;
      skip = 1;
      continue;
      } 
   set = 0;
   skip = 0;
   fputc(ch,out);
    }
fclose(in);
fclose(out);
}

void scan(void)                     /* scans for alpha code in files */
{
FILE *in;
int set = 0;
unsigned long int cnt_1;
int count = 0;
unsigned long last;
char ch,dch;
char password[6]; 
char bravo[4];
char inname[13];
int num,x;


printf("\n Enter file name to scan ");
scanf("%12s",&inname);   

if ((in = fopen(inname, "rb"))==NULL)
   {
   fprintf(stderr, "Couldn't open file \"%s\".\n",inname);
   exit(1);
   }

printf("\n Enter bravo key ");
scanf("%s",&bravo);
ch = fgetc(in);
num = atoi(bravo);
x = (unsigned int)ch - num;
if (x != 0)
{exit(0);}

printf("\n Enter 5 character alpha code ");
scanf("%s",&password);

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);

for (cnt_1 = 0L; cnt_1 <= last - 1; cnt_1++)  
   {                                                          
     dch = fgetc(in) ^ password[set];
     switch (dch)                   
     {                                                
        case 'v':
          if (set == 0)
          set = 1;
        break;
        case 'z':
         if (set == 1)
         set = 2;
         if (set == 3)
         set = 4;
        break;
        case 'c':
         if (set == 2)
         set = 3;
         if (set == 4)
           {
           printf("\n offset = %ld ", ftell(in) - 5);
           set = 0;
           count++;                       /* it counts how many alpha keys found */
           }
        break;
        default: 
        set = 0;                  /* if it can't find one of the above it resets */
     }
  }

printf("\n With the alpha key given there are %d occurences in %s ",count,inname); 
fclose(in);
} 

void crack(void)
{
FILE *in,*key,*out;                                    /* declare three file pointers */
char ch,chr,encrypt;
char opname[13];
char inname[13];
char keyfile[13];
unsigned long count,klast,last,offset;                       

printf("\n Enter first file name, including extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of second file to XOR with first including file extension ");
scanf("%12s",&keyfile);
if((key = fopen(keyfile, "rb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &keyfile);
exit(0);
}

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname); 
           
if((out = fopen(opname, "wb")) == NULL)
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }                          


printf("\nEnter key offset:-  ");      /* enter offset for key file */
scanf("%ld",&offset);

fseek(key,0L,SEEK_END);           /* make sure offset is within range of key file */
klast = ftell(key);
if (offset >= klast)
   {
   printf("\n the offset value must be less than the size of the key file ");
   printf("\n your key file is %ld bytes long ", klast);
   printf("\n           !CRACKING  ABORTED!         \N\N\N");
   exit(0);
   } 

fseek(in,0L,SEEK_END);                               /* seek end of file */
	last = ftell(in);                            /* report size of file */
	for (count = 0L; count <= last - 1; count++)     /* loop to end of data file */
	{
		fseek(in, +count, SEEK_SET);         /* go forwards */
                fseek(key, count + offset, SEEK_SET);         /* keep track in key file */
		ch = fgetc(in);                       /* get char from data file */ 
                chr = fgetc(key);                     /* get char from key file */
                encrypt = ch ^ chr;                  /* encrypt key file with data file */ 
                fputc(encrypt,out);

/* the following lines put 1 chr from each stream to o/p file to analyse whats
   happening              
             fputc(ch,out); 
             fputc(chr,out);
             fputc(encrypt,out); */	
	}

fclose(in);
fclose(key);
fclose(out);
}

void zeros(void)
{
FILE *out;

unsigned long cnt_2,last;
char ch,opname[13];
char offset[11];
long int x;   
                           
printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }                          

printf("\n enter the size of file you wish to create ");
scanf("%s",&offset);
x = atol(offset);
printf("\n value is %ld ", x);

printf("\n creating file please wait.....");


for(cnt_2 = 0L; cnt_2 <= x; cnt_2++)            /* x is the size of file */
   {
   ch = 0x00;           /* put the ASCII char you want to generate here */
   fputc(ch,out);
   }

fclose(out);
}

void kill(void)
{
FILE *in, *out;

char nameop[13];
char nameip[13];
char chr;
unsigned long last,count,offset;
char nb[12];
printf("\n Enter the sstream name \n");
scanf("%12s",&nameip);

if ((in = fopen(nameip, "rb"))==NULL)
   {
   fprintf(stderr, "Couldn't open sstream \"%s\".\n",nameip);
   exit(1);
   }

printf("\n Enter the output sstream name \n");
scanf("%12s",&nameop);

if((out = fopen(nameop, "wb")) == NULL)
   {
   fprintf(stderr,"Can't create output sstream. \"%s\" \n",nameop);
   exit(0);
   }

printf("\n WARNING THIS WILL DESTROY DATA CTL 'C' TO ABORT ");
printf("\n or enter code CHARLIE (C) to continue ");        /* input offset for removing tail off file */
scanf("%12s",&nb); 
offset = atol(nb);

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);

if(offset >= last)
{printf("\n out of range aborting......");exit(0);fclose(in);fclose(out);}

for (count = 0L; count <= offset; count++)                  
   {
   chr = fgetc(in);                                        /* strip tail off file */
   fputc(chr,out);
   } 
fclose(in);                                     /* I think these put EOF on file */
fclose(out);
}

void white(void)
{
FILE *in,*out;

unsigned long cnt_2,last;
char ch,opname[13];
char offset[11];
long int x;  
time_t t; 
unsigned long rnd,rndd;
                           
printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   } 

if((in = fopen("cryptic.exe", "rb")) == NULL)
   {
   fprintf(stderr,"a read is required from file cryptic.exe and has failed!. \n");
   exit(2);
   }                        

printf("\n enter the size of file you wish to create ");
scanf("%s",&offset);
x = atol(offset);
printf("\n value is %ld ", x);

printf("\n creating file please wait.....");
printf("\n this may take some time on a slow machine ");
rnd = time(&t) % 255;
for(cnt_2 = 0L; cnt_2 <= x; cnt_2++)          /* the x is the size of file */
   {
   ch = fgetc(in);
   if(ch == EOF){rewind(in);}
   rndd = rnd ^ ~ch;
   if(rnd >= 1800000){rnd = 10256;}
   rnd = rnd + 31 / 3;
   rnd = rnd + time(&t) %255;
   rnd = rnd + rand() % 255;
   fputc(rndd,out);
   }
fclose(out);
}

void insert(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch;
char alpha[5];
char buf_out[5];
char sync[] = "vzczc";

unsigned long last,count;

unsigned int r;
int x;


printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter 5 charater alpha sequence ");
scanf("%5s",&alpha);

printf("\n alpha code = %s ", alpha);

printf("\n\n GENERATING ALPHA CODE\n");

for(count = 0L; count <= 4; count++)
   {
   buf_out[count] = alpha[count] ^ sync[count];
   fputc(buf_out[count],out);
   }

fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* find file size */
        rewind(in);                        /* set file pointer to start of file */
	for (count = 0L; count <= last - 1; count++) /* loop to end of data file */
	{      
		ch = fgetc(in);                       /* get char from data file */    
                fputc(ch,out);                     /* copy character to o/p file */                
        }
fclose(in);
fclose(out);
}

void xrandom(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[] = "00000";
unsigned long last,count;
unsigned int seed;
unsigned int r;
int x,status = 0,set = 0,skip =0;


printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n ADDING NOISE\n");

srand((unsigned int)seed);                            /* set pseudo-random seed */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* find file size */
        rewind(in);                        /* set file pointer to start of file */
	for (count = 0L; count <= last - 1; count++) /* loop to end of data file */
	{

 if(set == 0)
       {
       r = (unsigned int) rand();
       }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       fputc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){fputc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     fputc(ch,out);
     }                
        }
fclose(in);
fclose(out);
}

void unrandom(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[] = "00000";
unsigned long last,count;
unsigned int seed;
unsigned int r;
int set = 0;
int skip = 0;
int status = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n EXTRACTING NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */

fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
for(count = 0L; count <= last - 1; count++)
   {
if(set == 0)
       {
       r = (unsigned int) rand();
       }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       fputc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){fputc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     fputc(ch,out);
     }
   }
fclose(in);
fclose(out);
}

void rempub(void)
{
FILE *in, *out;
char ch,opname[13];
char inname[13];
unsigned long cnt_a,last;

printf("\n Enter pgp name to remove public key from ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_a = 0;cnt_a <= last - 1;cnt_a++)
    {
    ch = fgetc(in);
    if(cnt_a > 17)
    fputc(ch,out);
    }

fclose(in);
fclose(out);
}

void inspub(void)
{
FILE *in, *key, *out;
char ch,opname[13];
char inname[13];
char keyfile[13];
unsigned long cnt_a,last;

printf("\n Enter pgp file name insert public key into ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of pgp referance file including file extension ");
scanf("%12s",&keyfile);
if((key = fopen(keyfile, "rb")) == NULL)
{
fprintf(stderr,"can't open referance file. \n", &keyfile);
exit(0);
}

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

cnt_a=0;
while ((ch = fgetc(key)) !=EOF)
   {
   cnt_a = cnt_a +1;
   if(cnt_a < 19)                           /* put header from 1st file into o/p */
   fputc(ch,out);
   } 
cnt_a=0;
fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_a = 0;cnt_a <= last - 1;cnt_a++)
    {
    ch = fgetc(in);
    fputc(ch,out);
    }

fclose(in);
fclose(key);
fclose(out);
}

void compair(void)
{
FILE *in, *key;
char ch,cha,first[13];
char second[13];
unsigned long cnt_a,lastin,lastkey;
unsigned long cnt_b = 0;

printf("\n Enter name of first file including file extension ");
printf("\n this must be the larger of the files if they are different ");
printf("\n sizes it will compair the bytes upto the size of the smaller ");
printf("\n file ");
scanf("%12s",&first);
if((in = fopen(first, "rb")) == NULL)
{
fprintf(stderr,"can't read file \n");
exit(0);
}
printf("\n Enter name of second file including file extension ");
scanf("%12s",&second);
if((key = fopen(second, "rb")) == NULL)
{
fprintf(stderr,"can't read file \n");
exit(0);
}

fseek(in,0L,SEEK_END);
lastin = ftell(in);
fseek(key,0L,SEEK_END);
lastkey = ftell(key);
if((lastin - lastkey) != 0)
{printf("\n these file are not the same size ");}
rewind(in);
rewind(key);
for(cnt_a = 0;cnt_a <= lastkey - 1;cnt_a++)
    {
    ch = fgetc(key);
    cha = fgetc(in);
    if (((char)ch - (char)cha) != 0)
    {cnt_b++;}
    }
printf("\n number of errors found = %ld ", cnt_b);
printf("\n If you've found errors make sure if the files are not the same ");
printf("\n size they are the correct way round ");
fclose(in);
fclose(key);
}

void copy(void)
{
FILE *in, *out;

unsigned long cnt_2,last;
char ch,opname[13];
char inname[13];

printf("\n Enter name of file to copy including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                    /* read only */
   {
   fprintf(stderr,"Can't open file file. \n",&inname);
   exit(2);
   }      

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);
if((out = fopen(opname, "wb")) == NULL)
{
fprintf(stderr,"can't create output file. \n", &opname);
exit(0);
}

printf("\n copying file please wait.....");

fseek(in,0L,SEEK_END);
last = ftell(in);
rewind(in);
for(cnt_2 = 0L; cnt_2 <= last - 1; cnt_2++)
   {
   ch = fgetc(in);
   fputc(ch,out);
   }
fclose(in);
fclose(out);
}

void vert(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[] = "00000";
unsigned long last = 0;
unsigned long count = 0;
unsigned long nb = 0;
unsigned int seed = 0;
unsigned int r = 0;
int status = 0,set = 0,skip = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* find file size */
        rewind(in);                        /* set file pointer to start of file */
printf("\n input skipping parameter ");
scanf("%ld",&nb);
if(nb > last)
   {
   printf("\n the size of your skipping parameter is out of range ");
   fclose(in);fclose(out);exit(0);
   }
for (count = 0L; count <= nb - 1; count++) 
     {
     ch = fgetc(in);
     fputc(ch,out);
     }
/* ch = 'X';fputc(ch,out); */
/*---------------------------------------------------------------------------*/
/* produces pseudo-random number if its divisable by 7 and skip = 0 then it  */
/* takes a byte from data file and memorises it. Depending on set/skip/status*/
/* variables it then encrypts subsequent bytes with it.                      */
/* set - stops rand from increamenting if divisable by 7                     */
/* skip stops string of random numbers being used                            */
/* status sends all bytes to o/p untill encryption cuts in                   */               
/*---------------------------------------------------------------------------*/
printf("\n\n ADDING NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */
r250_init(seed);
	for (count = nb; count <= last - 1; count++) /* loop to end of data file */
	{
 if(set == 0)
       {
       r = (unsigned int) rand() ^ (unsigned int) r250();
       }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       fputc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){fputc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     fputc(ch,out);
     }                
        }
fclose(in);
fclose(out);
}

void unvert(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[] = "00000";
unsigned long last = 0;
unsigned long count = 0;
unsigned long nb = 0;
unsigned int seed = 0;
unsigned int r = 0;
int set = 0;
int skip = 0;
int status = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputed string to a number */

printf("\n enter skip parameter ");
scanf("%ld",&nb);
srand((unsigned int)seed);                            /* set pseudo-random seed */
r250_init(seed);
fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
if(nb > last)
   {
   printf("\n the size of your skipping parameter is out of range ");
   fclose(in);fclose(out);exit(0);
   }
for (count = 0L; count <= nb - 1; count++) 
     {
     ch = fgetc(in);
     fputc(ch,out);
     }

printf("\n\n EXTRACTING NOISE\n");
for(count = nb; count <= last - 1; count++)
   {
if(set == 0)
       {
       r = (unsigned int) rand() ^ (unsigned int) r250();
       }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       fputc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){fputc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     fputc(ch,out);
     }
   }
fclose(in);
fclose(out);
}

void multi(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,noise;
char preseed[] = "00000";
unsigned long rnd,rndd,last,count;
unsigned int seed;
unsigned int r;
int status_2 = 0;
time_t t;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n ADDING ENCRYPTED NOISE\n");
rnd = time(&t) % 255;                /* produce a random number bassed on clock */
srand((unsigned int)seed);                            /* set pseudo-random seed */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* fine file size */
        rewind(in);                        /* set file pointer to start of file */
	for (count = 0L; count <= last - 1; count++) /* loop to end of data file */
	{
                r = (unsigned int)rand();
		ch = fgetc(in);                       /* get char from data file */ 
                rndd = rnd ^ ch;                        /* generate white noise */
                if((r % 7) == 0)         /* test for place noise to be inserted */
                {
                fputc((char)rndd,out);                /* put white noise in file */
                noise = (char)rndd;                
                if(rnd >= 1800000){rnd = 10023;}                /* modify noise */
                rnd = rnd + 42 / 3;  
                status_2 = 1;
                }
                    /* makes sure the first bytes before noise are encrypted */
                if(status_2 == 0)
                {r = r % 255;ch = ch ^ r;
                fputc(ch,out);}
                                  /* encrypts with noise and sends to output */
                if(status_2 == 1)
                {ch = ch ^ noise;fputc(ch,out);}
        }

fclose(in);
fclose(out);
}

void unmulti(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,noise;
char preseed[] = "00000";
unsigned long last,count;
unsigned int seed;
unsigned int r;
int status_1 = 0;
int set = 0;
int skip = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n EXTRACTING ENCRYPTED NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */

fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
for(count = 0L; count <= last - 1; count++)
   {
   if(set == 0)
      {
      r = (unsigned int) rand();
      }
   ch = fgetc(in);
   
   if ((r % 7) == 0 && skip == 0)
      {
      set = 1;
      skip = 1;
      status_1 = 1;
      noise = ch;
      continue;
      } 
   set = 0;
   skip = 0;
   if(status_1 == 0)
   {r = r % 255; ch = ch ^ r ;
   fputc(ch,out);}
   if(status_1 == 1)
   {ch = ch ^ noise;fputc(ch,out);}
    }
fclose(in);
fclose(out);
}

void back(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[4];
unsigned long nb,last,count,cnt_1;
unsigned int seed;
unsigned int r;
int x,status = 0,set = 0,skip =0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 0 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* find file size */
        rewind(in);                        /* set file pointer to start of file */
printf("\n input skipping parameter ");
scanf("%ld",&nb);
if(nb > last)
   {
   printf("\n the size of your skipping parameter is out of range ");
   fclose(in);fclose(out);exit(0);
   }
for (count = 0L; count <= nb - 1; count++) 
     {
     ch = fgetc(in);
     fputc(ch,out);
     }
/* ch = 'X';fputc(ch,out); */
/*---------------------------------------------------------------------------*/
/* produces pseudo-random number if its divisable by 7 and skip = 0 then it  */
/* takes a byte from data file and memorises it. Depending on set/skip/status*/
/* variables it then encrypts subsequent bytes with it.                      */
/* set - stops rand from increamenting if divisable by 7                     */
/* skip stops string of random numbers being used                            */
/* status sends all bytes to o/p untill encryption cuts in                   */               
/*---------------------------------------------------------------------------*/
printf("\n\n ADDING NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */
	for (count = nb; count <= last - 1; count++) /* loop to end of data file */
	{
 if(set == 0)
       {
       r = (unsigned int) rand();
       }
   ch = getc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       putc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){putc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     putc(ch,out);
     }                
        }
fclose(in);
fclose(out);
}

void unback(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,chn;
char preseed[4];
unsigned long nb,last,count,cnt_1;
unsigned int seed;
unsigned int r;
int set = 0;
int skip = 0;
int status = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 0 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n enter skip parameter ");
scanf("%ld",&nb);
srand((unsigned int)seed);                            /* set pseudo-random seed */
fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
if(nb > last)
   {
   printf("\n the size of your skipping parameter is out of range ");
   fclose(in);fclose(out);exit(0);
   }
for (count = 0L; count <= nb - 1; count++) 
     {
     ch = fgetc(in);
     fputc(ch,out);
     }

printf("\n\n EXTRACTING NOISE\n");
for(count = nb; count <= last - 1; count++)
   {
if(set == 0)
       {
       r = (unsigned int) rand();
       }
   ch = getc(in);
   
   if ((r % 7) == 0 && skip == 0)
       {
       set = 1;
       skip = 1;
       status = 1;
       chn = ch;
       putc(ch,out);
       continue;
       } 
   set = 0;
   skip = 0;
     if(status == 0){putc(ch,out);}
else if(status == 1)
     {
     ch = ch ^ chn;
     putc(ch,out);
     }
   }
fclose(in);
fclose(out);
}

void modify(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,noise;
char preseed[] = "00000";
unsigned long rnd,rndd,last,count;
unsigned int seed;
unsigned int r,k;
int status_2 = 0;
time_t t;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }

printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n ADDING ENCRYPTED NOISE\n");
rnd = time(&t) % 255;                /* produce a random number bassed on clock */
srand((unsigned int)seed);
r250_init(seed);                            /* set pseudo-random seed */
fseek(in,0L,SEEK_END);                                      /* seek end of file */
	last = ftell(in);                                     /* fine file size */
        rewind(in);                        /* set file pointer to start of file */
	for (count = 0L; count <= last - 1; count++) /* loop to end of data file */
	{
                r = (unsigned int)rand();
		ch = fgetc(in);                       /* get char from data file */ 
                k = (unsigned int)r250() % 25;
                if(k < 2) k = k + 2;
                rndd = rnd ^ ~ch;                        /* generate white noise */
                if((r % (unsigned int)k) == 0)         /* test for place noise to be inserted */
                {
                fputc((char)rndd,out);                /* put white noise in file */
                noise = (char)rndd;                
                if(rnd >= 1800000){rnd = 10023;}                /* modify noise */
                rnd = rnd + 42 / 3;
                rnd = rnd + time(&t) % 255;  
                status_2 = 1;
                }
                    /* makes sure the first bytes before noise are encrypted */
                if(status_2 == 0)
                {r = r % 255;ch = ch ^ r;
                fputc(ch,out);}
                                  /* encrypts with noise and sends to output */
                if(status_2 == 1)
                {ch = ch ^ noise;fputc(ch,out);}
        }

fclose(in);
fclose(out);
}

void unmodify(void)
{
FILE *in,*out;

char opname[13];  
char inname[13];
char ch,noise;
char preseed[] = "00000";
unsigned long last,count;
unsigned int seed;
unsigned int r,k;
int status_1 = 0;
int set = 0;
int skip = 0;

printf("\n Enter name of data file including file extension ");
scanf("%12s",&inname);            
if((in = fopen(inname, "rb")) == NULL)                            /* read only */
   {
   fprintf(stderr,"Can't open data file. \n",&inname);
   exit(2);
   }


printf("\n Enter name of output file including file extension ");
scanf("%12s",&opname);            
if((out = fopen(opname, "wb")) == NULL)                          /* write only */
   {
   fprintf(stderr,"Can't create output file. \n",&opname);
   exit(2);
   }

printf("\n enter seed value 1 - 32000 ");
scanf("%s",&preseed);
seed = atoi(preseed);                    /* convert inputted string to a number */

printf("\n\n EXTRACTING ENCRYPTED NOISE\n");
srand((unsigned int)seed);                            /* set pseudo-random seed */
r250_init(seed);
fseek(in,0L,SEEK_END);
   last = ftell(in);
   rewind(in);
for(count = 0L; count <= last - 1; count++)
   {
   if(set == 0)
      {
      r = (unsigned int) rand();
      k = (unsigned int) r250() % 25;
      if(k < 2) k = k + 2;
      }
   ch = fgetc(in);
   
   if ((r % (unsigned int)k) == 0 && skip == 0)
      {
      set = 1;
      skip = 1;
      status_1 = 1;
      noise = ch;
      continue;
      } 
   set = 0;
   skip = 0;
   if(status_1 == 0)
   {r = r % 255; ch = ch ^ r ;
   fputc(ch,out);}
   if(status_1 == 1)
   {ch = ch ^ noise;fputc(ch,out);}
    }
fclose(in);
fclose(out);
}

void main(int argc,char *argv[])
{
if(argc != 2)
{prompt();exit(0);}

if(strcmp(argv[1], "-encrypt") == 0)
       {encrypt();}
else if(strcmp(argv[1], "-decrypt") == 0)
       {decrypt();}
else if(strcmp(argv[1], "-verbatum") == 0)
       {verbatum();}
else if(strcmp(argv[1], "-unverbatum") == 0)
       {verbatum();}
else if(strcmp(argv[1], "-wibble") == 0)
       {wibble();}
else if(strcmp(argv[1], "-unwibble") == 0)
       {unwibble();}
else if(strcmp(argv[1], "-reverse") == 0)
       {reverse();}
else if(strcmp(argv[1], "-invert") == 0)
       {invert();}
else if(strcmp(argv[1], "-lr1") == 0)
       {left();}
else if(strcmp(argv[1], "-rr1") == 0)
       {right();}
else if(strcmp(argv[1], "-rotate") == 0)
       {rotate();}
else if(strcmp(argv[1], "-merge") == 0)
       {merge();}
else if(strcmp(argv[1], "-unmerge") == 0)
       {unmerge();}
else if(strcmp(argv[1], "-mask") == 0)
       {mask();}
else if(strcmp(argv[1], "-duress") == 0)
       {duress();}
else if(strcmp(argv[1], "-preamble") == 0)
       {preamble();}
else if(strcmp(argv[1], "-size") == 0)
       {size();}
else if(strcmp(argv[1], "-inspgp") == 0)
       {inspgp();}
else if(strcmp(argv[1], "-rempgp") == 0)
       {rempgp();}
else if(strcmp(argv[1], "-noise") == 0)
       {randn();}
else if(strcmp(argv[1], "-unnoise") == 0)
       {unnoise();}
else if(strcmp(argv[1], "-scan") == 0)
       {scan();}
else if(strcmp(argv[1], "-xor") == 0)
       {crack();}
else if(strcmp(argv[1], "-zeros") == 0)
       {zeros();}
else if(strcmp(argv[1], "-kill") == 0)
       {kill();}
else if(strcmp(argv[1], "-white") == 0)
       {white();}
else if(strcmp(argv[1], "-insert") == 0)
       {insert();}
else if(strcmp(argv[1], "-random") == 0)
       {xrandom();}
else if(strcmp(argv[1], "-unrandom") == 0)
       {unrandom();}
else if(strcmp(argv[1], "-rempub") == 0)
       {rempub();}
else if(strcmp(argv[1], "-inspub") == 0)
       {inspub();}
else if(strcmp(argv[1], "-compair") == 0)
       {compair();}
else if(strcmp(argv[1], "-copy") == 0)
       {copy();}
else if(strcmp(argv[1], "-vert") == 0)
       {vert();}
else if(strcmp(argv[1], "-unvert") == 0)
       {unvert();}
else if(strcmp(argv[1], "-multi") == 0)
       {multi();}
else if(strcmp(argv[1], "-unmulti") == 0)
       {unmulti();}
else if(strcmp(argv[1], "-back") == 0)
       {back();}
else if(strcmp(argv[1], "-unback") == 0)
       {unback();}
else if(strcmp(argv[1], "-help") == 0)
       {prompt();exit(0);}
else if(strcmp(argv[1], "-help2") == 0)
       {help();exit(0);}
else if(strcmp(argv[1], "-help3") == 0)
       {help3();exit(0);}
else if(strcmp(argv[1], "-keyhelp") == 0)
       {keyhelp();exit(0);}
else if(strcmp(argv[1], "-modify") == 0)
       {modify();exit(0);}
else if(strcmp(argv[1], "-unmodify") == 0)
       {unmodify();exit(0);}
else if(strcmp(argv[1], argv[1]) == 0)
       {prompt();exit(0);}
}

