#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include <math.h>
#define	TWO_PI	((double)2.0 * M_PI)

typedef unsigned char DacPalette256[256][3];
unsigned char far *VGAmem;
struct REGPACK regp;
union  REGS reg;
int Linecolor=1,WritePage=0;
int minX=0,minY=0,maxx=320,maxy=200;

DacPalette256 Hallo;

/* Globals */

int	samples, power,winX=1;
double	real[2048], imag[2048], max, Pegel=40,FFTmax;
int Buffer[1024];
FILE	*fpi, *fpo;

/* Prototypes and forward declarations */

void	fft(void), max_amp(void);
int	permute(int);
double	magnitude(int);
void dspwrite ( unsigned char );
unsigned char dspread ( void );
unsigned char far *data;
unsigned char far *aligned;
unsigned char far aligned_physical;

/* Getvgapalette256 gets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* getvgapalette256(&dac256);			      */
void getvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1017;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}

/* Setvgapalette256 sets the entire 256 color palette */
/* PalBuf contains RGB values for all 256 colors      */
/* R,G,B values range from 0 to 63	              */
/* Usage:					      */
/*  DacPalette256 dac256;			      */
/*						      */
/* setvgapalette256(&dac256);			      */
void setvgapalette256(DacPalette256 *PalBuf)
{
  regp.r_ax = 0x1012;
  regp.r_bx = 0;
  regp.r_cx = 256;
  regp.r_es = FP_SEG(PalBuf);
  regp.r_dx = FP_OFF(PalBuf);
  intr(0x10,&regp);
}



void Grafik(int GFXmode)  // 13,      14,     17mono,   18,      19vga,  -1,3
{                         //320x200, 640x200, 640x480, 640x480, 320x200, text
VGAmem=(char far *)MK_FP(0xa000,0);
   regp.r_ax = GFXmode;
   intr(0x10,&regp);
}



void TextXYC(int x,int y,int c,char *daten)
{
 int m;
 m=strlen(daten);
 regp.r_ax = 0x1300;
 regp.r_bx = c+256*WritePage;
 regp.r_cx = m;
 regp.r_dx = x+256*y;
 regp.r_es = FP_SEG(daten);
 regp.r_bp = FP_OFF(daten);
 intr(0x10,&regp);
}



void MakePalette()
{
 int frag;
 for(frag=0;frag<256;frag++)
   {
    if(frag<32)
	       {
		Hallo[frag][0]=0;
		Hallo[frag][1]=0;
		Hallo[frag][2]=2*frag;
	       }
    if((frag>=32)&&(frag<96))
			     {
			      Hallo[frag][0]=0;
			      Hallo[frag][1]=(frag-32);
			      Hallo[frag][2]=(95-frag);
			     }
    if((frag>=96)&&(frag<128))
			      {
			       Hallo[frag][0]=2*(frag-96);
			       Hallo[frag][1]=63;
			       Hallo[frag][2]=0;
			      }
    if((frag>=128)&&(frag<192))
			       {
				Hallo[frag][0]=63;
				Hallo[frag][1]=(191-frag);
				Hallo[frag][2]=(frag-128);
			       }
    if(frag>=192)
   	         {
	          Hallo[frag][0]=31+abs(223-frag);
		  Hallo[frag][1]=0;
		  Hallo[frag][2]=0;
		  if(frag<223)Hallo[frag][2]=2*(222-frag);
	         }
   }
 setvgapalette256(&Hallo);
}


//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inportb(0x022C)&0x80);
    outportb(0x022C,c);
}
//------------------------------------------------------------------------------
void sbinit ( void )
{
    unsigned short x;
    inportb(0x022E);
    outportb(0x0226,0x01);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    outportb(0x0226,0x00);
    for(x=0;x<100;x++)
    {
        if(inportb(0x022E)&0x80)
        {
            if(inportb(0x022A)==0xAA) break;
        }
    }
    if(x==100)
    {
        printf("Sound Blaster not found at 0220h\n");
        exit(1);
    }
}
//------------------------------------------------------------------------------
void sbmalloc ( void )
{
    unsigned long physical;
    data=farmalloc(80000L);
    if(data==NULL)
    {
        printf("Memory Allocation Error\n");
        exit(1);
    }
    physical=((unsigned long)FP_OFF(data))+(((unsigned long)FP_SEG(data))<<4);
    physical+=0x0FFFFL;
    physical&=0xF0000L;
    aligned_physical=(physical>>16)&15;
    aligned=MK_FP(((unsigned short)aligned_physical<<12)&0xF000,0);
}
//------------------------------------------------------------------------------
void sbsettc ( unsigned char tc )
// tc = time constant = 256L - (1000000UL/samples per second)
{
    inportb(0x022E);
    dspwrite(0x40);
    dspwrite(tc);
}
//------------------------------------------------------------------------------
void sbrec ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,0);
    outportb(0x02,0);
    outportb(0x83,aligned_physical);
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x24);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
unsigned short dmacount ( void )
{
    unsigned short x;
    x=inportb(0x03);
    x|=inportb(0x03)<<8;
    if(x==0xFFFF) inportb(0x022E);
    return(x);
}
//------------------------------------------------------------------------------


/* The program */
//samples = How many Real/Imag Numbers...
//power =  log10((double)samples) / log10((double)2.0);


void fft()
{
	unsigned i1, i2, i3, i4, y;
	int	 loop, loop1, loop2;
	double	 a1, a2, b1, b2, z1, z2, v;

	/* Scale the data */

	for (loop = 0; loop < samples; loop++)  {
		real[loop] /= (double)samples;
		imag[loop] /= (double)samples;
	}

	i1 = samples >> 1;
	i2 = 1;
	v = TWO_PI * ((double)1.0 / (double)samples);

	for (loop = 0; loop < power; loop++)  {
		i3 = 0;
		i4 = i1;

		for (loop1 = 0; loop1 < i2; loop1++)  {
			y = permute(i3 / i1);
			z1 =  cos(v * y);
			z2 = -sin(v * y);

			for (loop2 = i3; loop2 < i4; loop2++)  {
				a1 = real[loop2];
				a2 = imag[loop2];

				b1 = z1*real[loop2+i1] - z2*imag[loop2+i1];
				b2 = z2*real[loop2+i1] + z1*imag[loop2+i1];

				real[loop2]      = a1 + b1;
				imag[loop2]      = a2 + b2;

				real[loop2 + i1] = a1 - b1;
				imag[loop2 + i1] = a2 - b2;
			}

			i3 += (i1 << 1);
			i4 += (i1 << 1);
		}

		i1 >>= 1;
		i2 <<= 1;
	}
}

/*
 *	Find maximum amplitude
 */

void max_amp()
{
	double	mag;
	int	loop;

	max = (double)0.0;
	for (loop = 0; loop < samples; loop++)  {
		if ((mag = magnitude(loop)) > max)
			max = mag;
	}
}

/*
 *	Calculate Power Magnitude
 */

double magnitude(n)
int	n;
{
	n = permute(n);
	return (sqrt(real[n] * real[n] + imag[n] * imag[n]));
}

/*
 *	Bit reverse the number
 *
 *	Change 11100000b to 00000111b or vice-versa
 */

int permute(index)
int	index;
{
	int	n1, result, loop;

	n1 = samples;
	result = 0;

	for (loop = 0; loop < power; loop++)  {
		n1 >>= 1;			/* n1 / 2.0 */
		if (index < n1)
			continue;

		result += (int) pow((double)2.0, (double)loop);
		index -= n1;
	}

	return result;
}
//---------------------------------------------------------------------------
void windows()
{
 int t;
 double w = 2.0 * M_PI / samples;
 double p90 = M_PI / 2.0;
 for(t=0;t<samples;t++) real[t]*=(1.0+sin(w*t-p90));   //cos!
}
//---------------------------------------------------------------------------
void mode19bar()
{
 unsigned e,f=319;
 for(e=63;e>=2;e--) { *(VGAmem+f)=Buffer[e]; f+=320; }
 _fmovmem(VGAmem+319,VGAmem+320,19840);
 f=0;
 for(e=2;e<64;e++)f+=Buffer[e];
 f/=40;
 if(f>319)f=319;
 for(e=0;e<f;e++)*(VGAmem+31360+e)=e/2+64;
 for(;e<320;e++)*(VGAmem+31360+e)=0;
 for(e=0;e<f;e++)*(VGAmem+32000+e)=e/2+64;
 for(;e<320;e++)*(VGAmem+32000+e)=0;
 for(e=0;e<f;e++)*(VGAmem+32640+e)=e/2+64;
 for(;e<320;e++)*(VGAmem+32640+e)=0;
 for(e=0;e<f;e++)*(VGAmem+33280+e)=e/2+64;
 for(;e<320;e++)*(VGAmem+33280+e)=0;
 for(e=0;e<f;e++)*(VGAmem+33920+e)=e/2+64;
 for(;e<320;e++)*(VGAmem+33920+e)=0;
}



void cool()
{
 int i,t;
 double v;
 long m;
samples=128;
power =  log10((double)samples) / log10((double)2.0);
Grafik(19);
MakePalette();
TextXYC(0,18,100,"  FFT-3D, Freeware by Lars Otte");
TextXYC(0,20,250,"SPACE => toggle Linear/logarithmic");
TextXYC(0,22,250,"  +   =>  incrementing Volumelevel");
TextXYC(0,24,250,"  -   =>  decrementing Volumelevel");
for(t=0;t<256;t++)*(VGAmem+49280+t)=t;
for(t=0;t<255;t++)*(VGAmem+49601+t)=t;
for(t=0;t<254;t++)*(VGAmem+49922+t)=t;
 sbrec(8000);
 while(dmacount()!=0xFFFF);
 for(i=999;i<7999;i++) m=m+ *(aligned+i);
 m=m/7000;    //Zero calibration!

nochmal:
 for(i=0;i<samples;i++) { imag[i]=0; real[i]= *(aligned+i) - m; }
 sbrec(129);
 windows();
 fft();
 for(t=2;t<64;t++)
    {
     i=permute(t);
     v=sqrt(real[i] * real[i] + imag[i] * imag[i]);
     v*=Pegel;
     if(winX)v=16.0*sqrt(v);
     if(v>255.0)Buffer[t]=255; else Buffer[t]=(int)v;
    }
 mode19bar();
 while(dmacount()!=0xFFFF);
if(!kbhit())goto nochmal;
i=getch();
if(i=='+'){Pegel=Pegel*1.4142136; goto nochmal;}
if(i=='-'){Pegel=Pegel/1.4142136; goto nochmal;}
if((i==13)||(i==32)) { winX^=1; goto nochmal;}
}





void main()
{
 long ra=8000,ca; //samplerate=8kHz fg=4kHz
sbinit();
sbmalloc();
ca= 256L - ( 1000000L / ra);
sbsettc(ca);
FFTmax=(double)ra;
cool();
Grafik(3);
}

