procedure LITEMENU;
{ Menu to change lighting parameters }

var Cmmd: integer;         { user's inputted choice }
    Lite: integer;         { light source # }
    Mat: integer;          { material # }
    Eps: real;             { temp for Epsilon }
    Rsh: real;             { temp for Randshade }
    ch: char;

begin
  repeat
    openwin (13,6,67,21, TRUE);
    gotoXY (20,1);
    writeln ('LIGHTING MENU');
    writeln; writeln;
    writeln ('1  Material Parameters (', Nmatl,')');
    writeln ('2  Light Sources (', Nlite,')');
    write   ('3  Gouraud Interpolation (');
    if (Interpolate) then
      writeln ('On)')
    else
      writeln ('Off)');
    write   ('4  Shadowing (');
    if (Shadowing) then
      writeln ('On)')
    else
      writeln ('Off)');
    writeln ('0  Return to Parameters Menu');
    writeln;
    write ('Command: ');
    Cmmd := getkey;
    if ((Cmmd < 1) or (Cmmd > 4)) and (Cmmd <> 0) then
      write(^G)
    else begin
      writeln (Cmmd);
      case Cmmd of
        1: begin
          if Nmatl < 1 then begin
            writeln('No Materials Defined!');
            write ('Press any key...');
            ch := readkey;
          end else begin
            Mat := 1;
            Mat := getoneint (Mat, 1, Nmatl, 'Material Number');
            writeln ('Shading is computing from a formula like:');
            writeln ('  E = I[R1(cos s)**R2 + R3cos n] + Ambient');
            R1[Mat] := getonereal (R1[Mat], 0.0, 99999.0, 'R1');
            R2[Mat] := getonereal (R2[Mat], -99999.0, 99999.0, 'R2');
            R3[Mat] := getonereal (R3[Mat], 0.0, 99999.0, 'R3');
            Ambient[Mat] := getonereal (Ambient[Mat], 0.0, 1.0,
                'Ambient Light');
            Color[Mat] := getoneint (Color[Mat], 0, Ncolors, 
                'Color (or 0 to enter RGB)');
            if (Color[Mat] = 0) then begin
              Color[Mat] := 2;  { for wireframe plotting }
              Redmax[Mat] := getoneint (Redmax[Mat], 1, 256, 'Max Red  ');
              Grnmax[Mat] := getoneint (Grnmax[Mat], 1, 256, 'Max Green');
              Blumax[Mat] := getoneint (Blumax[Mat], 1, 256, 'Max Blue ');
            end else
              color_to_rgb (Color[Mat], Redmax[Mat], Grnmax[Mat], Blumax[Mat]);
          end;  { if Nmatl < 1 }
        end; { 1: }
        2: begin
          if (Nlite > 1) then
            writeln ('There are currently ', Nlite, ' light sources.')
          else
            writeln ('There is currently ', Nlite, ' light source.');
          writeln ('Entering a light source number of 0 deletes the last');
          writeln ('  light source.  Entering a light source number of ',
                  Nlite+1);
          writeln ('  will add a new light source.');
          Lite := 1;
          Lite := getoneint (Lite, 0, Nlite+1, 'Light Source Number');
          if (Lite = 0) then begin
            if (Nlite < 2) then begin
              writeln ('Error: Cant delete all light sources!');
              write ('Press any key...');
              ch := readkey;
            end else
              Nlite := Nlite - 1;
          end;
          if (Lite > Nlite) then begin
            Nlite := Nlite + 1;
            Lite := Nlite;
            Xlite[Lite] := 0.0;
            Ylite[Lite] := 0.0;
            Zlite[Lite] := 0.0;
            Intensity[Lite] := 1.0;
          end;
          if (Lite > 0) then begin
            Xlite[Lite] := getonereal (Xlite[Lite], -99999.0, 99999.0, 'X');
            Ylite[Lite] := getonereal (Ylite[Lite], -99999.0, 99999.0, 'Y');
            Zlite[Lite] := getonereal (Zlite[Lite], -99999.0, 99999.0, 'Z');
            Intensity[Lite] := getonereal (Intensity[Lite], 0.0, 2.0,
                               'Intensity');
          end; { if Lite }
        end; { 2: }
        3: begin
          writeln ('Epsilon: Largest Change in Shading to Interpolate');
          writeln ('  A value of about 0.3 usually works well.');
          writeln ('  Enter a value of 0.0 for no interpolation.');
          Eps := Epsilon;
          Eps := getonereal (Eps, 0.0, 1.0, 'Epsilon');
          if (Eps > 0.0) then begin
            Interpolate := TRUE;
            Epsilon := Eps;
          end else
            Interpolate := FALSE;
          if (Interpolate) then begin
            writeln ('Entering a random shading value greater than 0');
            writeln ('  will cause the shading at all pixels in a Gouraud');
            writeln ('  interpolated rendering to be increased by a random');
            writeln ('  value in the range of 0 to the Random Shade.');
            writeln ('(Recommended values are no greater than the size of');
            writeln ('  one distinguishable shade -- for instance, on a 16');
            writeln ('  shade system, use numbers no greater than ',
                     (1.0/16.0):7:3,')');
            Rsh := Randshade;
            Rsh := getonereal (Rsh, 0.0, 1.0, 'Random Shade');
            if (Rsh > 0.0) then begin
              Dorandom := TRUE;
              Randshade := Rsh;
            end else
              Dorandom := FALSE;
          end; { if Interpolate }
        end; { 3: }
        4: begin
          if (Shadowing) then
            Shadowing := FALSE
          else
            Shadowing := TRUE;
        end; { 4: }
      end; { case Cmmd }
    end;
  until (Cmmd = 0)
end; { procedure Litemenu }
