procedure WRITEFILE (Filename: text80);
{ Write the new SURFMODL-format file }

var Outfile: text;              { file to write to }
    Vert: integer;              { vertex # }
    Node: integer;              { node # }
    Mat: integer;               { material # }
    Surf: integer;              { surface # }
    Nvertex: integer;           { # vertices in surface }
    Fileopen: boolean;          { flag opened file }
    Yorn: char;                 { user response }

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
begin
{$endif}
  Fileopen := FALSE;
  while (NOT Fileopen) do begin
    assign (Outfile, Filename);
    {$I-}
    rewrite (Outfile);
    {$I+}
    if (ioresult <> 0) then begin
      writeln ('Error opening output file ',Filename);
      write ('Try again (Y or N)?');
      readln (Yorn);
      if (Yorn <> 'Y') and (Yorn <> 'y') then
        halt;
    end else
      Fileopen := TRUE;
  end; { while }

  writeln (Outfile, Flpurpose);
  writeln (Outfile, 4);
  writeln (Outfile, '* NMatls, Nnodes, Nsurf, Maxvert, Nsides');
  writeln (Outfile, Nmatl,' ',Nnodes,' ',Nsurf,' ',Maxvert,' ',Nsides);

  writeln (Outfile, '************ MATERIAL DATA SECTION **************');
  for Mat := 1 to Nmatl do
    writeln (Outfile, R1[Mat],' ',R2[Mat],' ',R3[Mat],' ',Color[Mat],' ',
             Ambient[Mat]);

  writeln (Outfile, '*************** NODAL DATA SECTION **************');
  for Node := 1 to Nnodes do
    writeln (Outfile, World[Node][1]:9:4,' ',World[Node][2]:9:4,' ',
             World[Node][3]:9:4);

  writeln (Outfile, '************* SURFACE DATA SECTION **************');
  for Surf := 1 to Nsurf do begin
    Nvertex := nvert (Surf);
    write (Outfile, Nvertex,' ',Matl[Surf],' ');
    for Vert := 1 to Nvertex do
      write (Outfile, konnec (Surf, Vert),' ');
    writeln (Outfile);
  end; { for Surf }

  close (Outfile);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure WRITEFILE }
