#include <stdio.h>
#include <sgtty.h>
#include <debug.h>
#include <ctype.h>
#include <setjmp.h>
#include <signal.h>
void (*signal())();
void (*moresig)();

long int size, position;
char filename[30];
char isaconsole = '\0';
char isapipe = '\0';
int tabsize = 8;
#define STDIN 0
#define STDOUT 1
#define STDERR 2
#define ESC '\033'
void (*output)();
extern int scr_putc();
std_out(c)
{
	write(1,&c,1);
}
jmp_buf moreenv;
moreintr()
{
	signal(SIGINT,moresig);
	longjmp(moreenv,-1);
}

more(argc,argv)
	int argc;
	char *argv[];
{
	FILE *fp, *fopen();
	long ftell();
	long int i;
	long int fsize();

	if (-1 == setjmp(moreenv))
	{
		write(2,"Interrupted\r\n",13);
		fclose(fp);
		return -1;
	}

	moresig = signal(SIGINT,moreintr);
	isaconsole = isatty(STDOUT);
	isapipe = !isatty(STDIN);
	if (isaconsole)
	{
		output = scr_putc;
		scr_echo(0);
	}
	else
		output = std_out;
	if ( (*(++argv))[0] == '-' && isdigit((*argv)[1]) )
	{
		tabsize = atoi( (*argv+1) );
		--argc;
	} else
	{
		--argv;
	}
	if (argc == 1)
	{
		if (NULL == (fp = fdopen(0,"r")))
		{
			return -1;
		}
		display(fp);
		crlf();
		return 0;
	}
	while(--argc) 
	{
		if (NULL == (fp = fopen(*(++argv),"r")) )
		{
			fprintf(stderr,"more - can't open %s\n",*argv);
			continue;
		}
		strncpy(filename,*argv,30);
		if (filename[29])
			filename[29] = '\0';
		if (!isapipe)
			size = fsize(fp);
		position = 0;
		if (-2 == display(fp))
			argc = 0;		/* force completion of command */
		fclose(fp);
	}
bugout:
	if (isaconsole)
		scr_echo(0);
	crlf();
	tabsize = 8;
	isaconsole = isapipe = '\0';
	signal(SIGINT,moresig);
	return 0;
}

long fsize(fp) 
	FILE *fp;
{
	long ftell();
	long position, last;
	position = ftell(fp);
	if (-1 == fseek(fp,0L,2))
	{
		fprintf(stderr,"more - error on fseek\n");
	}
	last = (ftell(fp));
	fseek(fp,position,0);
	return last;
}
#define LBUFSIZE 160
char linebuffer[LBUFSIZE];
int lines;

display(fp)
	FILE *fp;
{
	FILE *fgets();
	long ftell();
	char c;
	lines = 1;
	while ( NULL != fgets(linebuffer,LBUFSIZE,fp))
	{
		if (isaconsole)
		{
			if (lines == 1)		/* top of display */
			{
				scr_clear();
			}
		}
		lines += localputs(linebuffer);
		if (isaconsole)
		{
			if (lines >=  24)		/* bottome of display */
			{
				char tst;
				position = ftell(fp);
				scr_curs(24,0);
				if (!isapipe)
					scr_printf(
				"%s - %ld bytes - %d%% displayed - <ESC> = skip to next file",
					filename,size,percent(position,size) );
				else
					scr_printf("-more-");
				switch (scr_getc())
				{
				case ESC :
					return 0;
				case 3 :
					return -2;
				default:
					break;
				}

				lines = 1;
			}
		}
	}
	if (isaconsole)
	{
		if (lines != 1)		/* bottome of display */
		{

			scr_curs(24,0);
			if (!isapipe)
			{
				position = ftell(fp);
				scr_printf("%s - %ld characters - %d%% displayed",
					filename,size,percent(position,size) );
			}
			else
				scr_printf("-done-");
			scr_getc();
			lines = 1;
		}
	}
}

percent(x,y)
	long int x,y;
{	/* returns integer percentage of x into y */
	float xf,yf;
	xf = x; yf = y;
	x = ((xf/yf)*100);
	return (x);
}

localputs(lb)
	register char *lb;
{
	int lines, pos, tabstop;
	lines = 1;
	pos = 0;
	while (*lb)
	{
		switch (*lb)
		{
		case '\t':
			tabstop = pos + (tabsize - (pos % tabsize));	
			for (;pos <= tabstop; pos++)
				(*output)(' ');
			break;
		case '\n':
			(*output)('\r');
		default:
			(*output)(*lb);
			pos++;
		}
		if (pos == 79)
		{
			pos = 1;
			(*output)('\r');
			(*output)('\n');
			++lines;
		} else if (pos > 79)
		{
			pos -= 80;
			++lines;
		}
		++lb;
	}
	return lines;
}

scr_printf(fmt,args)
char *fmt; unsigned args;
{
	extern int scr_putc();

	format(scr_putc,fmt,&args);
}
