
; REDVIEW.ASM  Copyright (C) by Alexandr NOVY 1988-92 (release 3)

MY_FLAG EQU 0BEh

_TEXT       SEGMENT
	    ASSUME  cs:_TEXT, ds:_TEXT, ss:_TEXT
	    ORG     100h

$start:      jmp   $begin

oldadr09    DD ?
oldadr21    DD ?
oldadr2f    DD ?
strategy    DD ?  ; address of CON startegy routine
interrupt   DD ?  ; address of CON interrupt routine
		  ; start of device request header
char_count  DW 0  ; bytes sent
drh_len     DB _DRH_LEN
drh_unt     DB ?
drh_cmd     DB 8  ; output device command number
drh_status  DW ?
drh_reserv  DB 8 DUP(?)
drh_media   DB ?
drh_bufaddr DD ?  ; address of output buffer
drh_count   DW ?  ; byte count
drh_sector  DW ?
drh_vidaddr DD ?
drh_ss32    DD ?
_DRH_LEN equ $-drh_len
		  ; end of device request header
space       DB 8 DUP(32) ; buffer for tab expanding
duplo       DB 1
character   DB ?
stack_size  DW 256

; ################################ INTERRUPT 09 ##############################
$begin09:
            push ax
            in al,60h
            cmp al,3ah
            jne $old09

            push es
            xor ax,ax
            mov es,ax
            test byte ptr es:[0417h],08h ; test for Alt
            jne  $alt09
            test byte ptr es:[0417h],04h ; test for Ctrl
            jne  $ctrl09
            pop  es
            jmp  short $old09
$ctrl09:
            mov  cs:duplo,0
            jmp  short $end09
$alt09:
            mov  cs:duplo,1
$end09:
            in al,60h
            in al,61h
            mov ah,al
            or  al,80h
            out 61h,al
            xchg ah,al
            out  61h,al
            mov  al,20h
            out  20h,al
            pop  es
            pop  ax
            sti
            iret
$old09:
           pop ax
           jmp cs:oldadr09
; ############################# END OF INTERRUPT 09 ##########################

IFNDEF _286_
retw DW ?
push_all:
         pop  cs:retw
         push ax
         push bx
         push cx
         push dx
         push bp
         push si
         push di
         jmp  cs:retw
pop_all:
         pop cs:retw
         pop di
         pop si
         pop bp
         pop dx
         pop cx
         pop bx
         pop ax
         jmp cs:retw
ENDIF

; ################################ INTERRUPT 21 ##############################
_ss_ dw 0
_sp_ dw 0
_jmps_ dw 0
_new_stack_:
	   pop cs:_jmps_
	   cmp cs:stack_size,0
	   je  $jmps
	   cli
	   mov cs:_ss_,ss
	   mov cs:_sp_,cs
	   mov ss,cs:_sp_
	   mov cs:_sp_,sp
	   mov sp,OFFSET $begin
	   add sp,cs:stack_size
	   sti
$jmps:	   jmp cs:_jmps_
_old_stack_:
	   pop cs:_jmps_
	   cmp cs:stack_size,0
	   je  $jmps
	   cli
	   mov ss,cs:_ss_
	   mov sp,cs:_sp_
	   sti
	   jmp cs:_jmps_

$begin21:
;-------------------------------------------------------
	   cmp ax,4400h       ; IOCTL info for handle 1 & 2
	   jne $21_1          ; must be 'device' when
	   cmp bx,1           ; REDVIEW installed
	   je  $21_dev
	   cmp bx,2
	   jne $21_1
$21_dev:
	   call _new_stack_   ; Without this redview conflicts
			      ; with Richard Marks' UUencode/UUdecode.
			      ; I don't know why.
	   call old21
	   pushf
	   or   dx,80h        ; set 'device' bit in IOCTL info
	   popf
	   call _old_stack_
	   retf 2
$21_1:
;--------------------------------------------------------            
           cmp cs:duplo,0     ; test of redview state (ON or OFF)
	   je  $old21

	   cmp ah,02          ; function 02 ?
	   jne $l2106
$l2102:
	   call rtest1        ; is stdout redirected ?
	   jne $old21
	   call send_char
	   jmp  short $old21

$l2106:
	   cmp  ah,06         ; function 06 ?
	   jne  $l2109
	   cmp  dl,0ffh
	   jne  $l2102

$l2109:
	   cmp ah,09          ; function 09 ?
	   jne $l2140
	   call rtest1        ; is stdout redirected ?
	   jne $old21
	   push si
	   push dx
	   mov  si,dx
$loop09:   mov  dl,[si]
	   cmp  dl,'$'
	   je   $end2109
	   call send_char
	   inc  si
	   jmp  short $loop09
$end2109:  pop dx
	   pop si
$l2140:
	   cmp ah,40h    ; function 40 ?
	   jne $old21
	   jcxz $old21   ; if nothing to write
	   cmp bx,1      ; handle 01 (stdout) ?
	   jne $l21402
	   call rtest1   ; is stdout redirected ?
	   jne $old21
	   jmp short $l2140go
$l21402:   cmp bx,2      ; handle 02 (stderr) ?
	   jne $old21
	   call rtest2   ; is stderr redirected ?
	   jne $old21
$l2140go:
	   push cx
	   push dx
	   push si
	   mov  si,dx
$loop40:   mov  dl,[si]
	   call send_char
	   inc  si
	   loop $loop40
	   pop  si
	   pop  dx
	   pop  cx
$old21:
	   jmp cs:oldadr21

old21:
	   pushf
	   call cs:oldadr21
	   ret

send_char:  ; send one character to CON device
	   cmp  dl,7    ; beep
	   je   $sc0
	   cmp  dl,10   ; new line
	   je   $sc0
	   cmp  dl,8    ; backspace
	   jne  $sc13
	   cmp  cs:char_count,0
	   je   $sc0
	   dec  cs:char_count
	   jmp  short $sc0
$sc13:	   cmp  dl,13   ; carriage return
	   jne  $sc09
	   mov  cs:char_count,0
	   jmp  short $sc0
$sc09:     cmp  dl,9
	   jne  $sc
	   push ax    ; expanding tab
	   push bx
	   push dx
	   mov  ax,cs:char_count
	   sub  dx,dx
	   mov  bx,8
	   div  bx
	   neg  dx
	   add  dx,bx
	   mov  word ptr cs:drh_bufaddr[0],OFFSET space
	   mov  word ptr cs:drh_bufaddr[2],cs
	   mov  cs:drh_count,dx
	   add  cs:char_count,dx
	   call send
	   pop  dx
	   pop  bx
	   pop  ax
	   ret
$sc:	   inc  cs:char_count
$sc0:	   mov  cs:character,dl
	   mov  word ptr cs:drh_bufaddr[0],OFFSET character
	   mov  word ptr cs:drh_bufaddr[2],cs
	   mov  cs:drh_count,1
send:       ; send character string to CON device
	   push bx
	   push es
	   mov  bx,OFFSET drh_len
	   push cs
	   pop  es
	   call cs:strategy
	   pop  es
	   pop  bx
	   call cs:interrupt
	   ret

device_test:
           push ax
           push dx
           mov  ax,4400h
           call old21
           test dl,80h
           pop  dx
           pop  ax
           ret

rtest1:     ; test if stdout is redirected
	   push bx
	   mov  bx,1
$rtest:    call device_test
	   pop  bx
	   ret
rtest2:     ; test if stderr is redirected
           push bx
           mov  bx,2
           jmp short $rtest

; ################################ INTERRUPT 2f ##############################
$begin2f:
          cmp  ah,MY_FLAG
          je   $l2f_0
	  jmp  cs:oldadr2f
$l2f_0:
	  or   al,al
	  jne  $l2f_1
	  mov  al,0ffh
$l2f_1:
	  cmp  al,1
	  jne  $l2f_2
	  mov  ax,cs   ; return segment of resident part
$l2f_2:
	  iret
; ############################# END OF INTERRUPT 2f ##########################

; ############################# START UP ################################

$begin:
	    mov resseg,cs

	    mov ah,35h
	    mov al,09h
	    int 21h
	    mov word ptr oldadr09[2],es
	    mov word ptr oldadr09[0],bx ; get int 09

	    mov ah,35h
	    mov al,21h
	    int 21h
	    mov word ptr oldadr21[2],es
	    mov word ptr oldadr21[0],bx ; get int 21

	    mov ah,35h
	    mov al,2fh
	    int 21h
	    mov word ptr oldadr2f[2],es
	    mov word ptr oldadr2f[0],bx ; get int 2f

	    mov ah,52h ; get list of lists
	    int 21h
	    les bx,es:[bx+0ch] ; load address of CON device
	    mov ax,es:[bx+6]   ; load address of strategy routine
	    mov word ptr strategy[0],ax
	    mov word ptr strategy[2],es
	    mov ax,es:[bx+8]   ; load address of interrupt routine
	    mov word ptr interrupt[0],ax
	    mov word ptr interrupt[2],es

	    mov dx,OFFSET ilogo
	    mov cx,l_ilogo
	    call msg

	    mov ah,MY_FLAG
	    sub al,al
	    int 2fh
	    or  al,al
	    je  $cont
	    cmp al,0ffh
	    jne $noins
	    mov  al,1
	    int  2fh
	    mov  resseg,ax
	    mov  es,ax
	    mov  ax,word ptr es:[$begin2f]
	    cmp  ax,word ptr [$begin2f]
	    je   $end
$noins:
	    mov dx,OFFSET noins
	    mov cx,l_noins
	    call msg
	    int 20h
$end:
	    call cmd_line
	    call unload
	    call status
	    int 20h
$cont:
	    call cmd_line

	    cmp  _unload,0
	    je   $cont1
	    mov dx,OFFSET noloaded
	    mov cx,l_noloaded
	    call msg
	    int 20h
$cont1:
	    mov dx,OFFSET resins
	    mov cx,l_resins
	    call msg

	    call status

	    mov ah,25h
	    mov al,09h
	    mov dx,OFFSET $begin09
	    int 21h                      ; set int 09

	    mov ah,25h
	    mov al,21h
	    mov dx,OFFSET $begin21
	    int 21h                      ; set int 21

	    mov ah,25h
	    mov al,2fh
	    mov dx,OFFSET $begin2f
	    int 21h                      ; set int 2f

	    push cs:[2ch] ; release of the enviroment
	    pop  es
	    mov  ah,49h
	    int  21h

	    push ds
	    pop es
	    mov dx,stack_size ; allocates extra stack space
	    add dx,OFFSET $begin + 1
	    int 27h  ; terminate and stay resident
;--------------------------------------------------

upper_al:
	   cmp  al,97
	   jb   $upend
	   cmp  al,122
	   ja   $upend
	   sub  al,32
$upend:    ret

cmd_line:
	   push si
	   mov  si,129
	   mov  es,resseg
$cmd_l1:
	   cmp  si,256
	   jge  $cmd_end
	   mov  al,[si]
	   cmp  al,13
	   je   $cmd_end
	   call upper_al
	   cmp  al,'U'
	   jne  $cmd_O
	   mov  _unload,1
	   jmp  short $cmd_next
$cmd_O:
	   cmp  al,'O'
	   jne  $cmd_next
	   mov  al,[si+1]
	   call upper_al
	   cmp  al,'N'
	   jne  $cmd_F
	   mov  es:duplo,1
	   jmp  short $cmd_next
$cmd_F:
	   cmp  al,'F'
	   jne  $cmd_next
	   mov  es:duplo,0
$cmd_next:
	   inc  si
	   jmp  short $cmd_l1
$cmd_end:
	   pop  si
	   ret


status:
	   mov es,resseg
	   cmp es:duplo,0
	   je  $disabled
	   mov dx,OFFSET onstate
	   mov cx,l_onstate
	   call msg
	   ret
$disabled: mov dx,OFFSET offstate
	   mov cx,l_offstate
	   call msg
	   ret


unload:
	   cmp _unload,0
	   jne  $unload1
	   ret
$unload1:
	   call check_vectors
	   jnz  $unload_failedv
	   mov  es,resseg
	   mov  ah,49h
	   int  21h    ;release resident segment
	   jb   $unload_failedr
	   call release_vectors
	   mov  dx,OFFSET unloaded
	   mov  cx,l_unloaded
	   call msg
	   int 20h
$unload_failedr:
	   mov  dx,OFFSET nounloadr
	   mov  cx,l_nounloadr
	   call msg
	   ret
$unload_failedv:
	   mov  dx,OFFSET nounloadv
	   mov  cx,l_nounloadv
	   call msg
	   ret


check_vectors:
	push di
	push si
	cld
	mov  cx,nvectors
	mov  di,OFFSET begins
	mov  si,OFFSET vectors
$check_v_lop:
	mov  ah,35h
	lodsb
	int  21h
	cmp  [di],bx
	jne  $check_v_end
	mov  ax,es
	cmp  resseg,ax
	jne  $check_v_end
	add  di,2
	loop $check_v_lop
	cmp  ax,ax
$check_v_end:
	pop  si
	pop  di
	ret

release_vectors:
	push di
	push si
	cld
	mov  cx,nvectors
	mov  di,OFFSET oldadrs
	mov  si,OFFSET vectors
	mov  es,resseg
$release_v_lop:
	mov  ah,25h
	lodsb
	push ds
	mov  bx,[di]
	lds  dx,es:[bx]
	int  21h
	pop  ds
	add  di,2
	loop $release_v_lop
	pop  si
	pop  di
	ret

oldadrs  DW oldadr09,oldadr21,oldadr2f
begins   DW $begin09,$begin21,$begin2f
vectors  DB 9h,21h,2fh
nvectors DW 3


msg:            ; send message (ds:dx) to screen
	   mov  word ptr drh_bufaddr[0],dx
	   mov  word ptr drh_bufaddr[2],ds
	   mov  drh_count,cx
	   mov  bx,OFFSET drh_len
	   push ds
	   pop  es
	   call strategy
	   call interrupt
	   ret


resseg     DW ? ; segment of resident part
_unload    DW 0 ; request for unload

ilogo DB 13,10,"REDVIEW 3.0 - Copyright (C) 1988-92 by Alexandr NOVY.",13,10
l_ilogo EQU $ - ilogo
resins DB "Resident part installed.",13,10
l_resins EQU $ - resins
noins DB "Cannot be installed.",13,10
l_noins EQU $ - noins
noloaded DB "Cannot uninstall, REDVIEW is not installed!",13,10
l_noloaded EQU $ - noloaded
nounloadr DB "REDVIEW uninstall failed, cannot release program memory!",13,10
l_nounloadr EQU $ - nounloadr
nounloadv DB "REDVIEW uninstall failed, vector(s) in use by another program!",13,10
l_nounloadv EQU $ - nounloadv
unloaded DB "REDVIEW uninstalled!",13,10
l_unloaded EQU $ - unloaded
onstate DB "REDVIEW is enabled.",13,10
l_onstate EQU $ - onstate
offstate DB "REDVIEW is disabled.",13,10
l_offstate EQU $ - offstate

_TEXT       ENDS
	    END   $start
