	TITLE	'TEE - tee junction for DOS pipes'
;From Dr Dobbs Journal, Apr 85
;Author:  A. K. Head, 6 Duffryn Place, Melbourne Australia 3142
;	reformatted and error handling added by Ray Duncan
;
; TEE reads from the standard input (redirectable) and
; outputs to both the standard output (redirectable)
; and a file, e.g.:  DIR | TEE C:\MYDIR\FILE.EXT | SORT
; [Toad Hall Note:  The above example does NOT work (is not sorted).]

; The file can be CON, LPT1, etc.  If it is CON, then
; keyboard Control-S pauses the display as usual.
;
;(Excerpt from the 16-Bit Software Toolbox column by Ray Duncan,
; same issue)
;

;TEE	- A standard filter in Unix systems, is used in a pipe to make
;	two copies of the standard input, directing one to a file and
;	the other to the standard output (which might also be redirected
;	into a file).  Where you normally would use a filename, here you
;	can use any logical device such as PRN: or CON:.  For example,
;	you could enter the command:
;	DIR |SORT|TEE C:SORTED.DIR
; [Toad Hall Note:  The above example DOES work.]

;	This would direct the output of the directory command to the SORT
;	filter and thence to TEE, which would send one copy of the sorted
;	listing to the disk file C:SORTED.DIR and the other copy to the
;	standard output (console, in this case).  This version of TEE
;	doesn't support the Unix switches -i (ignore interrupts) or -a
;	(append to previous contents of a file).
;
;
;v1.1
; - Toad Hall Tweak
; - Typed in from Dr Dobbs listing
; - Slightly tweaked
; David Kirschbaum
; Toad Hall
; kirsch@braggvax.ARPA


COMMAND	equ	80H		;buffer for command tail
BUFLEN	equ	16384		;buffer length, alter to taste

CR	equ	0DH		;ASCII carriage return
LF	equ	0AH		;ASCII line feed
;FF	equ	0CH		;ASCII form feed
EOF	equ	01AH		;End-of-file marker
;TAB	equ	09H		;ASCII tab code
BLANK	equ	20H		;ASCII blank

				;DOS 2.x pre-defined handles
STDIN	equ	0000		; standard input file
;STDOUT	equ	0001		; standard output file
STDERR	equ	0002		; standard error file
;STDAUX	equ	0003		; standard auxiliary file
;STDPRN	equ	0004		; standard printer file

Cseg	SEGMENT PARA PUBLIC 'Code'

	ASSUME	CS:Cseg, DS:Cseg

	org	100H

Tee	proc	near		;TH was FAR, but no reason for that

	xor	ax,ax			;TH clear msb
	mov	si,COMMAND		;TH address of command string
	cld				;TH insure fwd
	lodsb				;TH snarf length of cmd tail, bump SI
	mov	cx,ax			;TH length in CX for counter
	mov	di,si			;TH point DI to command string+1
	mov	dx,si			;TH DX needs COMMAND+1 later

Tee1:					;squeeze out leading spaces
	lodsb				;TH snarf cmd line char
	cmp	al,BLANK		;a space or less?
	jbe	Tee2			;yep, skip it
	 stosb				;TH stuff in command buffer, bump DI
Tee2:
	loop	Tee1			;go until it's exhausted

;TH cx is already 0 from the Tee1 loop
	mov	[di],ah			;make ASCIIZ string

	mov	ah,3CH			;create output file
;	xor	cx,cx			;TH attribute=0
;	mov	dx,COMMAND+1		;command string
	int	21H
	jb	Tee6			;can't create file

	mov	handle,ax		;save token for file

Tee3:	mov	ah,3FH			;read standard input
;	mov	bx,STDIN
	xor	bx,bx			;TH 0 = STDIN
	mov	cx,BUFLEN
	mov	dx,offset buffer	;TH was LEA
	int	21H
	jb	Tee4			;read error

	mov	nchar,ax		;save length of read
	or	ax,ax			;anything read in?
	jz	Tee4			;nope, end of file, exit

	mov	cx,ax			;TH nr chars read = nr to write
	mov	ah,40H			;write to file
	mov	bx,handle
;	mov	cx,nchar
	int	21H
	jb	Tee7			;write error

;	cmp	ax,nchar		;did we write all we read?
	cmp	ax,cx			;TH did we write all we read?
	je	Tee3			;TH yep, read again until EOF
;Bug report says this count may be short 1 if DOS hit a Ctrl Z EOF
;in a file.  Let's check...
	mov	si,offset buffer	;point to buffer
	add	si,ax			;short char count = buffer ptr
	cmp	byte ptr [si],EOF	;Is that char the EOF?
	jne	Tee7			;nope, some other write error
					;else just close up w/o error

Tee4:	mov	ah,3EH			;close output file
	mov	bx,handle
	int	21H

Tee5:	mov	ax,4C00H		;terminate, ERRORLEVEL 0
	int	21H

Tee6:	mov	dx,offset err1		;'Can't create file'
	mov	cx,ERR1LEN		;length of err msg
	mov	ah,40H			;display error msg & exit
	mov	bx,STDERR
	int	21H
	mov	ax,4C01H		;terminate, ERRORLEVEL 1
	int	21H

Tee7:	mov	dx,offset err2		;'Disk is full'
	mov	cx,ERR2LEN		;length of error msg
	mov	ah,40H			;display error msg & exit
	mov	bx,STDERR
	int	21H
	mov	ah,3EH			;close output file
	mov	bx,handle
	int	21H
	mov	ax,4C02H		;terminate, ERRORLEVEL 2
	int	21H

Tee	endp

nchar	dw	0			;nr of chars actually input
handle	dw	0			;token for output file

err1	db	CR,LF,'Tee: Cannot create file',CR,LF
ERR1LEN	equ	$-offset err1

err2	db	CR,LF,'Tee: Disk is full.',CR,LF
ERR2LEN	equ	$-offset err2

buffer	equ	$		;data is read here from standard input

Cseg	ends
	end	Tee
