/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* real.h  -  header file for emulated real functions */

#ifndef REAL_HEADER
#define REAL_HEADER  1

#include <howard.h>

#define MAXRPRECISION   8               /* maximum real precision (decimal places) */

typedef enum {
    RDOMAIN = 1,    /* argument domain -- log (-1)          */
    RSING,          /* argument singularity -- pow (0,-2)   */
    ROVERFLOW,      /* overflow range error  -- rint > LONG_MAX     */
    RUNDERFLOW,     /* underflow range error  -- rint < LONG_MIN    */
    RTLOSS,         /* total loss of significance -- */
    RPLOSS,         /* partial loss of significance -- */
    RFRACOVER,      /* fraction overflow range error -- rfrac > LONG_MAX    */
    RFRACUNDER,     /* fraction underflow range error -- rfrac < LONG_MIN   */
    RDIVBYZERO,     /* divide by zero -- 1/0 */
}   _rmexcep;

typedef struct REAL {
            long rint;              /* real - integer */
            long rfrac;             /* real - fraction */
            int precision;          /* precision of fraction (# of decimal places) */
        };

/* Global variables (for reference only) *//*
int _r_minpre, _r_maxpre;
boolean _r_maximum = FALSE;                 /* should rnormalize() try to minimize or maximize the precision */*/

/* function prototypes */
struct REAL rdiv(long int numer, long int denom, int precision);    /* real division without FP emulator library */
struct REAL radd(struct REAL val, struct REAL sval, int precision); /* real addition without FP emulator library */
struct REAL rsub(struct REAL val, struct REAL sval, int precision); /* real subtraction without FP emulator library */
void rnormalize(struct REAL *r1, struct REAL *r2);  /* normalize emulated fp values (fix the decimal places) */
long lpow(long base, int exponent);         /* raise a base to an exponent */
long rceil(struct REAL rx);                 /* rounds up */
long rfloor(struct REAL rx);                /* rounds down */
int rsign(struct REAL rx);                  /* return sign */
struct REAL *rnegate(struct REAL *rx);      /* change sign */

#endif              /* REAL_HEADER */
