/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* stringhk.h  -  Howard Kapustein's string header file */

#ifndef STRINGHK_HEADER
#define STRINGHK_HEADER 1

#include <howard.h>

#define endstri(s)      (strlen(s)-1)      /* end of string, integer */
#define endstrp(s)      (s+endstri(s))     /* end of string, pointer */

/* function prototypes */
int intlen(char *number);       /* find length of integer part of string */
char *strcomma(char *source);   /* convert a string to xx,xxx,xxx format */
char *strtodol(char *source);   /* convert string to $ format */
char *ltrim(char *source);             /* trim blanks on left */
char *rtrim(char *source);             /* trim blanks on right */
char *atrim(char *source);             /* trim blanks on left & right */
char *strins(char *source, char *new, char *ptr);      /* string insert */
char *strdel(char *source, char *old); /* string delete */
char *strrep(char c, int len);         /* replicate c len times */
char *strfill(char *str, char c, int count);    /* fill string str with c count times */
char *leftstr(char *source, int len);  /* LEFT$(SOURCE$,len) */
char *rightstr(char *source, int len); /* RIGHT$(SOURCE$,len) */
char *midstr(char *source, int begin, int len);  /* MID$(SOURCE$,begin,len) */
char *strshleft(char *source, int count);    /* shift string left count chars */
char *strshright(char *source, int count);   /* shift string right count chars */
char *strclean(char *str);             /* remove non-printable ASCII codes */
char *strcapital(char *str);           /* capitalize first letter of each word */
int stroccur(char *str, char *substr); /* # occurences of substring in string */
int strwcmp(char *wstr, char *str);    /* compare wildcard w/string (*,?) */
int strwicmp(char *wstr, char *str);   /* compare wildcard w/string (*,?), ignore case */
char *strtocomma(char *source);   /* convert a string to xx,xxx,xxx format */
char *strtabexpand(char *source, char *dest, int tablen);   /* expand TABs to tablen SPACEs */
char *strspace2tab(char *source, char *dest, int tablen);   /* compress tablen SPACEs to TABs */
boolean iswildcarded(char *str);        /* does str have wildcards in it */
boolean isallalpha(char *str);          /* are all chars in string alphabetic */
boolean isallalphanum(char *str);       /* are all chars in string alphanumeric */
boolean isallupper(char *str);          /* are all chars in string upper case */
boolean isalllower(char *str);          /* are all chars in string lower case */
char *strpadleft(char *str, char c, int len);   /* pad the left of str of c len times */
char *strpadright(char *str, char c, int len);  /* pad the right of str of c len times */
char *soundex(char *str, char *soundexstr);     /* Soundex code */
char *strsetsz(char **str, int len);    /* adjust length of string by truncating/padding */

#endif              /* STRINGHK_HEADER */
