{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Misc/Classes.pas                 [x] Protected mode

  Demonstration of class relation checks using the Classes instance
  of tClassManager in EFKERNEL.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFDEF, EFKERNEL, EFADT, EFLIST, EFARRAY, EFDATA, EFMATH,
     EFBASIC, EFSTRING, EFSTREAM, EFFILTER, EFSORT, EFELEM;

var A : tObject;
    B : tStream;
    C : tStandardStream;

begin
     { Display the class hierarchy in the
       used library extentions (EFKERNEL).
       The hierarchy is physically stored
       as a tree structure. }

     WriteLn;
     { Display descendants to tMathObject only }
     Classes^.Search ( 0, 'tMathObject', NIL, NIL)^.StreamWrite ( StdIO );
     WriteLn;

     A.Initialize; B.Initialize; C.Initialize;

     { If A has the same type as B,
       they are instances from the same class. }

     if A.IsEqualType (@B) then
        WriteLn ('A and B have the same class.');

     { A class type (VMT address) is also valid
       for some relational operations (but notice that
       TypeOf(tObject) not is equal to @B): you can pass
       both TypeOf and @B to EFLIBs relational methods. }

     if A.IsEqualType ( TypeOf (tObject) ) then
        WriteLn ('A is a tObject.');

     if C.IsParent ( @A ) then
        WriteLn ('A is (any) parent to C.');

     { A class (A) can descend directly
       or indirectly from another class (B).
       If A descend directly from B, B is the immediate
       parent to A.

       In other words: IsDescendant returns TRUE
       only if the specified class is a immediate
       subclass, but IsDerived returns TRUE if
       the specified class is any subclass. }

     if A.IsDescendant ( @B ) then
        WriteLn ('B descend directly from A - B is an immediate subclass.');

     if not A.IsDescendant ( @C ) then
        WriteLn ('But C is not a direct descendant of A!');

     if A.IsDerived ( @C ) then
        WriteLn ('C descend from A - C is an arbitrary subclass.');

     A.Intercept; B.Intercept; C.Intercept;
end.