{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Advcast.pas              [x] Protected mode

  Advanced type-casting mechanism for strings. This program uses
  a stack that it registers as a new "kernel" instance. This stack
  stores buffer tString instances, and makes type-casting very simple.
  You should call the Clear procedure immedidately after the caster
  has been used.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFKERNEL, EFSTREAM, EFDATA, EFSTRING;


const Converted : pStack = NIL;

{ Conert a Pascal string to a EFLIB string and create
  an instance that this procedure owns (and are responsible
  to intercept). }
function P2S (A : string) : pString;
var Casted : pString;
begin
     Casted := New (pString, Initialize (A));
     Converted^.Push (Casted);
     P2S := Casted;
end;

{ Removes some type-cast buffer instances from the cast stack. }
procedure Clear (PopCount : word);
var Index : word;
begin
     while (PopCount > 0) and not Converted^.IsEmpty do begin
           Converted^.Skip; Dec (PopCount);
     end;
end;


var A : pString;
begin
     { Create a conversion buffer (stack) and register
       it for interception when the program terminates. }
     New (Converted, Initialize (SizeOf(pString)));
     Interceptor^.Register (Converted);

     A := P2S('Implemented a type-cast mechanism!');
     A^.Replace (P2S (' a '), P2S (' a sophisticated ' ));
     A^.LineFeed;

     A^.StreamWrite (StdIO);

     Clear (3); { Clear type-cast buffer to release
                  temporary memory. }
end.