(*****************************************************************************

  Program:  Table demonstration.

  Purpose:
    This unit demonstrates the ability of the table unit.

  Features:
    Shows how the table unit can solve a table to optimal conditions.
    Example...
      Assuming the table consists of persons and the amount of time
      { or cost } it takes for that person to complete a particular job,
      this unit will find the optimal assignment conditions to complete the
      jobs in the least amount of time.  { or cost }

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Table_Demo( Input, Output, Infile );

  Uses
    Tables;

  Var
    Table: Table_Type;
    Solutions: Solution_List_Type;
    InFile: Text;

  Begin
    WriteLn( 'Table unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the ability of the Table unit.  It reads' );
    WriteLn( 'in a table from a file called Table.Dat and attempts to solve it finding' );
    WriteLn( 'all the best possible solutions.  The results are displayed quickly, so' );
    WriteLn( 'watch out for them.' );
    WriteLn;
    WriteLn( 'Please press [enter] to continue.' );
    ReadLn;

   {$IFNDEF OS2}
    Assign( InFile, 'Table.Dat' );
   {$ELSE}
    Assign( Infile, 'D:\Desktop\Programm\Pascal\Table.Dat' );
   {$ENDIF}
    Reset( InFile );
    Read_Table( InFile, Table );
    Close( InFile );

    Print_Table( OutPut, Table );

    Minimize_Solve_Multiple( Table, Solutions );
    Print_Solutions( OutPut, Solutions );

  End.

