;---------------------------------------------------------------------------
; Program:  ClrScr.Inc
;
; Author:   Steve Poulsen
;
; This procedure will Clr the screen at a window entered in CX and DX with 
; CL = X1, CH = Y1, DL = X2, DH = Y2. SI should point to the attribute to use.
;
; Before:
;       CX = Upper Left
;       DX = Lower Right
;       SI = Pointer to attribute
; After:
;       Nothing
; Changes:
;       Nothing
;
;---------------------------------------------------------------------------
ClrScr  Proc    Near
        Assume CS:Code,DS:Nothing,ES:Nothing
        Push AX
        Push DI
        Push ES
        Push BX
        Push CX
        
        Mov AX,0B800h                   ; Screen memory segment for color
        Mov ES,AX
        
        
        Mov AH,0Fh                      ; Check video mode
        Int 10h
        Cmp AL,07h                      ; Monochrome?
        JNE Clra
        Mov AX,0B000h                   ; Screen memory segment for mono
        Mov ES,AX
Clra:        
        Mov BL,CL                       ; Clear a line at CH
        Mov BH,0
        
        Mov AL,160                      ; Convert to linear
        Mul CH
        Mov DI,AX                       
        Add DI,BX
        Add DI,BX                       ; Put location in DI
Ca:        
        Push DX
        Mov DH,CS:[SI]                  ; Mov Color into DH
        Mov DL,20h                      ; Mov space into DL
        Mov ES:[DI],DX                  ; Put at current location
        Pop DX
        Cmp BL,DL                       ; Compute current location with X2
        JE Na                           ; Jump if done with line
        Inc DI                          ; Move to next X location
        Inc DI
        Inc BL
        Jmp Ca                          ; Repeat for this location
Na:                                      
        Inc DI                          ; Mov to next position
        Inc DI
        Inc CH                          ; Increment Y position
        Cmp CH,DH                       ; Compare Y with Y2
        JLE Clra                        ; Jmp to clear another line
        
        Pop CX
        Pop BX
        Pop ES
        Pop DI
        Pop AX
        Ret
ClrScr EndP

