/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_otstream
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TTerminal
#include "tvtools.h"

#include <alloc.h>
#include <stdarg.h>
#include <stdio.h>



class MyTerminal: public TTerminal
{
 public:

   MyTerminal( const TRect& r, TScrollBar *hs, TScrollBar *vs, ushort bufSize )
             : TTerminal( r, hs, vs, bufSize )
   {
    // Assign the TTerminal text device driver to a text "file"
    os = new otstream( this );
   }

   ~MyTerminal()
   {
    delete os;
   }

   void clearBuf( void )
   {
    queFront = queBack = 0;
    *buffer = EOS;
    setLimit( 0, 1 );
    setCursor( 0, 0 );
    showCursor();
   }

   void setText( const char *msg )
   {
    clearBuf();
    appendText( msg );
   }

   void appendText( const char *s );


 private:

   otstream *os;
};



void MyTerminal::appendText( const char *msg )
{
 Boolean center;
 int lineOrg, wordOrg, p;
 char buffer[256];

 if ( ! *msg )
    return;

 center = False;

 for ( p = 0; msg[p]; )
    {
     if ( msg[p] == 3 )
        {
         center = True;
         p++;
        }

     lineOrg = p;
     // Search for last whole word of line
     do {
         wordOrg = p;

         // skip leading blanks
         while ( msg[p] == ' ' ) p++;

         // skip non-blanks
         while ( msg[p] && (msg[p] != ' ') && (msg[p] != '\n') ) p++;
        }
     while ( msg[p] && (msg[p] != '\n') && (p < (lineOrg + size.x)) );

     if ( p > lineOrg + size.x )
        if ( wordOrg > lineOrg )
           p = wordOrg;
        else
           p = lineOrg + size.x;

     if ( center )
        wordOrg = (size.x - p + lineOrg) / 2 ;
     else
        wordOrg = 0;

     memset( buffer, ' ', wordOrg );
     strncpy( buffer + wordOrg, &msg[lineOrg], p - lineOrg );
     buffer[wordOrg + p - lineOrg] = EOS;

     *os << endl << buffer;

     // skip trailing blanks
     while ( msg[p] == ' ' ) p++;

     if ( msg[p] == '\n' )
        {
         center = False;
         p++;
         if ( msg[p] == '\r' )
            p++;
        }
    }
}

class TMsgDlg: public TDialog
{
 public:

   TMsgDlg( const char *msg );

   MyTerminal *tty;
};



TMsgDlg::TMsgDlg( const char *msg )
        : TDialog( TRect(0, 0, 41, 9), "Please Wait" ),
          TWindowInit( initFrame )
{
 flags &= ~wfClose;
 options |= ofCentered;

 TScrollBar *sb = new TScrollBar( TRect(0,0,0,0) );
 sb->state |= sfDisabled;
 sb->state &= ~sfVisible;
 insert( sb );

 TRect rect( 3 , 1 , size.x-2, size.y-1 );
 tty = new MyTerminal( rect, 0, sb,
                      (rect.b.x - rect.a.x) * (rect.b.y - rect.a.y)
                    );
 insert( tty );

 tty->appendText( msg );
}




static TMsgDlg *TheStatusBox = 0;

Boolean existStatusBox()
{
 return (Boolean) (TheStatusBox != 0);
}



void RemoveStatusBox()
{
 if ( TheStatusBox )
    {
     TObject::destroy(TheStatusBox) ;
     TheStatusBox = 0;
    }
}



void StatusBox( const char *msg )
{
 if ( TheStatusBox )
    TheStatusBox->tty->setText( msg );
 else
    {
     TheStatusBox = new TMsgDlg( msg );
     TProgram::application->insert( TheStatusBox );
    }
}


void StatusBoxf( const char *fmt, ... )
{
 char buffer[256];

 vsprintf( buffer , fmt , ... );
 StatusBox( buffer );
}


void appendStatusBox( const char *msg )
{
 if ( ! TheStatusBox )
    StatusBox( msg );
 else
    TheStatusBox->tty->appendText( msg );
}


void appendStatusBoxf( const char *fmt, ... )
{
 char buffer[256];

 vsprintf( buffer , fmt , ... );
 appendStatusBox( buffer );
}
