/*---------------------------------------------------------*/
/*                                                         */
/*   Turbo Vision 1.0                                      */
/*   TVGUID05 Demo Source File                             */
/*   Copyright (c) 1991 by Borland International           */
/*                                                         */
/*---------------------------------------------------------*/

#define Uses_fpstream
#define Uses_MsgBox

#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TEvent
#define Uses_TEventQueue
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStatusDef
#define Uses_TSubMenu
#define Uses_TView
#define Uses_TWindow
#include <tv.h>

#include "toycfg.h"
#include "modedlg.h"
#include "video.h"

#include <help.h>
#include "helpctx.h"

const int cmVideoMode     = 200;
const int cmPreviousTopic = 201;
const int cmUsingHelp     = 202;
const int cmContents      = 203;



class TDemoApp : public TApplication
{

public:
    const char *helpFileName;

    TDemoApp();
    static TStatusLine *initStatusLine(TRect r);
    static TMenuBar *initMenuBar(TRect r);
    virtual void getEvent(TEvent &event);
    virtual TPalette& getPalette() const;
    virtual void handleEvent(TEvent& event);
    void showHelp(int aHelpCtx);
    void videoMode();
};

/*******************************************************
class TToyApp : virtual public TApplication
{

public:
    const char *helpFileName;

    virtual void getEvent(TEvent &event);
    virtual TPalette& getPalette() const;
    void showHelp(int aHelpCtx);
};

class TDemoApp : public TToyApp
{

public:
    TDemoApp();
    static TStatusLine *initStatusLine(TRect r);
    static TMenuBar *initMenuBar(TRect r);
    virtual void handleEvent(TEvent& event);
    void videoMode();
};

********************************************************/

#define TToyApp TDemoApp

//
//  Init application
//

TDemoApp::TDemoApp() :
    TProgInit(TDemoApp::initStatusLine,
              TDemoApp::initMenuBar,
	      TDemoApp::initDeskTop
	    )
{
  helpFileName = "helptest.hlp";
  showHelp(hcIntro);
}


//
//  Event loop to check for context help request
//

void TToyApp::getEvent(TEvent &event)
{
  TApplication::getEvent(event);

  if (event.what==evCommand)
  {
    switch (event.message.command)
    {
      case cmHelp:          showHelp(getHelpCtx()); break;
      case cmContents:      showHelp(hcContents); break;
      case cmPreviousTopic: showHelp(previousTopic); break;
      default:
          return;
    }
    clearEvent(event);
  }
}


//
//  Return application's palette, with help colors added
//

TPalette& TToyApp::getPalette() const
{
    static TPalette newcolor (cpColor cHelpColor, sizeof(cpColor cHelpColor)-1);
    static TPalette newblackwhite(cpBlackWhite cHelpBlackWhite, sizeof(cpBlackWhite cHelpBlackWhite)-1);
    static TPalette newmonochrome(cpMonochrome cHelpMonochrome, sizeof(cpMonochrome cHelpMonochrome)-1);
    static TPalette *palettes[] =
        {
        &newcolor,
        &newblackwhite,
        &newmonochrome
        };
    return *(palettes[appPalette]);
}

//
//  Handle events
//

void TDemoApp::handleEvent(TEvent& event)
{
    TApplication::handleEvent(event);
    if(event.what == evCommand)
	{
	switch(event.message.command)
	    {
            case cmUsingHelp:
                showHelp(hcUsingHelp);
                break;
	    case cmVideoMode:
		videoMode();
		break;
	    default:
		return;
	    }
	clearEvent(event);
	}
}


//
//  Create menu bar
//

TMenuBar *TDemoApp::initMenuBar(TRect r)
{

    r.b.y = r.a.y + 1;
    return new TMenuBar(r,
	*new TSubMenu("~V~ideo", kbAltV)+
	    *new TMenuItem("~V~ideo mode...", cmVideoMode, kbNoKey, hcNoContext, "")+
	*new TSubMenu("~H~elp", kbAltH)+
	    *new TMenuItem("~C~ontents", cmContents, kbNoKey, hcNoContext, "")+
	    *new TMenuItem("~P~revious topic", cmPreviousTopic, kbNoKey, hcNoContext, "")+
	    *new TMenuItem("~U~sing help", cmUsingHelp, kbNoKey, hcNoContext, "")
	);
}


//
//  Create statusline
//

TStatusLine *TDemoApp::initStatusLine(TRect r)
{
    r.a.y = r.b.y - 1;
    return new TStatusLine(r,
	*new TStatusDef(hcHelpOnHelp, hcHelpOnHelp)+
            *new TStatusItem("~F1~ Help on Help", kbF1, cmHelp)+
            *new TStatusItem("~Alt-B~ Back", kbAltB, cmPreviousTopic)+
            *new TStatusItem("~Alt-C~ Contents", kbAltC, cmContents)+
            *new TStatusItem("", kbF5, cmZoom)+
            *new TStatusItem("", kbCtrlF5, cmResize)+
	*new TStatusDef(0, 0xFFFF)+
	    *new TStatusItem(0, kbF10, cmMenu)+
            *new TStatusItem("~F1~ Help", kbF1, cmHelp)+
	    *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit)
	);
}


//
//  Show help window
//

void TToyApp::showHelp(int aHelpCtx)
{
  TWindow   *w;
  THelpFile *hFile;
  fpstream  *helpStrm;
  static Boolean helpInUse = False;

  if (helpInUse == True)
    message(this, evCommand, cmSwitchToTopic, (void*)aHelpCtx);
  else
  {
    helpInUse = True;

    helpStrm = new fpstream(helpFileName, ios::in|ios::binary);
    hFile = new THelpFile(*helpStrm);
    if (!helpStrm)
    {
      messageBox("Could not open help file", mfError | mfOKButton);
      delete hFile;
    }
    else
    {
      w = new THelpWindow(hFile, aHelpCtx);
      w->helpCtx = hcHelpOnHelp;
      if (validView(w) != 0)
      {
        execView(w);
        destroy(w);
      }
    }
    helpInUse = False;
  }
}


//
//  Determine video modes and show them in a dialog
//

void TDemoApp::videoMode()
{
    if (messageBox("Have to do some tests, there is no guarantee that it works",
                   mfInformation | mfOKButton | mfCancelButton) == cmOK)
    {
      TVideoList::setup();
      selectVideoModeDialog();
    }
}


//
//  Start the whole thing
//

int main()
{
    checkVideoType();

    TDemoApp demoApp;
    demoApp.run();
    return 0;
}
