#define Uses_TCommandSet

#if !defined( __VIDEO_H)
#define __VIDEO_H

#include <tv.h>
#include "toycfg.h"

typedef void (*AddModeProc)(ushort mode, ushort rows, ushort columns,
                   ushort charHeight, Boolean color);

/*******************************************************************
  Video BIOS stuff
*******************************************************************/
const int    crtWidth   = 0x4A; /* byte */
const int    crtSize    = 0x4C; /* word */
const int    addr6845   = 0x63; /* word */
const int    crtRows    = 0x84; /* byte EGA/VGA */
const int    crtPoints  = 0x85; /* byte EGA/VGA */
const int    crtInfo    = 0x87; /* byte EGA/VGA */

/* Use with UseInternalFont */
const int    internal8x8Font  = 0x12;
const int    internal8x14Font = 0x11;
const int    internal8x16Font = 0x14;


/*******************************************************************
  Video mode detection stuff
*******************************************************************/
typedef enum {OTHER, EGA, VGA} VideoTypes;
typedef enum {vtVesa=1, vtVideo7} SpecialVideoTypes;

/* This value can be used to rule out Vesa and V7 tests run-time */
extern SpecialVideoTypes videoTypesToCheck;

/* Detected video type */
extern VideoTypes videoType;


#ifdef TOYVIDEO7SUPPORT
 extern Boolean video7;

 const int
   V7Installed = 1,
   HPInstalled = 2;
#endif

#ifdef TOYVESASUPPORT
 extern ushort dontClearVideoModeFlag;
#else
 const dontClearVideoModeFlag = 0x80;
#endif


typedef class TCommandSet ModeSet;

extern ModeSet standardTextModes;
extern ModeSet vgaModes;
extern ModeSet vesaModes;


/*******************************************************************
  Video state object
*******************************************************************/
class VideoState {
  ushort mode;
  uchar lines;
  uchar charHeight;
  void save();
  void restore();
};


void setSpecialVideoMode(ushort mode);
ushort getSpecialVideoMode();

#ifdef TOYVESASUPPORT
 void checkVesa();
#endif
#ifdef TOYVIDEO7SUPPORT
 void checkVideo7();
#endif

void checkEVGA();
void checkVideoType();

int getCurrentScanLines();
void useInternalFont(uchar font);
void loadUserFont(uchar points, int first, int count, void *font);
Boolean isProbablyTextMode();
Boolean isColorMode();

void scanEVGAModes(ushort modeOffset, ModeSet modesToCheck,
                   AddModeProc addMode);

#endif
