:: RUNNING TIME (dedicated environment on 486DX2/50 VLB):  5 hours 35 minutes
::              (time includes making sorted cross file duplicate trash files)
:: PCBFiler:      29 minutes (two sorts, first on name ascending at the start,
::                            then back to date descending at the finish)
:: FIXDIR.BAT:    11 minutes (first method, includes two DIR merges on itself)
:: CROSSDUP.BAT:  3 hours 40 minutes (sorted trash file STRIPCRS.BAT method)
:: MASTER.BAT     1 hour 15 minutes

:: This batch file is completed, but it is a control batch file and the batch
:: files it calls need to be finished and separated (they are shown first).  It
:: combines the DIRs and CD-ROMs, either through merging or copying, does the
:: job of DIRDUPE.BAT, and depending on how the called STRIPCRS.BAT is written,
:: performs the same as either CRSDUPE2.BAT or CRSDUPE3.BAT.  If you are in a
:: hurry, you can skip reading the other files (I still highly recommend going
:: over the beginning of DIRDUPE.BAT) and just use this one, since it basically
:: summarizes and updates what's in the others.  However, they do give you more
:: details on operation and explanations of why something is done a particular
:: way, and CRSDUPE1.BAT is a completely different animal.

:: These commands are written for MERGESYS; for MERGEPRO, add /s to each line.
:: If no field options are shown, also add /f1.

:: Please note:  my apologies to anyone who tried to use this batch file and
:: found it didn't work right when testing for "errorlevels".  It was written
:: using the NDOS (the same as 4DOS) command processor, and I discovered later
:: that COMMAND.COM doesn't respond the same when testing the errorlevel.  I
:: have changed the errorlevel tests, and it should now work with COMMAND.COM.


::
:: FIXDIR.BAT
:: This can vary a lot depending on what it will do (the last four lines in all
:: three examples are identical).  If you are appending just one CD-ROM, the
:: method below is fine (same as shown in BATNOTES).  Change or remove /b1??h
:: as necessary; if you don't have a heading or strip it in line 1, remove all
:: the /b's from lines 2 and 4.  If nothing goes wrong on line 4, there won't
:: be any log since "+n" is used.  If there is an error of some kind, e.g., a
:: file isn't found, the log will only contain the error message.  The similar
:: method shown in DIRDUPE.BAT needed to delete the temporary trash file each
:: time, since MERGE did not delete an input file that is also the output file
:: if its size would be zero for safety reasons, but the new "E" parameter for
:: "compares" now does it if no records are written and the exit code is zero.
:: You actually don't need the "if not exist ..." because MERGE just quits if
:: it can't find a file, but then DIR_TEMP.LOG will exist with "file not found"
:: errors for all the DIRs that don't have any duplicates.

:: MERGE /o /b1??h /k /ef /ea /f1 /f3ddt /td:\temp\%1.err+n /ld:\temp\direrror.log /vl d:\pcb\dirc\%1
:: MERGE /o /b1??h /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\%1
:: if not exist d:\temp\temp.dup goto END
:: MERGE /o /b1?? /b21 /1te /td:\temp\%1.dup+n /ld:\temp\dir_temp.log+n d:\pcb\dirc\%1 d:\temp\temp.dup
:: :END

:: If you are appending more than one CD-ROM, use a sort loop, but you should
:: also make sure there won't be any alphabetic dates.  Even without something
:: like alphabetic dates, the sort loop may run a long time because it can loop
:: up to one less than the total number of added CD-ROMs (depending on how many
:: duplicates there are and the order of their dates).  If all DIRs, including
:: the CD-ROM's, have had their errors corrected, you can delete line 7 (but it
:: may be a good idea to keep line 7 just in case; it doesn't run unless there
:: are errors).  What is shown below needs to be adjusted for the DIR headings.
:: If they are in place and you want to keep them, remove the first two lines
:: and the sixth line, and only change the /b's for the starting line numbers.
:: If the DIRs don't have headings, remove the same lines and all the /b's.  If
:: they have headings and you want to strip them, keep the first two and sixth
:: lines but remove the /b's from the rest of the lines.

:: MERGE /o /b1?? /k /ef /f1 /f3ddt /ld:\temp\sort.log d:\pcb\dirc\%1
:: if errorlevel 3 goto END
:: if not errorlevel 2 goto NOSORT
:: :SORT
:: MERGE /o /b1??h /k /ef /f1 /f3ddt /ld:\temp\sort.log d:\pcb\dirc\%1
:: if errorlevel 3 goto END
:: if errorlevel 2 goto SORT
:: :NOSORT
:: if errorlevel 1 MERGE /o /b1??h /k /ea /f1 /f3ddt /td:\temp\%1.err+n /ld:\temp\direrror.log /vl d:\pcb\dirc\%1
:: MERGE /o /b1??h /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\%1
:: if not exist d:\temp\temp.dup goto END
:: MERGE /o /b1?? /b21 /1te /td:\temp\%1.dup+n /ld:\temp\dir_temp.log+n d:\pcb\dirc\%1 d:\temp\temp.dup
:: :END

:: If you are merging one CD-ROM with the bbs DIRs, you can use the arrangement
:: below.  It would also be called for the last merge if merging more than one
:: CD-ROM (see DIRDUPE.BAT and the end of TRICKS for more information).  /b2??h
:: in the first line is for the bbs DIR heading (this assumes there is one and
:: you're keeping it; adjust the /b's as described above where needed).  If the
:: CD-ROM DIRs also have a heading and you're only merging one, set /b1?? for
:: it.  However, if more than one is merged, it might be better to pass a third
:: replaceable parameter with the CD-ROM's "begin on line" (the first parameter
:: is just the bbs DIR name, and the second is the CD-ROM DIR name and path).
:: If you are merging CD-ROMs, you also don't need a "sort" loop or /ef since
:: dates are merged in sequence (assuming the bbs DIRs were "merged" sometime
:: before and have no dupes within a DIR, and the CD-ROM's have none either).

:: MERGE /o /b1?? /b2??h /k /ea /f1 /f3ddt /td:\temp\%1.err+n /ld:\temp\direrror.log /vl %2 d:\pcb\dirc\%1
:: MERGE /o /b1??h /td:\temp\temp.dup+n /ld:\temp\dir_dupe.log /vl1 d:\pcb\dirc\%1
:: if not exist d:\temp\temp.dup goto END
:: MERGE /o /b1?? /b21 /1te /td:\temp\%1.dup+n /ld:\temp\dir_temp.log+n d:\pcb\dirc\%1 d:\temp\temp.dup
:: :END

:: There are several ways you can merge more than one CD-ROM.  You could call a
:: separate CD-ROM.BAT that merges all the CD-ROMs with the respective bbs DIRs
:: from either COMBINE.BAT or as a replacement for the first line in FIXDIR.BAT
:: above.  You could also just add the needed lines to the start of FIXDIR.BAT
:: or write a one line batch file and call it with the different file names.
:: However you do it, the "merge" line should be the same as the first line in
:: FIXDIR.BAT above.  Whenever the bbs DIR is merged on itself in the second
:: line, all dupes created by the CD-ROMs will end up in the DIR's trash file
:: and the one left in the DIR will be whatever has the latest date (if any had
:: the same dates, the one kept will be from the last CD-ROM that was merged).
:: However, if you're adding a BUNCH of CD-ROMs, the bbs DIR could get huge,
:: and it would take longer for each successive merge, so it might be faster to
:: merge the bbs DIR on itself after each new CD-ROM is added, in other words,
:: call the FIXDIR.BAT above for every new CD-ROM.  The only difference is the
:: dupes in the DIR's trash file wouldn't be sorted anymore (each new group is
:: appended to what is already there).  You could add one more line to merge in
:: the new set of stripped duplicates, but then there probably wouldn't be any
:: overall time savings (I think it would actually take longer).

:: As mentioned in BATNOTES, any names stripped for errors should not just be
:: merged back into the DIR when COMBINE.BAT is done because the DIRs will have
:: their own and any cross dupes removed whenever you look at these error trash
:: files, so before remerging, you should do a "compare" of each bbs DIR to the
:: repaired descriptions so you can see if some other DIR already has the same
:: description.  This can be done by merging all the repaired descriptions into
:: one file and writing a 61 line batch file to call another batch file just
:: like FIXDIR.BAT is called.  Assuming you named any fixed descriptions with
:: the same DIR name and .FIX as an extension, you could use the "for" command
:: in the same batch file to first merge them into DIRFIXED.ALL:

:: for %%f in (d:\temp\dir*.fix) do MERGE /o %%f d:\temp\dirfixed.all

:: The first time I tested these commands, I overlooked an out sequence record
:: in one of the fixed files, so you may also want to run MERGE on each of them
:: before the command above.  The called batch file should contain the line:

:: MERGE /o /b1??h /b21 /1te /td:\temp\%1.got+n d:\pcb\dirc\%1 d:\temp\dirfixed.all

:: Since Compare's "e" is used above, if all the fixed descriptions are also in
:: another DIR, DIRFIXED.ALL won't even exist when the compares are completed.
:: The trash file DIR??.GOT will only exist if a corresponding bbs DIR already
:: has the repaired description, and you can check it to determine which is the
:: best if you want.  If none exist, just merge the fixed descriptions into the
:: DIR they came from originally, otherwise you can also use the "for" command
:: to remove from the fixed descriptions any that another DIR has (see SUMMARY
:: AND MY RECOMMENDATIONS further below for an explanation of the /p switch):

:: for %%f in (d:\temp\dir*.fix) do MERGE /o /p /1ke d:\temp\dirfixed.all %%f

:: Now merge the remaining fixed descriptions back into their DIRs.  Since "e"
:: is used again above, you can even automate remerging in a 61 line batch file
:: that calls another containing the line shown below.  If all the descriptions
:: in DIR??.FIX are already somewhere else, it will be deleted (none will be in
:: DIRFIXED.ALL, so DIR??.FIX won't have any to keep when the compare is done).

:: if exist d:\temp\%1.fix MERGE /o /b2??h d:\temp\%1.fix d:\pcb\dirc\%1

:: All of these steps could be combined into one batch file.  You'd just need
:: to check that DIRFIXED.ALL existed before executing the "for" command above,
:: and if it doesn't, exit the batch file.  An example of what it might look
:: like is below (the first line is there to make sure all errors are fixed):

:: for %%f in (d:\temp\dir*.fix) do MERGE /o /ef /ea /p /td:\temp\error.fix /ld:\temp\fixerror.log+n /vl %%f
:: for %%f in (d:\temp\dir*.fix) do MERGE /o %%f d:\temp\dirfixed.all
:: call CHECKFIX.BAT dir1
:: call CHECKFIX.BAT dir2
:: call CHECKFIX.BAT dir3
:: ...
:: if not exist d:\temp\dirfixed.all goto END
:: for %%f in (d:\temp\dir*.fix) do MERGE /o /p /1ke d:\temp\dirfixed.all %%f
:: call MERGEFIX.BAT dir1
:: call MERGEFIX.BAT dir2
:: call MERGEFIX.BAT dir3
:: ...
:: :END

::
:: STRIPCRS.BAT
:: When "%2" is used for the stripped cross file duplicate trash file, its name
:: will correspond to the higher numbered DIR that had the dupes removed, the
:: same as that used in CRSDUPE3.BAT, which facilitates keeping duplicate names
:: because they are really different programs (see CRSDUPE3.BAT and TRICKS for
:: more information).  If %1 is used, the trash file name matches the lower
:: numbered DIR that did the stripping, as in CRSDUPE2.BAT, which can help to
:: replace a kept description with a better one that was stripped from a higher
:: numbered DIR.  Use either line 1 below by itself, or lines 2 - 6 together.
:: The first line is the fastest and produces unsorted trash files (all new
:: stripped dupes are appended).  The other lines create a trash file sorted by
:: name (the dates may not be in descending order since the description coming
:: first is the "marked" kept occurrence from the lower numbered DIR; there may
:: also be more than one pair of marked and stripped duplicates if "%1" is used
:: for the trash file since the same file name could be in more than one higher
:: numbered DIR).  If there are still DIR headings, add /b1?? /b2??h (it only
:: goes in line 1 for the second group; running time above is for group two).
:: These also use Compare's "e" parameter, although it's improbable that a bbs
:: DIR would have all of its descriptions stripped, but you never know.

:: MERGE /o /1te /td:\temp\%2.crs+n /ld:\temp\crossdup.log /vl1 d:\pcb\dirc\%1 d:\pcb\dirc\%2

:: MERGE /o /1te /td:\temp\temp.crs+n /ld:\temp\crossdup.log /vl1 d:\pcb\dirc\%1 d:\pcb\dirc\%2
:: if not exist d:\temp\temp.crs goto END
:: MERGE /o /k /ld:\temp\temp_crs.log+n d:\temp\temp.crs d:\temp\%2.crs
:: del d:\temp\temp.crs
:: :END

::
:: SWAPCRS.BAT
:: This batch file strips the description from a higher numbered DIR, but then
:: replaces the lower numbered DIR's description with it.  It is only used when
:: DIR60 is compared to DIR61, but it can be used for other compares also (see
:: the CRSDUPE?.BATs and TRICKS).  There are two methods:  the first just makes
:: a straight swap (it is the quickest) and the second keeps the latest date in
:: the lower numbered DIR, regardless where it came from originally.  If there
:: are still headings, add /b1?? /b2??h to line 1 and /b2??h to line 3 in both
:: methods, and in the second /b1??h to line 4 and /b1?? /b21 to line 5.  Like
:: in STRIPCRS.BAT above, use whichever replaceable parameter you want for the
:: cross duplicate trash file name (currently it is "%2.crs").  These examples
:: do not put the replaced description from the lower numbered DIR first in the
:: trash file, then follow it with the "marked" kept description, as is done in
:: the CRSDUPE? batch files (the kept description comes first even though it is
:: really the second occurrence, but this keeps all trash files uniform).  Both
:: methods also merge the stripped duplicates into the continuing trash file.
:: To just append them in the first method, replace lines 4 - 6 with:
:: MERGE /o /1te /td:\temp\%2.crs+n /ld:\temp\temp_swp.log+n d:\temp\%2.sav d:\temp\%1.str
:: For the second, replace lines 5 - 7 with (add /b1?? /b21 to the line below
:: if the DIR headings are still attached):
:: MERGE /o /1te /td:\temp\%2.crs+n /ld:\temp\temp_swp.log+n d:\pcb\dirc\%1 d:\temp\stripped.dup

:: MERGE /o /1e /td:\temp\%2.sav+n /ld:\temp\temp_swp.log+n d:\pcb\dirc\%1 d:\pcb\dirc\%2
:: if not exist d:\temp\%2.sav goto END
:: MERGE /o /td:\temp\%1.str+n /ld:\temp\crossdup.log /vl1 d:\temp\%2.sav d:\pcb\dirc\%1
:: MERGE /o /1te /td:\temp\temp.crs+n /ld:\temp\temp_swp.log+n d:\temp\%2.sav d:\temp\%1.str
:: MERGE /o /k /ld:\temp\temp_swp.log+n d:\temp\temp.crs d:\temp\%2.crs
:: del d:\temp\temp.crs
:: del d:\temp\%2.sav
:: :END

:: MERGE /o /1e /td:\temp\%2.sav+n /ld:\temp\crossdup.log /vl1 d:\pcb\dirc\%1 d:\pcb\dirc\%2
:: if not exist d:\temp\%2.sav goto END
:: MERGE /o /k /f1 /f3ddt /ld:\temp\temp_swp.log+n d:\temp\%2.sav d:\pcb\dirc\%1
:: MERGE /o /td:\temp\stripped.dup+n /ld:\temp\crossdup.log /vl1 d:\pcb\dirc\%1
:: MERGE /o /1te /td:\temp\temp.crs+n /ld:\temp\temp_swp.log+n d:\pcb\dirc\%1 d:\temp\stripped.dup
:: MERGE /o /k /ld:\temp\temp_swp.log+n d:\temp\temp.crs d:\temp\%2.crs
:: del d:\temp\temp.crs
:: del d:\temp\%2.sav
:: :END

::
:: CROSSDUP.BAT
:: This is the workhorse that strips cross file duplicates.  CRSDUPE2 and 3.BAT
:: used a line for every compare (about 1800 of them), but this does the same
:: thing in 120 lines by using some batch file tricks.  COMBINE.BAT only needs
:: 60 lines for the compares, and calls CROSSDUP.BAT with the DIR name (%1) to
:: do the comparing, then CROSSDUP.BAT calls STRIPCRS.BAT with both file names.

:: goto %1
:: :dir1
:: call STRIPCRS.BAT %1 dir2
:: :dir2
:: call STRIPCRS.BAT %1 dir3
:: :dir3
:: call STRIPCRS.BAT %1 dir4
:: :dir4
:: call STRIPCRS.BAT %1 dir5
:: :dir5
:: call STRIPCRS.BAT %1 dir6
:: :dir6
:: call STRIPCRS.BAT %1 dir7
:: :dir7
:: call STRIPCRS.BAT %1 dir8
:: :dir8
:: call STRIPCRS.BAT %1 dir9
:: :dir9
:: call STRIPCRS.BAT %1 dir10
:: :dir10
:: call STRIPCRS.BAT %1 dir11
:: :dir11
:: call STRIPCRS.BAT %1 dir12
:: :dir12
:: call STRIPCRS.BAT %1 dir13
:: :dir13
:: call STRIPCRS.BAT %1 dir14
:: :dir14
:: call STRIPCRS.BAT %1 dir15
:: :dir15
:: call STRIPCRS.BAT %1 dir16
:: :dir16
:: call STRIPCRS.BAT %1 dir17
:: :dir17
:: call STRIPCRS.BAT %1 dir18
:: :dir18
:: call STRIPCRS.BAT %1 dir19
:: :dir19
:: call STRIPCRS.BAT %1 dir20
:: :dir20
:: call STRIPCRS.BAT %1 dir21
:: :dir21
:: call STRIPCRS.BAT %1 dir22
:: :dir22
:: call STRIPCRS.BAT %1 dir23
:: :dir23
:: call STRIPCRS.BAT %1 dir24
:: :dir24
:: call STRIPCRS.BAT %1 dir25
:: :dir25
:: call STRIPCRS.BAT %1 dir26
:: :dir26
:: call STRIPCRS.BAT %1 dir27
:: :dir27
:: call STRIPCRS.BAT %1 dir28
:: :dir28
:: call STRIPCRS.BAT %1 dir29
:: :dir29
:: call STRIPCRS.BAT %1 dir30
:: :dir30
:: call STRIPCRS.BAT %1 dir31
:: :dir31
:: call STRIPCRS.BAT %1 dir32
:: :dir32
:: call STRIPCRS.BAT %1 dir33
:: :dir33
:: call STRIPCRS.BAT %1 dir34
:: :dir34
:: call STRIPCRS.BAT %1 dir35
:: :dir35
:: call STRIPCRS.BAT %1 dir36
:: :dir36
:: call STRIPCRS.BAT %1 dir37
:: :dir37
:: call STRIPCRS.BAT %1 dir38
:: :dir38
:: call STRIPCRS.BAT %1 dir39
:: :dir39
:: call STRIPCRS.BAT %1 dir40
:: :dir40
:: call STRIPCRS.BAT %1 dir41
:: :dir41
:: call STRIPCRS.BAT %1 dir42
:: :dir42
:: call STRIPCRS.BAT %1 dir43
:: :dir43
:: call STRIPCRS.BAT %1 dir44
:: :dir44
:: call STRIPCRS.BAT %1 dir45
:: :dir45
:: call STRIPCRS.BAT %1 dir46
:: :dir46
:: call STRIPCRS.BAT %1 dir47
:: :dir47
:: call STRIPCRS.BAT %1 dir48
:: :dir48
:: call STRIPCRS.BAT %1 dir49
:: :dir49
:: call STRIPCRS.BAT %1 dir50
:: :dir50
:: call STRIPCRS.BAT %1 dir51
:: :dir51
:: call STRIPCRS.BAT %1 dir52
:: :dir52
:: call STRIPCRS.BAT %1 dir53
:: :dir53
:: call STRIPCRS.BAT %1 dir54
:: :dir54
:: call STRIPCRS.BAT %1 dir55
:: :dir55
:: call STRIPCRS.BAT %1 dir56
:: :dir56
:: call STRIPCRS.BAT %1 dir57
:: :dir57
:: call STRIPCRS.BAT %1 dir58
:: :dir58
:: call STRIPCRS.BAT %1 dir59

:: You may want to replace STRIPCRS.BAT with SWAPCRS.BAT for all the "compares"
:: to DIRs 60 and 61 (this example only swaps for DIR60 to 61).  If you decide
:: to replace it for all DIR61 compares, remove the last two lines and insert:
:: call SWAPCRS.BAT %1 dir61

:: :dir59
:: call STRIPCRS.BAT %1 dir60
:: :dir60
:: if not %1x==dir60x call STRIPCRS.BAT %1 dir61
:: if %1x==dir60x call SWAPCRS.BAT %1 dir61

::
:: MASTER.BAT
:: This one's easy (with the DIR headings in place, add /b1?? /b21).

:: MERGE /o /ld:\temp\master.log d:\pcb\dirc\%1 d:\temp\master


::
:: THE SHORT WAY
:: Ok, now I'll give you the down and dirty versions:  no logs, no trash files.
:: These should also take less time (remove the /b's if there are no headings).
:: It is assumed you are not keeping any duplicates that are really different
:: programs because you won't be able to with these (duplicates will be gone!).

:: FIXDIR.BAT 1 (needs a trash file for errors or you could lose descriptions):

:: MERGE /o /b1??h /ef /ea /f1 /f3ddt /td:\temp\%1.err+n d:\pcb\dirc\%1
:: MERGE /o /b1??h d:\pcb\dirc\%1

:: If there are no errors because all DIRs have been fixed previously, you can
:: omit /ea and the trash file in the first line above, but since this is for a
:: single "appended" CD-ROM, you still need the first line to insure the latest
:: date is kept.  If the DIR headings are in place but you want to strip them,
:: keep the /b in the first line but drop the "h".

:: FIXDIR.BAT 2 (to keep the latest date, you still need a sort loop):

:: MERGE /o /b1??h /ef /f1 /f3ddt d:\pcb\dirc\%1
:: if errorlevel 3 goto END
:: if not errorlevel 2 goto NOSORT
:: :SORT
:: MERGE /o /b1??h /ef /f1 /f3ddt d:\pcb\dirc\%1
:: if errorlevel 3 goto END
:: if errorlevel 2 goto SORT
:: :NOSORT
:: if errorlevel 1 MERGE /o /b1??h /ea /f1 /f3ddt /td:\temp\%1.err+n d:\pcb\dirc\%1
:: MERGE /o /b1??h d:\pcb\dirc\%1
:: :END

:: The sort loop above probably won't take as long as in the original version
:: because dupes are removed whenever they are encountered rather than saving
:: them until the final merge on itself, so the DIR doesn't stay as big.  This
:: would keep the DIR heading because of "h", but you should adjust it as was
:: discussed in FIXDIR.BAT above (it has every line and you may not need them
:: all, e.g., if you keep the headings, you can remove lines 1, 2, and 6).

:: FIXDIR.BAT 3 (keeps the latest date):

:: MERGE /o /b1?? /b2??h /ea /f1 /f3ddt /td:\temp\%1.err+n %2 d:\pcb\dirc\%1
:: MERGE /o /b1??h d:\pcb\dirc\%1

:: If you are merging more than one CD-ROM, either use the first line for each
:: added DIR, or use both lines, which is probably faster for adding a lot of
:: CD-ROMs.  As with FIXDIR.BAT 1, if there are headings but you want to strip
:: them, keep the /b2 in the first line but drop the "h".

:: FIXDIR.BAT 4 (same as 3, but keeps the last merged dupe regardless of date):

:: MERGE /o /b1?? /b2??h /ea /td:\temp\%1.err+n %2 d:\pcb\dirc\%1

:: This is the simplest (almost) way to merge CD-ROMs.  If you don't care about
:: the date, or pick your CD-ROM merge sequence so the last added probably has
:: the latest dates, you can use it for all the merges, and instead of having
:: "append" batch files, make "merge" batch files to combine the CD-ROM and bbs
:: DIRs.  If you have corrected any errors in every DIR, CD-ROM included (see
:: DIRDUPE.BAT and the end of TRICKS for how to fix the DIRs), this reduces to:

:: MERGE /o /b1?? /b2??h %2 d:\pcb\dirc\%1

:: The advantages are several.  You can add as many CD-ROMs at once as you like
:: and not have to worry about PCBFiler "loosing" descriptions or reaching its
:: capacity as could happen with a huge DIR created by appending a large number
:: of CD-ROMs.  The merges will run fast since the DIR's duplicates are removed
:: as they are added and the DIR doesn't get as big.  The CD-ROM "merge" batch
:: files can also do double duty when taking a CD-ROM off-line by adding extra
:: replaceable parameters so they can be "compared" to the existing bbs DIRs or
:: the descriptions that were removed from them.  Or if you let the merge batch
:: files call another batch file that normally contains the commands to merge,
:: e.g., a MERGEROM.BAT with the line above, you can then temporarily replace
:: it with a batch file that has whatever commands are needed for a particular
:: purpose, such as removing a CD-ROM's descriptions (see the end of TRICKS).

:: STRIPCRS.BAT:

:: MERGE /o /1e /b1?? /b2??h d:\pcb\dirc\%1 d:\pcb\dirc\%2

:: SWAPCRS.BAT 1 (it's still got several lines):

:: MERGE /o /1e /b1?? /b2??h /td:\temp\temp.dup+n d:\pcb\dirc\%1 d:\pcb\dirc\%2
:: if not exist d:\temp\temp.dup goto END
:: MERGE /o /b2??h d:\temp\temp.dup d:\pcb\dirc\%1
:: del d:\temp\temp.dup
:: :END

:: An even shorter version (but it will take a little longer to run):

:: MERGE /o /1m /b1?? /b2??h d:\pcb\dirc\%2 d:\pcb\dirc\%1
:: MERGE /o /1e /b1?? /b2??h d:\pcb\dirc\%1 d:\pcb\dirc\%2

:: SWAPCRS.BAT 2 (keeps the latest date):

:: MERGE /o /1e /b1?? /b2??h /td:\temp\temp.dup+n d:\pcb\dirc\%1 d:\pcb\dirc\%2
:: if not exist d:\temp\temp.dup goto END
:: MERGE /o /b2??h /f1 /f3ddt d:\temp\temp.dup d:\pcb\dirc\%1
:: MERGE /o /b1??h d:\pcb\dirc\%1
:: del d:\temp\temp.dup
:: :END

:: MASTER.BAT:

:: MERGE /o /b1?? /b21 d:\pcb\dirc\%1 d:\temp\master


::
:: SUMMARY AND MY RECOMMENDATIONS:
:: Since you keep a copy of all the CD-ROM DIRs on your hard drive anyway, sort
:: them by name ascending with PCBFiler using one of the methods in TRICKS and
:: let MERGE fix them so they are always ready to be used for adding/removing a
:: CD-ROM (change your "append" batch files to "merge" them instead by calling
:: another batch file with the actual merge commands).  Just keep each one in a
:: separate directory and zip them when they aren't needed to save space.  You
:: can even automate the "fixing" by using the batch file below and passing the
:: appropriate directory name (do not include a trailing backslash, file name,
:: or wildcards).  If there is a DIR heading, use "begin on line" as the second
:: parameter, e.g., /b114, but don't include an "h" so it will be stripped from
:: the DIR for storage on the hard drive.  This example assumes the CD-ROM DIR
:: names don't have an extension and puts any error files in the same directory
:: as the DIRs (error files will have the same name as the DIR with .ERR as an
:: extension).  The "for" command will act on every file in the named directory
:: that does not have an extension, but if there may be other files besides the
:: DIRs without one, you can modify the parameter inside the parentheses, e.g.,
:: use just (%1) and invoke the batch file with something like d:\cdrom\dir* if
:: all the DIR names are the same accept for the number.  If you do change the
:: "for" command, you will also need to replace "%1\direrror" with "%%f", which
:: then writes a separate log for each DIR instead of one log for all of them:

:: the first commands will be for sorting with PCBFiler on name ascending
:: for %%f in (%1\*) do MERGE /o /p /ef /ea /f1 /f3ddt /t%%f.err+n /l%1\direrror.log /vl %%f %2

:: MERGE has a new switch, "/P", which enables this to work.  When there is not
:: a separately named output file, MERGE writes a temporary file in the same
:: directory as the input file that is to become the output file's name, then
:: deletes the original input file and renames the temporary file with its name
:: when the merge is successfully completed.  This technique saves time, but it
:: can also change the order of file names in the directory, and files that did
:: come first may now be at the end.  The "for" command goes through the file
:: names in the order that they occur, and will execute on the same file again
:: if it has been placed further down than where it originally was.  With /p,
:: you can specify a different work path for MERGE to write the temporary file,
:: and when the merge is done, the temp file is copied over the original file.

:: While this keeps the same directory order, it adds some time to the merges,
:: especially on big files (think how long it takes DOS to copy a 2 meg file;
:: 30 seconds, or about 10%, was added to the 5 1/2 minutes for DIRDUPE.BAT).
:: This file would take about 30 minutes more if /p was added to every command.
:: Using /p by itself writes the temporary file in the current directory, but
:: you can also add a path, e.g., /p%1 above will write the temp file in the
:: same directory as the CD-ROM DIRs, and still copy it over the original file.
:: I do not recommend using /p unless you need to keep a certain file order or
:: you aren't sure you have enough disk space on the input/output file's drive,
:: e.g., the "master" list would require about 30 megs of free space before it
:: starts even though the finished master is about 15 megs, but by specifying a
:: separate work path (which of course needs 15 megs of free space) you'd need
:: just the 15 megs of free space on the output drive.

:: This example also assumes there are no duplicate names within the individual
:: CD-ROM DIRs (they would probably not be detected since /f1 /f3ddt is used to
:: trap any date errors).  If you think there might be, the "for" command will
:: need to call a separate batch file using:

:: for %%f in (%1\*) do call FIXCD.BAT %%f %2

:: The first line in FIXCD.BAT is basically the same as the MERGE line above,
:: and the second line then merges the DIR on itself to remove duplicate names:

:: MERGE /o /p /k /ef /ea /f1 /f3ddt /t%1.err+n /l%1.log /vl %1 %2
:: MERGE /o /p /t%1.dup+n /l%1.log /vl %1

:: If you set up all the CD-ROM DIRs as has been suggested, once your bbs DIRs
:: are fixed and you have all the CD-ROMs on-line, you should not ever have to
:: add more than one CD-ROM at a time as new ones arrive, which can be done
:: during normal maintenance time.  When you need to take one off-line, use the
:: method shown in TRICKS.  It should take a lot less time than recompiling all
:: the CD-ROMs.  The lines below show a sample "merge" batch file for a CD-ROM.

:: call MERGEROM.BAT dir1 d:\rompath\cd-rom5
:: call MERGEROM.BAT dir2 d:\rompath\cd-rom9
:: call MERGEROM.BAT dir3 d:\rompath\cd-rom13
:: ...

:: If you always want the latest date, MERGEROM.BAT would be:

:: MERGE /o /b2??h /f1 /f3ddt %2 d:\pcb\dirc\%1
:: MERGE /o /b1??h d:\pcb\dirc\%1

:: To just keep the CD-ROM DIR description in case of a duplicate name:

:: MERGE /o /b2??h %2 d:\pcb\dirc\%1

:: If you merge your CD-ROMs as shown, sort the bbs DIRs with PCBFiler before
:: calling the merge batch files and delete the calls to FIXDIR.BAT below (what
:: is really happening is the merge files are calling a version of FIXDIR.BAT).


@echo off

::
:: If you are appending the CD-ROM DIRs to the bbs DIRs, do it here, otherwise
:: FIXDIR.BAT can merge them together besides stripping the duplicates from the
:: DIRs.  It can also remove the DIR headings and/or "sort" if you add several
:: CD-ROMs at once (see BATNOTES for a discussion of FIXDIR.BAT and sorting).
:: To merge the CD-ROM DIRs, call FIXDIR.BAT with both file names (to simplify
:: things, the CD-ROM DIR goes second, but in FIXDIR.BAT its parameter is the
:: first file name; specify the full path name for the CD-ROM), or you can call
:: separate "merge" batch files for each CD-ROM, or just call one merge batch
:: file that calls the others; the possibilities are endless.  If you do merge
:: them, depending on how, you may not even need a separate call to FIXDIR.BAT
:: (its function could be incorporated with the merge calls).  If the CD-ROM
:: DIR has a heading, you can either add /b1??n here or to FIXDIR.BAT, but if
:: you're merging several CD-ROMs and some have headings while others don't,
:: you should pass it here since FIXDIR.BAT will be used for all the CD-ROMs.

:: call WHIZBANG.BAT  ("appends" the CD-ROM and bbs DIRs)
:: copy d:\pcb\dirc\ascend.lst d:\pcb\dirc\dir.lst
:: PCBFILER /sort ... (name ascending)

call FIXDIR.BAT dir1
call FIXDIR.BAT dir2
call FIXDIR.BAT dir3
call FIXDIR.BAT dir4
call FIXDIR.BAT dir5
call FIXDIR.BAT dir6
call FIXDIR.BAT dir7
call FIXDIR.BAT dir8
call FIXDIR.BAT dir9
call FIXDIR.BAT dir10
call FIXDIR.BAT dir11
call FIXDIR.BAT dir12
call FIXDIR.BAT dir13
call FIXDIR.BAT dir14
call FIXDIR.BAT dir15
call FIXDIR.BAT dir16
call FIXDIR.BAT dir17
call FIXDIR.BAT dir18
call FIXDIR.BAT dir19
call FIXDIR.BAT dir20
call FIXDIR.BAT dir21
call FIXDIR.BAT dir22
call FIXDIR.BAT dir23
call FIXDIR.BAT dir24
call FIXDIR.BAT dir25
call FIXDIR.BAT dir26
call FIXDIR.BAT dir27
call FIXDIR.BAT dir28
call FIXDIR.BAT dir29
call FIXDIR.BAT dir30
call FIXDIR.BAT dir31
call FIXDIR.BAT dir32
call FIXDIR.BAT dir33
call FIXDIR.BAT dir34
call FIXDIR.BAT dir35
call FIXDIR.BAT dir36
call FIXDIR.BAT dir37
call FIXDIR.BAT dir38
call FIXDIR.BAT dir39
call FIXDIR.BAT dir40
call FIXDIR.BAT dir41
call FIXDIR.BAT dir42
call FIXDIR.BAT dir43
call FIXDIR.BAT dir44
call FIXDIR.BAT dir45
call FIXDIR.BAT dir46
call FIXDIR.BAT dir47
call FIXDIR.BAT dir48
call FIXDIR.BAT dir49
call FIXDIR.BAT dir50
call FIXDIR.BAT dir51
call FIXDIR.BAT dir52
call FIXDIR.BAT dir53
call FIXDIR.BAT dir54
call FIXDIR.BAT dir55
call FIXDIR.BAT dir56
call FIXDIR.BAT dir57
call FIXDIR.BAT dir58
call FIXDIR.BAT dir59
call FIXDIR.BAT dir60
call FIXDIR.BAT dir61

call CROSSDUP.BAT dir1
call CROSSDUP.BAT dir2
call CROSSDUP.BAT dir3
call CROSSDUP.BAT dir4
call CROSSDUP.BAT dir5
call CROSSDUP.BAT dir6
call CROSSDUP.BAT dir7
call CROSSDUP.BAT dir8
call CROSSDUP.BAT dir9
call CROSSDUP.BAT dir10
call CROSSDUP.BAT dir11
call CROSSDUP.BAT dir12
call CROSSDUP.BAT dir13
call CROSSDUP.BAT dir14
call CROSSDUP.BAT dir15
call CROSSDUP.BAT dir16
call CROSSDUP.BAT dir17
call CROSSDUP.BAT dir18
call CROSSDUP.BAT dir19
call CROSSDUP.BAT dir20
call CROSSDUP.BAT dir21
call CROSSDUP.BAT dir22
call CROSSDUP.BAT dir23
call CROSSDUP.BAT dir24
call CROSSDUP.BAT dir25
call CROSSDUP.BAT dir26
call CROSSDUP.BAT dir27
call CROSSDUP.BAT dir28
call CROSSDUP.BAT dir29
call CROSSDUP.BAT dir30
call CROSSDUP.BAT dir31
call CROSSDUP.BAT dir32
call CROSSDUP.BAT dir33
call CROSSDUP.BAT dir34
call CROSSDUP.BAT dir35
call CROSSDUP.BAT dir36
call CROSSDUP.BAT dir37
call CROSSDUP.BAT dir38
call CROSSDUP.BAT dir39
call CROSSDUP.BAT dir40
call CROSSDUP.BAT dir41
call CROSSDUP.BAT dir42
call CROSSDUP.BAT dir43
call CROSSDUP.BAT dir44
call CROSSDUP.BAT dir45
call CROSSDUP.BAT dir46
call CROSSDUP.BAT dir47
call CROSSDUP.BAT dir48
call CROSSDUP.BAT dir49
call CROSSDUP.BAT dir50
call CROSSDUP.BAT dir51
call CROSSDUP.BAT dir52
call CROSSDUP.BAT dir53
call CROSSDUP.BAT dir54
call CROSSDUP.BAT dir55
call CROSSDUP.BAT dir56
call CROSSDUP.BAT dir57
call CROSSDUP.BAT dir58
call CROSSDUP.BAT dir59
call CROSSDUP.BAT dir60

:: There is an extra "merge" creating the "master" like this, but that's so any
:: changes only need to be made to MASTER.BAT instead of here also.  The first
:: two "calls" could have been replaced with:
:: MERGE /o /ld:\temp\master.log d:\pcb\dirc\dir1 d:\pcb\dirc\dir2 d:\temp\master

call MASTER.BAT dir1
call MASTER.BAT dir2
call MASTER.BAT dir3
call MASTER.BAT dir4
call MASTER.BAT dir5
call MASTER.BAT dir6
call MASTER.BAT dir7
call MASTER.BAT dir8
call MASTER.BAT dir9
call MASTER.BAT dir10
call MASTER.BAT dir11
call MASTER.BAT dir12
call MASTER.BAT dir13
call MASTER.BAT dir14
call MASTER.BAT dir15
call MASTER.BAT dir16
call MASTER.BAT dir17
call MASTER.BAT dir18
call MASTER.BAT dir19
call MASTER.BAT dir20
call MASTER.BAT dir21
call MASTER.BAT dir22
call MASTER.BAT dir23
call MASTER.BAT dir24
call MASTER.BAT dir25
call MASTER.BAT dir26
call MASTER.BAT dir27
call MASTER.BAT dir28
call MASTER.BAT dir29
call MASTER.BAT dir30
call MASTER.BAT dir31
call MASTER.BAT dir32
call MASTER.BAT dir33
call MASTER.BAT dir34
call MASTER.BAT dir35
call MASTER.BAT dir36
call MASTER.BAT dir37
call MASTER.BAT dir38
call MASTER.BAT dir39
call MASTER.BAT dir40
call MASTER.BAT dir41
call MASTER.BAT dir42
call MASTER.BAT dir43
call MASTER.BAT dir44
call MASTER.BAT dir45
call MASTER.BAT dir46
call MASTER.BAT dir47
call MASTER.BAT dir48
call MASTER.BAT dir49
call MASTER.BAT dir50
call MASTER.BAT dir51
call MASTER.BAT dir52
call MASTER.BAT dir53
call MASTER.BAT dir54
call MASTER.BAT dir55
call MASTER.BAT dir56
call MASTER.BAT dir57
call MASTER.BAT dir58
call MASTER.BAT dir59
call MASTER.BAT dir60
call MASTER.BAT dir61

:: Add here whatever is needed to have PCBFiler sort on name descending.

:: copy d:\pcb\dirc\descend.lst d:\pcb\dirc\dir.lst
:: PCBFILER /sort ... (date descending)
