; ASC2EBC.ASM -- Program to convert an ASCII file to EBCDIC

; Usage -- A> ASC2EBC < input filespec > output filespec

; From PC Mag 10-1-85
;v1.1	Toad Hall Tweak
;	Minor tweaks, no significant changes.
;	David Kirschbaum, Toad Hall
;	kirsch@usasoc.soc.mil

CSEG	Segment
	Assume  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
	Org	0100h
Entry:	jmp	Begin

Table	db	000H,001H,002H,003H,037H,02DH,02EH,02FH
	db	016H,005H,025H,00BH,00CH,00DH,00EH,00FH
	db	010H,011H,012H,013H,03CH,03DH,032H,026H
	db	018H,019H,03FH,027H,022H,01DH,01EH,01FH
	db	040H,05AH,07FH,07BH,05BH,06CH,050H,07DH
	db	04DH,05DH,05CH,04EH,06BH,060H,04BH,061H
	db	0F0H,0F1H,0F2H,0F3H,0F4H,0F5H,0F6H,0F7H
	db	0F8H,0F9H,07AH,05EH,04CH,07EH,06EH,06FH
	db	07CH,0C1H,0C2H,0C3H,0C4H,0C5H,0C6H,0C7H
	db	0C8H,0C9H,0D1H,0D2H,0D3H,0D4H,0D5H,0D6H
	db	0D7H,0D8H,0D9H,0E2H,0E3H,0E4H,0E5H,0E6H
	db	0E7H,0E8H,0E9H,0ADH,0E0H,0BDH,08AH,06DH
	db	07DH,081H,082H,083H,084H,085H,086H,087H
	db	088H,089H,091H,092H,093H,094H,095H,096H
	db	097H,098H,099H,0A2H,0A3H,0A4H,0A5H,0A6H
	db	0A7H,0A8H,0A9H,0C0H,04FH,0D0H,0A1H,007H

Begin:	cld				; Direction Forward
	mov	DX,Offset EndProg	; Beyone end of program
	mov	CX,SP			; Top of segment
	sub	CX,100h			; Leave foom for stack
	sub	CX,DX			; Number of bytes for buffer

MainLoop:
;v1.1	mov	BX,0			; Standard Input
	xor	bx,bx			; Standard Input		v1.1
	mov	AH,3Fh			; Read Function Call
	int	21h			; Call DOS
	jc	Exit			; Exit if error

	push	CX			; Save requested read bytes
	mov	CX,AX			; Get bytes read
	jcxz	Exit			; Exit if no bytes read

	mov	BX,Offset Table		; Conversion Table
	mov	SI,Offset EndProg	; Beginning of Data
	mov	DI,SI			; Destination is same
	push	CX			; Save bytes actually read

	mov	ah,7FH			;handy constant for stripping	v1.1
Conversion:
	lodsb				; Get byte
	and	AL,ah	;7Fh		; Strip out high bit		v1.1
	xlat	Table			; Convert it
	stosb				; Save byte
	loop	Conversion		; For all data

	pop	CX			; Get back bytes read
	mov	BX,1			; Standard Output Handle
	mov	AH,40h			; Write Function Call
	int	21h			; Call DOS
	jc	Exit			; Exit if error

	cmp	AX,CX			; See if all bytes written
	jb	Exit			; Exit if disk is full

	pop	CX			; Get back bytes to read
	jmp	MainLoop		; Do next read

Exit:	int	20h			; Terminate Program

EndProg	Label	Byte			; Buffer Area
CSEG	EndS
	End	Entry
