;PPMPX4b.ASM 3.3(for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS
;	1991-97 by YUJI KIDA
;
.386P

code	segment	use16
	assume	cs:code,ds:code

	INCLUDE	UBP.MAC
	include	ppmpx.h

	org	100h

start:
	jmp	start0

	include	dpmi4ub.h
	include	dpmi4ub.lib

start0:

; branch

	MOV_AX	AR0		;ARRAY[0] is the command
	MOV	BX,OFFSET CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	dw	INITIALIZE,SETMATRIX,freememory

	even
spmem		dw	?
ssmem		dw	?

drv_off		dw	?
drv_seg		dw	?

FBsize		dd	?		;size of original FactorBase
MATsize		dd	?		;size of matrix
ROWSsize	dd	?		;number of ROW data

histhandle	dw	?
RFBhandle	dw	?
ROWShandle	dw	?
decomphandle	dw	?

handle1		dw	?
size1		dd	?
handle2		dw	?

FBmemberID	dd	?
MATmemberID	dd	?

matrixrightbase	dw	?
databuffer	dw	?


	align	4
RFBbase			dd	?
ROWSbase		dd	?
decompdatabase		dd	?
decomppointerbase	dd	?
historybase		dd	?

totaloperations		dd	?


;
; free DPMI memory
;
;command#=2

freememory:
	call	freemainDATAmemory
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


;
; set matrix
;
;command#=1

setmatrix:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	mov	[spmem],sp

	call	real2protB

	mov	eax,[MATsize]
	mov	ecx,[ROWSsize]
	cmp	ecx,eax
	jbe	short setmat5
	mov	ecx,eax
setmat5:
	xor	edx,edx		;MATmemberID counter
	mov	ebx,[ROWSbase]
setmat10:
	push	ebx
	push	ecx
	push	edx
	mov	eax,fs:[ebx]
	mov	[FBmemberID],eax
	mov	[MATmemberID],edx

	call	clear3rdbuffer
	call	backsubstitution
	call	clear2ndbuffer
	call	set2ndpart
	call	clear1stbuffer
	call	set1stpart
	call	writethisrow
setmat20:
	pop	edx
	pop	ecx
	pop	ebx
	inc	edx
	add	ebx,4
	dec	ecx
	jnz	setmat10

	call	fillrests

	call	prot2real

	call	closefiles

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


fillrests:
	mov	ecx,[MATsize]
	sub	ecx,[ROWSsize]
	jbe	short fillrestsret
	mov	edx,[ROWSsize]
fillrests10:
	push	ecx
	push	edx
	mov	[MATmemberID],edx
	call	clear2ndbuffer
	call	clear1stbuffer
	call	set1stpart
	call	writethisrow
	pop	edx
	inc	edx
	pop	ecx
	dec	ecx
	jnz	fillrests10
fillrestsret:
	ret


backsubstitution:
	mov	bx,[databuffer]

	mov	edi,[FBmemberID]	;initial set unit vector
	mov	cx,di
	and	cl,7
	shr	edi,3		;needs mat size < 8*2^16
	mov	al,1
	shl	al,cl
	xor	[di+bx],al

	mov	edx,[totaloperations]
	or	edx,edx
	jz	backsubstret
	mov	esi,edx
	dec	esi
	shl	esi,3	;8 = operation file unit size
	add	esi,[historybase]	;final operation ptr
backsubst10:
	mov	edi,fs:[esi]		;dest
	mov	cx,di
	and	cl,7
	shr	edi,3
	mov	al,1
	shl	al,cl
	test	[di+bx],al
	jnz	short backsubst30
backsubst20:
	sub	esi,8
	dec	edx
	jnz	backsubst10
backsubstret:
	ret

backsubst30:
	mov	edi,fs:[esi+4]		;source
	mov	cx,di
	and	cl,7
	shr	edi,3
	mov	al,1
	shl	al,cl
	xor	[di+bx],al
	jmp	backsubst20


set2ndpart:
	mov	ebx,[decomppointerbase]
	mov	si,[databuffer]
	mov	ecx,[FBsize]
	shr	ecx,4		;1/16
set2nd10:
	push	ecx
	lodsw
	push	si
	mov	cx,16
set2nd20:
	shr	ax,1
	jnc	set2nd30
	push	ax
	push	cx

countthisX:
	mov	esi,fs:[ebx]	;top of the decomposition data
	mov	cx,fs:[esi]
	jcxz	countthisret
countthis10:
	add	esi,4
	mov	eax,fs:[esi]
	shl	eax,2
	add	eax,[RFBbase]
	mov	eax,fs:[eax]		;RFB prime number
	inc	eax
	jz	short countthis20	;if = sentinel
	dec	eax

	push	cx
	mov	cl,al
	and	cl,7
	shr	eax,3
	add	ax,[matrixrightbase]
	mov	di,ax
	mov	al,1
	shl	al,cl
	xor	[di],al
	pop	cx
countthis20:
	loop	countthis10

countthisret:
	pop	cx
	pop	ax
set2nd30:
	add	ebx,4
	loop	set2nd20
	pop	si
	pop	ecx
	dec	ecx
	jnz	set2nd10
	ret


set1stpart:
	mov	eax,[MATmemberID]
	mov	cl,al
	shr	eax,3
	and	cl,7
	add	ax,offset BUFFER
	mov	di,ax
	mov	al,1
	shl	al,cl
	mov	[di],al
	ret


clear1stbuffer:
	mov	di,offset BUFFER
clearbuffer10:
	mov	ecx,[MATsize]
clearbuffer20:
	shr	ecx,5			;1/32
	xor	eax,eax
	rep	stosd
	ret

clear2ndbuffer:
	mov	di,[matrixrightbase]
	jmp	clearbuffer10

clear3rdbuffer:
	mov	di,[databuffer]
	mov	ecx,[FBsize]
	jmp	clearbuffer20


writethisrow:
	call	prot2real

	mov	dx,offset BUFFER
	mov	ecx,[MATsize]
	shr	ecx,2			;*2/8 this means
	mov	eax,[MATmemberID]	;matsize < 4*2^16
	mov	bx,[handle1]
	cmp	eax,[size1]
	jb	short setrow100
	mov	bx,[handle2]
setrow100:
	mov	ah,40h			;write data
	int	21h
	jc	diskerror

	call	real2protB
	ret

;

closefiles:
	mov	ax,cs
	mov	ds,ax

	mov	bx,[histhandle]
	or	bx,bx
	jz	short closef10		;not opened
	mov	ah,3eh			;close file
	int	21h
closef10:
	mov	bx,[handle1]
	or	bx,bx
	jz	short closef20		;not opened
	mov	ah,3eh			;close file
	int	21h
closef20:
	mov	bx,[handle2]
	or	bx,bx
	jz	short closef30		;not opened
	mov	ah,3eh			;close file
	int	21h
closef30:
	ret


;
;* Initialize
;
;COMMAND#=0

;	V1 = datadrive
;	V2 = mebers
;	V3 = maxlength
;	V4 = minlength
;	V5 = totallength

INITIALIZE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	[spmem],sp

	MOV	BX,V1		;adr of drv
	MOV	AX,[BX]
	MOV	[drv_OFF],AX
	MOV	AX,[BX+2]
	MOV	[drv_SEG],AX

	xor	eax,eax
	mov_ax	AR2
	shl	eax,5		;this means matsize must 
				;< 32* 2^16
	mov	[MATsize],eax

	shr	eax,3
	mov	bx,offset BUFFER
	add	bx,ax
	mov	[matrixrightbase],bx
	add	bx,ax		;this means matsize 
				;< 4*work area size
	mov	[databuffer],bx

	call	totalfilesize
	push	eax
	call	getdecompptrsize
	pop	edx
	add	eax,edx
	add	eax,0fh		;for alignment safety *
	mov	[DPMImemorysize],eax

	call	DPMIinit
	jc	dpmierror

	mov	eax,dword ptr [DPMIaddresslow]
	add	eax,0fh		;
	and	ax,0fff0h	;* see above
	mov	fs:[_primeadr],eax

	call	prot2real
	call	getRFB
	call	getROWS
	call	getDECOMPDATA
	call	gethistDATA
	call	createMATRIXfiles

initout:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

diskerror:
	mov	ax,8001h
errorout:
	mov	bx,cs
	mov	ds,bx

	mov	bx,AR0
	mov	[bx],ax
	mov	sp,[spmem]
	call	closefiles
	jmp	initout

initlackofdata:
	mov	ax,8002h
	jmp	errorout
dpmierror:
;	call	prot2real
	mov	ax,8003h
	jmp	errorout


	; copy RFB file to memory

getRFB:
	mov	ax,3d00h		;open for read
	mov	dx,offset RFBfilename
	int	21h
	jc	diskerror
	mov	[RFBhandle],ax

	call	real2protB

	mov	edi,fs:[_primeadr]
	mov	[RFBbase],edi
getRFB10:
	push	edi

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[RFBhandle]
	mov	ah,3fh			;read
	int	21h
	or	ax,ax
	jz	short getRFBeof

	push	ax
	call	real2protB
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
	pop	edi
getRFB20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	getRFB20
	jmp	getRFB10

getRFBeof:
	pop	eax
	mov	[ROWSbase],eax
	sub	eax,[RFBbase]
	shr	eax,2
	mov	[FBsize],eax	;original FBsize

	mov	ah,3eh		;close file
	mov	bx,[RFBhandle]
	int	21h
	ret


getROWS:
	mov	ax,3d00h		;open for read
	mov	dx,offset ROWSfilename
	int	21h
	jc	diskerror
	mov	[ROWShandle],ax

	call	real2protB

	mov	edi,[ROWSbase]
getROWS10:
	push	edi

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[ROWShandle]
	mov	ah,3fh			;read
	int	21h
	or	ax,ax
	jz	short getROWSeof

	push	ax
	call	real2protB
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
	pop	edi
getROWS20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	getROWS20
	jmp	getROWS10

getROWSeof:
	pop	eax
	mov	[decompdatabase],eax
	sub	eax,[ROWSbase]
	shr	eax,2
	mov	[ROWSsize],eax

	mov	ah,3eh			;close file
	mov	bx,[ROWShandle]
	int	21h
	ret


getDECOMPDATA:
	mov	si,offset decompfilename
	call	setpathname
	mov	dx,offset BUFFER
	mov	ax,3d00h		;open for read
	int	21h
	jc	diskerror
	mov	[decomphandle],ax

	call	real2protB

	mov	edi,[decompdatabase]
getdecomp10:
	push	edi

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[decomphandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	short getdecompeof

	push	ax
	call	real2protB
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
	pop	edi
getdecomp20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	getdecomp20
	jmp	getdecomp10

getdecompeof:
	pop	eax
	mov	[decomppointerbase],eax

	mov	ah,3eh			;close file
	mov	bx,[decomphandle]
	int	21h

	call	real2protB

	mov	ebx,[decomppointerbase]
	mov	esi,[decompdatabase]
getdecomp100:
	mov	fs:[ebx],esi
	mov	edx,fs:[esi]	;# of members
	inc	edx
	shl	edx,2		;*4
	add	esi,edx		;next top
	add	ebx,4
	cmp	esi,[decomppointerbase]
	jb	getdecomp100
	mov	[historybase],ebx

	call	prot2real
	ret


gethistDATA:
	mov	ax,3d00h		;open for read
	mov	dx,offset historyfilename
	int	21h
	jc	diskerror
	mov	[histhandle],ax

	call	real2protB

	mov	edi,[historybase]
gethist10:
	push	edi

	call	prot2real

	mov	dx,offset BUFFER
	mov	cx,1000h
	mov	bx,[histhandle]
	mov	ah,3fh
	int	21h
	or	ax,ax
	jz	short gethisteof

	push	ax
	call	real2protB
	pop	cx

	shr	cx,2
	mov	si,offset BUFFER
	pop	edi
gethist20:
	lodsd
	mov	fs:[edi],eax
	add	edi,4
	loop	gethist20
	jmp	gethist10

gethisteof:
	pop	eax
	sub	eax,[historybase]
	shr	eax,3			;8bytes/unit
	mov	[totaloperations],eax

	mov	ah,3eh			;close file
	mov	bx,[histhandle]
	int	21h
	ret


createMATRIXfiles:
	mov	bx,offset MATRIXNAME1
	MOV_AX	AR3
	or	ax,ax
	jz	short createmat10
	sub	bx,2
	add	al,'@'
	mov	[bx],al
createmat10:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle1],ax

	xor	eax,eax
	MOV_AX	AR4
	shl	eax,1
	MOV	[size1],eax

	mov	bx,offset MATRIXNAME2
	MOV_AX	AR5
	or	ax,ax
	jz	short createmat20
	sub	bx,2
	add	al,'@'
	mov	[bx],al
createmat20:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle2],ax
	ret

setpathname:				;input si
	push	ax
	push	cx
	push	di

	push	ds			;/*
	push	si

	lds	si,dword ptr [Drv_off]
	mov	di,offset BUFFER
	lodsw
	mov	cx,ax
	shl	cx,1
	and	cx,00ffh		;cut 255 chars
	shl	ax,1
	jnc	short setpath10
	dec	cx
setpath10:
	rep	movsb

	pop	si
	pop	ds			;*/

setpath20:
	lodsb
	stosb
	or	al,al
	jnz	setpath20

	pop	di
	pop	cx
	pop	ax
	ret


getdecompptrsize:
	mov	dx,offset DECOMPFILENAME
	mov	ax,3d00h		;read open
	int	21h

	mov	bx,ax
	xor	esi,esi
getdecompptrsize10:
	mov	ah,3fh		;read file
	mov	cx,4
	mov	dx,offset BUFFER
	int	21h
	or	ax,ax
	jz	getdecompptrsize20		;eof

	mov	edx,dword ptr [BUFFER]	;# of members
	shl	edx,2		;*4
	add	esi,4

	push	edx
	pop	dx
	pop	cx
	mov	ax,4201h		;move file ptr
	int	21h
	jmp	getdecompptrsize10

getdecompptrsize20:
	mov	ah,3eh			;close file
	int	21h
	mov	eax,esi			;eax = result
	ret


totalfilesize:
	xor	esi,esi
	mov	dx,offset RFBFILENAME
	call	getfilesize
	add	esi,eax
	mov	dx,offset ROWSFILENAME
	call	getfilesize
	add	esi,eax
	mov	dx,offset DECOMPFILENAME
	call	getfilesize
	add	esi,eax
	mov	dx,offset historyfilename
	call	getfilesize
	add	eax,esi			;eax = result
	ret


getfilesize:
	;inp dx = offset of file name
	;out eax = size

	mov	ax,3d00h		;read open
	int	21h

	push	ax			;handle
	mov	bx,ax
	mov	ax,4202h		;move file ptr to end
	xor	cx,cx
	xor	dx,dx
	int	21h
					;now dx:ax = file size
	pop	bx
	push	dx
	push	ax

	mov	ah,3eh			;close file
	int	21h

	pop	eax
	ret




historyfilename	db	'PPMPHIST.PPM',0
RFBFILENAME	db	'PPMPRFB.PPM',0
ROWSFILENAME	db	'PPMPROWS.PPM',0
DECOMPFILENAME	db	'PPMPDCMP.PPM',0
		db	' :'
MATRIXNAME1	db	'PPMPMAT1.PPM',0
		db	' :'
MATRIXNAME2	db	'PPMPMAT2.PPM',0


	align	4
	;needs 3 buffers each has matsize/8 byte
maxmatwordsize	equ	2000h
BUFFER		dw	maxmatwordsize dup(0)
		dw	maxmatwordsize dup(0)
		dw	maxmatwordsize dup(0)

CODE	ENDS
END	START
