
O    EQU OFFSET
SYS  EQU INT 021
STOP EQU INT 020
TSR  EQU INT 027


   ;USE PSP FOR DATA


SIGN    EQU  0F7   ;Signature 'FTH' (46h,54h,48h)
OLDINT  EQU  0FA    ;OLD INT 10h VECTOR
VERSION EQU  0FE   ;Version Number to force (0102) DEFAULT
MEMORYS EQU 0100   ;Memory size in 64K units (4=256K)
CONTROL EQU 0102   ;CONTROL WORD. BIT FLAGS:
                   ; BIT 0: Disable VESA if set
                   ;     7: Terminate TSR if set

CT_NOVESA EQU   1  ;SET TO DISABLE ANY PREVIOUS VESA DRIVER
CT_NEW    EQU 040  ;SET IF NO PREVIOUS "vesalie" INSTALLED
CT_STOP   EQU 080  ;SET TO TERMINATE AND UNINSTALL

 ORG 0100
 JMP START

INT10:
 PUSHF
 CS TEST B[CONTROL],CT_STOP
 JNZ >L7
 CMP AH,04F
 JNZ >L8
 CS TEST B[CONTROL],CT_NOVESA
 JNZ >L9
 CMP AL,0
 JNZ >L8            ;NOW 04F00
 CS CALL D[OLDINT]  ;FLAGS ALREADY ON STACK
 PUSH BP
 MOV BP,SP
 PUSH AX
 LAHF
 MOV [BP+6],AH  ;CHANGE OLD FLAGS ON STACK
 CS MOV AX,[VERSION]
 OR AX,AX
 IF NE ES MOV [DI+4],AX
 CS MOV AX,[MEMORYS]
 OR AX,AX
 IF NE ES MOV [DI+012],AX
 POP AX,BP
 IRET

L9:   ;KILL ANY VESA QUERIES
 POPF
 IRET
L8:   ;LET SOMEONE ELSE HANDLE THIS
 POPF
 CS JMP D[OLDINT]

L7:   ;TERMINATE
 PUSH ES,AX
 XOR AX,AX
 MOV ES,AX
 CS MOV AX,[OLDINT]
 ES MOV [040],AX
 CS MOV AX,[OLDINT+2]
 ES MOV [042],AX

 MOV AH,049
 MOV ES,CS
 SYS
 POP AX,ES
 POPF
 IRET


START:
 MOV W[VERSION],0
 MOV W[MEMORYS],0
 MOV B[CONTROL],0

 XOR AX,AX
 MOV ES,AX
 ES LES DI,[040]    ;INT 10h VECTOR
 MOV [OLDINT],DI
 MOV [OLDINT+2],ES
 CMP DI,O INT10
 JNZ >L2
 ES CMP W[SIGN],05446
 JNZ >L2
 ES CMP B[SIGN+2],048
 JZ >L3
L2:
 MOV ES,CS
 OR B[CONTROL],CT_NEW
L3:
 MOV SI,080
 LODSB
 MOV AH,0
 ADD AX,SI
 MOV DI,AX
 MOV B[DI],0
L0:
 LODSB
 OR AL,AL
 IF Z JMP PROCESS
 CMP AL,'/'
 IF NE CMP AL,'-'
 JZ >L1
 CMP AL,' '
 JZ L0
 CMP AL,9
 JZ L0
 CMP AL,0D
 JZ L0
 JMP USAGE

L1:
 LODSB
 OR AL,020    ;LOWER CASE
 CMP AL,'o'
 JNZ >L1
 LODSB
 OR AL,020
 CMP AL,'n'
 JNE >L2
 ES AND B[CONTROL],NOT CT_NOVESA
 JMP L0
L2:
 CMP AL,'f'
 IF E ES OR B[CONTROL],CT_NOVESA
 LODSB
 CMP AL,'f'
 IF NE CMP AL,'F'
 IF NE DEC SI
 JMP L0
L1:
 CMP AL,'?'
 JNZ >l2
USAGE:
 MOV AH,9
 MOV DX,O USE
 SYS
 STOP


L2:
 CMP AL,'m'
 JNZ >L3
 MOV BX,0
L22:
 LODSB
 CMP AL,'0'
 JB >L7
 CMP AL,'9'
 JA >L7
 XCHG AX,BX
 MOV DX,10
 MUL DX
 AND BX,0F
 ADD BX,AX
 JMP L22
L7:
 ADD BX,63
 MOV CL,6
 SHR BX,CL
 ES MOV [MEMORYS],BX
 JMP L0
L3:
 CMP AL,'u'
 JNZ >L4
 ES OR B[CONTROL],CT_STOP
 OR B[CONTROL],CT_STOP
 JMP L0
L4:
 MOV BX,0
 CMP AL,'0'
 IF E MOV BX,0100
 CMP AL,'1'
 IF E MOV BX,0101
 CMP AL,'2'
 IF E MOV BX,0102
 OR BX,BX
 JZ USAGE
 ES MOV W[VERSION],BX
 JMP L0

PROCESS:
 TEST B[CONTROL],CT_STOP
 JZ >L6
 MOV DX,O UNLOAD
 MOV AH,9
 SYS
 STOP

L6: 
 TEST B[CONTROL],CT_NEW
 JNZ >L5
 MOV DX,O ALLOK
 MOV AH,9
 SYS
 STOP

L5:  ;INSTALL
 MOV W[SIGN],05446
 MOV B[SIGN+2],'H'
 XOR AX,AX
 MOV ES,AX
 ES MOV W[040],O INT10
 ES MOV W[042],CS
 MOV ES,[02C]     ;Environment
 MOV AH,049
 SYS
 MOV DX,O LOAD
 MOV AH,9
 SYS
 MOV DX,O START
 TSR        ;GO TSR, KEEP UNTIL START

BUF:
ALLOK:
 DB 13,10,'VESALIE: Parameters have been changed.',13,10,'$'
UNLOAD:
 DB 13,10,'VESALIE has been uninstalled',13,10,'$'
LOAD:
 DB 13,10,'VESALIE has been installed.',13,10,'$'

USE:
 DB 13,10,'Usage: VESALIE [/0|/1|/2] [/ON|/OFF] [/Mxx] [/U]',13,10
 DB 13,10,'Where /0 /1 /2 selects VESA version 1.00, 1.01 or 1.02'
 DB 13,10,'      /ON /OFF turns the VESA driver on and off'
 DB 13,10,'      /Mxx     sets the memory size returned by the driver'
 DB 13,10,'      /U       Uninstalls the VESA "Cheat" facility'
 DB 13,10,'$'
