/*
Function: int set_directory(char *path)
Purpose : perform a chdir to given directory
Params  : path = full path to new directory
Return  : zero on success, non-zero on error
*/

#include <dir.h>
#include <string.h>

extern char _slrerr[80];        /* Global error buffer */

int set_directory(char *path)
{
  char disk_drive = path[0];
  char new_path[MAXPATH];
	int disknum = 0;
  int x = 0;

	disk_drive = toupper(disk_drive);
	disknum = disk_drive - 65;
	if ((disknum >= 0) && (disknum <=25))
	{
		setdisk(disknum);
	}
	else
	{
    sprintf(_slrerr,"set_directory(): invalid disk: %c",disk_drive);
    goto ErrorExit;
	}

  new_path[0] = '\0';
	for (x = 2; x < strlen(path); x++)
	{
		new_path[x - 2] = path[x];
	}
	new_path[x - 2] = '\0';

  /* Allow paths like "i:" to work */
  if (new_path[0] == '\0') strcpy(new_path,"\\");

  if (chdir(new_path) != 0)
	{
    sprintf(_slrerr,"set_directory(): directory %s does not exist",new_path);
		goto ErrorExit;
	}
GoodExit:
	return 0;
ErrorExit:
	return 1;
}
