/*===========================================================================
SOLAR v0.95.3 slrcmd :: Module ..\slrcmd\slrcmd.c
Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code module has been placed in the public domain.
===========================================================================*/

/* Include Files */

#include <stdio.h>
#include <dir.h>
#include <string.h>
#include "codedate.h"
#include "slrcmd.h"

int main(int argc, char *argv[])
{
  FILE *commands_file = NULL;

  extern    char    *optarg;
	unsigned  char    x;
  const     char    *optionS = "u:U:S:s:vV";

	char              orig_path[MAXPATH];
	char              username[10];
  int               exit_code   = x_success;
  char              delimiter   = ' ';
  char              buf[1024];
  char              comtoken[80];

  /* Set default values for globals */

  strcpy(temp_path,      "NONE");
  strcpy(user_path,      "NONE");
  strcpy(config_path,    "NONE");
  strcpy(log_path,       "NONE");
  strcpy(swap_path,      ".");
  strcpy(newsgroups_path,"NONE");
  strcpy(username,       "NONE");
  strcpy(protocol,       "NONE");
  strcpy(compress,       "NONE");
  strcpy(uucpname,       "SOLAR");
  strcpy(speed,          "LOCAL");

  diskswap            = YES;
  send_list           = NO;
  send_mail           = NO;
  delete_mail         = NO;
  news_index          = c;
  mail_type           = m;
  default_keyword     = 'a';
  verbose             = NO;     /* Default to no verbose     */

  /* Store original directory */

	getcwd(orig_path, MAXPATH);

  /* Parse command line */

	while ((x = getopt(argc, argv, optionS)) != '\xFF')
	{
		switch (toupper(x)) {
      case '?'  : exit_code = x_usage;
      						goto ExitMain;
      case 'U'  : if ((strcmp(username,"NONE")) == 0)
									{
                    strcpy(username,optarg);
                    break;
                  }
									else
                  {
                    exit_code = x_usage;
                    goto ExitMain;
                  }
      case 'S'  : strcpy(speed,optarg);
                  break;
      case 'V'  : verbose = YES;
                  break;
    }
  }

  /* Check to see if username was set. If
     not, try to set from PCBDOOR.SYS or
     DOORS.SYS file. */

  if (strcmp(username,"NONE") == 0)
	{
    if (read_doors() != 0)
		{
      exit_code = x_usage;
      goto ExitMain;
    }
  }

  if (verbose == YES)
  {
    RPrintf("\nSOLAR v%s <> slrcmd (%s)\n\n",VERSION,CODE_DATE);
    RPrintf("Processing COMMANDS for user: %s\n",username);
  }

  /* Load configuration files. */          
                                           
  if ((load_static(username) != 0)    || \
      (load_config() != 0)            || \
      (user_defaults() != 0))
  {                                          
    exit_code = x_fatal;                     
    goto ExitMain;                           
  }                                          

  if ((commands_file = open_commands_file()) == NULL)           
  {                                                             
    RPrintf("\nslrcmd: No %s file to process\n",COMMANDS_NAME); 
    exit_code = x_success;
    goto ExitMain;                                              
  }

  while (fgets(buf,1024,commands_file) != NULL)
  {
    RPrintf("\nProcessing command: %s\n",buf);

/*
    if (strnicmp(buf,"SENDME",6) == 0)
    {
      call sendme
    }
*/
    comtoken[0] = '\0';
    strcpy(comtoken,extract_parm(buf,delimiter));

    if (strnicmp(buf,"SUBSCRIBE ",10) == 0)
    {
      if (subscribe(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }

    if (strnicmp(buf,"UNSUBSCRIBE ",12) == 0)
    {
      if (unsubscribe(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }
/*
    if (strnicmp(buf,"CATCHUP ",8) == 0)
    {
      call catchup
    }
*/

    if (strnicmp(buf,"LIST",4) == 0)
    {
      if (set_send_list(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }

    if (strnicmp(buf,"MAIL ",5) == 0)
    {
      if (set_send_mail(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }

    if (strnicmp(buf,"DELETEMAIL ",11) == 0)
    {
      if (set_delete_mail(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }

    if (strnicmp(buf,"NEWSINDEX ",10) == 0)
    {
      if (set_news_index(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }

    if (strnicmp(buf,"MAILTYPE ",10) == 0)
    {
      if (set_mail_type(comtoken) != 0)
        RPrintf("<slrcmd> warning: %s\n",_slrerr);
    }
  }
  if (write_options() != 0) 
  {
    exit_code = x_fatal;
    goto ExitMain;
  }

ExitMain:
  if (commands_file) fclose(commands_file);
  set_directory(orig_path);

  switch (exit_code) {
    case x_success  : break;
    case x_usage    : usage();
                      break;
    case x_fatal    : fprintf(stderr,"\n%s\n",_slrerr);
                      sprintf(logbuf,"%s",_slrerr);
                      logit("slrcmd");
                      break;
  }
  return exit_code;
}

/*
 * Function: FILE *open_commands_file();
 * Purpose : Open SOUP COMMANDS file for read
 * Return  : Pointer to COMMANDS file, NULL on error.
 *
*/

FILE *open_commands_file()
{
  char commands_path[MAXPATH];

  strcpy(commands_path,temp_path);
  strcat(commands_path,"\\");
  strcat(commands_path,COMMANDS_NAME);

  return fopen(commands_path,"rt");
}

void usage()
{
  RPrintf("\nSOLAR v%s <> slrcmd (%s)\n",VERSION,CODE_DATE);
  RPrintf("\nUsage: slrcmd -u username [-s speed] [-v]\n");
  return;
}
