/*
    This file contains functions that are needed for the linked list library
    to work properly. How to free a node, how to print a node and so on.
*/

/* #include "cmp3llist.h" */
#include"cmp3funcs.h"

extern void freeleft(void *node)
{
    list_left_t *theblock = (list_left_t*) node;
    free(theblock->name);
    return;
}

extern void freeright(void *node)
{
    list_right_t *theblock = (list_right_t*) node;
    free(theblock->name);
    return;
}

/****************************************************************************
 *  Print functions for left and right lists
 *  Prints name to the pad
 *  Returns: nothing
 ****************************************************************************/
void printleft(void *thenode, int selected)
{
    list_left_t *node = (list_left_t*) thenode;

    if (selected && (curwin == FOCUSED_LEFT))
        wattron(pad_left, A_REVERSE);
    mvwprintw(pad_left, ll_nodenum(list_left, thenode), 0,
            "%s/", node->name);
    wattroff(pad_left, A_REVERSE);
    return;
}

void printright(void *thenode, int selected)
{
    list_right_t *node = (list_right_t*) thenode;

    if (selected && (curwin == FOCUSED_RIGHT))
        wattron(pad_right, A_REVERSE);
    mvwprintw(pad_right, ll_nodenum(list_right, thenode), 0,
            "%s", node->name);
    wattroff(pad_right, A_REVERSE);
    return;
}

/****************************************************************************
 *  Initialize lists
 *  Returns: nothing
 ****************************************************************************/
void init_lists(char *directory, int leftnum, int rightnum)
{
    void   *infoptr;
    int     i;

/*     list_left = ll_create(sizeof(list_left_t), &freeleft); */
/*     list_right = ll_create(sizeof(list_right_t), &freeright); */
    list_left = ll_create(sizeof(list_left_t), NULL);
    list_right = ll_create(sizeof(list_right_t), NULL);
    ll_prninit(list_left, &printleft);
    ll_prninit(list_right, &printright);

    /* Set up info area */
    infoptr = Malloc(sizeof(info_left_t));
    strcpy(((info_left_t*)infoptr)->directory, directory);
    if (leftnum != 0) {
        ((info_left_t*)infoptr)->line = leftnum - ((LINES-8)/2);
        if (leftnum < 0)
            leftnum = 0;
    }
    ll_info(list_left, infoptr);

    infoptr = Malloc(sizeof(info_right_t));
    if (rightnum != 0) {
        ((info_right_t*)infoptr)->line = rightnum - ((LINES-8)/2);
        if (rightnum < 0)
            rightnum = 0;
    }
    ll_info(list_right, infoptr);

    newdir(directory);

    /* Initialize list to first element and print it */
    ll_reset(list_left);
    ll_reset(list_right);
    for (i = 0; i <= leftnum; i++)
    {
        ll_next(list_left);
    }
    ll_prnall(list_left);

    for (i = 0; i <= rightnum; i++)
    {
        ll_next(list_right);
    }
    ll_prnall(list_right);
    return;
}

/****************************************************************************
 *  Terminate lists
 *  Returns: nothing
 ****************************************************************************/
void free_lists()
{
    void *infoptr;

    infoptr = ll_info(list_left, NULL);
/*     if (((info_left_t*) infoptr)->directory != NULL) */
/*         free(((info_left_t*) infoptr)->directory); */
    free(infoptr);
    infoptr = ll_info(list_right, NULL);
    free(infoptr);

    ll_destroy(list_left);
    ll_destroy(list_right);
    return;
}

/* EOF */
