/*
    Handle the volume control.
*/    

#include "cmp3funcs.h"
#include<sys/soundcard.h>

static int mixernum,                    /* ID number for the mixer */
           vol;                         /* Current volume level */

/****************************************************************************
 *  Initialize volume control
 *  Returns: nothing
 ****************************************************************************/
extern void initvol()
{
    if ((mixernum=open("/dev/mixer", O_RDWR)) < 0) {
        fprintf(stderr, "open /dev/mixer: %s", strerror(errno));
        enditall(SIGSEGV);
    }
    ioctl(mixernum, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
    vol=vol & 0xff;
    mvprintw(3,COLS/2-1,"-");
    mvprintw(LINES-7,COLS/2-1,"-");
    mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");
    return;
}

extern void endvol()
{
    close(mixernum);
}

/****************************************************************************
 *  Clean up volume bar area
 *  Basically forces curses to touch it all
 *  Returns:
 ****************************************************************************/
extern void volclean()
{
    int i;

/*    XXX - This is a hack */
    for (i=4; i< LINES-7; i++) {
        mvprintw(i,COLS/2-1,"|");
        mvprintw(i,COLS/2-1," ");
    }
    mvprintw(3,COLS/2-1,"-");
    mvprintw(LINES-7,COLS/2-1,"-");
    mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1,"*");

    return;
}

/****************************************************************************
 *  User requestes the volume be increased
 *  Although I hate users in general, we should probably do it.
 *  Returns: nothing
 ****************************************************************************/
extern void volup()
{
    int i;

    mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1," ");
    vol += 3;
    if (vol > 100)
        vol = 100;
    i = vol | vol << 8;
    ioctl(mixernum, MIXER_WRITE(SOUND_MIXER_VOLUME), &i);
    mvprintw((LINES-8)-(vol*(LINES-12)/100), COLS/2-1, "*");
    return;
}

/****************************************************************************
 *  It's too loud junior, turn it down!
 *  Returns: nothing
 ****************************************************************************/
extern void voldown()
{
    int i;

    mvprintw((LINES-8)-(vol*(LINES-12)/100),COLS/2-1," ");
    vol -= 3;
    if (vol < 0)
        vol = 0;
    i = vol | vol << 8;
    ioctl(mixernum, MIXER_WRITE(SOUND_MIXER_VOLUME), &i);
    mvprintw((LINES-8)-(vol*(LINES-12)/100), COLS/2-1, "*");
    return;
}

/* EOF */