#!/usr/bin/perl
################################################################################
##           External FREQ processor v.0.1.2 for ifcico 2.9+.os               ##
##           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		      ##
##  Works ONLY with patched ifcico (patch by Serg Oskin <serg@oskin.msk.su>)  ##
##   Written by Andy Pershin <apa@penza.com.ru> AKA 2:5059/9.15@fidonet       ##
##          Last corrections at Wed Sep  3 08:28:54 MSD 1997	              ##
################################################################################
#
# Full Name of configuration file.
#
$Config="/usr/fido/etc/efreqp.conf";
################################################################################
$q = 1;
$TotalSize = 0;
&BeginWork();
########################
##  Subrutines here

sub BeginWork
{
    &ReadConfig();
    &ReadAreas();
    &ReadComStr();
    &ReadREQ();
    &WriteInOut();
    &WriteInMFR();
}
#Ok
#####################
sub ReadConfig
{
    my($KeyWord, $Value);
    open(CONF,$Config) || die "Cannot read $Config. Please check.\n";
    while(<CONF>) {
        /^#/		&& next;
        /^[ \t]*$/	&& next;
        chop;
        ($KeyWord, $Value) = split(/[ \t]+/, $_, 2);
        if($KeyWord =~ /^LogFile/) {
            $LogFile = $Value;
        } elsif($KeyWord =~ /^Areas/) {
            $Areas = $Value;
        } elsif($KeyWord =~ /^DList/) {
            $DList = $Value;
        } elsif($KeyWord =~ /^Aliases/) {
            $Aliases = $Value;
        } elsif($KeyWord =~ /^Descs/) {
            $Descs = $Value;
        } elsif($KeyWord =~ /^DescMiss/) {
            $DescMiss = $Value;
        }
    }
    $DescMiss = "Description missing." if !defined($DescMiss);
    die "Undefined the ~Areas~ parameter in $Config.\n" if !defined($Areas);
    die "Undefined the ~DList~ parameter in $Config.\n" if !defined($DList);
    die "Undefined the ~Aliases~ parameter in $Config.\n" if !defined($Aliases);
    close CONF;
}
#Ok
#####################
sub ReadAreas
{
    my($i) = 0;
    open(A,$Areas) || die "Cannot read $Areas. Please check\n";
    while(<A>) {
        /^#/	   && next;
        /^[ \t]*$/ && next;
        chop;
        $i++;
        ($AreaAccess[$i], $AreaName[$i], $AreaPath[$i],
         $AreaDesc[$i]) = split(/[ \t]+/, $_, 4);
    }
    close A;
}
#Ok
#####################
sub OpenDesc
{
    my($DescFile) = $_[0];
    my($text) = "";
    open(Descr,$DescFile) || return $DescMiss;
    while(<Descr>) {
        chop;
        $text .= $_;
    }
    close Descr;
    return $text;
}
#Ok
####################
sub Logger
{
    my($LogData) = @_[0];
    if(defined($LogFile)) {
        open(LOG,">>$LogFile") || die "Cannot write to $LogFile.\n";
        printf LOG "$LogData";
        close LOG;
    }
}
#Ok
#####################
sub GetDate
{
    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,$isdst);
    ($sec, $min, $hour, $mday, $mon, $year,
     $wday, $yday, $isdst) = localtime(time());
    $mon++;
    $TempCurDate = sprintf("%02d-%02d-%02d", $mday, $mon, $year);
    return $TempCurDate;
}
#Ok
#####################
sub GetTime
{
    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,$isdst);
    ($sec, $min, $hour, $mday, $mon, $year, $wday,
     $yday, $isdst) = localtime(time());
    $TempCurTime = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
    return $TempCurTime;
}
#Ok
#####################
# analise command string
sub ReadComStr
{
    my($i, $StrParams);
    $StrParams = "";
    for($i=0; $i<=$#ARGV; $i++) {
        $StrParams .= $ARGV[$i]." ";
        if($ARGV[$i] =~ /^-s/i) {
            $Speed = $ARGV[$i];
            $Speed =~ s/^-[sS]//;
        } elsif($ARGV[$i] =~ /^-wazoo$/i) {
            $Unused = "wazoo";
        } elsif($ARGV[$i] =~ /^-bark$/i) {
            $Unused = "bark";
        } elsif($ARGV[$i] =~ /^-p$/i) {
            $Protect = 3;
        } elsif($ARGV[$i] =~ /^-l$/i) {
            $Protect = 2;
        } elsif(!defined($RemoteAddr)) {
            $RemoteAddr = $ARGV[$i];
        } elsif(!defined($ReqFiles)) {
            $ReqFiles = $ARGV[$i];
        } elsif(!defined($OutFiles)) {
            $OutFiles = $ARGV[$i];
        } elsif(!defined($MessForRem)) {
            $MessForRem = $ARGV[$i];
        } else {
            &Logger("Error: too many arguments - $StrParams\n");
            exit(1);
        }
        $Protect = 1 if !defined($Protect);
        $CurDate = &GetDate();
        $CurTime = &GetTime();
    }
    &Logger("$CurDate $CurTime Get REQ from $RemoteAddr\n");
}
#Ok
####################
sub ReadREQ
{
    open(REQ,$ReqFiles) || die "Cannot read file with FREQ requests.\n";
    while(<REQ>) {
        chop;
        next if(/^$/);
        next if(/^\|/);
        ($InReqFile, $InPasswd, $Musor) = split(/\|/, $_, 3);
        # Now we find REQ file in Areas
        &FindFiles($InReqFile, $InPasswd);
    }
    close REQ;
}
#Ok
####################
sub FindFiles
{
    my($a) = $_[0];          # File Name from REQ
    my($b) = $_[1];          # Password from there  ;)
    my($flag);
    my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev);
    my($atime,$mtime,$ctime,$blksize,$blocks);
    my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
    my($c,$d,$e,$f);
    $flag = 0;
    open(FL,$DList) || die "Cannot read $DList\n";
    while(<FL>) {
        # FileName AreaPath AreaAccess
        ($c, $d, $e,) = split(/[\t]+/, $_, 3);
        $f = 3 if($e =~ /P/);
        $f = 2 if($e =~ /L/);
        $f = 1 if($e =~ /A/);
        if($c eq $a) {
            #Permissions!
            if($Protect < $f) {
                $RulezFileName[$q] = $a;
                $RulezFileDate[$q] = "-none-";
                $RulezFileSize[$q] = "-none-";
                $RulezFileDesc[$q] = "You are _NOT_ allowed to FREQ this file. Access denided.";
                $SuxFile[$q] = 1;
                $q++;
                $flag = 1;
                &Logger("\t$a\tAccess denided.\n ");
                last;
            } else {
                $RulezFileName[$q] = $a;
                $RulezFilePath[$q] = $d."/".$a;
                if(defined($Descs)) {
                    $RulezFileDesc[$q] = &OpenDesc($Descs."/".$a.".desc");
                } else {
                    $RulezFileDesc[$q] = &OpenDesc($d."/".$a.".desc");
                }
                ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev,
                 $RulezFileSize[$q], $atime, $mtime, $ctime,
                 $blksize, $blocks) = stat("$RulezFilePath[$q]");
                ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,
                 $isdst) = localtime($mtime);
                $mon++;
                $RulezFileDate[$q] = sprintf("%02d-%02d-%02d", $mday,
                                             $mon, $year);
                $TotalSize += $RulezFileSize[$q];
                $SuxFile[$q] = 0;
                $q++;
                $flag = 1;
                last;
            }
        }
    }
    close FL;
    if($flag == 0) {
        &RunAlias($a);
    }
}
####################
sub RunAlias
{
    my($a) = $_[0];
    my($b, $c, $d);
    my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev);
    my($size,$atime,$mtime,$ctime,$blksize,$blocks);
    my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
    my($flag);
    $flag = 0;
    open(ALS,$Aliases) || die "Cannot open $Aliases\n";
    while(<ALS>) {
        /^#/		&& next;
        /^[ \t]*$/	&& next;
        chop;
        ($b, $c, $d, $e) = split(/[ \t]+/, $_, 4);
        if($b eq $a) {
            ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev, $size,
             $atime, $mtime, $ctime, $blksize, $blocks) = stat("$d");
            ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,
             $isdst) = localtime($mtime);
	    $mon++;
            $RulezFileDate[$q] = sprintf("%02d-%02d-%02d", $mday,
                                         $mon, $year);
            $RulezFileName[$q] = $c;
            $RulezFilePath[$q] = $d;
            $RulezFileDesc[$q] = $e;
            $RulezFileSize[$q] = $size;
	    $SuxFile[$q] = 0;
            $TotalSize += $RulezFileSize[$q];
            $q++;
            $flag = 1;
            last;
        }
    }
    if($flag == 0) {
        $RulezFileName[$q] = $a;
        $RulezFileDate[$q] = "-none-";
	$RulezFileSize[$q] = "-none-";
	$RulezFileDesc[$q] = "File _NOT_ found. Sorry.";
	$SuxFile[$q] = 1;
	$q++;
        &Logger("\t$a\tNOT found.\n ");
    }
    close ALS;
}
####################
sub WriteInOut
{
    my($i);
    open(OUT,">$OutFiles") || die "Cannot write in $OutFiles\n";
    for($i=1; $i<$q; $i++) {
        if($SuxFile[$i] != 1) {
            printf OUT "$RulezFilePath[$i]\t$RulezFileName[$i]\n";
            &Logger("\t$RulezFileName[$i]\t$RulezFilePath[$i]\n");
        }
    }
    close OUT;
}
####################
sub WriteInMFR
{
    my($OUTF);
    open(MFR,">$MessForRem") || die "Cannot write in $MessForRem\n";
    $OUTF = select(MFR);
    print "\n";
    &DoMFR();
    print "\n\tFileNames in UpperCase and LowerCase are DIFFERENT.\n";
    print "\t\t\tYou are WARNED.\n\n";
    close MFR;
    select($OUTF);
}
####################
sub DoMFR
{
    my($i);
format MFR =
@<<<<<<<<<<<<<<<<<<<<<< @>>>>>>> @<<<<<<< ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$fn,                    $fs,     $fd,     $fdesc
~~                                        ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                          $fdesc
.
        for($i=1; $i<$q; $i++) {
            $fn = $RulezFileName[$i];
            $fs = $RulezFileSize[$i];
            $fd = $RulezFileDate[$i];
            $fdesc = $RulezFileDesc[$i];
            write;
        }
    print "$TailMFR";
}
#########################
# That's all, folks  ;) #
#########################
