#!/usr/bin/perl
################################################################################
##	                  File List Generator v.0.1.2		   	      ##
##   Written by Andy Pershin <apa@penza.com.ru> AKA 2:5059/9.15@fidonet       ##
##	      Last corrections at Wed Sep  3 08:28:54 MSD 1997		      ##
################################################################################
# Full Name of configuration file.
$Config="/usr/fido/etc/efreqp.conf";
################################################################################
#mkdir "/tmp/flgen", 0700 || die "Cannot create directory in /tmp\n";
ReadConfig();
ReadAreas();
#system "rm -rf /tmp/flgen" || die "Cannot remove directory /tmp/flgen\n";
###########################
####### Subrutines here
sub ReadConfig
{
    my( $KeyWord, $Value );
    open(CONF,$Config) || die "Cannot open $Config. Please check.\n";
    while(<CONF>) {
        /^#/		&& next;
        /^[ \t]*$/	&& next;
        chop;
        ($KeyWord, $Value) = split(/[ \t]+/, $_, 2);
        if($KeyWord =~ /^Areas/) {
            $Areas = $Value;
        } elsif($KeyWord =~ /^Descs/) {
            $Descs = $Value;
        } elsif($KeyWord =~ /^Aliases/) {
            $Aliases = $Value;
        } elsif($KeyWord =~ /^DList/) {
            $DList = $Value;
        } elsif($KeyWord =~ /^DescMiss/) {
            $DescMiss = $Value;
        } elsif($KeyWord =~ /^Header/) {
            $Header = $Value;
        }
    }
    $DescMiss = "Description missing." if !defined($DescMiss);
    die "Undefined the ~Areas~ parameter in $Config.\n" if !defined($Areas);
    die "Undefined the ~DList~ parameter in $Config.\n" if !defined($DList);
    $Header = "/dev/null" if !defined($Header);
    close CONF;
}
###########################
sub ReadAreas
{
    PrintBanner();
    PrintAliases();
    open(Flist,">$DList") || die "Cannot write to filelist\n";
    open(A,$Areas) || die "Cannot read $Areas. Please check\n";
    while(<A>) {
        /^#/		&& next;
        /^[ \t]*$/	&& next;
        chop;
        ($AreaAccess, $AreaName, $AreaPath, $AreaDesc) = split(/[ \t]+/, $_, 4);
        $TAreaAccess = "For All" if($AreaAccess =~ /A/);
        $TAreaAccess = "For Listed Users" if($AreaAccess =~ /L/);
        $TAreaAccess = "For Protected Users" if($AreaAccess =~ /P/);
format TopArea = 


+------------------------------------------------------------------------------+
| Area: @<<<<<<<<<<<<<<<<<<        @>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> |
         $AreaName,               $AreaDesc
+----------------+-----------------------------------+-------------------------+
                 | Access Level: @|||||||||||||||||| |
                                 $TAreaAccess
                 +-----------------------------------+

.
format DataArea = 
^<<<<<<<<<<<<<<<<<<<<<<<<<< [@]@>>>>>>> @<<<<<<< ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$RulezFile, $RulezFileFlag, $RulezFileSize, $RulezFileDate, $RulezFileDesc
^<<<<<<<<<<<<<<<<<<<<<<<<                      ~~^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$RulezFile,                                      $RulezFileDesc
.
$! = 1;
$- = 0;
$^ = TopArea;
$~ = DataArea;
$= = 100000;

        chdir($AreaPath) || die "Cannot change directory $AreaPath\n";
        foreach $CurFile (<*>) {
            if(-f $CurFile) {
                $RulezFile = $CurFile;
                print Flist "$RulezFile\t$AreaPath\t$AreaAccess\n";
                ($dev, $ino, $mode, $nlink, $uid, $gid, $rdev,
                 $RulezFileSize, $atime, $mtime, $ctime, $blksize,
                 $blocks) = stat("$AreaPath/$RulezFile");
                ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,
                 $isdst) = localtime($mtime);
                $mon++;
                $RulezFileDate = sprintf("%02d-%02d-%02d", $mday, $mon, $year);
                $RulezFileDesc = OpenDesc($Descs."\/".$RulezFile,$AreaPath."\/".$RulezFile);
                #$RulezFileDesc = OpenDesc($AreaPath."\/".$RulezFile) if !defined($Descs);
                $GlobalSize += $RulezFileSize;
                $GlobalKvo++;
                if (time() - $mtime < (7 * 24 * 3600)) {
                    $RulezFileFlag = "*";
                } else {
                    $RulezFileFlag = " ";
                }
                write;
            }
        }
    }
    close A;
    close FList;
    print "\n\n";
    print "=" x 80;
    print "\n";
    $GlobalSize = sprintf("%9.3f",$GlobalSize/1024);
    print "\t\tTotal: $GlobalSize KyloBytes in $GlobalKvo files\n";
    print "=" x 80;
    print "\n";
}
##########
sub PrintBanner
{
    my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,$isdst);
    my($GenDate, $GenTime);
    open(GlHead,$Header) || die "Cannot open $Header \n";
    while(<GlHead>) {
        print;
    }
    close GlHead;
    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday,
     $isdst) = localtime(time());
    $mon++;
    $GenDate = sprintf("%02d-%02d-%02d", $mday, $mon, $year);
    $GenTime = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
    print "\n\t\t\tGenerated $GenDate $GenTime\n";
}
##########
sub PrintAliases
{
    my($a, $b, $c, $d);
    my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev);
    my($size,$atime,$mtime,$ctime,$blksize,$blocks);
    my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
format TopAlias = 


+------------------------------------------------------------------------------+
|                       Available aliases for FREQ:                            |
+------------------------------------------------------------------------------+
|                                                                              |
.
format DataAlias = 
| ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<       ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< |
$a,                                    $d
~~                                     ^<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< |
                                       $d
.

$! = 1;
$- = 0;
$^ = TopAlias;
$~ = DataAlias;
$= = 100000;
open(ALS,$Aliases) || die "Cannot open $Aliases\n";
while(<ALS>) {
    chop;
    /^#/       	&& next;
    /^[ \t]*$/	&& next;
    ($a, $b, $c, $d) = split(/[ \t]+/, $_, 4);
    write;
}
close ALS;
print "+";
print "-" x 78;
print "+\n";
}
##########
sub OpenDesc
{
    my($dfile) = $_[0];
    my($rfile) = $_[1];
    my($text) = "";
    $dfile .= ".desc";
    open(Descr,"$dfile") || return $text = ProcessInFile($rfile,$dfile);
    while(<Descr>) {
        chop;
        $text .= $_;
    }
    close Descr;
    return $text;
}
##########
sub ProcessInFile
{
    my($file) = $_[0];
    my($dfile) = $_[1];
    my($text) = "";
    my($text1) = "";
    my($musor, $flag);
    if($file =~ /\.[Rr][Pp][Mm]$/) {
        open(Q, "rpm -qip $file |") || die "Your $file is RPM binary, it is must die\n";
        while(<Q>) {
            chop;
            if($flag == 1) {
                $text1 .= $_;
                next;
            }
            if($_ =~ /^Summary(\s)*:/) {
                ($musor, $text) = split(/:\s/);
            }
            if($_ =~ /^Description(\s)*:/) {
                $flag = 1;
                next;
            }
        }
        close Q;
        if($text eq "" || $text eq "(none)") {
            $text = $text1;
        }
    } elsif($file =~ /\.[Tt][Aa][Rr]$/) {
        # tar Oxf filename.tar >/tmp/flgen/qwerty
        $flag = 0;
        $text = $DescMiss;
    } else {
        $text = `file $file`;
	$file =~ s/\$/\\\$/g;
        $file =~ s/\^/\\\^/g;
        $file =~ s/\+/\\\+/g;
	$file =~ s/\&/\\\&/g;
	$file =~ s/\(/\\\(/g;
	$file =~ s/\)/\\\)/g;
	$file =~ s/\[/\\\[/g;
	$file =~ s/\]/\\\]/g;
	$file =~ s/\`/\\\`/g;
	$file =~ s/\'/\\\'/g;
        $file =~ s/\"/\\\"/g;
        $text =~ s/$file: //;
    }
    if($text =~ /^data$/) {
        $text = $DescMiss;
    }
    open(D,">$dfile") || die "Cannot write Description for $file\n";
    print D "$text\n";
    close D;
    return $text;
}
##########
sub ReadDiz
{
    my($a) = $_[0];
    my($b) = "";
    open(Q,"$a") || return $DescMiss;
    while(<Q>) {
        chop;
        $b .= $_;
        $b .= " ";
    }
    close Q;
    return $b;
}
##########
