#!/usr/bin/perl

# $Id: kosher.pl,v 1.8 1997/12/02 23:16:28 crosser Exp crosser $
#
# $Log: kosher.pl,v $
# Revision 1.8  1997/12/02 23:16:28  crosser
# allow 7bit along with 8bit transfer-encoding
#
# Revision 1.7  1997/12/01 06:14:22  crosser
# check only start of words in body
#
# Revision 1.6  1997/11/28 22:44:22  crosser
# fix bug with charset in quotes
#
# Revision 1.5  1997/11/27 21:31:15  crosser
# allow content-type text and quotes around koi8-r
#
# Revision 1.4  1997/11/25 22:01:07  crosser
# check headers correctly
#
# Revision 1.3  1997/11/24 00:43:26  crosser
# Add parameter to rfc822putheader: filter or not filter?  That is the question.
#
# Revision 1.2  1997/11/23 23:47:22  crosser
# add comment
#

# Check if the article is kosher (proper content-type and charset).
# Copyright (c) 1997 Eugene G. Crosser

sub kosher {
	local($body,@header)=@_;
	local($ng,$ct,$cte,$h,$w,$suspect);

	$ng=&rfc822hdr("Newsgroups",@header);
	unless ($ng) {
		return "No \"Newsgroups:\" header in the article";
	}
	if ($ng =~ /,/) {
		return "More than one newsgroup requested, only one allowed";
	}

	$ct=&rfc822hdr("Content-Type",@header);
	if ($ct) {
		if (($ct =~ /text\/plain/i) || ($ct =~ /text\s/i)) {
			if ($ct =~ /[\s;]charset="{0,1}([^\s,;"]*)"{0,1}/i) {
				if ($1 !~ /^koi8-r$/i) {
					return "charset \"$1\" present and is not \"koi8-r\"";
				}
			}
		} else {
			return "Content-type is not \"text/plain\", all others disallowed";
		}
	}

	$cte=&rfc822hdr("Content-Transfer-Encoding",@header);
	if ($cte) {
		if ($cte !~ /[78]bit/i) {
			return "Content-Transfer-Encoding is not \"7bit\" or \"8bit\", not allowed";
		}
	}

	foreach $h(@header) {
		if ($h =~ /\s=[\w-]*\?[QB]\?/i) {
			return "MIME-encoded headers present, not allowed";
		}
	}

	foreach $w(split(/\s/,$body)) {
		if ($w =~ /^[][]{2,}/) {
			$suspect++;
		}
		if ($w =~ /^[a-z][A-Z]{2,}/) {
			$suspect++;
		}
	}

	if ($suspect > 1) {
		return "Body of the article looks like Russian text in other than koi8 encoding";
	}

	return "OK";
}

1;
