BEGIN {

#  -[ Default variables ]--------------------------------------------

   OldBase = "C:\\USR\\FILES"
   NewBase = "/files"
   Exclude = "'files.bbs' '.+\.desc'"
   AnnEcho = "filefix.announce"
   Mode     = 664

#  -[ Internal variables ]-------------------------------------------

   Passthru = 0
   Announce = 0
}
{
   if ($1 == "Name") printf "\nArea %s\n", $3
   if ($1 == "Desc") {
       printf "Desc"
       for (i=3; i<NF; i++) printf " %s", $i
       printf "\n"
   }
   if ($1 == "Dest") {
      if ($3 == "Pass" && $4 == "through") {
         Passthru = 1
         next
      }
      NP = split(substr($3,length(OldBase)+2),pth,"\\")
      printf "Path %s", NewBase
      for (i=1; i<NP; i++) printf "\/%s", tolower(pth[i])
      printf "\n"
   }
   if ($1 == "Announce" && $3 == "Yes") print "Newfile", AnnEcho
   if ($1 == "Group") {
      print "Group", $3
      print "Exclude", Exclude
   }
   if ($1 == "Max" && $2 == "days") {
      if (Passthru == 1) {
         print "Save 0"
         Passthru = 0
      }
      else {
         if ($4 == 0) print "Save -1"
         else print "Save", $4
      }
   }
   if ($1 == "Use" && $2 == "aka") print "AKA", $4
   if ($1 == "Export" && $2 == "Systems") {
      printf "Links"
      getline
      getline
      while (NF) {
          if ($1 == "B" || $1 == "R") printf " %s", $2
          if ($1 == "S") printf " !%s", $2
          if ($1 == "I") printf " [!]%s", $2
          if ($3 == "B" || $3 == "R") printf " %s", $4
          if ($3 == "S") printf " !%s", $4
          if ($3 == "I") printf " [!]%s", $4
          getline
      }
      printf "\nMode %d\n", Mode
   }
}
END {printf "\n"}
