sub Namer {
	&ReadAreas() || return 0;
	&SetNames() || return 0;
	&WriteAreas() || return 0;
	return 1;
}

sub SetNames {
	local( @lfiles, $lst );
	local( $flag, $area, $desc, $other );

	if( !&TestConfig( "ECHOLIST" )) {
		&logger( 3, "EchoList not defined.", "warning" );
		return 0;
	}
	@lfiles = <$FConfig{'ECHOLIST'}>;
	if( $#lfiles == -1 ) {
		&logger( 0, "EchoList not found.", "err" );
		return 0;
	}
	if( !open( lst, $lfiles[0] )) {
		&logger( 0, "Cannot open file ".$FConfig{'ECHOLIST'}.". $!", "err" );
		return 0;
	}
	&logger( 3, "Setting description for areas.", "info" );
	while( <lst> ) {
		chop;
		chop; # ms-dos
		if(( /^Area/i ) || ( /^Down/i ) || ( /^Lost/i ) || ( /^Hold/i )) {
			( $flag, $area, $desc, $other ) = split( /[ \t]+/, $_, 4 );
			$area =~ tr/a-z/A-Z/;
			$desc =~ s/_/ /g;
			$AreaDesc{$area} = $desc;
		}
	}
	close( lst );
	return 1;
}
