
sub Scaner {
	local( $i );
	local( $outpath );

	$ScanTime = time;
	if( defined( $FConfig{'LASTSCAN'} )) {
		if( ! -e $FConfig{'LASTSCAN'} ) {
			system "touch $FConfig{'LASTSCAN'}";
			&logger( 0, "Do nothing - LastScan file not found. Creating.", "warning" );
			return 1;
		}
		$LastScanTime = ( stat( $FConfig{'LASTSCAN'} ))[9];
		utime $ScanTime, $ScanTime, $FConfig{'LASTSCAN'};
	} else {
		$LastScanTime = $ScanTime;
	}

	&ReadAreas() || return 0;
	&ReadUsers() || return 0;

	undef( %UserSaved );
	for( $i = 0; $i <= $#UserAddr; $i++ ) {
		$UserSaved{$UserAddr[$i]} = 1;
	}
	for( $i = 0; $i <= $#AreaName; $i++ ) {
		next if( $AreaName[$i] =~ /^default/ );
		&ScanArea( $AreaName[$i] );
	}
	if( $FConfig{'SENDANNOUNCE'} =~ /^[yY]/ ) {
		&MessageOfNewFiles();
	}
#scan saved files
	for( $i = 0; $i <= $#UserAddr; $i++ ) {
		next if( $UserSaved{$UserAddr[$i]} == 0 );
		if( $UserFlags{$UserAddr[$i]} =~ /\+[hH]/ ) {
			$suffix = ".hlo";
		} else {
			$suffix = ".flo";
		}
		$outpath = &OutPath( $UserAddr[$i] );
		if( &mklock( $outpath.".bsy", 1 )) {
			&ScanSaved( $outpath, $suffix, $UserAddr[$i] );
			unlink( $outpath.".bsy" );
		}
	}
	return 1;
}

sub RemoveIfExist {
	local( $file ) = $_[0];
	local( $name, $path, $tics );

	return if( ! -e $file );

	system "rm -f ".$file;
	$path = basepath( $file );
	$name = basename( $file );
	$name = &toupper( $name );
	return if( ! open( tics, "grep -li ".BadName($name)." $path/*.[Tt][Ii][Cc] 2>/dev/null |" ));
	while( <tics> ) {
		chop;
		system "rm -f ".$_;
	}
	close( tics );
}

sub ScanSaved {
	local( $outpath ) = $_[0];
	local( $suffix ) = $_[1];
	local( $faddr ) = $_[2];
	local( $lo, $oplo, $slo, $sto, $sfrom );
	$oplo = 0;
	if( -s $outpath.".ofl/save.flo" ) {
		if( !open( slo, $outpath.".ofl/save.flo" )) {
			&logger( 0, "Cannot read ".$outpath.".ofl/save.flo for $links[$i] [$!].", "err" );
		} else {
			while( <slo> ) {
				chop;
				next if( /^[ \t]*$/ );
				if( $oplo == 0 ) {
					if( ! open( lo, ">>".$outpath.$suffix )) {
						&logger( 0, "Cannot write $outpath.$suffix for $links[$i] [$!].", "err" );
						unlink( $outpath.".bsy" );
						last;
					}
					$oplo = 1;
				}
				$sto = $_;
				$sto =~ s/^\^//;
				$sfrom = $sto;
				$sfrom =~ s/\.flx\//.ofl\//;
				next if( ! -e $sfrom );
				&RemoveIfExist( $sto ) if( $sto !~ /\.[tT][iI][cC]$/ );
				if( link( $sfrom, $sto )) {
					print lo "^".$sto."\n";
					&logger( 3, "Send ".&basename( $sto )." to ".$faddr, "info" ) if( $sto !~ /\.tic/i );
					unlink( $sfrom );
				}
			}
			close( slo );
			unlink( $outpath.".ofl/save.flo" ) if( $oplo );
		}
	}
	close( lo ) if( $oplo );
	$oplo = 0;
	if( -s $outpath.".ofl/save.hlo" ) {
		if( !open( slo, $outpath.".ofl/save.hlo" )) {
			&logger( 0, "Cannot read ".$outpath.".ofl/save.hlo for $links[$i] [$!].", "err" );
		} else {
			while( <slo> ) {
				chop;
				next if( /^[ \t]*$/ );
				if( $oplo == 0 ) {
					if( ! open( lo, ">>".$outpath.$suffix )) {
						&logger( 0, "Cannot write $outpath.$suffix for $links[$i] [$!].", "err" );
						unlink( $outpath.".bsy" );
						last;
					}
					$oplo = 1;
				}
				$sto = $_;
				$sto =~ s/^\^//;
				$sfrom = $sto;
				$sfrom =~ s/\.flx\//.ofl\//;
				next if( ! -e $sfrom );
				&RemoveIfExist( $sto ) if( $sto !~ /\.[tT][iI][cC]$/ );
				if( link( $sfrom, $sto )) {
					print lo "^".$sto."\n";
					&logger( 3, "Send ".&basename( $sto )." to ".$faddr, "info" ) if( $sto !~ /\.tic/i );
					unlink( $sfrom );
				}
			}
			close( slo );
			unlink( $outpath.".ofl/save.hlo" ) if( $oplo );
		}
	}
	close( lo ) if( $oplo );
}

sub OutPath {
	local( $addr ) = $_[0];
	local( $mdir ) = 0;
	local( $path );
	local( $zone, $net, $node, $point );

	$mdir = $_[1] if( defined( $_[1] ));
	( $zone, $net, $node, $point ) = &ParseAddr( $addr );
	$path = $FConfig{'OUTBOUND'};
	$path = $path.sprintf( ".%03x", $zone ) if( $zone != $my_zone );
	if( $mdir && ( !-d $path )) {
		if( ! mkdir( $path, 0700 )) {
			&logger( 0, "Cannot create directory $path [$!].", "err" );
			return "";
		}
	}
	$path = $path.sprintf( "/%04x%04x", $net, $node );
	if( ! $point ) {
		return $path;
	} else {
		$path = $path.".pnt";
		if( $mdir && ( !-d $path )) {
			if( ! mkdir( $path, 0700 )) {
				&logger( 0, "Cannot create directory $path [$!].", "err" );
				return "";
			}
		}
		$path = $path.sprintf( "/%08x", $point );
		return $path;
	}
}

sub ScanArea {
	local( $area ) = $_[0];
	local( $hdir, $dfile, $exclude, $i, $ftime, $fmode, $tics, $ticdir, $ftic, $links, $myaddr );
	local( $SaveTic, $SaveTicDesc, $SaveTicLDesc, $SaveTicPath, $SaveTicSeenby );
	local( $OldFrom, $announce, $crfile, $t );
	local( $zone, $net, $node, $point, $atmp );
	local( $outpath, $descdir, $stics, $sto, $sfrom );

	if( ! opendir( hdir, $AreaPath{$area} )) {
		&logger( 0, "Cannot open directory for $area [$!].", "err" );
		return 0;
	}
	@exclude = split( /'*[ \t]+'*/, " ".$AreaExclude{$area}." " );
	if( $FConfig{'DESCDIR'} =~ /^\// ) {
		$descdir = $FConfig{'DESCDIR'};
	} else {
		$descdir = $AreaPath{$area}."/".$FConfig{'DESCDIR'};
	}
input:	while(( $dfile = readdir( hdir )) ne "" ) {
		next input if( $dfile =~ /^\.\.*$/ );
		next input if( ! -f $AreaPath{$area}."/".$dfile );
		for( $i = 0; $i <= $#exclude; $i++ ) {
			next if( $exclude[$i] eq "" );
			next input if( $dfile =~ /$exclude[$i]/ );
		}
		$ftime = ( stat( $AreaPath{$area}."/".$dfile ))[9];
		$fmode = ( stat( $AreaPath{$area}."/".$dfile ))[2];
		if( defined( $AreaSave{$area} ) && ( $AreaSave{$area} > 0 )) {
			if(( $ftime + $AreaSave{$area} * 86400 ) < $ScanTime ) {
				&logger( 5, "File ".BadName( $dfile )." too old, removed.", "info" );
				system "rm -f ".$AreaPath{$area}."/".BadName($dfile)." ".$descdir."/".BadName($dfile).".desc";
				next input;
			}
		}
		if( defined( $FConfig{'LASTSCAN'} )) {
			next input if( $ftime < $LastScanTime );
		} else {
			next input if(( $fmode & 01000 ) == 0 );
			$fmode = sprintf( "chmod 0%o, \"%s\"", $fmode ^ 01000, $AreaPath{$area}."/".BadName($dfile));
			if( ! eval $fmode ) {
				&logger( 0, "Cannot clear sticky bit on ".$AreaPath{$area}."/".BadName($dfile).". Hatch abort. $!", "err" );
				next input;
			}
		}
		$ftic = "";
		undef %Tic;
		undef @TicVia;
		undef @TicDesc;
		undef @TicLDesc;
		undef @TicPath;
		undef @TicSeenby;
		$announce = 1;
		if( &TestConfig( 'TICDIR' )) {
			if( $FConfig{'TICDIR'} =~ /^\// ) {
				$ticdir = $FConfig{'TICDIR'};
			} else {
				$ticdir = $AreaPath{$area}."/".$FConfig{'TICDIR'};
			}
			$df = &toupper( $dfile );
			if( open( tics, "grep -li ".BadName($df)." $ticdir/*.[Tt][Ii][Cc] 2>/dev/null |" )) {
				$ftic = <tics>;
				chop $ftic;
				close( tics );
				&ReadTic( $ftic ) if( $ftic ne "" );
				system "rm -f $ftic";
				$announce = 0 if( $#TicPath >= 0 );
			}
		}
		if( defined( $AreaAKA{$area} )) {
			$myaddr = $AreaAKA{$area};
		} else {
			$myaddr = $FConfig{'ADDRESS'};
		}
		$Tic{'FILE'} = $dfile if( ! defined( $Tic{'FILE'} ));
		$Tic{'AREA'} = $area if( ! defined( $Tic{'AREA'} ));
		$Tic{'ORIGIN'} = $myaddr if( ! defined( $Tic{'ORIGIN'} ));
		if( defined( $Tic{'FROM'} )) {
			$OldFrom = $Tic{'FROM'};
		} else {
			$OldFrom = "";
		}
		$Tic{'FROM'} = $myaddr;
		$Tic{'SIZE'} = ( stat( $AreaPath{$area}."/".$dfile ))[7] if( ! defined( $Tic{'SIZE'} ));
		$Tic{'DATE'} = $ftime if( ! defined( $Tic{'DATE'} ));
		if( ! defined( $Tic{'CRC'} )) {
			if( open( tics, "$FConfig{'BINDIR'}/crc32 < $AreaPath{$area}/".BadName($dfile)." |" ))  {
				$Tic{'CRC'} = <tics>;
				chop $Tic{'CRC'};
				close( tics );
			} else {
				&logger( 5, "Cannot calculate CRC for ".BadName($dfile).".", "err" );
			}
		}
		if( $#TicDesc == -1 ) {
			$i = 0;
			undef @TicLDesc;
			if( open( tics, $descdir."/".$dfile.".desc" )) {
				while( <tics> ) {
					chop;
					if( /^[ \t]*$/ ) {
						$i = 1;
						next;
					}
					if( $i == 0 ) {
						$TicDesc[$#TicDesc + 1] = $_;
					} else {
						$TicLDesc[$#TicLDesc + 1] = $_;
					}
				}
				close( tics );
			} else {
				&logger( 5, "Cannot find descriptor for ".BadName($dfile).".", "err" );
## if not send without descriptor
				next input;
## else
#				if( &TestConfig( 'DEFDESC' )) {
#					$TicDesc[0] = $FConfig{'DEFDESC'};
#				} else {
#					$TicDesc[0] = "Descriptor missing";
#				}
# end if
			}
		}	
		if( $announce ) {
			if( defined( $AreaNewfile{$area} )) {
				if( ! -e $AreaNewfile{$area} ) {	
					$crfile = ">";
				} else {
					$crfile = ">>";
				}
				if( ! open( t, $crfile.$AreaNewfile{$area} )) {
					&logger( 0, "Cannot write announce. Error: $!", "err" );
					$announce = 0;
				} else {
					if( $crfile eq ">" ) {
						print t "File             Size         Area                 Origin\n";
						print t "---------------- ------------ -------------------- ----------------\n";
					}
					print t sprintf( "%-16s %-12d %-20s %-16s\n", $Tic{'FILE'}, $Tic{'SIZE'}, $area, $Tic{'ORIGIN'} );
					print t "Fullname: ".$Tic{'FULLNAME'}."\n" if( defined( $Tic{'FULLNAME'} ));
					for( $i = 0; $i <= $#TicDesc; $i++ ) {
						print t $TicDesc[$i]."\n";
					}
					if( $#TicLDesc > -1 ) {
						print t "\n";
						for( $i = 0; $i <= $#TicLDesc; $i++ ) {
							print t $TicLDesc[$i]."\n";
						}
					}
					print t "-------------------------------------------------------------------\n";
					close( t );
				}
			}
		}
		$TicPath[$#TicPath + 1] = $myaddr." ".&strtime( 'path' );
		undef @links;
		undef @slinks;
		@links = split( /[ \t]+/, $AreaLinks{$area} );
		for( $i = 0; $i <= $#links; $i++ ) {
			if( find( $links[$i], @TicSeenby ) == -1 ) {
				$slinks[$#slinks+1] = $links[$i];
			}
		}
		if( defined( $AreaAKA{$area} )) {
			@links = split( /[ \t]+/, $FConfig{'ADDRESS'}." ".$AreaLinks{$area} );
		}
		if( &find( $myaddr, @links ) == -1 ) {
			$links[$#links+1] = $myaddr;
		}
		for( $i = 0; $i <= $#links; $i++ ) {
			next if( $links[$i] =~ /^\!*\-\!*/ );
			$links[$i] =~ s/\!//;
 			if(( $links[$i] ne $OldFrom ) && ( &find( $links[$i], @TicSeenby ) == -1 )) {
				$TicSeenby[$#TicSeenby + 1] = $links[$i];
			}
		}
		@links = @slinks;
		for( $i = 0; $i <= $#TicSeenby; $i++ ) {
			$TicSeenby[$i] = sprintf( "%05d%05d%05d%05d", &ParseAddr( $TicSeenby[$i] ));
		}
		@atmp = @TicSeenby;
		@TicSeenby = sort { $a <=> $b } @atmp;
		for( $i = 0; $i <= $#TicSeenby; $i++ ) {
			( $zone, $net, $node, $point ) = ( $TicSeenby[$i] =~ /([0-9]{5})([0-9]{5})([0-9]{5})([0-9]{5})/ );
			if( $point =~ /^0+$/ ) {
				$TicSeenby[$i] = sprintf( "%d:%d/%d", $zone, $net, $node );
			} else {
				$TicSeenby[$i] = sprintf( "%d:%d/%d.%d", $zone, $net, $node, $point );
			}
		}
		%SaveTic = %Tic;

		$atmp = $FConfig{'OUTBOUND'}."/".$dfile;
		if( ! -e $atmp ) {
			system "cp $AreaPath{$area}/".BadName($dfile)." ".$FConfig{'OUTBOUND'}."/".&BadName($dfile);
		}
		if( ! -e $atmp ) {
			&logger( 0, "Cannot copy ".BadName($dfile)." in to outbound [$!].", "err" );
			return 0;
		}
		for( $i = 0; $i <= $#links; $i++ ) {
			next if( $links[$i] =~ /^\!*\-/ );
			$links[$i] =~ s/\!//;
			next if( $links[$i] eq $OldFrom );
			%Tic = %SaveTic;
			$Tic{'TO'} = $links[$i];
			$Tic{'PW'} = $UserPasswd{$links[$i]};
			$ftic = &MakeTicName( $links[$i], $Tic{'CRC'}, $area );
			if( $UserFlags{$links[$i]} =~ /\+[hH]/ ) {
				$suffix = ".hlo";
			} else {
				$suffix = ".flo";
			}
			$outpath = $FConfig{'OUTBOUND'};
			if( ! -d $outpath ) {
				if( ! mkdir( $outpath, 0700 )) {
					&logger( 0, "Cannot create filefix directory [$!].", "err" );
					next;
				}
			}
			$outpath = &OutPath( $links[$i], 1 );
			if( ! -d $outpath.".flx" ) {
				if( ! mkdir( $outpath.".flx", 0700 )) {
					&logger( 0, "Cannot create directory $outpath.flx [$!].", "err" );
					next;
				}
			}
# try make .bsy on link
			if( &mklock( $outpath.".bsy", 1 )) {
# look for save (.bsy) files
				&ScanSaved( $outpath, $suffix, $links[$i] );
# send current files
				if( ! open( tics, ">>".$outpath.$suffix )) {
					&logger( 0, "Cannot write $outpath.$suffix for $links[$i] [$!].", "err" );
					unlink( $outpath.".bsy" );
					next;
				}
				print tics "^".$outpath.".flx/".$dfile."\n";
				print tics "^".$outpath.".flx/".$ftic."\n";
				close( tics );
				&logger( 3, "Send ".$dfile." to $Tic{'TO'}", "info" );
				system "rm -f `grep -li ".BadName($dfile)." ".$outpath.".flx/*.tic 2>/dev/null`";
				&RemoveIfExist( $outpath.".flx/".$dfile );
				if( link( $atmp, $outpath.".flx/".$dfile )) {
					utime $Tic{'DATE'}, $Tic{'DATE'}, $outpath.".flx/".$dfile;
					&WriteTic( $outpath.".flx/".$ftic );
				} else {
					&logger( 0, "Cannot create link ".$atmp." to ".$outpath.".flx/".$dfile." [$!].", "err" );
				}
				unlink( $outpath.".bsy" );
				$UserSaved{$links[$i]} = 0;
			} else {
# .bsy found
				if( ! -d $outpath.".ofl" ) {
					if( ! mkdir( $outpath.".ofl", 0700 )) {
						&logger( 0, "Cannot create directory $outpath.ofl [$!].", "err" );
						next;
					}
				}
				if( ! open( tics, ">>".$outpath.".ofl/save".$suffix )) {
					&logger( 0, "Cannot write ".$outpath.".ofl/save".$suffix." for $links[$i] [$!].", "err" );
					next;
				}
				print tics "^".$outpath.".flx/".$dfile."\n";
				print tics "^".$outpath.".flx/".$ftic."\n";
				close( tics );
				&logger( 3, "Save ".$dfile." for $Tic{'TO'}", "info" );
				system "rm -f `grep -li ".BadName($dfile)." ".$outpath.".ofl/*.tic 2>/dev/null`";
				&RemoveIfExist( $outpath.".ofl/".$dfile );
				if( link( $atmp, $outpath.".ofl/".$dfile )) {
					utime $Tic{'DATE'}, $Tic{'DATE'}, $outpath.".ofl/".$dfile;
					&WriteTic( $outpath.".ofl/".$ftic );
				} else {
					&logger( 0, "Cannot create link ".$atmp." to ".$outpath.".ofl/".$dfile." [$!].", "err" );
				}
			}
		}
		unlink $FConfig{'OUTBOUND'}."/".$dfile;
		if( defined( $AreaSave{$area} )) {
			if( $AreaSave{$area} == 0 ) {
				system "rm -f ".$AreaPath{$area}."/".BadName($dfile)." ".$descdir."/".BadName($dfile).".desc";
			}
		}
		if( defined( $FConfig{'LASTSCAN'} )) {
			utime $LastScanTime - 1, $LastScanTime - 1, $AreaPath{$area}."/".$dfile;
		}
	}
	closedir( hdir );
}
