/*****************************************************************************
 *
 * Announcen
 *
 *****************************************************************************/

#include "fidogate.h"
#include "annou.h"


#ifdef ANNOU7

/* prototypes */


/*--------------------------------------------------------------------
 * announcen
 *--------------------------------------------------------------------*/
 
typedef struct st_tnode *annou_ptr;

typedef struct st_tnode {
    char *filename;
    unsigned long size;
    time_t date;
    Textlist ldesc;
    char *key;
    char *areadesc;
    char *areaname;
    int	zone;
    Node addr;
    annou_ptr left;
    annou_ptr right;
} q_annou;

q_annou *annou_queue = NULL;
int tick_test_queue = 0;
unsigned long annou_total = 0;
char annou_test_char[20] = "";
char *annou_test_echo = NULL;
char *annou_test_key = NULL;
int annou_test_open = 0;
int annou_test_counter = 0;
/*int annou_is_groups = 0;*//*global*/
AreasBBS *annou_areasbbs = NULL;
int cf_len, cf_sp;

Textlist outbody;
Message  outmsg;


void dupnode(Node d, Node s)
{
    d.zone = s.zone;
    d.net = s.net;
    d.node = s.node;
    d.point = s.point;
    BUF_COPY(d.domain, s.domain);
    d.flags = s.flags;
}

annou_ptr talloc(void)
{
q_annou *p;

    p = (annou_ptr) xmalloc(sizeof(q_annou));
    p->filename = NULL;
    p->size = 0;
    p->date = 0;
    tl_init(&p->ldesc);
    p->key = NULL;
    p->areadesc = NULL;
    p->areaname = NULL;
    p->left = NULL;
    p->right = NULL;
    return p;
}

/*-----------------------------------------------------------------------
 * annou_cmp
 *-----------------------------------------------------------------------*/
int annou_cmp(q_annou *p, Tick *tic, AreasBBS *area)
{
int cond;

    if ((!p) || (!tic) || (!area)) {
	debug(1, "annou_cmp: Error NULL Pointer");
	return 0;
    }
    if ((cond = strcmp(area->key, p->key)) == 0) {
	if ((cond = strcmp(tic->area, p->areaname)) == 0) {
	    cond = strcmp(tic->file, p->filename);
	}
    }
    return cond;
}

/*--------------------------------------------------------------------
 * annou_debug
 *--------------------------------------------------------------------*/
int annou_debug(q_annou *d)
{
Textline *pl;

    debug(2, "annou_debug: - start -");
    debug(2, "d->key.......: %s", d->key);
    debug(2, "d->areadesc..: %s", d->areadesc);
    debug(2, "d->areaname..: %s", d->areaname);
    debug(2, "d->zone......: %ld", d->zone);
    debug(2, "d->addr......: %s", node_to_asc(&d->addr, TRUE));
    debug(2, "d->filename..: %s", d->filename);
    debug(2, "d->date......: %s", date("%d.%m.%y", &d->date));
    for (pl=d->ldesc.first; pl; pl=pl->next) {
	debug(2, "d->ldesc.....: %s", pl->line);
    }
    debug(2, "d->size......: %s", d->size);
    return OK;
}

/*--------------------------------------------------------------------
 * annou_copy
 *--------------------------------------------------------------------*/
int annou_copy(q_annou *d, Tick *t, AreasBBS *area)
{

    d->key = strsave(area->key);
    d->areadesc = strsave(area->desc);
    d->areaname = strsave(area->area);
    d->zone = area->zone;
    d->addr = area->addr;
    d->filename = strsave(t->file);
    d->date = t->date;
    if (t->ldesc.first) {
	tl_addtl(&d->ldesc, &t->ldesc);
    }
    else if (t->desc.first) {
	tl_addtl(&d->ldesc, &t->desc);
    }
    d->size = t->size;
    return OK;
}

/*--------------------------------------------------------------------
 * addtree
 *--------------------------------------------------------------------*/
q_annou *addtree(q_annou *p, Tick *t, AreasBBS *area)
{
int cond;

    if (p == NULL) {
	p = talloc();
	annou_copy(p, t, area);
	p->left = p->right = NULL;
    } else if ((cond = annou_cmp(p, t, area)) == 0) {
	debug(1, "error: ticcmp==0 (doppeltes/tic/file?)");
    }
    else if (cond < 0)
	p->left = addtree(p->left, t, area);
    else
	p->right = addtree(p->right, t, area);
    return p;
}
	

/*----------------------------------------------------------------------
 * annou_add
 *----------------------------------------------------------------------*/
 int	annou_add	(Tick *tic, AreasBBS *area)
{
    annou_queue = addtree(annou_queue, tic, area);
    if (annou_queue==NULL) {
	return ERROR;
    }
    return OK;
}

int xstricmp (char *sa, char *sb)
{
    if ((sa == NULL) && (sb == NULL)) {
	return 0;
    }
    if (sa == NULL) {
	return -1;
    }
    if (sb == NULL) {
	return 1;
    }
    return (stricmp(sa, sb));
}

/*
 * charinsert
 */
void charinsert (char s1[], int ichar, int pos, int maxs1)
{
int i, len;
int ilen = 1;
    len = strlen(s1);
    if (len < maxs1) {
	maxs1 = len + 1;
    }
    
    if (len == maxs1) { return; }
    if (pos >= maxs1) { return; }
    if (pos > strlen(s1)) { return; }
    
    for (i=len; i>=0; --i)
 {
	if (i+pos+ilen <= maxs1) {
	    s1[i+pos+ilen] = s1[i+pos];
	}
    }
    s1[pos] = ichar;
}
/*-------------------------------------------------------------------
 * annou_format_line
 *-------------------------------------------------------------------*/
char *annou_format_line (char *s, size_t size, int width, int sp, Textlist *tl)
{
int i = 0;
char vbuf1[100] = "";
char vbuf2[100] = "";
char *ptr=s, *ppos;
int len1, len2;

    i = 0;    
    while ( (i <= len1) && (s[i] != 0) && (i < size) ) {
	if ((s[i]=='\t') || (s[i]=='\n') || (s[i]=='\r')) 
	    s[i]=' ';
	ptr++; ++i;
    }
    
    ptr = s;
    while (strlen (ptr)>width) {
	ppos=ptr;
	ptr += width;
	while ((!isspace (*ptr)) && (ptr!=ppos)) {
	    ptr--;
	}
	if (ptr==ppos) {
	    ptr += width;
	    BUF_COPY(vbuf2, ptr);
	    *ptr = 0; 
	} else {
	    BUF_COPY(vbuf2, ptr);
	    *ptr = 0;
	}
    }
    
    BUF_COPY(vbuf1, s);
	
    if (strlen(vbuf1) > 0) { tl_append(tl, vbuf1); }
	
    if (strlen(vbuf2) > 0) {
	i = 0;
	len2 = strlen(vbuf2);
	while ( (isspace(vbuf2[i])) && (vbuf2[i] != 0) && (i <= len2) ) {
	    ++i;
	}
	if (i < sp) {
	    while ( (i < sp) ) {
		charinsert( vbuf2, ' ', 0, sizeof(vbuf2) );
		++i;
	    }
	}
	tl_append(tl, vbuf2);
    }
    
    return s;
}

/*-------------------------------------------------------------------
 * annou_group_change
 *-------------------------------------------------------------------*/
int	annou_group_change(q_annou *pa, Textlist *tl)
{
    if (annou_test_counter == 0) {
	return FALSE;
    }
    
/*    annou_get_areasbbs(pa);*/
    
    if (xstricmp(pa->key, annou_test_key)) {
	return TRUE;
    }
    if (annou_test_counter != 0) {
	return TRUE;
    }
    return FALSE;
}

/*--------------------------------------------------------------------
 * annou_cf_expand
 *--------------------------------------------------------------------*/
char *annou_cf_expand(char *d, size_t n, char *s, q_annou *pa)
{
int i, len, dlen;
char dummy[256];

    d[0] = 0;
    
    len = strlen(s);
    
    for (i=0; (i<len); i++)
    {
	if (n < strlen(d)) {
    break; }
	if (s[i] == '%') {
	    i++;
/*	    if (s[i] == '-') {*/
/*	    }*/
/*	    if (-12) ....*/

/*	    debug(3, "if %% : i/s : %3ld/%2ld '%s'", i, s[i], d);*/
	    if (s[i] == 'R') {
		if (pa->areadesc) {
		    strcat(d, pa->areadesc);
		}
	    }
	    else if (s[i] == 'A') {
		if (pa->areaname) {
		    strcat(d, pa->areaname);
		}
	    }
	    else if (s[i] == 'F') {
		if (pa->filename) {
		    strcat(d, pa->filename);
		}
	    }
	    else if (s[i] == 'S') {
		sprintf(dummy, "%lu", pa->size);
		strcat(d, dummy);
	    }
	    else if (s[i] == 'D') {
		sprintf(dummy, "%s", date("%d.%m.%y", &pa->date));
		strcat(d, dummy);
	    }
	    else if (s[i] == 'L') {
		sprintf(dummy, "%s", pa->ldesc.first->line);
		strcat(d, dummy);
	    }
	    else if (s[i] == 'Z') {
		sprintf(dummy, "%lu", annou_total);
		strcat(d, dummy);
	    }
	}
	else {
	    dlen = strlen(d);
	    d[dlen] = s[i];
	    d[dlen+1] = 0;
	}
    }
    return d;
}

/*--------------------------------------------------------------------
 * annou_exp_file
 *--------------------------------------------------------------------*/
int	annou_exp_file(char *d, size_t n, char *s, q_annou *pa, char *s2)
{
int i, len, dlen;
char dummy[256];

    d[0] = 0;
    
    len = strlen(s);
    
    for (i=0; (i<len); i++)
    {
	if (n < strlen(d)) {
    break; }
	if (s[i] == '%') {
	    i++;
/*	    if (s[i] == '-') {*/
/*	    }*/
/*	    if (-12) ....*/

/*	    debug(3, "if %% : i/s : %3ld/%2ld '%s'", i, s[i], d);*/
	    if (s[i] == 'R') {
		if (pa->areadesc) {
		    strcat(d, pa->areadesc);
		}
	    }
	    else if (s[i] == 'A') {
		if (pa->areaname) {
		    strcat(d, pa->areaname);
		}
	    }
	    else if (s[i] == 'F') {
		if (pa->filename) {
		    sprintf(dummy, "%-12s", pa->filename);
		    strcat(d, dummy);
		}
	    }
	    else if (s[i] == 'S') {
		sprintf(dummy, "%7lu", pa->size);
		strcat(d, dummy);
	    }
	    else if (s[i] == 'K') {
		sprintf(dummy, "%6lu", (pa->size/1024));
		strcat(d, dummy);
	    }
	    else if (s[i] == 'D') {
		sprintf(dummy, "%s", date("%d.%m.%y", &pa->date));
		strcat(d, dummy);
	    }
	    else if (s[i] == 'L') {
		sprintf(dummy, "%s", s2);
		strcat(d, dummy);
	    }
	    else if (s[i] == 'Z') {
		sprintf(dummy, "%lu", annou_total);
		strcat(d, dummy);
	    }
	}
	else {
	    dlen = strlen(d);
	    d[dlen] = s[i];
	    d[dlen+1] = 0;
	}
    }
    return OK;
}

/*-------------------------------------------------------------------
 * annou_cf_area
 *-------------------------------------------------------------------*/
int	annou_cf_area(q_annou *pa, Textlist *tl)
{
char *vbuf;
char *s, *s2, *key, *arg;
int vtest = FALSE;
char vchar[256];

    vtest = FALSE;

    if (annou_is_groups) {
	for(s = cf_get_string("AnnounceGArea", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceGArea", FALSE) )
	{
	    vbuf = strsave(s);
	    key = strtok(vbuf, " \t");
	    arg = strtok(NULL  , "");
	    annou_cf_expand(vchar, sizeof(vchar), arg, pa);
	    
	    for (s2=key; *s2; s2++) {
		if (strchr(annou_test_key, *s2)) {
		    tl_append(tl, vchar);
		    vtest = TRUE;
	    break;
		}
	    }
	}
    }
    if (!vtest) {
	for (s = cf_get_string("AnnounceArea", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceArea", FALSE) ) {
	    annou_cf_expand(vchar, sizeof(vchar), s, pa);
	    tl_append(tl, vchar);
	    debug(8, "AnnounceArea: %s", vchar);
	}
    }
    return OK;
}

/*-------------------------------------------------------------------
 * annou_cf_file
 *-------------------------------------------------------------------*/
int	annou_cf_file(q_annou *pa, Textlist *tl, int isldesc, char *ldesc)
{
char *vbuf;
char *s, *s2, *key, *arg;
int vtest = FALSE;
char vchar[256];

    vtest = FALSE;

    if (annou_is_groups) {
	for(s = cf_get_string("AnnounceGFile", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceGFile", FALSE) )
	{
	    vbuf = strsave(s);
	    key = strtok(vbuf, " \t");
	    arg = strtok(NULL  , "");
	    annou_exp_file(vchar, sizeof(vchar), arg, pa, ldesc);
	    
	    for (s2=key; *s2; s2++) {
		if (strchr(annou_test_key, *s2)) {
/*		    tl_append(tl, vchar);*/
		    annou_format_line (vchar, sizeof(vchar), cf_len, cf_sp, tl);
		    vtest = TRUE;
	    break;
		}
	    }
	}
    }
    if (!vtest) {
	for (s = cf_get_string("AnnounceFile", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceFile", FALSE) ) {
	    annou_exp_file(vchar, sizeof(vchar), s, pa, ldesc);
/*	    tl_append(tl, vchar);*/
	    annou_format_line (vchar, sizeof(vchar), cf_len, cf_sp, tl);
	    vtest = TRUE;
	    debug(8, "AnnounceFile : %s", vchar);
	}
    }
    if (vtest) {
        return OK;
    }
    else {
	return ERROR;
    }
}

/*----------------------------------------------------------------
 * annou_get_echo
 *----------------------------------------------------------------*/
int	
annou_get_echo	(Textlist *tl, char *e_flag, int t_flag)
{
char *s, *s2, *key, *vbuf;
int vtest = FALSE;

    vtest = FALSE;

    if ((e_flag) && ((annou_areasbbs = areasbbs_lookup(e_flag)) != NULL)) {
	/* gueltige option --echo */
	annou_test_echo = strsave(e_flag);
	vtest = TRUE;
    }
    else if ( (t_flag) && (e_flag) ) {
	annou_test_echo = strsave(e_flag);
	vtest = TRUE;
    }
    else {
	/* keine gueltiges --echo, Echo aus ftntick.conf */
	if (annou_is_groups) {
	    for(s = cf_get_string("AnnounceGEcho", TRUE);
		s && *s && (!vtest);
		s = cf_get_string("AnnounceGEcho", FALSE) )
	    {
		vbuf = strsave(s);
		key = strtok(vbuf, " \t"); 
		annou_test_echo = strtok(NULL  , "");
		for (s2=key; *s2; s2++) {
		    if (strchr(annou_test_key, *s)) {
		        if ((annou_areasbbs = areasbbs_lookup(annou_test_echo)) != NULL) {
			    vtest = TRUE;
		break;
			}
			else {
			    debug(3, "annou_get_echo: AnnounceGEcho: %s lookup failed", annou_test_echo);
			}
		    }
		    else { 
			debug(3, "else if strchr");
		    }
		}
	    }
	}
    }
    if (!vtest) {
	for(s = cf_get_string("AnnounceEcho", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceEcho", FALSE) )
	{
	    vbuf = strsave(s);
	    if ((annou_areasbbs = areasbbs_lookup(vbuf)) != NULL) {
		annou_test_echo = strsave(vbuf);
		vtest = TRUE;
	    }
	    else {
		debug(3, "annou_get_echo: AnnounceEcho: %s lookup failed", vbuf);
	    }
	}
    }
    return OK;
}

/*----------------------------------------------------------------
 * annou_get_footer
 *----------------------------------------------------------------*/
int	
annou_get_footer	(Textlist *tl, char *e_flag, q_annou *pa)
{
char *s, *s2, *key, *arg, *vbuf = NULL;
int vtest = FALSE;
char vchar[256];

    vtest = FALSE;

    if (annou_is_groups) {
	for(s = cf_get_string("AnnounceGFooter", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceGFooter", FALSE) )
	{
	    if (vbuf) { xfree(vbuf); }
	    vbuf = strsave(s);
	    key = strtok(vbuf, " \t");
	    arg = strtok(NULL  , "");
	    annou_cf_expand(vchar, sizeof(vchar), arg, pa);
	    for (s2=key; *s2; s2++) {
		if (strchr(annou_test_key, *s)) {
		    tl_append(tl, vchar);
		    vtest = TRUE;
	    break;
		}
	    }
	}
    }
    
    if (!vtest) {
	for(s = cf_get_string("AnnounceFooter", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceFooter", FALSE) )
	{
	    annou_cf_expand(vchar, sizeof(vchar), s, pa);
	    tl_append(tl, vchar);
	    debug(8, "annou_get_footer: AnnounceFooter: %s", vbuf);
	}
    }
    if (vbuf) { xfree(vbuf); }
    return OK;
}

/*-------------------------------------------------------------------
 * annou_get_x
 *-------------------------------------------------------------------*/
char	*annou_get_x(char *x, int groups)
{
char *s, *s2, *key, *arg;
char *sdummy = NULL;
char *res;
int vtest = FALSE;

    vtest = FALSE;
    if (groups) {
	for(s = cf_get_string(x, TRUE); s && *s && (!vtest); s = cf_get_string(x, FALSE) )
	{
	    if (sdummy) { xfree(sdummy); }
	    sdummy = strsave(s);
	    key = xstrtok(sdummy, " \t");  arg = xstrtok(NULL  , "");
	    for (s2=key; *s2; s2++) {
		if (strchr(annou_test_key, *s2)) {
		    vtest = TRUE;
	    break;
		}
	    }
	}
    }
    else {
	if (!vtest) { 
	    arg = cf_get_string(x, TRUE);
	    if (arg) {
		vtest = TRUE;
	    }
	}
    }
    if (vtest) {
	res = strsave(arg);
        debug(8, "annou_get_x: %s : %s", x, s);
	if (sdummy) { xfree(sdummy); }
	return res;
    }
    else {   /* no config entry found */
        debug(8, "annou_get_x: Error, failed");
	if (sdummy) { xfree(sdummy); }
	return NULL;
    }
}

/*-------------------------------------------------------------------
 * annou_get_from
 *-------------------------------------------------------------------*/
int	annou_get_from(Message *mes)
{
char *arg = NULL;

    arg = annou_get_x("AnnounceGFrom", TRUE);
    if (!arg) {
	arg = annou_get_x("AnnounceFrom", FALSE);
    }
    if (arg) {
	BUF_COPY(mes->name_from, arg);
        debug(8, "AnnounceFrom : %s", arg);
	return OK;
    }
    else {   /* no config entry found */
        debug(1, "annou_get_from: Error, failed");
	return ERROR;
    }
    return OK;
}

/*-------------------------------------------------------------------
 * annou_get_to
 *-------------------------------------------------------------------*/
int	annou_get_to(Message *mes)
{
char *arg = NULL;

    arg = annou_get_x("AnnounceGTo", TRUE);
    if (!arg) {
	arg = annou_get_x("AnnounceTo", FALSE);
    }
    if (arg) {
	BUF_COPY(mes->name_to, arg);
        debug(8, "AnnounceTo : %s", arg);
	return OK;
    }
    else {   /* no config entry found */
        debug(1, "annou_get_from: Error, failed");
	return ERROR;
    }
    return OK;
}

/*-------------------------------------------------------------------
 * annou_get_subject
 *-------------------------------------------------------------------*/
int	annou_get_subject(Message *mes)
{
char *arg = NULL;

    arg = annou_get_x("AnnounceGSubject", TRUE);
    if (!arg) {
	arg = annou_get_x("AnnounceSubject", FALSE);
    }
    if (arg) {
	BUF_COPY(mes->subject, arg);
        debug(8, "AnnounceSubject : %s", arg);
	return OK;
    }
    else {   /* no config entry found */
        debug(1, "annou_get_from: Error, failed");
	return ERROR;
    }
    return OK;
}

/*-----------------------------------------------------------------
 * annou_set_addr
 *-----------------------------------------------------------------*/
int	annou_set_addr(q_annou *p)
{
    /* Set address for this area */
    if(p->zone != -1) {
	cf_set_zone(p->zone);
    }
    if(p->addr.zone != -1) {
	cf_set_curr(&p->addr);
    }
    return OK;
}
/*-----------------------------------------------------------------------
 * annou_close
 *-----------------------------------------------------------------------*/
int	annou_close(Textlist *tl, char *e_flag, q_annou *pa, int t_flag)
{
char vbuf[MAXPATH];

    sprintf(vbuf, "\r");
    tl_append(tl, vbuf);

    if (annou_get_footer(tl, e_flag, pa) == ERROR) {
	debug(2, "annou_close: Error: annou_get_footer failed");
    }

    sprintf(vbuf, "\r");
    tl_append(tl, vbuf);
    
    /* Send reply */
    node_clear(&outmsg.node_from);
    node_clear(&outmsg.node_orig);
    
    if (annou_set_addr(pa) == ERROR) {
	debug(2, "annou_close: Error annou_set_addr");
    }

    outmsg.node_from   = *cf_addr();
    outmsg.node_to   = *cf_addr();
    outmsg.node_orig   = *cf_addr();
    outmsg.attr      = 0;
    outmsg.cost      = 0;
    outmsg.date      = time(NULL);
    if ((annou_get_from(&outmsg) == ERROR)) {
	debug(2, "annou_close: Error: annou_get_from failed");
    }
    if (annou_get_to(&outmsg) == ERROR) {
	debug(2, "annou_close: Error: annou_get_to failed");
    }
    if (annou_get_subject(&outmsg) == ERROR) {
	debug(2, "annou_close: Error: annou_get_subject failed");
    }

    if (annou_get_echo(tl, e_flag, t_flag) == ERROR) {
	debug(2, "annou_close: Error: annou_get_echo failed");
    }
    outmsg.area		= annou_test_echo;
    
    annou_test_open = FALSE;
    
    return outpkt_echomail(&outmsg, tl, "FtnTick"); /* PROGRAM); */
    
    return OK;
}

/*-------------------------------------------------------------------
 * annou_get_header
 *-------------------------------------------------------------------*/
int	annou_get_header(Textlist *tl)
{
char *vbuf;
char *s, *s2, *key, *area;
int vtest = FALSE;

    vtest = FALSE;

    if (annou_is_groups) {
	for(s = cf_get_string("AnnounceGHeader", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceGHeader", FALSE) )
	{
	    vbuf = strsave(s);
	    key = strtok(vbuf, " \t");
	    area = strtok(NULL  , "");
	    for (s2=key; *s2; s2++) {
		if (strchr(annou_test_key, *s2)) {
		    tl_append(tl, area);
		    vtest = TRUE;
	    break;
		}
	    }
	}
    }
    if (!vtest) {
	for (s = cf_get_string("AnnounceHeader", TRUE);
	    s && *s;
	    s = cf_get_string("AnnounceHeader", FALSE) ) {
	    vbuf = strsave(s);
	    tl_append(tl, vbuf);
	    debug(8, "AnnounceHeader: %s", vbuf);
	}
    }
    return OK;
}

/*-----------------------------------------------------------------------
 * annou_open
 *-----------------------------------------------------------------------*/
int	annou_open(q_annou *pa, Textlist *tl, char *e_flag, int t_flag)
{
char vbuf[MAXPATH];

    if ((!annou_group_change(pa, tl)) && (annou_test_counter != 0)) { /* no groups change */
	return OK;                  /* only change when groups in conf supported */
    }                               /* and groups/area found in areas.bbs */
    annou_test_counter = annou_test_counter + 1;
    if (annou_test_open) {
	if (annou_close(tl, e_flag, pa, t_flag) == ERROR) {
	    debug(1, "annou_open: Error annou_close");
	    return ERROR;
 	}
    }

    tl_init(&outbody);
    
    if (annou_get_header(tl) == ERROR) {
	debug(1, "annou_open: Error: annou_get_header failed");
    }
    
    sprintf(vbuf, "\r");
    tl_append(&outbody, vbuf);
    
    annou_test_open = TRUE;
    
    return OK;
}

/*---------------------------------------------------------------
 * annou_line
 *---------------------------------------------------------------*/
int	annou_line(q_annou *pa, Textlist *tl)
{
Textline *pl;
char	vchar[MAXPATH] = "";
char vspace[256];
int i, i2;

    annou_total = annou_total + pa->size;
    
    if (stricmp(annou_test_char, pa->areaname)) {
	sprintf(vchar, " ");
	tl_append(tl, vchar);
	annou_cf_area(pa, tl);
    }
    
    if (pa->ldesc.first)
    {
	i = 0;
	for(pl=pa->ldesc.first; pl; pl=pl->next)
	{
	    ++i;
	    if (i == 1) {
		if (annou_cf_file(pa, tl, FALSE, pl->line) == ERROR) {
		    debug(1, "annou_line: annou_cf_file == ERROR");
		    sprintf(vchar, "%-12s%7ld KB %s %s", pa->filename, (pa->size/1024),
			date("%d.%m.%y", &pa->date), pl->line);
		    annou_format_line (vchar, sizeof(vchar), cf_len, cf_sp, tl);
		}
	    }
	    else {
		    vspace[0] = 0;
		    for (i2=0; i2<cf_sp; i2++)
			{ BUF_APPEND(vspace, " "); }
		    sprintf(vchar, "%s%s", vspace, pl->line);
		    annou_format_line (vchar, sizeof(vchar), cf_len, cf_sp, tl);
	    }
	}
    }
    sprintf(vchar, " ");
    tl_append(tl, vchar);
    BUF_COPY(annou_test_char, pa->areaname);
    return OK;
}

/*-------------------------------------------------------------------
 * annou_print
 *-------------------------------------------------------------------*/
int	annou_print(q_annou *pa, Textlist *tl, char *e_flag, int t_flag)
{
    /* groups change */
    if ((xstricmp(annou_test_key, pa->key) 
    && (annou_test_counter != 0))) {
	if (annou_test_open) {
	    if (annou_close(tl, e_flag, pa, t_flag) == ERROR) {
		debug(1, "annou_print: Error annou_close");
		return ERROR;
	    }
	}
    }
    
    annou_test_key = strsave(pa->key);
    
    /* outfile open */
    if (!annou_test_open) {
	if (annou_open(pa, tl, e_flag, t_flag) == ERROR) {
	    debug(1, "annou_print: Error annou_open");
	    return ERROR;
	}
    }

    return (annou_line(pa, tl));
    
}

/*-----------------------------------------------------------------------
 * annou_treeprint
 *-----------------------------------------------------------------------*/
void	annou_treeprint(q_annou *p, Textlist *tl, char *e_flag, AreasBBS *area, int t_flag)
{
    if (p != NULL) {
	annou_treeprint((annou_ptr) p->left, tl, e_flag, area, t_flag);
	if (annou_print(p, tl, e_flag, t_flag)==ERROR) {
	    debug(1, "treeprint: Error: tick_a failed");
	}
	annou_treeprint((annou_ptr) p->right, tl, e_flag, area, t_flag);
    }
}

/*---------------------------------------------------------------------
 * annou_do_mail
 *---------------------------------------------------------------------*/
int annou_do_mail	(char *e_flag, AreasBBS *area, int t_flag)
{
    if (annou_queue == NULL) {
	debug(2, "ftntick: no tic's to announce");
	return OK;
    }
    
    cf_len = atoi(cf_get_string("AnnounceLength", TRUE));
    cf_sp = atoi(cf_get_string("AnnounceSpace", TRUE));
    
    annou_treeprint(annou_queue, &outbody, e_flag, area, t_flag);
    
    if (annou_test_open) {
	if (annou_close(&outbody, e_flag, annou_queue, t_flag) == ERROR) {
	    debug(1, "tick_do_annou_mail: Error: annou_close failed");
	    return ERROR;
	}
    }
    
    return OK;
}

#endif
