/*
  hatcher for gtic, experimental, 18 April 1998
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "config.h"

char *hatcher_areaname;
char *hatcher_filename;
char *hatcher_replaces;
char *hatcher_desc;
int hatcher_copy;
int hatcher_koi8;
int hatcher_desc_stdin;

void hatcher(void)
{
	char tic_tmp[PATH_MAX];
	char *file_name;
	char new_path[PATH_MAX];
	char c_tmp[SMALLBUFSIZE];
	char buff[BUFSIZE];
	char *a_desc=NULL;
	char *p;
	tic_t *tic;
	area_t *atmp;
	user_t *utmp;
	node_t *FROM=NULL;
	FILE *fp;

	atmp=list_find_entry(areas,hatcher_areaname);
	if(atmp)
	{
		a_desc=atmp->desc;
		FROM=atmp->aka;
	}
	if(FROM==NULL)
		FROM=&whoami;
	nodetoftn(c_tmp,FROM);
	utmp=list_find_entry(users,c_tmp);
	if(utmp==NULL)
	{
		e_printf("Unable to find \"%s\" in users_file \"%s\"",c_tmp,users_file);
		abort2();
	}
	if(strcmp(utmp->passwd,"*")==0)
	{
		e_printf("Hatcher can't process node %s with \"*\" password.",c_tmp);
		abort2();
	}
	
	if(access_via_stat(hatcher_filename,R_OK))
	{
		e_printf("Unable to read \"%s\" for hatching.",hatcher_filename);
		abort2();
	}
	
	while(1)
	{
		snprintf(tic_tmp,sizeof(tic_tmp)-1,"%s/%08lx.tic",inbound,
			(long)time(NULL)+rand());
		if(access_via_stat(tic_tmp,F_OK)) break;
	}
	
	if(strrchr(hatcher_filename,'/'))
		file_name=strrchr(hatcher_filename,'/')+1;
	else
		file_name=hatcher_filename;

	snprintf(new_path,sizeof(new_path)-1,"%s/%s",inbound,file_name);

	if(access_via_stat(new_path,F_OK)==0)
	{
		e_printf("Hatcher: file %s already exist.",new_path);
		abort2();
	}

	if(cmp_paths(hatcher_filename,new_path)!=0)
	{
		/* make hardlink/copy, if paths is not equal */
		int cp_res;
		if(hatcher_copy)
			cp_res=cp(hatcher_filename,new_path);
		else
			cp_res=ln(hatcher_filename,new_path);
		if(cp_res!=0)
		{
			e_printf("Unable to copy/link %s to %s.",hatcher_filename,new_path);
			abort2();
		}
	}

	tic=xmalloc(sizeof(tic_t));

	tic->area=xstrcpy(hatcher_areaname);
	tic->file=xstrcpy(file_name);
	tic->fullname=NULL;
	tic->crc=filecrc32(new_path);
	tic->magic=NULL;
	tic->replaces=hatcher_replaces?xstrcpy(hatcher_replaces):NULL;
	tic->size=-1;
	tic->date=-1;
	tic->release=-1;
	tic->author=NULL;
	tic->source=NULL;
	tic->app=NULL;
	tic->max_app=0;
	tic->from_pwd=NULL;
	(tic->to).zone=0;
	tic->via=NULL;
	tic->max_via=0;

	nodecpy(&(tic->origin),FROM);
	nodecpy(&(tic->from),FROM);

	tic->max_path=0;
	snprintf(buff,sizeof(buff)-1,"%s %lu %s",
		nodetoftn(NULL,FROM),(unsigned long)time(NULL),texttime(1));
	p=xstrcpy(buff);
	tic->path=ilist_init();
	ilist_add(tic->path,tic->max_path++,p);
	
	tic->seenby=list_init();
	list_add(tic->seenby,c_tmp,"");
	
	tic->pw=xstrcpy(utmp->passwd);

	tic->areadesc=xstrcpy(a_desc);

	tic->ldesc=NULL;
	tic->max_ldesc=0;

	tic->desc=NULL;
	tic->max_desc=0;

	if(hatcher_desc)
	{
		tic->desc=ilist_init();
		/* remove \r and \n for most correctly output tic file */
		strremove(hatcher_desc,"\n");
		strremove(hatcher_desc,"\r");
		if(hatcher_koi8)
			k2a(hatcher_desc,strlen(hatcher_desc));
		ilist_add(tic->desc,tic->max_desc++,hatcher_desc);
	}
	
	if(hatcher_desc_stdin)
	{
		tic->ldesc=ilist_init();
		while(1)
		{
			if(fgets(buff,sizeof(buff)-1,stdin)==NULL) break;
			delcrlf(buff);
			if(buff[0]==0) continue; /* skip empty lines */
			if(hatcher_koi8)
				k2a(hatcher_desc,strlen(hatcher_desc));
			p=xstrcpy(buff);
			ilist_add(tic->ldesc,tic->max_ldesc++,p);
		}
	}

	tic->created=xstrcpy(
  "by gtic " VERSION " Copyright (C) 1998 Yuri Kuzmenko 2:463/169"
	);
	
	fp=fopen(tic_tmp,"wb");
	if(fp==NULL)
	{
		freetic(tic);
		e_printf("Unable to open for write tic file %s.\n",tic_tmp);
		abort2();
	}
	if(writeticFILE(tic,fp))
	{
		freetic(tic);
		e_printf("Unable to write tic file %s.\n",tic_tmp);
		abort2();
	}

	freetic(tic);
	
	ass(fclose(fp)==0);
}
