/*
  logger routines
*/

#include <stdio.h>
#include <time.h>
#include <stdarg.h>
#include <sys/stat.h>

#include "config.h"

FILE *logfd = NULL;

void e_printf(const char *fmt, ...)
{
	static char tmp[BUFSIZE];
	va_list ap;
	
	va_start(ap, fmt);
	vsnprintf(tmp, sizeof(tmp)-1, fmt, ap);
	va_end(ap);
	
	fprintf(stderr,"%s\n",tmp);
	if (logfd)
	{
		fprintf(logfd, "%s: ERROR: %s\n", texttime(1), tmp);
		fflush(logfd);
	}
}

void l_printf(const char *fmt, ...)
{
	static char tmp[BUFSIZE];
	va_list ap;
	
	va_start(ap, fmt);
	vsnprintf(tmp, sizeof(tmp)-1, fmt, ap);
	va_end(ap);

	if (logfd)
	{
          fprintf(logfd, "%s: %s\n", texttime(1), tmp);
	  fflush(logfd);
	}
/*else puts(tmp);*/
}

void l_init(const char *name)
{
	if(log_file_mode==0) return;
	logfd = fopen(name, "a");
	if (!logfd) {
		fprintf(stderr, "Unable to open log file %s.\n",name);
		return;
	}
	fchmod(fileno(logfd),log_file_mode);
}
